/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import java.util.Objects;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.Config;
import org.apache.doris.thrift.TColumnType;
import org.apache.doris.thrift.TScalarType;
import org.apache.doris.thrift.TTypeDesc;
import org.apache.doris.thrift.TTypeNode;
import org.apache.doris.thrift.TTypeNodeType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScalarType
extends Type {
    public static final int DATETIME_PRECISION = 18;
    public static final int DEFAULT_PRECISION = 9;
    public static final int DEFAULT_SCALE = 0;
    public static final int MAX_VARCHAR_LENGTH = 65533;
    public static final int MAX_CHAR_LENGTH = 255;
    public static final int MAX_HLL_LENGTH = 16385;
    public static final int CHAR_INLINE_LENGTH = 128;
    public static final int MAX_STRING_LENGTH = 0x7FFFFFFB;
    public static final int MAX_JSONB_LENGTH = 0x7FFFFFFB;
    public static final int MAX_PRECISION = 38;
    public static final int MAX_DECIMALV2_PRECISION = 27;
    public static final int MAX_DECIMALV2_SCALE = 9;
    public static final int MAX_DECIMAL32_PRECISION = 9;
    public static final int MAX_DECIMAL64_PRECISION = 18;
    public static final int MAX_DECIMAL128_PRECISION = 38;
    public static final int DEFAULT_MIN_AVG_DECIMAL128_SCALE = 4;
    public static final int MAX_DATETIMEV2_SCALE = 6;
    private long byteSize = -1L;
    private static final Logger LOG = LogManager.getLogger(ScalarType.class);
    @SerializedName(value="type")
    private final PrimitiveType type;
    @SerializedName(value="len")
    private int len = -1;
    @SerializedName(value="precision")
    private int precision;
    @SerializedName(value="scale")
    private int scale;
    @SerializedName(value="precisionStr")
    private String precisionStr;
    @SerializedName(value="scaleStr")
    private String scaleStr;
    @SerializedName(value="lenStr")
    private String lenStr;

    public void setByteSize(long byteSize) {
        this.byteSize = byteSize;
    }

    public long getByteSize() {
        return this.byteSize;
    }

    public ScalarType(PrimitiveType type) {
        this.type = type;
    }

    public static ScalarType createType(PrimitiveType type, int len, int precision, int scale) {
        switch (type) {
            case CHAR: {
                return ScalarType.createCharType(len);
            }
            case VARCHAR: {
                return ScalarType.createVarcharType(len);
            }
            case STRING: {
                return ScalarType.createStringType();
            }
            case DECIMAL32: 
            case DECIMAL64: 
            case DECIMAL128: {
                return ScalarType.createDecimalV3Type(precision, scale);
            }
            case DECIMALV2: {
                return ScalarType.createDecimalType(precision, scale);
            }
            case DATETIMEV2: {
                return ScalarType.createDatetimeV2Type(scale);
            }
            case TIMEV2: {
                return ScalarType.createTimeV2Type(scale);
            }
        }
        return ScalarType.createType(type);
    }

    public static ScalarType createType(PrimitiveType type) {
        switch (type) {
            case INVALID_TYPE: {
                return INVALID;
            }
            case NULL_TYPE: {
                return NULL;
            }
            case BOOLEAN: {
                return BOOLEAN;
            }
            case SMALLINT: {
                return SMALLINT;
            }
            case TINYINT: {
                return TINYINT;
            }
            case INT: {
                return INT;
            }
            case BIGINT: {
                return BIGINT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case CHAR: {
                return CHAR;
            }
            case VARCHAR: {
                return ScalarType.createVarcharType();
            }
            case BINARY: {
                return ScalarType.createStringType();
            }
            case JSONB: {
                return ScalarType.createJsonbType();
            }
            case STRING: {
                return ScalarType.createStringType();
            }
            case HLL: {
                return ScalarType.createHllType();
            }
            case BITMAP: {
                return BITMAP;
            }
            case QUANTILE_STATE: {
                return QUANTILE_STATE;
            }
            case AGG_STATE: {
                return AGG_STATE;
            }
            case LAMBDA_FUNCTION: {
                return LAMBDA_FUNCTION;
            }
            case DATE: {
                return DATE;
            }
            case DATETIME: {
                return DATETIME;
            }
            case DATEV2: {
                return DATEV2;
            }
            case DATETIMEV2: {
                return DEFAULT_DATETIMEV2;
            }
            case TIMEV2: {
                return TIMEV2;
            }
            case TIME: {
                return TIME;
            }
            case DECIMAL32: {
                return DEFAULT_DECIMAL32;
            }
            case DECIMAL64: {
                return DEFAULT_DECIMAL64;
            }
            case DECIMAL128: {
                return DEFAULT_DECIMAL128;
            }
            case DECIMALV2: {
                return DEFAULT_DECIMALV2;
            }
            case LARGEINT: {
                return LARGEINT;
            }
            case ALL: {
                return ALL;
            }
        }
        LOG.warn("type={}", (Object)type);
        Preconditions.checkState((boolean)false);
        return NULL;
    }

    public static ScalarType createType(String type) {
        switch (type) {
            case "INVALID_TYPE": {
                return INVALID;
            }
            case "NULL_TYPE": {
                return NULL;
            }
            case "BOOLEAN": {
                return BOOLEAN;
            }
            case "SMALLINT": {
                return SMALLINT;
            }
            case "TINYINT": {
                return TINYINT;
            }
            case "INT": {
                return INT;
            }
            case "BIGINT": {
                return BIGINT;
            }
            case "FLOAT": {
                return FLOAT;
            }
            case "DOUBLE": {
                return DOUBLE;
            }
            case "CHAR": {
                return CHAR;
            }
            case "VARCHAR": {
                return ScalarType.createVarcharType();
            }
            case "JSON": {
                return ScalarType.createJsonbType();
            }
            case "STRING": 
            case "TEXT": {
                return ScalarType.createStringType();
            }
            case "HLL": {
                return ScalarType.createHllType();
            }
            case "BITMAP": {
                return BITMAP;
            }
            case "QUANTILE_STATE": {
                return QUANTILE_STATE;
            }
            case "AGG_STATE": {
                return AGG_STATE;
            }
            case "LAMBDA_FUNCTION": {
                return LAMBDA_FUNCTION;
            }
            case "DATE": {
                return DATE;
            }
            case "DATETIME": {
                return DATETIME;
            }
            case "DATEV2": {
                return DATEV2;
            }
            case "DATETIMEV2": {
                return DATETIMEV2;
            }
            case "TIME": {
                return TIME;
            }
            case "DECIMAL": 
            case "DECIMALV2": {
                return ScalarType.createDecimalType();
            }
            case "DECIMALV3": {
                return ScalarType.createDecimalV3Type();
            }
            case "LARGEINT": {
                return LARGEINT;
            }
        }
        LOG.warn("type={}", (Object)type);
        Preconditions.checkState((boolean)false);
        return NULL;
    }

    public static ScalarType createCharType(int len) {
        ScalarType type = new ScalarType(PrimitiveType.CHAR);
        type.len = len;
        return type;
    }

    public static ScalarType createCharType(String lenStr) {
        ScalarType type = new ScalarType(PrimitiveType.CHAR);
        type.lenStr = lenStr;
        return type;
    }

    public static ScalarType createChar(int len) {
        ScalarType type = new ScalarType(PrimitiveType.CHAR);
        type.len = len;
        return type;
    }

    public static ScalarType createDecimalType() {
        if (Config.enable_decimal_conversion) {
            return DEFAULT_DECIMALV3;
        }
        return DEFAULT_DECIMALV2;
    }

    public static ScalarType createDecimalType(int precision) {
        return ScalarType.createDecimalType(precision, 0);
    }

    public static ScalarType createDecimalType(int precision, int scale) {
        ScalarType type = new ScalarType(ScalarType.getSuitableDecimalType(precision, true));
        type.precision = precision;
        type.scale = scale;
        return type;
    }

    public static ScalarType createDecimalType(PrimitiveType primitiveType, int precision, int scale) {
        ScalarType type = new ScalarType(primitiveType);
        type.precision = precision;
        type.scale = scale;
        return type;
    }

    public static ScalarType createDecimalType(String precisionStr) {
        int precision = Integer.parseInt(precisionStr);
        ScalarType type = new ScalarType(ScalarType.getSuitableDecimalType(precision, true));
        type.precisionStr = precisionStr;
        type.scaleStr = null;
        return type;
    }

    public static ScalarType createDecimalType(String precisionStr, String scaleStr) {
        ScalarType type = new ScalarType(PrimitiveType.DECIMALV2);
        type.precisionStr = precisionStr;
        type.scaleStr = scaleStr;
        return type;
    }

    public static ScalarType createDecimalV3Type() {
        return DEFAULT_DECIMALV3;
    }

    public static ScalarType createDecimalV3Type(int precision) {
        return ScalarType.createDecimalV3Type(precision, 0);
    }

    public static ScalarType createDecimalV3Type(int precision, int scale) {
        ScalarType type = new ScalarType(ScalarType.getSuitableDecimalType(precision, false));
        type.precision = precision;
        type.scale = scale;
        return type;
    }

    public static ScalarType createDecimalV3Type(String precisionStr) {
        int precision = Integer.parseInt(precisionStr);
        ScalarType type = new ScalarType(ScalarType.getSuitableDecimalType(precision, false));
        type.precisionStr = precisionStr;
        type.scaleStr = null;
        return type;
    }

    public static ScalarType createDecimalV3Type(String precisionStr, String scaleStr) {
        ScalarType type = new ScalarType(ScalarType.getSuitableDecimalType(Integer.parseInt(precisionStr), false));
        type.precisionStr = precisionStr;
        type.scaleStr = scaleStr;
        return type;
    }

    public static ScalarType createDecimalV2Type() {
        Preconditions.checkState((!Config.disable_decimalv2 ? 1 : 0) != 0, (Object)"DecimalV2 is disable in fe.conf!");
        return DEFAULT_DECIMALV2;
    }

    public static ScalarType createDecimalV2Type(int precision) {
        Preconditions.checkState((!Config.disable_decimalv2 ? 1 : 0) != 0, (Object)"DecimalV2 is disable in fe.conf!");
        return ScalarType.createDecimalV2Type(precision, 0);
    }

    public static ScalarType createDecimalV2Type(int precision, int scale) {
        Preconditions.checkState((!Config.disable_decimalv2 ? 1 : 0) != 0, (Object)"DecimalV2 is disable in fe.conf!");
        ScalarType type = new ScalarType(PrimitiveType.DECIMALV2);
        type.precision = precision;
        type.scale = scale;
        return type;
    }

    public static ScalarType createDecimalV2Type(String precisionStr) {
        Preconditions.checkState((!Config.disable_decimalv2 ? 1 : 0) != 0, (Object)"DecimalV2 is disable in fe.conf!");
        ScalarType type = new ScalarType(PrimitiveType.DECIMALV2);
        type.precisionStr = precisionStr;
        type.scaleStr = null;
        return type;
    }

    public static ScalarType createDecimalV2Type(String precisionStr, String scaleStr) {
        Preconditions.checkState((!Config.disable_decimalv2 ? 1 : 0) != 0, (Object)"DecimalV2 is disable in fe.conf!");
        ScalarType type = new ScalarType(PrimitiveType.DECIMALV2);
        type.precisionStr = precisionStr;
        type.scaleStr = scaleStr;
        return type;
    }

    public static PrimitiveType getSuitableDecimalType(int precision, boolean decimalV2) {
        if (decimalV2 && !Config.enable_decimal_conversion) {
            return PrimitiveType.DECIMALV2;
        }
        if (precision <= 9) {
            return PrimitiveType.DECIMAL32;
        }
        if (precision <= 18) {
            return PrimitiveType.DECIMAL64;
        }
        return PrimitiveType.DECIMAL128;
    }

    public static ScalarType createDecimalTypeInternal(int precision, int scale, boolean decimalV2) {
        ScalarType type = new ScalarType(ScalarType.getSuitableDecimalType(precision, decimalV2));
        type.precision = Math.min(precision, 38);
        type.scale = Math.min(type.precision, scale);
        return type;
    }

    public static ScalarType createDatetimeV2Type(int scale) {
        ScalarType type = new ScalarType(PrimitiveType.DATETIMEV2);
        type.precision = 18;
        type.scale = scale;
        return type;
    }

    public static ScalarType createTimeV2Type(int scale) {
        ScalarType type = new ScalarType(PrimitiveType.TIMEV2);
        type.precision = 18;
        type.scale = scale;
        return type;
    }

    public static ScalarType createDatetimeType() {
        if (!Config.enable_date_conversion) {
            return new ScalarType(PrimitiveType.DATETIME);
        }
        ScalarType type = new ScalarType(PrimitiveType.DATETIMEV2);
        type.precision = 18;
        type.scale = 0;
        return type;
    }

    public static ScalarType createDateType() {
        if (Config.enable_date_conversion) {
            return new ScalarType(PrimitiveType.DATEV2);
        }
        return new ScalarType(PrimitiveType.DATE);
    }

    public static ScalarType createDatetimeV1Type() {
        Preconditions.checkState((!Config.disable_datev1 ? 1 : 0) != 0, (Object)"Datev1 is disable in fe.conf!");
        return new ScalarType(PrimitiveType.DATETIME);
    }

    public static ScalarType createDateV1Type() {
        Preconditions.checkState((!Config.disable_datev1 ? 1 : 0) != 0, (Object)"Datev1 is disable in fe.conf!");
        return new ScalarType(PrimitiveType.DATE);
    }

    public static ScalarType createTimeType() {
        if (!Config.enable_date_conversion) {
            return new ScalarType(PrimitiveType.TIME);
        }
        ScalarType type = new ScalarType(PrimitiveType.TIMEV2);
        type.precision = 18;
        type.scale = 0;
        return type;
    }

    public static ScalarType createDateV2Type() {
        return new ScalarType(PrimitiveType.DATEV2);
    }

    public static Type getDefaultDateType(Type type) {
        switch (type.getPrimitiveType()) {
            case DATE: {
                if (Config.enable_date_conversion) {
                    return Type.DATEV2;
                }
                return Type.DATE;
            }
            case DATETIME: {
                if (Config.enable_date_conversion) {
                    return Type.DATETIMEV2;
                }
                return Type.DATETIME;
            }
        }
        return type;
    }

    public static ScalarType createWiderDecimalV3Type(int precision, int scale) {
        ScalarType type = new ScalarType(ScalarType.getSuitableDecimalType(precision, false));
        type.precision = precision <= 9 ? 9 : (precision <= 18 ? 18 : 38);
        type.scale = scale;
        return type;
    }

    public static ScalarType createVarcharType(int len) {
        ScalarType type = new ScalarType(PrimitiveType.VARCHAR);
        type.len = len;
        return type;
    }

    public static ScalarType createVarcharType(String lenStr) {
        ScalarType type = new ScalarType(PrimitiveType.VARCHAR);
        type.lenStr = lenStr;
        return type;
    }

    public static ScalarType createStringType() {
        ScalarType type = new ScalarType(PrimitiveType.STRING);
        type.len = 0x7FFFFFFB;
        return type;
    }

    public static ScalarType createJsonbType() {
        ScalarType type = new ScalarType(PrimitiveType.JSONB);
        type.len = 0x7FFFFFFB;
        return type;
    }

    public static ScalarType createVarchar(int len) {
        ScalarType type = new ScalarType(PrimitiveType.VARCHAR);
        type.len = len;
        return type;
    }

    public static ScalarType createVarcharType() {
        return new ScalarType(PrimitiveType.VARCHAR);
    }

    public static ScalarType createHllType() {
        ScalarType type = new ScalarType(PrimitiveType.HLL);
        type.len = 16385;
        return type;
    }

    public String toString() {
        if (this.type == PrimitiveType.CHAR) {
            if (this.isWildcardChar()) {
                return "CHARACTER";
            }
            return "CHAR(" + this.len + ")";
        }
        if (this.type == PrimitiveType.DECIMALV2) {
            if (this.isWildcardDecimal()) {
                return "DECIMAL(*, *)";
            }
            return "DECIMAL(" + this.precision + ", " + this.scale + ")";
        }
        if (this.type.isDecimalV3Type()) {
            if (this.isWildcardDecimal()) {
                return "DECIMALV3(*, *)";
            }
            return "DECIMALV3(" + this.precision + ", " + this.scale + ")";
        }
        if (this.type == PrimitiveType.DATETIMEV2) {
            return "DATETIMEV2(" + this.scale + ")";
        }
        if (this.type == PrimitiveType.TIMEV2) {
            return "TIMEV2(" + this.scale + ")";
        }
        if (this.type == PrimitiveType.VARCHAR) {
            if (this.isWildcardVarchar()) {
                return "VARCHAR(65533)";
            }
            return "VARCHAR(" + this.len + ")";
        }
        if (this.type == PrimitiveType.STRING) {
            return "TEXT";
        }
        if (this.type == PrimitiveType.JSONB) {
            return "JSON";
        }
        return this.type.toString();
    }

    @Override
    public String toSql(int depth) {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.type) {
            case CHAR: {
                if (this.isWildcardVarchar()) {
                    stringBuilder.append("character");
                    break;
                }
                if (Strings.isNullOrEmpty((String)this.lenStr)) {
                    stringBuilder.append("char").append("(").append(this.len).append(")");
                    break;
                }
                stringBuilder.append("char").append("(`").append(this.lenStr).append("`)");
                break;
            }
            case VARCHAR: {
                if (this.isWildcardVarchar()) {
                    stringBuilder.append("varchar(*)");
                    break;
                }
                if (Strings.isNullOrEmpty((String)this.lenStr)) {
                    stringBuilder.append("varchar").append("(").append(this.len).append(")");
                    break;
                }
                stringBuilder.append("varchar").append("(`").append(this.lenStr).append("`)");
                break;
            }
            case DECIMALV2: {
                if (Strings.isNullOrEmpty((String)this.precisionStr)) {
                    stringBuilder.append("decimal").append("(").append(this.precision).append(", ").append(this.scale).append(")");
                    break;
                }
                if (!Strings.isNullOrEmpty((String)this.precisionStr) && !Strings.isNullOrEmpty((String)this.scaleStr)) {
                    stringBuilder.append("decimal").append("(`").append(this.precisionStr).append("`, `").append(this.scaleStr).append("`)");
                    break;
                }
                stringBuilder.append("decimal").append("(`").append(this.precisionStr).append("`)");
                break;
            }
            case DECIMAL32: 
            case DECIMAL64: 
            case DECIMAL128: {
                String typeName = "decimalv3";
                if (Strings.isNullOrEmpty((String)this.precisionStr)) {
                    stringBuilder.append(typeName).append("(").append(this.precision).append(", ").append(this.scale).append(")");
                    break;
                }
                if (!Strings.isNullOrEmpty((String)this.precisionStr) && !Strings.isNullOrEmpty((String)this.scaleStr)) {
                    stringBuilder.append(typeName).append("(`").append(this.precisionStr).append("`, `").append(this.scaleStr).append("`)");
                    break;
                }
                stringBuilder.append(typeName).append("(`").append(this.precisionStr).append("`)");
                break;
            }
            case DATETIMEV2: {
                stringBuilder.append("datetimev2").append("(").append(this.scale).append(")");
                break;
            }
            case TIME: {
                stringBuilder.append("time");
                break;
            }
            case TIMEV2: {
                stringBuilder.append("time").append("(").append(this.scale).append(")");
                break;
            }
            case BOOLEAN: {
                return "boolean";
            }
            case TINYINT: {
                return "tinyint(4)";
            }
            case SMALLINT: {
                return "smallint(6)";
            }
            case INT: {
                return "int(11)";
            }
            case BIGINT: {
                return "bigint(20)";
            }
            case LARGEINT: {
                return "largeint(40)";
            }
            case NULL_TYPE: 
            case FLOAT: 
            case DOUBLE: 
            case HLL: 
            case BITMAP: 
            case QUANTILE_STATE: 
            case LAMBDA_FUNCTION: 
            case DATE: 
            case DATETIME: 
            case DATEV2: 
            case VARIANT: 
            case ARRAY: {
                stringBuilder.append(this.type.toString().toLowerCase());
                break;
            }
            case STRING: {
                stringBuilder.append("text");
                break;
            }
            case JSONB: {
                stringBuilder.append("json");
                break;
            }
            case AGG_STATE: {
                stringBuilder.append("agg_state(unknown)");
                break;
            }
            default: {
                stringBuilder.append("unknown type: " + this.type.toString());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    protected String prettyPrint(int lpad) {
        return Strings.repeat((String)" ", (int)lpad) + this.toSql();
    }

    @Override
    public void toThrift(TTypeDesc container) {
        TTypeNode node = new TTypeNode();
        container.types.add(node);
        node.setType(TTypeNodeType.SCALAR);
        TScalarType scalarType = new TScalarType();
        scalarType.setType(this.type.toThrift());
        container.setByteSize(this.byteSize);
        switch (this.type) {
            case CHAR: 
            case VARCHAR: 
            case STRING: 
            case JSONB: 
            case HLL: {
                scalarType.setLen(this.getLength());
                break;
            }
            case DECIMAL32: 
            case DECIMAL64: 
            case DECIMAL128: 
            case DECIMALV2: 
            case DATETIMEV2: {
                Preconditions.checkArgument((this.precision >= this.scale ? 1 : 0) != 0, (Object)String.format("given precision %d is out of scale bound %d", this.precision, this.scale));
                scalarType.setScale(this.scale);
                scalarType.setPrecision(this.precision);
                break;
            }
            case TIMEV2: {
                Preconditions.checkArgument((this.precision >= this.scale ? 1 : 0) != 0, (Object)String.format("given precision %d is out of scale bound %d", this.precision, this.scale));
                scalarType.setScale(this.scale);
                scalarType.setPrecision(this.precision);
                break;
            }
        }
        node.setScalarType(scalarType);
    }

    public int decimalPrecision() {
        Preconditions.checkState((this.type == PrimitiveType.DECIMALV2 || this.type == PrimitiveType.DATETIMEV2 || this.type == PrimitiveType.TIMEV2 || this.type == PrimitiveType.DECIMAL32 || this.type == PrimitiveType.DECIMAL64 || this.type == PrimitiveType.DECIMAL128 ? 1 : 0) != 0);
        return this.precision;
    }

    public int decimalScale() {
        Preconditions.checkState((this.type == PrimitiveType.DECIMALV2 || this.type == PrimitiveType.DATETIMEV2 || this.type == PrimitiveType.TIMEV2 || this.type == PrimitiveType.DECIMAL32 || this.type == PrimitiveType.DECIMAL64 || this.type == PrimitiveType.DECIMAL128 ? 1 : 0) != 0);
        return this.scale;
    }

    @Override
    public PrimitiveType getPrimitiveType() {
        return this.type;
    }

    public int ordinal() {
        return this.type.ordinal();
    }

    @Override
    public int getLength() {
        if (this.len == -1) {
            if (this.type == PrimitiveType.CHAR) {
                return 255;
            }
            if (this.type == PrimitiveType.STRING) {
                return 0x7FFFFFFB;
            }
            return 65533;
        }
        return this.len;
    }

    @Override
    public int getRawLength() {
        return this.len;
    }

    public void setLength(int len) {
        this.len = len;
    }

    public void setMaxLength() {
        this.len = -1;
    }

    public boolean isLengthSet() {
        return this.getPrimitiveType() == PrimitiveType.HLL || this.len > 0 || !Strings.isNullOrEmpty((String)this.lenStr);
    }

    public int getScalarScale() {
        return this.scale;
    }

    public int getScalarPrecision() {
        return this.precision;
    }

    public String getScalarPrecisionStr() {
        return this.precisionStr;
    }

    public String getScalarScaleStr() {
        return this.scaleStr;
    }

    public String getLenStr() {
        return this.lenStr;
    }

    @Override
    public boolean isWildcardDecimal() {
        return (this.type.isDecimalV2Type() || this.type.isDecimalV3Type()) && this.precision == -1 && this.scale == -1;
    }

    @Override
    public boolean isWildcardVarchar() {
        return !(this.type != PrimitiveType.VARCHAR && this.type != PrimitiveType.HLL || this.len != -1 && this.len != 65533);
    }

    @Override
    public boolean isWildcardChar() {
        return this.type == PrimitiveType.CHAR && (this.len == -1 || this.len == 255);
    }

    @Override
    public boolean isFixedLengthType() {
        return this.type == PrimitiveType.BOOLEAN || this.type == PrimitiveType.TINYINT || this.type == PrimitiveType.SMALLINT || this.type == PrimitiveType.INT || this.type == PrimitiveType.BIGINT || this.type == PrimitiveType.FLOAT || this.type == PrimitiveType.DOUBLE || this.type == PrimitiveType.DATE || this.type == PrimitiveType.DATETIME || this.type == PrimitiveType.DECIMALV2 || this.type.isDecimalV3Type() || this.type == PrimitiveType.CHAR || this.type == PrimitiveType.DATEV2 || this.type == PrimitiveType.DATETIMEV2 || this.type == PrimitiveType.TIMEV2;
    }

    @Override
    public boolean isSupported() {
        switch (this.type) {
            case BINARY: 
            case UNSUPPORTED: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean supportsTablePartitioning() {
        return this.isSupported() && !this.isComplexType();
    }

    @Override
    public int getSlotSize() {
        return this.type.getSlotSize();
    }

    @Override
    public boolean matchesType(Type t) {
        if (this.equals(t)) {
            return true;
        }
        if (t.isAnyType()) {
            return t.matchesType(this);
        }
        if (!t.isScalarType()) {
            return false;
        }
        ScalarType scalarType = (ScalarType)t;
        if (this.type == PrimitiveType.VARCHAR && scalarType.isWildcardVarchar()) {
            return true;
        }
        if (this.type == PrimitiveType.CHAR && scalarType.isWildcardChar()) {
            return true;
        }
        if (this.type.isStringType() && scalarType.isStringType()) {
            return true;
        }
        if (this.isDecimalV2() && scalarType.isWildcardDecimal() && scalarType.isDecimalV2()) {
            Preconditions.checkState((!this.isWildcardDecimal() ? 1 : 0) != 0);
            return true;
        }
        if (this.isDecimalV3() && scalarType.isWildcardDecimal() && scalarType.isDecimalV3()) {
            Preconditions.checkState((!this.isWildcardDecimal() ? 1 : 0) != 0);
            return true;
        }
        if (this.isDecimalV2() && scalarType.isDecimalV2()) {
            return true;
        }
        if (this.isDecimalV3() && scalarType.isDecimalV3()) {
            return this.precision == scalarType.precision && this.scale == scalarType.scale;
        }
        return this.isDatetimeV2() && scalarType.isDatetimeV2();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ScalarType)) {
            return false;
        }
        ScalarType other = (ScalarType)o;
        if (this.isDatetimeV2() && other.isDatetimeV2()) {
            return this.decimalScale() == other.decimalScale();
        }
        if (this.isTimeV2() && other.isTimeV2()) {
            return this.decimalScale() == other.decimalScale();
        }
        if (this.type.isDecimalV3Type() && other.isDecimalV3()) {
            return this.precision == other.precision && this.scale == other.scale;
        }
        if (this.type != other.type) {
            return false;
        }
        if (this.type == PrimitiveType.CHAR) {
            return this.len == other.len;
        }
        if (this.type == PrimitiveType.VARCHAR) {
            return this.len == other.len;
        }
        if (this.type.isDecimalV2Type() || this.type == PrimitiveType.DATETIMEV2 || this.type == PrimitiveType.TIMEV2) {
            return this.precision == other.precision && this.scale == other.scale;
        }
        return true;
    }

    @Override
    public Type getMaxResolutionType() {
        if (this.isIntegerType()) {
            return BIGINT;
        }
        if (this.isFloatingPointType()) {
            return DOUBLE;
        }
        if (this.isNull()) {
            return NULL;
        }
        if (this.isDecimalV2()) {
            return ScalarType.createDecimalTypeInternal(38, this.scale, true);
        }
        if (this.getPrimitiveType() == PrimitiveType.DECIMAL32) {
            return ScalarType.createDecimalTypeInternal(9, this.scale, false);
        }
        if (this.getPrimitiveType() == PrimitiveType.DECIMAL64) {
            return ScalarType.createDecimalTypeInternal(18, this.scale, false);
        }
        if (this.getPrimitiveType() == PrimitiveType.DECIMAL128) {
            return ScalarType.createDecimalTypeInternal(38, this.scale, false);
        }
        if (this.isLargeIntType()) {
            return LARGEINT;
        }
        if (this.isDatetimeV2()) {
            return ScalarType.createDatetimeV2Type(6);
        }
        if (this.isTimeV2()) {
            return ScalarType.createTimeV2Type(6);
        }
        return INVALID;
    }

    public ScalarType getNextResolutionType() {
        Preconditions.checkState((this.isNumericType() || this.isNull() ? 1 : 0) != 0);
        if (this.type == PrimitiveType.DOUBLE || this.type == PrimitiveType.BIGINT || this.isNull()) {
            return this;
        }
        if (this.type == PrimitiveType.DECIMALV2) {
            return ScalarType.createDecimalTypeInternal(38, this.scale, true);
        }
        if (this.type == PrimitiveType.DECIMAL32) {
            return ScalarType.createDecimalTypeInternal(18, this.scale, false);
        }
        if (this.type == PrimitiveType.DECIMAL64) {
            return ScalarType.createDecimalTypeInternal(38, this.scale, false);
        }
        if (this.type == PrimitiveType.DECIMAL128) {
            return ScalarType.createDecimalTypeInternal(38, this.scale, false);
        }
        if (this.type == PrimitiveType.DATETIMEV2) {
            return ScalarType.createDatetimeV2Type(6);
        }
        if (this.type == PrimitiveType.TIMEV2) {
            return ScalarType.createTimeV2Type(6);
        }
        return ScalarType.createType(PrimitiveType.values()[this.type.ordinal() + 1]);
    }

    public ScalarType getMinResolutionDecimal() {
        switch (this.type) {
            case NULL_TYPE: {
                return Type.NULL;
            }
            case DECIMALV2: {
                return this;
            }
            case TINYINT: {
                return ScalarType.createDecimalType(3);
            }
            case SMALLINT: {
                return ScalarType.createDecimalType(5);
            }
            case INT: {
                return ScalarType.createDecimalType(10);
            }
            case BIGINT: {
                return ScalarType.createDecimalType(19);
            }
            case FLOAT: {
                return ScalarType.createDecimalTypeInternal(38, 9, false);
            }
            case DOUBLE: {
                return ScalarType.createDecimalTypeInternal(38, 17, false);
            }
        }
        return INVALID;
    }

    public boolean isSupertypeOf(ScalarType o) {
        Preconditions.checkState((this.isDecimalV2() || this.isDecimalV3() ? 1 : 0) != 0);
        Preconditions.checkState((o.isDecimalV2() || o.isDecimalV3() ? 1 : 0) != 0);
        if (this.isWildcardDecimal()) {
            return true;
        }
        if (o.isWildcardDecimal()) {
            return false;
        }
        return this.scale >= o.scale && this.precision - this.scale >= o.precision - o.scale;
    }

    public static ScalarType getAssignmentCompatibleType(ScalarType t1, ScalarType t2, boolean strict) {
        boolean t2IsBitMap;
        boolean t2IsHLL;
        if (!t1.isValid() || !t2.isValid()) {
            return INVALID;
        }
        if (t1.equals(t2)) {
            return t1;
        }
        if (t1.isNull()) {
            return t2;
        }
        if (t2.isNull()) {
            return t1;
        }
        boolean t1IsHLL = t1.type == PrimitiveType.HLL;
        boolean bl = t2IsHLL = t2.type == PrimitiveType.HLL;
        if (t1IsHLL || t2IsHLL) {
            if (t1IsHLL && t2IsHLL) {
                return ScalarType.createHllType();
            }
            return INVALID;
        }
        boolean t1IsBitMap = t1.type == PrimitiveType.BITMAP;
        boolean bl2 = t2IsBitMap = t2.type == PrimitiveType.BITMAP;
        if (t1IsBitMap || t2IsBitMap) {
            if (t1IsBitMap && t2IsBitMap) {
                return BITMAP;
            }
            return INVALID;
        }
        if (t1.type == PrimitiveType.ALL || t2.type == PrimitiveType.ALL) {
            return Type.ALL;
        }
        if (t1.isStringType() || t2.isStringType()) {
            if (t1.type == PrimitiveType.STRING || t2.type == PrimitiveType.STRING) {
                return ScalarType.createStringType();
            }
            return ScalarType.createVarcharType(Math.max(t1.len, t2.len));
        }
        if ((t1.isDecimalV3() || t1.isDecimalV2()) && (t2.isDateV2() || t2.isDate()) || (t2.isDecimalV3() || t2.isDecimalV2()) && (t1.isDateV2() || t1.isDate())) {
            return Type.DOUBLE;
        }
        if (t1.isDecimalV2() && t2.isDecimalV2()) {
            return ScalarType.getAssignmentCompatibleDecimalV2Type(t1, t2);
        }
        if (t1.isDecimalV3() && t2.isDecimalV2() || t2.isDecimalV3() && t1.isDecimalV2()) {
            int scale = Math.max(t1.scale, t2.scale);
            int integerPart = Math.max(t1.precision - t1.scale, t2.precision - t2.scale);
            return ScalarType.createDecimalV3Type(integerPart + scale, scale);
        }
        if (t1.isDecimalV2() || t2.isDecimalV2()) {
            if (t1.isFloatingPointType() || t2.isFloatingPointType()) {
                return Type.DOUBLE;
            }
            return t1.isDecimalV2() ? t1 : t2;
        }
        if (t1.isDecimalV3() || t2.isDecimalV3()) {
            if (t1.isFloatingPointType() || t2.isFloatingPointType()) {
                return t1.isFloatingPointType() ? t1 : t2;
            }
            if (t1.isBoolean() || t2.isBoolean()) {
                return t1.isDecimalV3() ? t1 : t2;
            }
        }
        if (t1.isDecimalV3() && t2.isFixedPointType() || t2.isDecimalV3() && t1.isFixedPointType()) {
            ScalarType intType;
            int scale;
            int precision;
            if (t1.isDecimalV3()) {
                precision = t1.precision;
                scale = t1.scale;
                intType = t2;
            } else {
                precision = t2.precision;
                scale = t2.scale;
                intType = t1;
            }
            int integerPart = precision - scale;
            integerPart = intType.isScalarType(PrimitiveType.TINYINT) || intType.isScalarType(PrimitiveType.SMALLINT) ? Math.max(integerPart, new BigDecimal(Short.MAX_VALUE).precision()) : (intType.isScalarType(PrimitiveType.INT) ? Math.max(integerPart, new BigDecimal(Integer.MAX_VALUE).precision()) : 38 - scale);
            if (scale + integerPart <= 38) {
                return ScalarType.createDecimalV3Type(scale + integerPart, scale);
            }
            return Type.DOUBLE;
        }
        if (t1.isDecimalV3() && t2.isDecimalV3()) {
            ScalarType finalType = ScalarType.createDecimalV3Type(Math.max(t1.decimalPrecision() - t1.decimalScale(), t2.decimalPrecision() - t2.decimalScale()) + Math.max(t1.decimalScale(), t2.decimalScale()), Math.max(t1.decimalScale(), t2.decimalScale()));
            if (finalType.getPrecision() > 38) {
                finalType = ScalarType.createDecimalV3Type(38, finalType.getScalarScale());
            }
            return finalType;
        }
        PrimitiveType smallerType = t1.type.ordinal() < t2.type.ordinal() ? t1.type : t2.type;
        PrimitiveType largerType = t1.type.ordinal() > t2.type.ordinal() ? t1.type : t2.type;
        PrimitiveType result = null;
        if (t1.isDatetimeV2() && t2.isDatetimeV2()) {
            return t1.scale > t2.scale ? t1 : t2;
        }
        if ((t1.isDatetimeV2() || t1.isDateV2()) && (t2.isDatetimeV2() || t2.isDateV2())) {
            return t1.isDatetimeV2() ? t1 : t2;
        }
        if (strict) {
            result = strictCompatibilityMatrix[smallerType.ordinal()][largerType.ordinal()];
        }
        if (result == null) {
            result = compatibilityMatrix[smallerType.ordinal()][largerType.ordinal()];
        }
        Preconditions.checkNotNull(result);
        if (result == PrimitiveType.DECIMALV2) {
            return Type.MAX_DECIMALV2_TYPE;
        }
        return ScalarType.createType(result);
    }

    public static ScalarType getAssignmentCompatibleDecimalV2Type(ScalarType t1, ScalarType t2) {
        int targetScale = Math.max(t1.decimalScale(), t2.decimalScale());
        int targetPrecision = Math.max(t1.decimalPrecision() - t1.decimalScale(), t2.decimalPrecision() - t2.decimalScale()) + targetScale;
        return ScalarType.createDecimalType(PrimitiveType.DECIMALV2, targetPrecision, targetScale);
    }

    public static ScalarType getAssignmentCompatibleDecimalV3Type(ScalarType t1, ScalarType t2) {
        int targetScale = Math.max(t1.decimalScale(), t2.decimalScale());
        int targetPrecision = Math.max(t1.decimalPrecision() - t1.decimalScale(), t2.decimalPrecision() - t2.decimalScale()) + targetScale;
        return ScalarType.createDecimalV3Type(targetPrecision, targetScale);
    }

    public static boolean isImplicitlyCastable(ScalarType t1, ScalarType t2, boolean strict) {
        return ScalarType.getAssignmentCompatibleType(t1, t2, strict).matchesType(t2);
    }

    public static boolean canCastTo(ScalarType type, ScalarType targetType) {
        return PrimitiveType.isImplicitCast(type.getPrimitiveType(), targetType.getPrimitiveType());
    }

    public boolean isDefaultDecimal() {
        return (this.isDecimalV3() || this.isDecimalV2()) && 9 == this.precision && 0 == this.scale;
    }

    @Override
    public TColumnType toColumnTypeThrift() {
        TColumnType thrift = new TColumnType();
        thrift.type = this.type.toThrift();
        if (this.type == PrimitiveType.CHAR || this.type == PrimitiveType.VARCHAR || this.type == PrimitiveType.HLL) {
            thrift.setLen(this.len);
        }
        if (this.type == PrimitiveType.DECIMALV2 || this.type.isDecimalV3Type() || this.type == PrimitiveType.DATETIMEV2 || this.type == PrimitiveType.TIMEV2) {
            thrift.setPrecision(this.precision);
            thrift.setScale(this.scale);
        }
        return thrift;
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + Objects.hashCode((Object)this.type);
        result = 31 * result + this.precision;
        result = 31 * result + this.scale;
        return result;
    }
}

