/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.catalog.MysqlColType;
import org.apache.doris.common.Config;
import org.apache.doris.thrift.TPrimitiveType;

public enum PrimitiveType {
    INVALID_TYPE("INVALID_TYPE", -1, TPrimitiveType.INVALID_TYPE, false),
    UNSUPPORTED("UNSUPPORTED_TYPE", -1, TPrimitiveType.UNSUPPORTED, false),
    NULL_TYPE("NULL_TYPE", 1, TPrimitiveType.NULL_TYPE, false),
    BOOLEAN("BOOLEAN", 1, TPrimitiveType.BOOLEAN, true),
    TINYINT("TINYINT", 1, TPrimitiveType.TINYINT, true),
    SMALLINT("SMALLINT", 2, TPrimitiveType.SMALLINT, true),
    INT("INT", 4, TPrimitiveType.INT, true),
    BIGINT("BIGINT", 8, TPrimitiveType.BIGINT, true),
    LARGEINT("LARGEINT", 16, TPrimitiveType.LARGEINT, true),
    FLOAT("FLOAT", 4, TPrimitiveType.FLOAT, true),
    DOUBLE("DOUBLE", 8, TPrimitiveType.DOUBLE, true),
    DATE("DATE", 16, TPrimitiveType.DATE, true),
    DATETIME("DATETIME", 16, TPrimitiveType.DATETIME, true),
    CHAR("CHAR", 16, TPrimitiveType.CHAR, true),
    VARCHAR("VARCHAR", 16, TPrimitiveType.VARCHAR, true),
    JSONB("JSON", 16, TPrimitiveType.JSONB, true),
    DECIMALV2("DECIMALV2", 16, TPrimitiveType.DECIMALV2, true),
    DECIMAL32("DECIMAL32", 4, TPrimitiveType.DECIMAL32, true),
    DECIMAL64("DECIMAL64", 8, TPrimitiveType.DECIMAL64, true),
    DECIMAL128("DECIMAL128", 16, TPrimitiveType.DECIMAL128I, true),
    TIME("TIME", 8, TPrimitiveType.TIME, false),
    HLL("HLL", 16, TPrimitiveType.HLL, true),
    BITMAP("BITMAP", 16, TPrimitiveType.OBJECT, true),
    QUANTILE_STATE("QUANTILE_STATE", 16, TPrimitiveType.QUANTILE_STATE, true),
    AGG_STATE("AGG_STATE", 16, TPrimitiveType.AGG_STATE, true),
    DATEV2("DATEV2", 4, TPrimitiveType.DATEV2, true),
    DATETIMEV2("DATETIMEV2", 8, TPrimitiveType.DATETIMEV2, true),
    TIMEV2("TIMEV2", 8, TPrimitiveType.TIMEV2, false),
    LAMBDA_FUNCTION("LAMBDA_FUNCTION", 16, TPrimitiveType.LAMBDA_FUNCTION, false),
    ARRAY("ARRAY", 32, TPrimitiveType.ARRAY, true),
    MAP("MAP", 24, TPrimitiveType.MAP, true),
    STRUCT("STRUCT", 16, TPrimitiveType.STRUCT, false),
    STRING("STRING", 16, TPrimitiveType.STRING, true),
    VARIANT("VARIANT", 24, TPrimitiveType.VARIANT, false),
    TEMPLATE("TEMPLATE", -1, TPrimitiveType.INVALID_TYPE, false),
    BINARY("BINARY", -1, TPrimitiveType.BINARY, false),
    ALL("ALL", -1, TPrimitiveType.INVALID_TYPE, false);

    private static final int DATE_INDEX_LEN = 3;
    private static final int DATEV2_INDEX_LEN = 4;
    private static final int DATETIME_INDEX_LEN = 8;
    private static final int VARCHAR_INDEX_LEN = 20;
    private static final int STRING_INDEX_LEN = 20;
    private static final int DECIMAL_INDEX_LEN = 12;
    public static ImmutableSet<PrimitiveType> typeWithPrecision;
    private static ImmutableSetMultimap<PrimitiveType, PrimitiveType> implicitCastMap;
    private static ArrayList<PrimitiveType> integerTypes;
    private static ArrayList<PrimitiveType> numericTypes;
    private static ArrayList<PrimitiveType> supportedTypes;
    private static PrimitiveType[][] compatibilityMatrix;
    private final String description;
    private final int slotSize;
    private final TPrimitiveType thriftType;
    private final boolean availableInDdl;
    private boolean isTimeType = false;

    public static ImmutableSetMultimap<PrimitiveType, PrimitiveType> getImplicitCastMap() {
        return implicitCastMap;
    }

    public static ArrayList<PrimitiveType> getIntegerTypes() {
        return integerTypes;
    }

    public static ArrayList<PrimitiveType> getNumericTypes() {
        return numericTypes;
    }

    public static ArrayList<PrimitiveType> getSupportedTypes() {
        return supportedTypes;
    }

    public static boolean isImplicitCast(PrimitiveType type, PrimitiveType target) {
        return implicitCastMap.get((Object)type).contains((Object)target);
    }

    private PrimitiveType(String description, int slotSize, TPrimitiveType thriftType, boolean availableInDdl) {
        this.description = description;
        this.slotSize = slotSize;
        this.thriftType = thriftType;
        this.availableInDdl = availableInDdl;
    }

    public void setTimeType() {
        this.isTimeType = true;
    }

    public boolean isTimeType() {
        return this.isTimeType;
    }

    public static PrimitiveType fromThrift(TPrimitiveType tPrimitiveType) {
        switch (tPrimitiveType) {
            case NULL_TYPE: {
                return NULL_TYPE;
            }
            case BOOLEAN: {
                return BOOLEAN;
            }
            case TINYINT: {
                return TINYINT;
            }
            case SMALLINT: {
                return SMALLINT;
            }
            case INT: {
                return INT;
            }
            case BIGINT: {
                return BIGINT;
            }
            case LARGEINT: {
                return LARGEINT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case DATE: {
                return DATE;
            }
            case DATETIME: {
                return DATETIME;
            }
            case DATEV2: {
                return DATEV2;
            }
            case DATETIMEV2: {
                return DATETIMEV2;
            }
            case BINARY: {
                return BINARY;
            }
            case DECIMALV2: {
                return DECIMALV2;
            }
            case DECIMAL32: {
                return DECIMAL32;
            }
            case DECIMAL64: {
                return DECIMAL64;
            }
            case DECIMAL128I: {
                return DECIMAL128;
            }
            case TIME: {
                return TIME;
            }
            case TIMEV2: {
                return TIMEV2;
            }
            case VARCHAR: {
                return VARCHAR;
            }
            case JSONB: {
                return JSONB;
            }
            case STRING: {
                return STRING;
            }
            case CHAR: {
                return CHAR;
            }
            case HLL: {
                return HLL;
            }
            case OBJECT: {
                return BITMAP;
            }
            case QUANTILE_STATE: {
                return QUANTILE_STATE;
            }
            case AGG_STATE: {
                return AGG_STATE;
            }
            case ARRAY: {
                return ARRAY;
            }
            case MAP: {
                return MAP;
            }
            case STRUCT: {
                return STRUCT;
            }
            case ALL: {
                return ALL;
            }
            case VARIANT: {
                return VARIANT;
            }
        }
        return INVALID_TYPE;
    }

    public static List<TPrimitiveType> toThrift(PrimitiveType[] types) {
        ArrayList result = Lists.newArrayList();
        for (PrimitiveType t : types) {
            result.add(t.toThrift());
        }
        return result;
    }

    public static int getMaxSlotSize() {
        return PrimitiveType.ARRAY.slotSize;
    }

    public static PrimitiveType getAssignmentCompatibleType(PrimitiveType t1, PrimitiveType t2) {
        if (!t1.isValid() || !t2.isValid()) {
            return INVALID_TYPE;
        }
        PrimitiveType smallerType = t1.ordinal() < t2.ordinal() ? t1 : t2;
        PrimitiveType largerType = t1.ordinal() > t2.ordinal() ? t1 : t2;
        PrimitiveType result = compatibilityMatrix[smallerType.ordinal()][largerType.ordinal()];
        Preconditions.checkNotNull((Object)((Object)result));
        return result;
    }

    public static boolean isImplicitlyCastable(PrimitiveType t1, PrimitiveType t2) {
        return PrimitiveType.getAssignmentCompatibleType(t1, t2) == t2;
    }

    public String toString() {
        return this.description;
    }

    public TPrimitiveType toThrift() {
        return this.thriftType;
    }

    public int getSlotSize() {
        return this.slotSize;
    }

    public boolean isAvailableInDdl() {
        return this.availableInDdl;
    }

    public boolean isFixedPointType() {
        return this == TINYINT || this == SMALLINT || this == INT || this == BIGINT || this == LARGEINT;
    }

    public boolean isFloatingPointType() {
        return this == FLOAT || this == DOUBLE;
    }

    public boolean isDecimalV2Type() {
        return this == DECIMALV2;
    }

    public boolean isDecimalV3Type() {
        return this == DECIMAL32 || this == DECIMAL64 || this == DECIMAL128;
    }

    public boolean isNumericType() {
        return this.isFixedPointType() || this.isFloatingPointType() || this.isDecimalV2Type() || this.isDecimalV3Type();
    }

    public boolean isValid() {
        return this != INVALID_TYPE;
    }

    public boolean isNull() {
        return this == NULL_TYPE;
    }

    public boolean isDateType() {
        return this == DATE || this == DATETIME || this == DATEV2 || this == DATETIMEV2;
    }

    public boolean isDateV2Type() {
        return this == DATEV2 || this == DATETIMEV2;
    }

    public boolean isArrayType() {
        return this == ARRAY;
    }

    public boolean isMapType() {
        return this == MAP;
    }

    public boolean isStructType() {
        return this == STRUCT;
    }

    public boolean isComplexType() {
        return this == ARRAY || this == MAP || this == STRUCT;
    }

    public boolean isHllType() {
        return this == HLL;
    }

    public boolean isBitmapType() {
        return this == BITMAP;
    }

    public boolean isVariantType() {
        return this == VARIANT;
    }

    public boolean isStringType() {
        return this == VARCHAR || this == CHAR || this == STRING || this == AGG_STATE;
    }

    public boolean isJsonbType() {
        return this == JSONB;
    }

    public boolean isCharFamily() {
        return this == VARCHAR || this == CHAR || this == STRING;
    }

    public boolean isIntegerType() {
        return this == TINYINT || this == SMALLINT || this == INT || this == BIGINT;
    }

    public MysqlColType toMysqlType() {
        switch (this) {
            case BOOLEAN: 
            case TINYINT: {
                return MysqlColType.MYSQL_TYPE_TINY;
            }
            case SMALLINT: {
                return MysqlColType.MYSQL_TYPE_SHORT;
            }
            case INT: {
                return MysqlColType.MYSQL_TYPE_LONG;
            }
            case BIGINT: {
                return MysqlColType.MYSQL_TYPE_LONGLONG;
            }
            case LARGEINT: {
                if (Config.use_mysql_bigint_for_largeint) {
                    return MysqlColType.MYSQL_TYPE_LONGLONG;
                }
                return MysqlColType.MYSQL_TYPE_STRING;
            }
            case FLOAT: {
                return MysqlColType.MYSQL_TYPE_FLOAT;
            }
            case DOUBLE: {
                return MysqlColType.MYSQL_TYPE_DOUBLE;
            }
            case TIME: 
            case TIMEV2: {
                return MysqlColType.MYSQL_TYPE_TIME;
            }
            case DATE: 
            case DATEV2: {
                return MysqlColType.MYSQL_TYPE_DATE;
            }
            case DATETIME: 
            case DATETIMEV2: {
                if (this.isTimeType) {
                    return MysqlColType.MYSQL_TYPE_TIME;
                }
                return MysqlColType.MYSQL_TYPE_DATETIME;
            }
            case DECIMALV2: 
            case DECIMAL32: 
            case DECIMAL64: 
            case DECIMAL128: {
                return MysqlColType.MYSQL_TYPE_NEWDECIMAL;
            }
            case STRING: {
                return MysqlColType.MYSQL_TYPE_BLOB;
            }
            case JSONB: {
                return MysqlColType.MYSQL_TYPE_JSON;
            }
            case MAP: {
                return MysqlColType.MYSQL_TYPE_MAP;
            }
        }
        return MysqlColType.MYSQL_TYPE_STRING;
    }

    public int getOlapColumnIndexSize() {
        switch (this) {
            case DATE: {
                return 3;
            }
            case DATEV2: {
                return 4;
            }
            case DATETIME: 
            case DATETIMEV2: {
                return 8;
            }
            case VARCHAR: {
                return 20;
            }
            case CHAR: {
                return -1;
            }
            case STRING: {
                return 20;
            }
            case DECIMALV2: {
                return 12;
            }
            case DECIMAL32: {
                return 4;
            }
            case DECIMAL64: {
                return 8;
            }
            case DECIMAL128: {
                return 16;
            }
        }
        return this.getSlotSize();
    }

    static {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)DECIMAL32);
        builder.add((Object)DECIMAL64);
        builder.add((Object)DECIMAL128);
        builder.add((Object)DATETIMEV2);
        typeWithPrecision = builder.build();
        builder = ImmutableSetMultimap.builder();
        builder.put((Object)NULL_TYPE, (Object)BOOLEAN);
        builder.put((Object)NULL_TYPE, (Object)TINYINT);
        builder.put((Object)NULL_TYPE, (Object)SMALLINT);
        builder.put((Object)NULL_TYPE, (Object)INT);
        builder.put((Object)NULL_TYPE, (Object)BIGINT);
        builder.put((Object)NULL_TYPE, (Object)LARGEINT);
        builder.put((Object)NULL_TYPE, (Object)FLOAT);
        builder.put((Object)NULL_TYPE, (Object)DOUBLE);
        builder.put((Object)NULL_TYPE, (Object)DATE);
        builder.put((Object)NULL_TYPE, (Object)DATETIME);
        builder.put((Object)NULL_TYPE, (Object)DATEV2);
        builder.put((Object)NULL_TYPE, (Object)DATETIMEV2);
        builder.put((Object)NULL_TYPE, (Object)DECIMALV2);
        builder.put((Object)NULL_TYPE, (Object)DECIMAL32);
        builder.put((Object)NULL_TYPE, (Object)DECIMAL64);
        builder.put((Object)NULL_TYPE, (Object)DECIMAL128);
        builder.put((Object)NULL_TYPE, (Object)CHAR);
        builder.put((Object)NULL_TYPE, (Object)VARCHAR);
        builder.put((Object)NULL_TYPE, (Object)STRING);
        builder.put((Object)NULL_TYPE, (Object)JSONB);
        builder.put((Object)NULL_TYPE, (Object)BITMAP);
        builder.put((Object)NULL_TYPE, (Object)TIME);
        builder.put((Object)NULL_TYPE, (Object)TIMEV2);
        builder.put((Object)BOOLEAN, (Object)BOOLEAN);
        builder.put((Object)BOOLEAN, (Object)TINYINT);
        builder.put((Object)BOOLEAN, (Object)SMALLINT);
        builder.put((Object)BOOLEAN, (Object)INT);
        builder.put((Object)BOOLEAN, (Object)BIGINT);
        builder.put((Object)BOOLEAN, (Object)LARGEINT);
        builder.put((Object)BOOLEAN, (Object)FLOAT);
        builder.put((Object)BOOLEAN, (Object)DOUBLE);
        builder.put((Object)BOOLEAN, (Object)DATE);
        builder.put((Object)BOOLEAN, (Object)DATETIME);
        builder.put((Object)BOOLEAN, (Object)DATEV2);
        builder.put((Object)BOOLEAN, (Object)DATETIMEV2);
        builder.put((Object)BOOLEAN, (Object)DECIMALV2);
        builder.put((Object)BOOLEAN, (Object)DECIMAL32);
        builder.put((Object)BOOLEAN, (Object)DECIMAL64);
        builder.put((Object)BOOLEAN, (Object)DECIMAL128);
        builder.put((Object)BOOLEAN, (Object)VARCHAR);
        builder.put((Object)BOOLEAN, (Object)STRING);
        builder.put((Object)TINYINT, (Object)BOOLEAN);
        builder.put((Object)TINYINT, (Object)TINYINT);
        builder.put((Object)TINYINT, (Object)SMALLINT);
        builder.put((Object)TINYINT, (Object)INT);
        builder.put((Object)TINYINT, (Object)BIGINT);
        builder.put((Object)TINYINT, (Object)LARGEINT);
        builder.put((Object)TINYINT, (Object)FLOAT);
        builder.put((Object)TINYINT, (Object)DOUBLE);
        builder.put((Object)TINYINT, (Object)DATE);
        builder.put((Object)TINYINT, (Object)DATETIME);
        builder.put((Object)TINYINT, (Object)DATEV2);
        builder.put((Object)TINYINT, (Object)DATETIMEV2);
        builder.put((Object)TINYINT, (Object)DECIMALV2);
        builder.put((Object)TINYINT, (Object)DECIMAL32);
        builder.put((Object)TINYINT, (Object)DECIMAL64);
        builder.put((Object)TINYINT, (Object)DECIMAL128);
        builder.put((Object)TINYINT, (Object)VARCHAR);
        builder.put((Object)TINYINT, (Object)STRING);
        builder.put((Object)SMALLINT, (Object)BOOLEAN);
        builder.put((Object)SMALLINT, (Object)TINYINT);
        builder.put((Object)SMALLINT, (Object)SMALLINT);
        builder.put((Object)SMALLINT, (Object)INT);
        builder.put((Object)SMALLINT, (Object)BIGINT);
        builder.put((Object)SMALLINT, (Object)LARGEINT);
        builder.put((Object)SMALLINT, (Object)FLOAT);
        builder.put((Object)SMALLINT, (Object)DOUBLE);
        builder.put((Object)SMALLINT, (Object)DATE);
        builder.put((Object)SMALLINT, (Object)DATETIME);
        builder.put((Object)SMALLINT, (Object)DATEV2);
        builder.put((Object)SMALLINT, (Object)DATETIMEV2);
        builder.put((Object)SMALLINT, (Object)DECIMALV2);
        builder.put((Object)SMALLINT, (Object)DECIMAL32);
        builder.put((Object)SMALLINT, (Object)DECIMAL64);
        builder.put((Object)SMALLINT, (Object)DECIMAL128);
        builder.put((Object)SMALLINT, (Object)VARCHAR);
        builder.put((Object)SMALLINT, (Object)STRING);
        builder.put((Object)INT, (Object)BOOLEAN);
        builder.put((Object)INT, (Object)TINYINT);
        builder.put((Object)INT, (Object)SMALLINT);
        builder.put((Object)INT, (Object)INT);
        builder.put((Object)INT, (Object)BIGINT);
        builder.put((Object)INT, (Object)LARGEINT);
        builder.put((Object)INT, (Object)FLOAT);
        builder.put((Object)INT, (Object)DOUBLE);
        builder.put((Object)INT, (Object)DATE);
        builder.put((Object)INT, (Object)DATETIME);
        builder.put((Object)INT, (Object)DATEV2);
        builder.put((Object)INT, (Object)DATETIMEV2);
        builder.put((Object)INT, (Object)DECIMALV2);
        builder.put((Object)INT, (Object)DECIMAL32);
        builder.put((Object)INT, (Object)DECIMAL64);
        builder.put((Object)INT, (Object)DECIMAL128);
        builder.put((Object)INT, (Object)VARCHAR);
        builder.put((Object)INT, (Object)STRING);
        builder.put((Object)BIGINT, (Object)BOOLEAN);
        builder.put((Object)BIGINT, (Object)TINYINT);
        builder.put((Object)BIGINT, (Object)SMALLINT);
        builder.put((Object)BIGINT, (Object)INT);
        builder.put((Object)BIGINT, (Object)BIGINT);
        builder.put((Object)BIGINT, (Object)LARGEINT);
        builder.put((Object)BIGINT, (Object)FLOAT);
        builder.put((Object)BIGINT, (Object)DOUBLE);
        builder.put((Object)BIGINT, (Object)DATE);
        builder.put((Object)BIGINT, (Object)DATETIME);
        builder.put((Object)BIGINT, (Object)DATEV2);
        builder.put((Object)BIGINT, (Object)DATETIMEV2);
        builder.put((Object)BIGINT, (Object)DECIMALV2);
        builder.put((Object)BIGINT, (Object)DECIMAL32);
        builder.put((Object)BIGINT, (Object)DECIMAL64);
        builder.put((Object)BIGINT, (Object)DECIMAL128);
        builder.put((Object)BIGINT, (Object)VARCHAR);
        builder.put((Object)BIGINT, (Object)STRING);
        builder.put((Object)LARGEINT, (Object)BOOLEAN);
        builder.put((Object)LARGEINT, (Object)TINYINT);
        builder.put((Object)LARGEINT, (Object)SMALLINT);
        builder.put((Object)LARGEINT, (Object)INT);
        builder.put((Object)LARGEINT, (Object)BIGINT);
        builder.put((Object)LARGEINT, (Object)LARGEINT);
        builder.put((Object)LARGEINT, (Object)FLOAT);
        builder.put((Object)LARGEINT, (Object)DOUBLE);
        builder.put((Object)LARGEINT, (Object)DATE);
        builder.put((Object)LARGEINT, (Object)DATETIME);
        builder.put((Object)LARGEINT, (Object)DATEV2);
        builder.put((Object)LARGEINT, (Object)DATETIMEV2);
        builder.put((Object)LARGEINT, (Object)DECIMALV2);
        builder.put((Object)LARGEINT, (Object)DECIMAL32);
        builder.put((Object)LARGEINT, (Object)DECIMAL64);
        builder.put((Object)LARGEINT, (Object)DECIMAL128);
        builder.put((Object)LARGEINT, (Object)VARCHAR);
        builder.put((Object)LARGEINT, (Object)STRING);
        builder.put((Object)FLOAT, (Object)BOOLEAN);
        builder.put((Object)FLOAT, (Object)TINYINT);
        builder.put((Object)FLOAT, (Object)SMALLINT);
        builder.put((Object)FLOAT, (Object)INT);
        builder.put((Object)FLOAT, (Object)BIGINT);
        builder.put((Object)FLOAT, (Object)LARGEINT);
        builder.put((Object)FLOAT, (Object)FLOAT);
        builder.put((Object)FLOAT, (Object)DOUBLE);
        builder.put((Object)FLOAT, (Object)DATE);
        builder.put((Object)FLOAT, (Object)DATETIME);
        builder.put((Object)FLOAT, (Object)DATEV2);
        builder.put((Object)FLOAT, (Object)DATETIMEV2);
        builder.put((Object)FLOAT, (Object)DECIMALV2);
        builder.put((Object)FLOAT, (Object)DECIMAL32);
        builder.put((Object)FLOAT, (Object)DECIMAL64);
        builder.put((Object)FLOAT, (Object)DECIMAL128);
        builder.put((Object)FLOAT, (Object)VARCHAR);
        builder.put((Object)FLOAT, (Object)STRING);
        builder.put((Object)DOUBLE, (Object)BOOLEAN);
        builder.put((Object)DOUBLE, (Object)TINYINT);
        builder.put((Object)DOUBLE, (Object)SMALLINT);
        builder.put((Object)DOUBLE, (Object)INT);
        builder.put((Object)DOUBLE, (Object)BIGINT);
        builder.put((Object)DOUBLE, (Object)LARGEINT);
        builder.put((Object)DOUBLE, (Object)FLOAT);
        builder.put((Object)DOUBLE, (Object)DOUBLE);
        builder.put((Object)DOUBLE, (Object)DATE);
        builder.put((Object)DOUBLE, (Object)DATETIME);
        builder.put((Object)DOUBLE, (Object)DATEV2);
        builder.put((Object)DOUBLE, (Object)DATETIMEV2);
        builder.put((Object)DOUBLE, (Object)DECIMALV2);
        builder.put((Object)DOUBLE, (Object)DECIMAL32);
        builder.put((Object)DOUBLE, (Object)DECIMAL64);
        builder.put((Object)DOUBLE, (Object)DECIMAL128);
        builder.put((Object)DOUBLE, (Object)VARCHAR);
        builder.put((Object)DOUBLE, (Object)STRING);
        builder.put((Object)DATE, (Object)BOOLEAN);
        builder.put((Object)DATE, (Object)TINYINT);
        builder.put((Object)DATE, (Object)SMALLINT);
        builder.put((Object)DATE, (Object)INT);
        builder.put((Object)DATE, (Object)BIGINT);
        builder.put((Object)DATE, (Object)LARGEINT);
        builder.put((Object)DATE, (Object)FLOAT);
        builder.put((Object)DATE, (Object)DOUBLE);
        builder.put((Object)DATE, (Object)DATE);
        builder.put((Object)DATE, (Object)DATETIME);
        builder.put((Object)DATE, (Object)DATEV2);
        builder.put((Object)DATE, (Object)DATETIMEV2);
        builder.put((Object)DATE, (Object)DECIMALV2);
        builder.put((Object)DATE, (Object)DECIMAL32);
        builder.put((Object)DATE, (Object)DECIMAL64);
        builder.put((Object)DATE, (Object)DECIMAL128);
        builder.put((Object)DATE, (Object)VARCHAR);
        builder.put((Object)DATE, (Object)STRING);
        builder.put((Object)DATETIME, (Object)BOOLEAN);
        builder.put((Object)DATETIME, (Object)TINYINT);
        builder.put((Object)DATETIME, (Object)SMALLINT);
        builder.put((Object)DATETIME, (Object)INT);
        builder.put((Object)DATETIME, (Object)BIGINT);
        builder.put((Object)DATETIME, (Object)LARGEINT);
        builder.put((Object)DATETIME, (Object)FLOAT);
        builder.put((Object)DATETIME, (Object)DOUBLE);
        builder.put((Object)DATETIME, (Object)DATE);
        builder.put((Object)DATETIME, (Object)DATETIME);
        builder.put((Object)DATETIME, (Object)DATEV2);
        builder.put((Object)DATETIME, (Object)DATETIMEV2);
        builder.put((Object)DATETIME, (Object)DECIMALV2);
        builder.put((Object)DATETIME, (Object)DECIMAL32);
        builder.put((Object)DATETIME, (Object)DECIMAL64);
        builder.put((Object)DATETIME, (Object)DECIMAL128);
        builder.put((Object)DATETIME, (Object)VARCHAR);
        builder.put((Object)DATETIME, (Object)STRING);
        builder.put((Object)DATEV2, (Object)BOOLEAN);
        builder.put((Object)DATEV2, (Object)TINYINT);
        builder.put((Object)DATEV2, (Object)SMALLINT);
        builder.put((Object)DATEV2, (Object)INT);
        builder.put((Object)DATEV2, (Object)BIGINT);
        builder.put((Object)DATEV2, (Object)LARGEINT);
        builder.put((Object)DATEV2, (Object)FLOAT);
        builder.put((Object)DATEV2, (Object)DOUBLE);
        builder.put((Object)DATEV2, (Object)DATE);
        builder.put((Object)DATEV2, (Object)DATETIME);
        builder.put((Object)DATEV2, (Object)DATEV2);
        builder.put((Object)DATEV2, (Object)DATETIMEV2);
        builder.put((Object)DATEV2, (Object)DECIMALV2);
        builder.put((Object)DATEV2, (Object)DECIMAL32);
        builder.put((Object)DATEV2, (Object)DECIMAL64);
        builder.put((Object)DATEV2, (Object)DECIMAL128);
        builder.put((Object)DATEV2, (Object)VARCHAR);
        builder.put((Object)DATEV2, (Object)STRING);
        builder.put((Object)DATETIMEV2, (Object)BOOLEAN);
        builder.put((Object)DATETIMEV2, (Object)TINYINT);
        builder.put((Object)DATETIMEV2, (Object)SMALLINT);
        builder.put((Object)DATETIMEV2, (Object)INT);
        builder.put((Object)DATETIMEV2, (Object)BIGINT);
        builder.put((Object)DATETIMEV2, (Object)LARGEINT);
        builder.put((Object)DATETIMEV2, (Object)FLOAT);
        builder.put((Object)DATETIMEV2, (Object)DOUBLE);
        builder.put((Object)DATETIMEV2, (Object)DATE);
        builder.put((Object)DATETIMEV2, (Object)DATETIME);
        builder.put((Object)DATETIMEV2, (Object)DATEV2);
        builder.put((Object)DATETIMEV2, (Object)DATETIMEV2);
        builder.put((Object)DATETIMEV2, (Object)DECIMALV2);
        builder.put((Object)DATETIMEV2, (Object)DECIMAL32);
        builder.put((Object)DATETIMEV2, (Object)DECIMAL64);
        builder.put((Object)DATETIMEV2, (Object)DECIMAL128);
        builder.put((Object)DATETIMEV2, (Object)VARCHAR);
        builder.put((Object)DATETIMEV2, (Object)STRING);
        builder.put((Object)CHAR, (Object)BOOLEAN);
        builder.put((Object)CHAR, (Object)TINYINT);
        builder.put((Object)CHAR, (Object)SMALLINT);
        builder.put((Object)CHAR, (Object)CHAR);
        builder.put((Object)CHAR, (Object)INT);
        builder.put((Object)CHAR, (Object)BIGINT);
        builder.put((Object)CHAR, (Object)LARGEINT);
        builder.put((Object)CHAR, (Object)FLOAT);
        builder.put((Object)CHAR, (Object)DOUBLE);
        builder.put((Object)CHAR, (Object)DATE);
        builder.put((Object)CHAR, (Object)DATETIME);
        builder.put((Object)CHAR, (Object)DATEV2);
        builder.put((Object)CHAR, (Object)DATETIMEV2);
        builder.put((Object)CHAR, (Object)DECIMALV2);
        builder.put((Object)CHAR, (Object)DECIMAL32);
        builder.put((Object)CHAR, (Object)DECIMAL64);
        builder.put((Object)CHAR, (Object)DECIMAL128);
        builder.put((Object)CHAR, (Object)VARCHAR);
        builder.put((Object)CHAR, (Object)STRING);
        builder.put((Object)VARCHAR, (Object)BOOLEAN);
        builder.put((Object)VARCHAR, (Object)TINYINT);
        builder.put((Object)VARCHAR, (Object)SMALLINT);
        builder.put((Object)VARCHAR, (Object)INT);
        builder.put((Object)VARCHAR, (Object)BIGINT);
        builder.put((Object)VARCHAR, (Object)LARGEINT);
        builder.put((Object)VARCHAR, (Object)FLOAT);
        builder.put((Object)VARCHAR, (Object)DOUBLE);
        builder.put((Object)VARCHAR, (Object)DATE);
        builder.put((Object)VARCHAR, (Object)DATETIME);
        builder.put((Object)VARCHAR, (Object)DATEV2);
        builder.put((Object)VARCHAR, (Object)DATETIMEV2);
        builder.put((Object)VARCHAR, (Object)DECIMALV2);
        builder.put((Object)VARCHAR, (Object)DECIMAL32);
        builder.put((Object)VARCHAR, (Object)DECIMAL64);
        builder.put((Object)VARCHAR, (Object)DECIMAL128);
        builder.put((Object)VARCHAR, (Object)VARCHAR);
        builder.put((Object)VARCHAR, (Object)JSONB);
        builder.put((Object)VARCHAR, (Object)STRING);
        builder.put((Object)STRING, (Object)BOOLEAN);
        builder.put((Object)STRING, (Object)TINYINT);
        builder.put((Object)STRING, (Object)SMALLINT);
        builder.put((Object)STRING, (Object)INT);
        builder.put((Object)STRING, (Object)BIGINT);
        builder.put((Object)STRING, (Object)LARGEINT);
        builder.put((Object)STRING, (Object)FLOAT);
        builder.put((Object)STRING, (Object)DOUBLE);
        builder.put((Object)STRING, (Object)DATE);
        builder.put((Object)STRING, (Object)DATETIME);
        builder.put((Object)STRING, (Object)DATEV2);
        builder.put((Object)STRING, (Object)DATETIMEV2);
        builder.put((Object)STRING, (Object)DECIMALV2);
        builder.put((Object)STRING, (Object)DECIMAL32);
        builder.put((Object)STRING, (Object)DECIMAL64);
        builder.put((Object)STRING, (Object)DECIMAL128);
        builder.put((Object)STRING, (Object)VARCHAR);
        builder.put((Object)STRING, (Object)JSONB);
        builder.put((Object)STRING, (Object)STRING);
        builder.put((Object)DECIMALV2, (Object)BOOLEAN);
        builder.put((Object)DECIMALV2, (Object)TINYINT);
        builder.put((Object)DECIMALV2, (Object)SMALLINT);
        builder.put((Object)DECIMALV2, (Object)INT);
        builder.put((Object)DECIMALV2, (Object)BIGINT);
        builder.put((Object)DECIMALV2, (Object)LARGEINT);
        builder.put((Object)DECIMALV2, (Object)FLOAT);
        builder.put((Object)DECIMALV2, (Object)DOUBLE);
        builder.put((Object)DECIMALV2, (Object)DECIMALV2);
        builder.put((Object)DECIMALV2, (Object)DECIMAL32);
        builder.put((Object)DECIMALV2, (Object)DECIMAL64);
        builder.put((Object)DECIMALV2, (Object)DECIMAL128);
        builder.put((Object)DECIMALV2, (Object)VARCHAR);
        builder.put((Object)DECIMALV2, (Object)STRING);
        builder.put((Object)DECIMAL32, (Object)BOOLEAN);
        builder.put((Object)DECIMAL32, (Object)TINYINT);
        builder.put((Object)DECIMAL32, (Object)SMALLINT);
        builder.put((Object)DECIMAL32, (Object)INT);
        builder.put((Object)DECIMAL32, (Object)BIGINT);
        builder.put((Object)DECIMAL32, (Object)LARGEINT);
        builder.put((Object)DECIMAL32, (Object)FLOAT);
        builder.put((Object)DECIMAL32, (Object)DOUBLE);
        builder.put((Object)DECIMAL32, (Object)DECIMALV2);
        builder.put((Object)DECIMAL32, (Object)DECIMAL32);
        builder.put((Object)DECIMAL32, (Object)DECIMAL64);
        builder.put((Object)DECIMAL32, (Object)DECIMAL128);
        builder.put((Object)DECIMAL32, (Object)VARCHAR);
        builder.put((Object)DECIMAL32, (Object)STRING);
        builder.put((Object)DECIMAL64, (Object)BOOLEAN);
        builder.put((Object)DECIMAL64, (Object)TINYINT);
        builder.put((Object)DECIMAL64, (Object)SMALLINT);
        builder.put((Object)DECIMAL64, (Object)INT);
        builder.put((Object)DECIMAL64, (Object)BIGINT);
        builder.put((Object)DECIMAL64, (Object)LARGEINT);
        builder.put((Object)DECIMAL64, (Object)FLOAT);
        builder.put((Object)DECIMAL64, (Object)DOUBLE);
        builder.put((Object)DECIMAL64, (Object)DECIMALV2);
        builder.put((Object)DECIMAL64, (Object)DECIMAL32);
        builder.put((Object)DECIMAL64, (Object)DECIMAL64);
        builder.put((Object)DECIMAL64, (Object)DECIMAL128);
        builder.put((Object)DECIMAL64, (Object)VARCHAR);
        builder.put((Object)DECIMAL64, (Object)STRING);
        builder.put((Object)DECIMAL128, (Object)BOOLEAN);
        builder.put((Object)DECIMAL128, (Object)TINYINT);
        builder.put((Object)DECIMAL128, (Object)SMALLINT);
        builder.put((Object)DECIMAL128, (Object)INT);
        builder.put((Object)DECIMAL128, (Object)BIGINT);
        builder.put((Object)DECIMAL128, (Object)LARGEINT);
        builder.put((Object)DECIMAL128, (Object)FLOAT);
        builder.put((Object)DECIMAL128, (Object)DOUBLE);
        builder.put((Object)DECIMAL128, (Object)DECIMALV2);
        builder.put((Object)DECIMAL128, (Object)DECIMAL32);
        builder.put((Object)DECIMAL128, (Object)DECIMAL64);
        builder.put((Object)DECIMAL128, (Object)DECIMAL128);
        builder.put((Object)DECIMAL128, (Object)VARCHAR);
        builder.put((Object)DECIMAL128, (Object)STRING);
        builder.put((Object)JSONB, (Object)VARCHAR);
        builder.put((Object)JSONB, (Object)STRING);
        builder.put((Object)HLL, (Object)HLL);
        builder.put((Object)BITMAP, (Object)BITMAP);
        builder.put((Object)QUANTILE_STATE, (Object)QUANTILE_STATE);
        builder.put((Object)AGG_STATE, (Object)AGG_STATE);
        builder.put((Object)AGG_STATE, (Object)VARCHAR);
        builder.put((Object)TIME, (Object)TIME);
        builder.put((Object)TIME, (Object)TIMEV2);
        builder.put((Object)TIME, (Object)DOUBLE);
        builder.put((Object)TIMEV2, (Object)TIME);
        builder.put((Object)TIMEV2, (Object)TIMEV2);
        builder.put((Object)TIMEV2, (Object)DOUBLE);
        implicitCastMap = builder.build();
        integerTypes = Lists.newArrayList();
        integerTypes.add(TINYINT);
        integerTypes.add(SMALLINT);
        integerTypes.add(INT);
        integerTypes.add(BIGINT);
        integerTypes.add(LARGEINT);
        numericTypes = Lists.newArrayList();
        numericTypes.add(TINYINT);
        numericTypes.add(SMALLINT);
        numericTypes.add(INT);
        numericTypes.add(BIGINT);
        numericTypes.add(LARGEINT);
        numericTypes.add(FLOAT);
        numericTypes.add(DOUBLE);
        numericTypes.add(DECIMALV2);
        numericTypes.add(DECIMAL32);
        numericTypes.add(DECIMAL64);
        numericTypes.add(DECIMAL128);
        supportedTypes = Lists.newArrayList();
        supportedTypes.add(NULL_TYPE);
        supportedTypes.add(BOOLEAN);
        supportedTypes.add(TINYINT);
        supportedTypes.add(SMALLINT);
        supportedTypes.add(INT);
        supportedTypes.add(BIGINT);
        supportedTypes.add(LARGEINT);
        supportedTypes.add(FLOAT);
        supportedTypes.add(DOUBLE);
        supportedTypes.add(VARCHAR);
        supportedTypes.add(JSONB);
        supportedTypes.add(STRING);
        supportedTypes.add(HLL);
        supportedTypes.add(CHAR);
        supportedTypes.add(DATE);
        supportedTypes.add(DATETIME);
        supportedTypes.add(TIME);
        supportedTypes.add(DATEV2);
        supportedTypes.add(DATETIMEV2);
        supportedTypes.add(TIMEV2);
        supportedTypes.add(DECIMALV2);
        supportedTypes.add(DECIMAL32);
        supportedTypes.add(DECIMAL64);
        supportedTypes.add(DECIMAL128);
        supportedTypes.add(BITMAP);
        supportedTypes.add(ARRAY);
        supportedTypes.add(MAP);
        supportedTypes.add(QUANTILE_STATE);
        supportedTypes.add(VARIANT);
        supportedTypes.add(AGG_STATE);
        compatibilityMatrix = new PrimitiveType[PrimitiveType.values().length][PrimitiveType.values().length];
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.NULL_TYPE.ordinal()] = NULL_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.BOOLEAN.ordinal()] = BOOLEAN;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.TINYINT.ordinal()] = TINYINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.SMALLINT.ordinal()] = SMALLINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.INT.ordinal()] = INT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.BIGINT.ordinal()] = BIGINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.LARGEINT.ordinal()] = LARGEINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.FLOAT.ordinal()] = FLOAT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.DOUBLE.ordinal()] = DOUBLE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.DATE.ordinal()] = DATE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.DATETIME.ordinal()] = DATETIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.DATEV2.ordinal()] = DATEV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.DATETIMEV2.ordinal()] = DATETIMEV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.CHAR.ordinal()] = CHAR;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.VARCHAR.ordinal()] = VARCHAR;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.JSONB.ordinal()] = JSONB;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.STRING.ordinal()] = STRING;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = DECIMALV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.DECIMAL32.ordinal()] = DECIMAL32;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.DECIMAL64.ordinal()] = DECIMAL64;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.DECIMAL128.ordinal()] = DECIMAL128;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.TIME.ordinal()] = TIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.TIMEV2.ordinal()] = TIMEV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.BITMAP.ordinal()] = BITMAP;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.QUANTILE_STATE.ordinal()] = QUANTILE_STATE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.AGG_STATE.ordinal()] = AGG_STATE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.BOOLEAN.ordinal()] = BOOLEAN;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.TINYINT.ordinal()] = TINYINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.SMALLINT.ordinal()] = SMALLINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.INT.ordinal()] = INT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.BIGINT.ordinal()] = BIGINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.LARGEINT.ordinal()] = LARGEINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.FLOAT.ordinal()] = FLOAT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.DOUBLE.ordinal()] = DOUBLE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.DATE.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.DATETIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.DATEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.DATETIMEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.CHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.VARCHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.JSONB.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.STRING.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = DECIMALV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.DECIMAL32.ordinal()] = DECIMAL32;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.DECIMAL64.ordinal()] = DECIMAL64;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.DECIMAL128.ordinal()] = DECIMAL128;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.TIME.ordinal()] = TIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.TIMEV2.ordinal()] = TIMEV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.TINYINT.ordinal()] = TINYINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.SMALLINT.ordinal()] = SMALLINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.INT.ordinal()] = INT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.BIGINT.ordinal()] = BIGINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.LARGEINT.ordinal()] = LARGEINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.FLOAT.ordinal()] = FLOAT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.DOUBLE.ordinal()] = DOUBLE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.DATE.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.DATETIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.DATEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.DATETIMEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.CHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.VARCHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.JSONB.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.STRING.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = DECIMALV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.DECIMAL32.ordinal()] = DECIMAL32;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.DECIMAL64.ordinal()] = DECIMAL64;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.DECIMAL128.ordinal()] = DECIMAL128;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.TIME.ordinal()] = TIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.TIMEV2.ordinal()] = TIMEV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.SMALLINT.ordinal()] = SMALLINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.INT.ordinal()] = INT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.BIGINT.ordinal()] = BIGINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.LARGEINT.ordinal()] = LARGEINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.FLOAT.ordinal()] = FLOAT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.DOUBLE.ordinal()] = DOUBLE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.DATE.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.DATETIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.DATEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.DATETIMEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.CHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.VARCHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.JSONB.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.STRING.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = DECIMALV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.DECIMAL32.ordinal()] = DECIMAL32;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.DECIMAL64.ordinal()] = DECIMAL64;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.DECIMAL128.ordinal()] = DECIMAL128;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.TIME.ordinal()] = TIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.TIMEV2.ordinal()] = TIMEV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.INT.ordinal()] = INT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.BIGINT.ordinal()] = BIGINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.LARGEINT.ordinal()] = LARGEINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.FLOAT.ordinal()] = FLOAT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.DOUBLE.ordinal()] = DOUBLE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.DATE.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.DATETIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.DATEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.DATETIMEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.CHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.VARCHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.JSONB.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.STRING.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = DECIMALV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.DECIMAL32.ordinal()] = DECIMAL32;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.DECIMAL64.ordinal()] = DECIMAL64;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.DECIMAL128.ordinal()] = DECIMAL128;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.TIME.ordinal()] = TIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.TIMEV2.ordinal()] = TIMEV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.BIGINT.ordinal()] = BIGINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.LARGEINT.ordinal()] = LARGEINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.FLOAT.ordinal()] = DOUBLE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.DOUBLE.ordinal()] = DOUBLE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.DATE.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.DATETIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.DATEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.DATETIMEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.CHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.VARCHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.JSONB.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.STRING.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = DECIMALV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.DECIMAL32.ordinal()] = DECIMAL32;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.DECIMAL64.ordinal()] = DECIMAL64;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.DECIMAL128.ordinal()] = DECIMAL128;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.TIME.ordinal()] = TIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.TIMEV2.ordinal()] = TIMEV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.LARGEINT.ordinal()] = LARGEINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.FLOAT.ordinal()] = DOUBLE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.DOUBLE.ordinal()] = DOUBLE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.DATE.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.DATETIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.DATEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.DATETIMEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.CHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.VARCHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.JSONB.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.STRING.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = DECIMALV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.DECIMAL32.ordinal()] = DECIMAL32;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.DECIMAL64.ordinal()] = DECIMAL64;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.DECIMAL128.ordinal()] = DECIMAL128;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.TIME.ordinal()] = TIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.TIMEV2.ordinal()] = TIMEV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.FLOAT.ordinal()] = FLOAT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.DOUBLE.ordinal()] = DOUBLE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.DATE.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.DATETIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.DATEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.DATETIMEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.CHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.VARCHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.JSONB.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.STRING.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = DECIMALV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.DECIMAL32.ordinal()] = DECIMAL32;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.DECIMAL64.ordinal()] = DECIMAL64;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.DECIMAL128.ordinal()] = DECIMAL128;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.TIME.ordinal()] = TIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.TIMEV2.ordinal()] = TIMEV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DOUBLE.ordinal()][PrimitiveType.DOUBLE.ordinal()] = DOUBLE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DOUBLE.ordinal()][PrimitiveType.DATE.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DOUBLE.ordinal()][PrimitiveType.DATETIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DOUBLE.ordinal()][PrimitiveType.DATEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DOUBLE.ordinal()][PrimitiveType.DATETIMEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DOUBLE.ordinal()][PrimitiveType.CHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DOUBLE.ordinal()][PrimitiveType.VARCHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DOUBLE.ordinal()][PrimitiveType.JSONB.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DOUBLE.ordinal()][PrimitiveType.STRING.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DOUBLE.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = DECIMALV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DOUBLE.ordinal()][PrimitiveType.DECIMAL32.ordinal()] = DECIMAL32;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DOUBLE.ordinal()][PrimitiveType.DECIMAL64.ordinal()] = DECIMAL64;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DOUBLE.ordinal()][PrimitiveType.DECIMAL128.ordinal()] = DECIMAL128;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DOUBLE.ordinal()][PrimitiveType.TIME.ordinal()] = TIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DOUBLE.ordinal()][PrimitiveType.TIMEV2.ordinal()] = TIMEV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATE.ordinal()][PrimitiveType.DATE.ordinal()] = DATE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATE.ordinal()][PrimitiveType.DATETIME.ordinal()] = DATETIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATE.ordinal()][PrimitiveType.DATEV2.ordinal()] = DATEV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATE.ordinal()][PrimitiveType.DATETIMEV2.ordinal()] = DATETIMEV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATE.ordinal()][PrimitiveType.CHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATE.ordinal()][PrimitiveType.VARCHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATE.ordinal()][PrimitiveType.STRING.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATE.ordinal()][PrimitiveType.JSONB.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATE.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATE.ordinal()][PrimitiveType.DECIMAL32.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATE.ordinal()][PrimitiveType.DECIMAL64.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATE.ordinal()][PrimitiveType.DECIMAL128.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATE.ordinal()][PrimitiveType.TIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATE.ordinal()][PrimitiveType.TIMEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATEV2.ordinal()][PrimitiveType.DATE.ordinal()] = DATEV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATEV2.ordinal()][PrimitiveType.DATETIME.ordinal()] = DATETIMEV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATEV2.ordinal()][PrimitiveType.DATEV2.ordinal()] = DATEV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATEV2.ordinal()][PrimitiveType.DATETIMEV2.ordinal()] = DATETIMEV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATEV2.ordinal()][PrimitiveType.CHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATEV2.ordinal()][PrimitiveType.VARCHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATEV2.ordinal()][PrimitiveType.STRING.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATEV2.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATEV2.ordinal()][PrimitiveType.DECIMAL32.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATEV2.ordinal()][PrimitiveType.DECIMAL64.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATEV2.ordinal()][PrimitiveType.DECIMAL128.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATEV2.ordinal()][PrimitiveType.TIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATEV2.ordinal()][PrimitiveType.TIMEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIME.ordinal()][PrimitiveType.DATETIME.ordinal()] = DATETIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIME.ordinal()][PrimitiveType.DATETIMEV2.ordinal()] = DATETIMEV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIME.ordinal()][PrimitiveType.CHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIME.ordinal()][PrimitiveType.VARCHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIME.ordinal()][PrimitiveType.JSONB.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIME.ordinal()][PrimitiveType.STRING.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIME.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIME.ordinal()][PrimitiveType.DECIMAL32.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIME.ordinal()][PrimitiveType.DECIMAL64.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIME.ordinal()][PrimitiveType.DECIMAL128.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIME.ordinal()][PrimitiveType.TIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIME.ordinal()][PrimitiveType.TIMEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIMEV2.ordinal()][PrimitiveType.DATETIME.ordinal()] = DATETIMEV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIMEV2.ordinal()][PrimitiveType.DATETIMEV2.ordinal()] = DATETIMEV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIMEV2.ordinal()][PrimitiveType.CHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIMEV2.ordinal()][PrimitiveType.VARCHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIMEV2.ordinal()][PrimitiveType.STRING.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIMEV2.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIMEV2.ordinal()][PrimitiveType.DECIMAL32.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIMEV2.ordinal()][PrimitiveType.DECIMAL64.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIMEV2.ordinal()][PrimitiveType.DECIMAL128.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIMEV2.ordinal()][PrimitiveType.TIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIMEV2.ordinal()][PrimitiveType.TIMEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.CHAR.ordinal()][PrimitiveType.CHAR.ordinal()] = CHAR;
        PrimitiveType.compatibilityMatrix[PrimitiveType.CHAR.ordinal()][PrimitiveType.VARCHAR.ordinal()] = VARCHAR;
        PrimitiveType.compatibilityMatrix[PrimitiveType.CHAR.ordinal()][PrimitiveType.JSONB.ordinal()] = CHAR;
        PrimitiveType.compatibilityMatrix[PrimitiveType.CHAR.ordinal()][PrimitiveType.STRING.ordinal()] = STRING;
        PrimitiveType.compatibilityMatrix[PrimitiveType.CHAR.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.CHAR.ordinal()][PrimitiveType.DECIMAL32.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.CHAR.ordinal()][PrimitiveType.DECIMAL64.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.CHAR.ordinal()][PrimitiveType.DECIMAL128.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.CHAR.ordinal()][PrimitiveType.TIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.CHAR.ordinal()][PrimitiveType.TIMEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.VARCHAR.ordinal()][PrimitiveType.VARCHAR.ordinal()] = VARCHAR;
        PrimitiveType.compatibilityMatrix[PrimitiveType.VARCHAR.ordinal()][PrimitiveType.STRING.ordinal()] = STRING;
        PrimitiveType.compatibilityMatrix[PrimitiveType.VARCHAR.ordinal()][PrimitiveType.JSONB.ordinal()] = VARCHAR;
        PrimitiveType.compatibilityMatrix[PrimitiveType.VARCHAR.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.VARCHAR.ordinal()][PrimitiveType.DECIMAL32.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.VARCHAR.ordinal()][PrimitiveType.DECIMAL64.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.VARCHAR.ordinal()][PrimitiveType.DECIMAL128.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.VARCHAR.ordinal()][PrimitiveType.TIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.VARCHAR.ordinal()][PrimitiveType.TIMEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.STRING.ordinal()][PrimitiveType.STRING.ordinal()] = STRING;
        PrimitiveType.compatibilityMatrix[PrimitiveType.STRING.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.STRING.ordinal()][PrimitiveType.DECIMAL32.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.STRING.ordinal()][PrimitiveType.DECIMAL64.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.STRING.ordinal()][PrimitiveType.DECIMAL128.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.STRING.ordinal()][PrimitiveType.JSONB.ordinal()] = STRING;
        PrimitiveType.compatibilityMatrix[PrimitiveType.STRING.ordinal()][PrimitiveType.TIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.STRING.ordinal()][PrimitiveType.TIMEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.JSONB.ordinal()][PrimitiveType.JSONB.ordinal()] = JSONB;
        PrimitiveType.compatibilityMatrix[PrimitiveType.JSONB.ordinal()][PrimitiveType.STRING.ordinal()] = STRING;
        PrimitiveType.compatibilityMatrix[PrimitiveType.JSONB.ordinal()][PrimitiveType.VARCHAR.ordinal()] = VARCHAR;
        PrimitiveType.compatibilityMatrix[PrimitiveType.JSONB.ordinal()][PrimitiveType.CHAR.ordinal()] = CHAR;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMALV2.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = DECIMALV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMALV2.ordinal()][PrimitiveType.DECIMAL32.ordinal()] = DECIMALV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMALV2.ordinal()][PrimitiveType.DECIMAL64.ordinal()] = DECIMALV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMALV2.ordinal()][PrimitiveType.DECIMAL128.ordinal()] = DECIMAL128;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMALV2.ordinal()][PrimitiveType.TIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMALV2.ordinal()][PrimitiveType.TIMEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMAL32.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = DECIMALV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMAL32.ordinal()][PrimitiveType.DECIMAL32.ordinal()] = DECIMAL32;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMAL32.ordinal()][PrimitiveType.DECIMAL64.ordinal()] = DECIMAL64;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMAL32.ordinal()][PrimitiveType.DECIMAL128.ordinal()] = DECIMAL128;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMAL32.ordinal()][PrimitiveType.TIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMAL32.ordinal()][PrimitiveType.TIMEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMAL64.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = DECIMALV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMAL64.ordinal()][PrimitiveType.DECIMAL32.ordinal()] = DECIMAL64;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMAL64.ordinal()][PrimitiveType.DECIMAL64.ordinal()] = DECIMAL64;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMAL64.ordinal()][PrimitiveType.DECIMAL128.ordinal()] = DECIMAL128;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMAL64.ordinal()][PrimitiveType.TIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMAL64.ordinal()][PrimitiveType.TIMEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMAL128.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = DECIMAL128;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMAL128.ordinal()][PrimitiveType.DECIMAL32.ordinal()] = DECIMAL128;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMAL128.ordinal()][PrimitiveType.DECIMAL64.ordinal()] = DECIMAL128;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMAL128.ordinal()][PrimitiveType.DECIMAL128.ordinal()] = DECIMAL128;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMAL128.ordinal()][PrimitiveType.TIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMAL128.ordinal()][PrimitiveType.TIMEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.HLL.ordinal()][PrimitiveType.HLL.ordinal()] = HLL;
        PrimitiveType.compatibilityMatrix[PrimitiveType.HLL.ordinal()][PrimitiveType.TIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.HLL.ordinal()][PrimitiveType.TIMEV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BITMAP.ordinal()][PrimitiveType.BITMAP.ordinal()] = BITMAP;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TIME.ordinal()][PrimitiveType.TIME.ordinal()] = TIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TIME.ordinal()][PrimitiveType.TIMEV2.ordinal()] = TIMEV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TIMEV2.ordinal()][PrimitiveType.TIME.ordinal()] = TIMEV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TIMEV2.ordinal()][PrimitiveType.TIMEV2.ordinal()] = TIMEV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.QUANTILE_STATE.ordinal()][PrimitiveType.QUANTILE_STATE.ordinal()] = QUANTILE_STATE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.AGG_STATE.ordinal()][PrimitiveType.AGG_STATE.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.NULL_TYPE.ordinal()] = NULL_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.BOOLEAN.ordinal()] = BOOLEAN;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.TINYINT.ordinal()] = TINYINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.SMALLINT.ordinal()] = SMALLINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.INT.ordinal()] = INT;
    }
}

