/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.doris.catalog.Type;
import org.apache.doris.thrift.TTypeDesc;
import org.apache.doris.thrift.TTypeNode;
import org.apache.doris.thrift.TTypeNodeType;

public class MultiRowType
extends Type {
    private final Type itemType;

    public MultiRowType(Type itemType) {
        this.itemType = itemType;
    }

    public Type getItemType() {
        return this.itemType;
    }

    @Override
    public String toSql(int depth) {
        if (depth >= MAX_NESTING_DEPTH) {
            return "ARRAY<...>";
        }
        return String.format("ARRAY<%s>", this.itemType.toSql(depth + 1));
    }

    public boolean equals(Object other) {
        if (!(other instanceof MultiRowType)) {
            return false;
        }
        MultiRowType otherMultiRowType = (MultiRowType)other;
        return otherMultiRowType.itemType.equals(this.itemType);
    }

    @Override
    public void toThrift(TTypeDesc container) {
        TTypeNode node = new TTypeNode();
        container.types.add(node);
        Preconditions.checkNotNull((Object)this.itemType);
        node.setType(TTypeNodeType.ARRAY);
        this.itemType.toThrift(container);
    }

    @Override
    protected String prettyPrint(int lpad) {
        String leftPadding = Strings.repeat((String)" ", (int)lpad);
        if (!this.itemType.isStructType()) {
            return leftPadding + this.toSql();
        }
        String structStr = this.itemType.prettyPrint(lpad);
        structStr = structStr.substring(lpad);
        return String.format("%sARRAY<%s>", leftPadding, structStr);
    }
}

