/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.util.Map;
import java.util.Objects;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Type;
import org.apache.doris.catalog.TypeException;
import org.apache.doris.thrift.TColumnType;
import org.apache.doris.thrift.TTypeDesc;
import org.apache.doris.thrift.TTypeNode;
import org.apache.doris.thrift.TTypeNodeType;

public class MapType
extends Type {
    @SerializedName(value="keyType")
    private final Type keyType;
    @SerializedName(value="isKeyContainsNull")
    private final boolean isKeyContainsNull;
    @SerializedName(value="valueType")
    private final Type valueType;
    @SerializedName(value="isValueContainsNull")
    private final boolean isValueContainsNull;

    public MapType() {
        this.keyType = NULL;
        this.isKeyContainsNull = true;
        this.valueType = NULL;
        this.isValueContainsNull = true;
    }

    public MapType(Type keyType, Type valueType) {
        Preconditions.checkNotNull((Object)keyType);
        Preconditions.checkNotNull((Object)valueType);
        this.keyType = keyType;
        this.isKeyContainsNull = true;
        this.valueType = valueType;
        this.isValueContainsNull = true;
    }

    public MapType(Type keyType, Type valueType, boolean keyContainsNull, boolean valueContainsNull) {
        Preconditions.checkNotNull((Object)keyType);
        Preconditions.checkNotNull((Object)valueType);
        this.keyType = keyType;
        this.isKeyContainsNull = keyContainsNull;
        this.valueType = valueType;
        this.isValueContainsNull = valueContainsNull;
    }

    @Override
    public PrimitiveType getPrimitiveType() {
        return PrimitiveType.MAP;
    }

    public Type getKeyType() {
        return this.keyType;
    }

    public Boolean getIsKeyContainsNull() {
        return this.isKeyContainsNull;
    }

    public Boolean getIsValueContainsNull() {
        return this.isValueContainsNull;
    }

    public Type getValueType() {
        return this.valueType;
    }

    public boolean equals(Object other) {
        if (!(other instanceof MapType)) {
            return false;
        }
        MapType otherMapType = (MapType)other;
        return otherMapType.keyType.equals(this.keyType) && otherMapType.valueType.equals(this.valueType);
    }

    @Override
    public String toSql(int depth) {
        if (depth >= MAX_NESTING_DEPTH) {
            return "MAP<...>";
        }
        return String.format("MAP<%s,%s>", this.keyType.toSql(depth + 1), this.valueType.toSql(depth + 1));
    }

    @Override
    public boolean matchesType(Type t) {
        if (this.equals(t)) {
            return true;
        }
        if (t.isAnyType()) {
            return t.matchesType(this);
        }
        if (!t.isMapType()) {
            return false;
        }
        if ((this.keyType.isNull() || ((MapType)t).getKeyType().isNull()) && (this.valueType.isNull() || ((MapType)t).getKeyType().isNull())) {
            return true;
        }
        return this.keyType.matchesType(((MapType)t).keyType) && this.valueType.matchesType(((MapType)t).valueType);
    }

    @Override
    public boolean hasTemplateType() {
        return this.keyType.hasTemplateType() || this.valueType.hasTemplateType();
    }

    @Override
    public Type specializeTemplateType(Type specificType, Map<String, Type> specializedTypeMap, boolean useSpecializedType) throws TypeException {
        MapType newMapType;
        MapType specificMapType = null;
        if (specificType instanceof MapType) {
            specificMapType = (MapType)specificType;
        } else if (!useSpecializedType) {
            throw new TypeException(specificType + " is not MapType");
        }
        Type newKeyType = this.keyType;
        if (this.keyType.hasTemplateType()) {
            newKeyType = this.keyType.specializeTemplateType(specificMapType != null ? specificMapType.keyType : specificType, specializedTypeMap, useSpecializedType);
        }
        Type newValueType = this.valueType;
        if (this.valueType.hasTemplateType()) {
            newValueType = this.valueType.specializeTemplateType(specificMapType != null ? specificMapType.valueType : specificType, specializedTypeMap, useSpecializedType);
        }
        if (Type.canCastTo(specificType, newMapType = new MapType(newKeyType, newValueType)) || useSpecializedType && !(specificType instanceof MapType)) {
            return newMapType;
        }
        throw new TypeException(specificType + " can not cast to specialize type " + newMapType);
    }

    public String toString() {
        return String.format("MAP<%s,%s>", this.keyType.toString(), this.valueType.toString());
    }

    @Override
    protected String prettyPrint(int lpad) {
        String leftPadding = Strings.repeat((String)" ", (int)lpad);
        if (!this.valueType.isStructType()) {
            return leftPadding + this.toSql();
        }
        String structStr = this.valueType.prettyPrint(lpad);
        structStr = structStr.substring(lpad);
        return String.format("%sMAP<%s,%s>", leftPadding, this.keyType.toSql(), structStr);
    }

    public static boolean canCastTo(MapType type, MapType targetType) {
        return (targetType.getKeyType().isStringType() && type.getKeyType().isStringType() || Type.canCastTo(type.getKeyType(), targetType.getKeyType())) && (Type.canCastTo(type.getValueType(), targetType.getValueType()) || targetType.getValueType().isStringType() && type.getValueType().isStringType());
    }

    public static Type getAssignmentCompatibleType(MapType t1, MapType t2, boolean strict) {
        Type keyCompatibleType = Type.getAssignmentCompatibleType(t1.getKeyType(), t2.getKeyType(), strict);
        if (keyCompatibleType.isInvalid()) {
            return ScalarType.INVALID;
        }
        Type valCompatibleType = Type.getAssignmentCompatibleType(t1.getValueType(), t2.getValueType(), strict);
        if (valCompatibleType.isInvalid()) {
            return ScalarType.INVALID;
        }
        return new MapType(keyCompatibleType, valCompatibleType, t1.getIsKeyContainsNull() != false || t2.getIsKeyContainsNull() != false, t1.getIsValueContainsNull() != false || t2.getIsValueContainsNull() != false);
    }

    @Override
    public boolean supportSubType(Type subType) {
        for (Type supportedType : Type.getMapSubTypes()) {
            if (subType.getPrimitiveType() != supportedType.getPrimitiveType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void toThrift(TTypeDesc container) {
        TTypeNode node = new TTypeNode();
        container.types.add(node);
        Preconditions.checkNotNull((Object)this.keyType);
        Preconditions.checkNotNull((Object)this.valueType);
        node.setType(TTypeNodeType.MAP);
        node.setContainsNulls(Lists.newArrayList((Object[])new Boolean[]{this.isKeyContainsNull, this.isValueContainsNull}));
        this.keyType.toThrift(container);
        this.valueType.toThrift(container);
    }

    @Override
    public TColumnType toColumnTypeThrift() {
        TColumnType thrift = new TColumnType();
        thrift.type = PrimitiveType.MAP.toThrift();
        return thrift;
    }

    public int hashCode() {
        return Objects.hash(this.keyType, this.valueType);
    }
}

