/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.util.Map;
import java.util.Objects;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Type;
import org.apache.doris.catalog.TypeException;
import org.apache.doris.thrift.TColumnType;
import org.apache.doris.thrift.TTypeDesc;
import org.apache.doris.thrift.TTypeNode;
import org.apache.doris.thrift.TTypeNodeType;

public class ArrayType
extends Type {
    public static final int MAX_NESTED_DEPTH = 9;
    @SerializedName(value="itemType")
    private Type itemType;
    @SerializedName(value="containsNull")
    private boolean containsNull;

    public ArrayType() {
        this.itemType = NULL;
        this.containsNull = true;
    }

    public ArrayType(Type itemType) {
        this(itemType, true);
    }

    public ArrayType(Type itemType, boolean containsNull) {
        this.itemType = itemType;
        this.containsNull = containsNull;
    }

    public Type getItemType() {
        return this.itemType;
    }

    public boolean getContainsNull() {
        return this.containsNull;
    }

    public void setContainsNull(boolean containsNull) {
        this.containsNull = containsNull;
    }

    @Override
    public PrimitiveType getPrimitiveType() {
        return PrimitiveType.ARRAY;
    }

    @Override
    public boolean matchesType(Type t) {
        if (this.equals(t)) {
            return true;
        }
        if (t.isAnyType()) {
            return t.matchesType(this);
        }
        if (!t.isArrayType()) {
            return false;
        }
        if (this.itemType.isNull() || ((ArrayType)t).getItemType().isNull()) {
            return true;
        }
        return this.itemType.matchesType(((ArrayType)t).itemType) && (((ArrayType)t).containsNull || !this.containsNull);
    }

    @Override
    public boolean hasTemplateType() {
        return this.itemType.hasTemplateType();
    }

    @Override
    public Type specializeTemplateType(Type specificType, Map<String, Type> specializedTypeMap, boolean useSpecializedType) throws TypeException {
        ArrayType specificArrayType = null;
        if (specificType instanceof ArrayType) {
            specificArrayType = (ArrayType)specificType;
        } else if (!useSpecializedType) {
            throw new TypeException(specificType + " is not ArrayType");
        }
        Type newItemType = this.itemType;
        if (this.itemType.hasTemplateType()) {
            newItemType = this.itemType.specializeTemplateType(specificArrayType != null ? specificArrayType.itemType : specificType, specializedTypeMap, useSpecializedType);
        }
        return new ArrayType(newItemType);
    }

    public static ArrayType create() {
        return new ArrayType();
    }

    public static ArrayType create(Type type, boolean containsNull) {
        return new ArrayType(type, containsNull);
    }

    @Override
    public String toSql(int depth) {
        if (!this.containsNull) {
            return "array<not_null(" + this.itemType.toSql(depth + 1) + ")>";
        }
        return "array<" + this.itemType.toSql(depth + 1) + ">";
    }

    public int hashCode() {
        return Objects.hash(this.itemType, this.containsNull);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ArrayType)) {
            return false;
        }
        ArrayType otherArrayType = (ArrayType)other;
        return otherArrayType.itemType.equals(this.itemType) && otherArrayType.containsNull == this.containsNull;
    }

    public static boolean canCastTo(ArrayType type, ArrayType targetType) {
        if (!targetType.containsNull && type.containsNull) {
            return false;
        }
        if (targetType.getItemType().isStringType() && type.getItemType().isStringType()) {
            return true;
        }
        return Type.canCastTo(type.getItemType(), targetType.getItemType());
    }

    public static Type getAssignmentCompatibleType(ArrayType t1, ArrayType t2, boolean strict) {
        Type itemCompatibleType = Type.getAssignmentCompatibleType(t1.getItemType(), t2.getItemType(), strict);
        if (itemCompatibleType.isInvalid()) {
            return ScalarType.INVALID;
        }
        return new ArrayType(itemCompatibleType, t1.getContainsNull() || t2.getContainsNull());
    }

    @Override
    public void toThrift(TTypeDesc container) {
        TTypeNode node = new TTypeNode();
        container.types.add(node);
        Preconditions.checkNotNull((Object)this.itemType);
        node.setType(TTypeNodeType.ARRAY);
        node.setContainsNull(this.containsNull);
        node.setContainsNulls(Lists.newArrayList((Object[])new Boolean[]{this.containsNull}));
        this.itemType.toThrift(container);
    }

    @Override
    protected String prettyPrint(int lpad) {
        String leftPadding = Strings.repeat((String)" ", (int)lpad);
        if (!this.itemType.isStructType()) {
            return leftPadding + this.toSql();
        }
        String structStr = this.itemType.prettyPrint(lpad).substring(lpad);
        return String.format("%sARRAY<%s>", leftPadding, structStr);
    }

    @Override
    public boolean isSupported() {
        return !this.itemType.isNull();
    }

    @Override
    public boolean supportSubType(Type subType) {
        for (Type supportedType : ArrayType.getArraySubTypes()) {
            if (subType.getPrimitiveType() != supportedType.getPrimitiveType()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("ARRAY<%s>", this.itemType.toString()).toUpperCase();
    }

    @Override
    public TColumnType toColumnTypeThrift() {
        TColumnType thrift = new TColumnType();
        thrift.type = PrimitiveType.ARRAY.toThrift();
        return thrift;
    }

    @Override
    public boolean isFixedLengthType() {
        return false;
    }

    @Override
    public boolean supportsTablePartitioning() {
        return false;
    }

    @Override
    public int getSlotSize() {
        return PrimitiveType.ARRAY.getSlotSize();
    }
}

