/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Type;
import org.apache.doris.thrift.TTypeDesc;
import org.apache.doris.thrift.TTypeNode;

public class AggStateType
extends ScalarType {
    @SerializedName(value="subTypes")
    private List<Type> subTypes;
    @SerializedName(value="subTypeNullables")
    private List<Boolean> subTypeNullables;
    @SerializedName(value="resultIsNullable")
    private Boolean resultIsNullable;
    @SerializedName(value="functionName")
    private String functionName;

    public AggStateType(String functionName, Boolean resultIsNullable, List<Type> subTypes, List<Boolean> subTypeNullables) {
        super(PrimitiveType.AGG_STATE);
        Preconditions.checkState((subTypes == null == (subTypeNullables == null) ? 1 : 0) != 0);
        if (subTypes != null && subTypeNullables != null) {
            Preconditions.checkState((subTypes.size() == subTypeNullables.size() ? 1 : 0) != 0, (Object)"AggStateType' subTypes.size()!=subTypeNullables.size()");
        }
        this.functionName = functionName;
        this.subTypes = subTypes;
        this.subTypeNullables = subTypeNullables;
        this.resultIsNullable = resultIsNullable;
    }

    public List<Type> getSubTypes() {
        return this.subTypes;
    }

    public List<Boolean> getSubTypeNullables() {
        return this.subTypeNullables;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public boolean getResultIsNullable() {
        return this.resultIsNullable;
    }

    @Override
    public String toSql(int depth) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("agg_state(");
        for (int i = 0; i < this.subTypes.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.subTypes.get(i).toSql());
            if (!this.subTypeNullables.get(i).booleanValue()) continue;
            stringBuilder.append(" NULL");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public void toThrift(TTypeDesc container) {
        super.toThrift(container);
        if (this.subTypes != null) {
            ArrayList<TTypeDesc> types = new ArrayList<TTypeDesc>();
            for (int i = 0; i < this.subTypes.size(); ++i) {
                TTypeDesc desc = new TTypeDesc();
                desc.setTypes(new ArrayList<TTypeNode>());
                this.subTypes.get(i).toThrift(desc);
                desc.setIsNullable(this.subTypeNullables.get(i));
                types.add(desc);
            }
            container.setSubTypes(types);
        }
        container.setResultIsNullable(this.resultIsNullable);
        container.setFunctionName(this.functionName);
    }

    @Override
    public boolean equals(Object o) {
        AggStateType other;
        if (!(o instanceof AggStateType)) {
            return false;
        }
        if (this.subTypes == null != ((other = (AggStateType)o).getSubTypes() == null)) {
            return false;
        }
        if (this.subTypes == null) {
            return true;
        }
        int subTypeNumber = this.subTypeNullables.size();
        if (subTypeNumber != other.subTypeNullables.size()) {
            return false;
        }
        for (int i = 0; i < subTypeNumber; ++i) {
            if (!this.subTypeNullables.get(i).equals(other.subTypeNullables.get(i))) {
                return false;
            }
            if (this.subTypes.get(i).equals(other.subTypes.get(i))) continue;
            return false;
        }
        return true;
    }
}

