/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sagemaker;

import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.plugin.task.api.enums.ResourceType;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.DataSourceParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.ResourceParametersHelper;
import org.apache.dolphinscheduler.plugin.task.sagemaker.SagemakerTaskExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SagemakerParameters
extends AbstractParameters {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SagemakerParameters.class);
    private String sagemakerRequestJson;
    private String username;
    private String password;
    private String awsRegion;
    private int datasource;
    private String type;

    public boolean checkParameters() {
        return StringUtils.isNotEmpty((CharSequence)this.sagemakerRequestJson);
    }

    public SagemakerTaskExecutionContext generateExtendedContext(ResourceParametersHelper parametersHelper) {
        DataSourceParameters dataSourceParameters = (DataSourceParameters)parametersHelper.getResourceParameters(ResourceType.DATASOURCE, Integer.valueOf(this.datasource));
        SagemakerTaskExecutionContext sagemakerTaskExecutionContext = new SagemakerTaskExecutionContext();
        sagemakerTaskExecutionContext.setConnectionParams(Objects.nonNull(dataSourceParameters) ? dataSourceParameters.getConnectionParams() : null);
        return sagemakerTaskExecutionContext;
    }

    public ResourceParametersHelper getResources() {
        ResourceParametersHelper resources = super.getResources();
        resources.put(ResourceType.DATASOURCE, Integer.valueOf(this.datasource));
        return resources;
    }

    @Generated
    public String getSagemakerRequestJson() {
        return this.sagemakerRequestJson;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getAwsRegion() {
        return this.awsRegion;
    }

    @Generated
    public int getDatasource() {
        return this.datasource;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setSagemakerRequestJson(String sagemakerRequestJson) {
        this.sagemakerRequestJson = sagemakerRequestJson;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
    }

    @Generated
    public void setDatasource(int datasource) {
        this.datasource = datasource;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public String toString() {
        return "SagemakerParameters(sagemakerRequestJson=" + this.getSagemakerRequestJson() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", awsRegion=" + this.getAwsRegion() + ", datasource=" + this.getDatasource() + ", type=" + this.getType() + ")";
    }
}

