/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sagemaker;

import com.amazonaws.services.sagemaker.AmazonSageMaker;
import com.amazonaws.services.sagemaker.model.DescribePipelineExecutionRequest;
import com.amazonaws.services.sagemaker.model.DescribePipelineExecutionResult;
import com.amazonaws.services.sagemaker.model.ListPipelineExecutionStepsRequest;
import com.amazonaws.services.sagemaker.model.ListPipelineExecutionStepsResult;
import com.amazonaws.services.sagemaker.model.PipelineExecutionStep;
import com.amazonaws.services.sagemaker.model.StartPipelineExecutionRequest;
import com.amazonaws.services.sagemaker.model.StartPipelineExecutionResult;
import com.amazonaws.services.sagemaker.model.StopPipelineExecutionRequest;
import com.amazonaws.services.sagemaker.model.StopPipelineExecutionResult;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineUtils.class);
    private static final String EXECUTING = "Executing";
    private static final String SUCCEEDED = "Succeeded";

    public PipelineId startPipelineExecution(AmazonSageMaker client, StartPipelineExecutionRequest request) {
        StartPipelineExecutionResult result = client.startPipelineExecution(request);
        String pipelineExecutionArn = result.getPipelineExecutionArn();
        String clientRequestToken = request.getClientRequestToken();
        log.info("Start success, pipeline: {}, token: {}", (Object)pipelineExecutionArn, (Object)clientRequestToken);
        return new PipelineId(pipelineExecutionArn, clientRequestToken);
    }

    public void stopPipelineExecution(AmazonSageMaker client, PipelineId pipelineId) {
        StopPipelineExecutionRequest request = new StopPipelineExecutionRequest();
        request.setPipelineExecutionArn(pipelineId.getPipelineExecutionArn());
        request.setClientRequestToken(pipelineId.getClientRequestToken());
        StopPipelineExecutionResult result = client.stopPipelineExecution(request);
        log.info("Stop pipeline: {} success", (Object)result.getPipelineExecutionArn());
    }

    public int checkPipelineExecutionStatus(AmazonSageMaker client, PipelineId pipelineId) {
        String pipelineStatus = this.describePipelineExecution(client, pipelineId);
        while (EXECUTING.equals(pipelineStatus)) {
            log.info("check Pipeline Steps running");
            this.listPipelineExecutionSteps(client, pipelineId);
            ThreadUtils.sleep((long)5000L);
            pipelineStatus = this.describePipelineExecution(client, pipelineId);
        }
        int exitStatusCode = -1;
        if (SUCCEEDED.equals(pipelineStatus)) {
            exitStatusCode = 0;
        }
        log.info("PipelineExecutionStatus : {}, exitStatusCode: {}", (Object)pipelineStatus, (Object)exitStatusCode);
        return exitStatusCode;
    }

    private String describePipelineExecution(AmazonSageMaker client, PipelineId pipelineId) {
        DescribePipelineExecutionRequest request = new DescribePipelineExecutionRequest();
        request.setPipelineExecutionArn(pipelineId.getPipelineExecutionArn());
        DescribePipelineExecutionResult result = client.describePipelineExecution(request);
        log.info("PipelineExecutionStatus: {}", (Object)result.getPipelineExecutionStatus());
        return result.getPipelineExecutionStatus();
    }

    private void listPipelineExecutionSteps(AmazonSageMaker client, PipelineId pipelineId) {
        ListPipelineExecutionStepsRequest request = new ListPipelineExecutionStepsRequest();
        request.setPipelineExecutionArn(pipelineId.getPipelineExecutionArn());
        request.setMaxResults(Integer.valueOf(100));
        ListPipelineExecutionStepsResult result = client.listPipelineExecutionSteps(request);
        List steps = result.getPipelineExecutionSteps();
        Collections.reverse(steps);
        log.info("pipelineStepsStatus: ");
        for (PipelineExecutionStep step : steps) {
            String stepMessage = step.toString();
            log.info(stepMessage);
        }
    }

    public static class PipelineId {
        private String pipelineExecutionArn;
        private String clientRequestToken;

        @Generated
        public String getPipelineExecutionArn() {
            return this.pipelineExecutionArn;
        }

        @Generated
        public String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Generated
        public void setPipelineExecutionArn(String pipelineExecutionArn) {
            this.pipelineExecutionArn = pipelineExecutionArn;
        }

        @Generated
        public void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PipelineId)) {
                return false;
            }
            PipelineId other = (PipelineId)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$pipelineExecutionArn = this.getPipelineExecutionArn();
            String other$pipelineExecutionArn = other.getPipelineExecutionArn();
            if (this$pipelineExecutionArn == null ? other$pipelineExecutionArn != null : !this$pipelineExecutionArn.equals(other$pipelineExecutionArn)) {
                return false;
            }
            String this$clientRequestToken = this.getClientRequestToken();
            String other$clientRequestToken = other.getClientRequestToken();
            return !(this$clientRequestToken == null ? other$clientRequestToken != null : !this$clientRequestToken.equals(other$clientRequestToken));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PipelineId;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $pipelineExecutionArn = this.getPipelineExecutionArn();
            result = result * 59 + ($pipelineExecutionArn == null ? 43 : $pipelineExecutionArn.hashCode());
            String $clientRequestToken = this.getClientRequestToken();
            result = result * 59 + ($clientRequestToken == null ? 43 : $clientRequestToken.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PipelineUtils.PipelineId(pipelineExecutionArn=" + this.getPipelineExecutionArn() + ", clientRequestToken=" + this.getClientRequestToken() + ")";
        }

        @Generated
        public PipelineId(String pipelineExecutionArn, String clientRequestToken) {
            this.pipelineExecutionArn = pipelineExecutionArn;
            this.clientRequestToken = clientRequestToken;
        }

        @Generated
        public PipelineId() {
        }
    }
}

