/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.mr;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.plugin.task.api.resource.ResourceContext;
import org.apache.dolphinscheduler.plugin.task.api.utils.ArgsUtils;
import org.apache.dolphinscheduler.plugin.task.mr.MapReduceParameters;
import org.apache.dolphinscheduler.plugin.task.mr.ProgramType;

public class MapReduceArgsUtils {
    private MapReduceArgsUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static List<String> buildArgs(MapReduceParameters param, TaskExecutionContext taskExecutionContext) {
        String mainArgs;
        String yarnQueue;
        String others;
        String appName;
        ArrayList<String> args = new ArrayList<String>();
        ResourceInfo mainJar = param.getMainJar();
        if (mainJar != null) {
            args.add("jar");
            ResourceContext resourceContext = taskExecutionContext.getResourceContext();
            args.add(resourceContext.getResourceItem(mainJar.getResourceName()).getResourceAbsolutePathInLocal());
        }
        ProgramType programType = param.getProgramType();
        String mainClass = param.getMainClass();
        if (programType != null && programType != ProgramType.PYTHON && StringUtils.isNotEmpty((CharSequence)mainClass)) {
            args.add(mainClass);
        }
        if (StringUtils.isNotEmpty((CharSequence)(appName = param.getAppName()))) {
            args.add(String.format("%s%s=%s", "-D", "mapreduce.job.name", ArgsUtils.escape((String)appName)));
        }
        if ((StringUtils.isEmpty((CharSequence)(others = param.getOthers())) || !others.contains("mapreduce.job.queuename")) && StringUtils.isNotEmpty((CharSequence)(yarnQueue = param.getYarnQueue()))) {
            args.add(String.format("%s%s=%s", "-D", "mapreduce.job.queuename", yarnQueue));
        }
        if (StringUtils.isNotEmpty((CharSequence)others)) {
            args.add(others);
        }
        if (StringUtils.isNotEmpty((CharSequence)(mainArgs = param.getMainArgs()))) {
            args.add(mainArgs);
        }
        return args;
    }
}

