/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.kubeflow;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.plugin.kubeflow.KubeflowHelper;
import org.apache.dolphinscheduler.plugin.kubeflow.KubeflowParameters;
import org.apache.dolphinscheduler.plugin.task.api.AbstractRemoteTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeflowTask
extends AbstractRemoteTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KubeflowTask.class);
    private final TaskExecutionContext taskExecutionContext;
    protected KubeflowHelper kubeflowHelper;
    private KubeflowParameters kubeflowParameters;
    private Path clusterYAMLPath;
    private Path yamlPath;

    public KubeflowTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public void init() throws TaskException {
        this.kubeflowParameters = (KubeflowParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), KubeflowParameters.class));
        log.info("Initialize Kubeflow task params {}", (Object)this.taskExecutionContext.getTaskParams());
        this.kubeflowParameters.setClusterYAML(this.taskExecutionContext.getK8sTaskExecutionContext().getConfigYaml());
        if (!this.kubeflowParameters.checkParameters()) {
            throw new TaskException("Kubeflow task params is not valid");
        }
        this.writeFiles();
        this.kubeflowHelper = new KubeflowHelper(this.clusterYAMLPath.toString());
    }

    public void submitApplication() throws TaskException {
        String command = this.kubeflowHelper.buildSubmitCommand(this.yamlPath.toString());
        log.info("Kubeflow task submit command: \n{}", (Object)command);
        String message = this.runCommand(command);
        log.info("Kubeflow task submit result: \n{}", (Object)message);
        KubeflowHelper.ApplicationIds applicationIds = new KubeflowHelper.ApplicationIds();
        applicationIds.setAlreadySubmitted(true);
        this.setAppIds(JSONUtils.toJsonString((Object)applicationIds));
    }

    public void trackApplicationStatus() throws TaskException {
        block1: {
            String message;
            String phase;
            String command = this.kubeflowHelper.buildGetCommand(this.yamlPath.toString());
            log.info("Kubeflow task get command: \n{}", (Object)command);
            do {
                ThreadUtils.sleep((long)3000L);
                message = this.runCommand(command);
                phase = this.kubeflowHelper.parseGetMessage(message);
                if (!KubeflowHelper.STATUS.FAILED_SET.contains(phase)) continue;
                this.exitStatusCode = -1;
                log.info("Kubeflow task get Failed result: \n{}", (Object)message);
                break block1;
            } while (!KubeflowHelper.STATUS.SUCCESS_SET.contains(phase));
            this.exitStatusCode = 0;
            log.info("Kubeflow task get Succeeded result: \n{}", (Object)message);
        }
    }

    public void cancelApplication() throws TaskException {
        String command = this.kubeflowHelper.buildDeleteCommand(this.yamlPath.toString());
        log.info("Kubeflow task delete command: \n{}", (Object)command);
        String message = this.runCommand(command);
        log.info("Kubeflow task delete result: \n{}", (Object)message);
        this.exitStatusCode = 137;
    }

    protected String runCommand(String command) {
        try {
            this.exitStatusCode = 0;
            return OSUtils.exeShell((String[])new String[]{"sh", "-c", command});
        }
        catch (Exception e) {
            this.exitStatusCode = -1;
            throw new TaskException("Kubeflow task submit command failed", (Throwable)e);
        }
    }

    public List<String> getApplicationIds() throws TaskException {
        return Collections.emptyList();
    }

    public void writeFiles() {
        String yamlContent = this.kubeflowParameters.getYamlContent();
        String clusterYAML = this.kubeflowParameters.getClusterYAML();
        Map paramsMap = this.taskExecutionContext.getPrepareParamsMap();
        yamlContent = ParameterUtils.convertParameterPlaceholders((String)yamlContent, (Map)ParameterUtils.convert((Map)paramsMap));
        this.yamlPath = Paths.get(this.taskExecutionContext.getExecutePath(), "kubeflow.yaml");
        this.clusterYAMLPath = Paths.get(this.taskExecutionContext.getExecutePath(), ".cluster.yaml");
        log.info("Kubeflow task yaml content: \n{}", (Object)yamlContent);
        try {
            Files.write(this.yamlPath, yamlContent.getBytes(), StandardOpenOption.CREATE);
            Files.write(this.clusterYAMLPath, clusterYAML.getBytes(), StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            throw new TaskException("Kubeflow task write yaml file failed", (Throwable)e);
        }
    }

    public KubeflowParameters getParameters() {
        return this.kubeflowParameters;
    }
}

