/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.task.executor.log;

import org.apache.dolphinscheduler.task.executor.ITaskExecutor;
import org.slf4j.MDC;

public class TaskExecutorMDCUtils {
    private static final String TASK_INSTANCE_ID_MDC_KEY = "taskInstanceId";
    private static final String TASK_INSTANCE_LOG_FULL_PATH_MDC_KEY = "taskInstanceLogFullPath";

    public static MDCAutoClosable logWithMDC(ITaskExecutor taskExecutor) {
        return TaskExecutorMDCUtils.logWithMDC(taskExecutor.getId(), taskExecutor.getTaskExecutionContext().getLogPath());
    }

    public static MDCAutoClosable logWithMDC(int taskExecutorId) {
        return TaskExecutorMDCUtils.logWithMDC(taskExecutorId, null);
    }

    public static MDCAutoClosable logWithMDC(int taskExecutorId, String logPath) {
        if (logPath != null) {
            MDC.put((String)TASK_INSTANCE_LOG_FULL_PATH_MDC_KEY, (String)logPath);
        }
        MDC.put((String)TASK_INSTANCE_ID_MDC_KEY, (String)String.valueOf(taskExecutorId));
        return () -> {
            MDC.remove((String)TASK_INSTANCE_LOG_FULL_PATH_MDC_KEY);
            MDC.remove((String)TASK_INSTANCE_ID_MDC_KEY);
        };
    }

    public static interface MDCAutoClosable
    extends AutoCloseable {
        @Override
        public void close();
    }
}

