/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.dms;

import com.amazonaws.services.databasemigrationservice.AWSDatabaseMigrationService;
import com.amazonaws.services.databasemigrationservice.model.Connection;
import com.amazonaws.services.databasemigrationservice.model.CreateReplicationTaskRequest;
import com.amazonaws.services.databasemigrationservice.model.CreateReplicationTaskResult;
import com.amazonaws.services.databasemigrationservice.model.DeleteReplicationTaskRequest;
import com.amazonaws.services.databasemigrationservice.model.DescribeConnectionsRequest;
import com.amazonaws.services.databasemigrationservice.model.DescribeConnectionsResult;
import com.amazonaws.services.databasemigrationservice.model.DescribeReplicationTasksRequest;
import com.amazonaws.services.databasemigrationservice.model.DescribeReplicationTasksResult;
import com.amazonaws.services.databasemigrationservice.model.Filter;
import com.amazonaws.services.databasemigrationservice.model.InvalidResourceStateException;
import com.amazonaws.services.databasemigrationservice.model.ReplicationTask;
import com.amazonaws.services.databasemigrationservice.model.ReplicationTaskStats;
import com.amazonaws.services.databasemigrationservice.model.ResourceNotFoundException;
import com.amazonaws.services.databasemigrationservice.model.StartReplicationTaskRequest;
import com.amazonaws.services.databasemigrationservice.model.StartReplicationTaskResult;
import com.amazonaws.services.databasemigrationservice.model.StopReplicationTaskRequest;
import com.amazonaws.services.databasemigrationservice.model.Tag;
import com.amazonaws.services.databasemigrationservice.model.TestConnectionRequest;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.dolphinscheduler.authentication.aws.AWSDatabaseMigrationServiceClientFactory;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmsHook {
    protected final Logger log = LoggerFactory.getLogger(DmsHook.class);
    private AWSDatabaseMigrationService client = DmsHook.createClient();
    private String replicationTaskIdentifier;
    private String sourceEndpointArn;
    private String targetEndpointArn;
    private String replicationInstanceArn;
    private String migrationType;
    private String tableMappings;
    private String replicationTaskSettings;
    private Date cdcStartTime;
    private String cdcStartPosition;
    private String cdcStopPosition;
    private List<Tag> tags;
    private String taskData;
    private String resourceIdentifier;
    private String replicationTaskArn;
    private String startReplicationTaskType;

    public static AWSDatabaseMigrationService createClient() {
        Map awsProperties = PropertyUtils.getByPrefix((String)"aws.dms.", (String)"");
        return AWSDatabaseMigrationServiceClientFactory.createAWSDatabaseMigrationServiceClient((Map)awsProperties);
    }

    public Boolean createReplicationTask() throws Exception {
        this.log.info("createReplicationTask ......");
        CreateReplicationTaskRequest request = new CreateReplicationTaskRequest().withReplicationTaskIdentifier(this.replicationTaskIdentifier).withSourceEndpointArn(this.sourceEndpointArn).withTargetEndpointArn(this.targetEndpointArn).withReplicationInstanceArn(this.replicationInstanceArn).withMigrationType(this.migrationType).withTableMappings(this.tableMappings).withReplicationTaskSettings(this.replicationTaskSettings).withCdcStartTime(this.cdcStartTime).withCdcStartPosition(this.cdcStartPosition).withCdcStopPosition(this.cdcStopPosition).withTags(this.tags).withTaskData(this.taskData).withResourceIdentifier(this.resourceIdentifier);
        request.setTableMappings(this.replaceFileParameters(request.getTableMappings()));
        request.setReplicationTaskSettings(this.replaceFileParameters(request.getReplicationTaskSettings()));
        CreateReplicationTaskResult result = this.client.createReplicationTask(request);
        this.replicationTaskIdentifier = result.getReplicationTask().getReplicationTaskIdentifier();
        this.replicationTaskArn = result.getReplicationTask().getReplicationTaskArn();
        this.log.info("replicationTaskIdentifier: {}, replicationTaskArn: {}", (Object)this.replicationTaskIdentifier, (Object)this.replicationTaskArn);
        return this.awaitReplicationTaskStatus("ready", new String[0]);
    }

    public Boolean startReplicationTask() {
        this.log.info("startReplicationTask ......");
        StartReplicationTaskRequest request = new StartReplicationTaskRequest().withReplicationTaskArn(this.replicationTaskArn).withStartReplicationTaskType(this.startReplicationTaskType).withCdcStartTime(this.cdcStartTime).withCdcStartPosition(this.cdcStartPosition).withCdcStopPosition(this.cdcStopPosition);
        StartReplicationTaskResult result = this.client.startReplicationTask(request);
        this.replicationTaskArn = result.getReplicationTask().getReplicationTaskArn();
        return this.awaitReplicationTaskStatus("running", new String[0]);
    }

    public Boolean checkFinishedReplicationTask() {
        this.log.info("checkFinishedReplicationTask ......");
        this.awaitReplicationTaskStatus("stopped", new String[0]);
        String stopReason = this.describeReplicationTasks().getStopReason();
        return stopReason.endsWith("FINISHED");
    }

    public void stopReplicationTask() {
        this.log.info("stopReplicationTask ......");
        if (this.replicationTaskArn == null) {
            return;
        }
        StopReplicationTaskRequest request = new StopReplicationTaskRequest().withReplicationTaskArn(this.replicationTaskArn);
        this.client.stopReplicationTask(request);
        this.awaitReplicationTaskStatus("stopped", new String[0]);
    }

    public Boolean deleteReplicationTask() {
        Boolean isDeleteSuccessfully;
        this.log.info("deleteReplicationTask ......");
        DeleteReplicationTaskRequest request = new DeleteReplicationTaskRequest().withReplicationTaskArn(this.replicationTaskArn);
        this.client.deleteReplicationTask(request);
        try {
            isDeleteSuccessfully = this.awaitReplicationTaskStatus("delete", new String[0]);
        }
        catch (ResourceNotFoundException e) {
            isDeleteSuccessfully = true;
        }
        return isDeleteSuccessfully;
    }

    public Boolean testConnectionEndpoint() {
        return this.testConnection(this.replicationInstanceArn, this.sourceEndpointArn) != false && this.testConnection(this.replicationInstanceArn, this.targetEndpointArn) != false;
    }

    public Boolean testConnection(String replicationInstanceArn, String endpointArn) {
        this.log.info("Test connect replication instance: {} and endpoint: {}", (Object)replicationInstanceArn, (Object)endpointArn);
        TestConnectionRequest request = new TestConnectionRequest().withReplicationInstanceArn(replicationInstanceArn).withEndpointArn(endpointArn);
        try {
            this.client.testConnection(request);
        }
        catch (InvalidResourceStateException e) {
            this.log.info(e.getErrorMessage());
        }
        return this.awaitConnectSuccess(replicationInstanceArn, endpointArn);
    }

    public Boolean awaitConnectSuccess(String replicationInstanceArn, String endpointArn) {
        String status;
        Filter instanceFilters = new Filter().withName("replication-instance-arn").withValues(new String[]{replicationInstanceArn});
        Filter endpointFilters = new Filter().withName("endpoint-arn").withValues(new String[]{endpointArn});
        DescribeConnectionsRequest request = new DescribeConnectionsRequest().withFilters(new Filter[]{endpointFilters, instanceFilters}).withMarker("");
        do {
            ThreadUtils.sleep((long)1000L);
            DescribeConnectionsResult response = this.client.describeConnections(request);
            status = ((Connection)response.getConnections().get(0)).getStatus();
            if (!status.equals("successful")) continue;
            this.log.info("Connect successful");
            return true;
        } while (status.equals("testing"));
        this.log.info("Connect error");
        return false;
    }

    public ReplicationTask describeReplicationTasks() {
        Filter replicationTaskFilter = new Filter().withName("replication-task-arn").withValues(new String[]{this.replicationTaskArn});
        DescribeReplicationTasksRequest request = new DescribeReplicationTasksRequest().withFilters(new Filter[]{replicationTaskFilter}).withMaxRecords(Integer.valueOf(20)).withMarker("");
        DescribeReplicationTasksResult result = this.client.describeReplicationTasks(request);
        ReplicationTask replicationTask = (ReplicationTask)result.getReplicationTasks().get(0);
        if (this.sourceEndpointArn == null) {
            this.sourceEndpointArn = replicationTask.getSourceEndpointArn();
        }
        if (this.targetEndpointArn == null) {
            this.targetEndpointArn = replicationTask.getTargetEndpointArn();
        }
        if (this.replicationInstanceArn == null) {
            this.replicationInstanceArn = replicationTask.getReplicationInstanceArn();
        }
        if (this.replicationTaskArn == null) {
            this.replicationTaskArn = replicationTask.getReplicationTaskArn();
        }
        return replicationTask;
    }

    public Boolean awaitReplicationTaskStatus(String exceptStatus, String ... stopStatus) {
        String status;
        List<String> stopStatusSet = Arrays.asList(stopStatus);
        Integer lastPercent = 0;
        do {
            ThreadUtils.sleep((long)1000L);
            ReplicationTask replicationTask = this.describeReplicationTasks();
            status = replicationTask.getStatus();
            if (status.equals("running") || status.equals("stopped")) {
                ReplicationTaskStats taskStats = replicationTask.getReplicationTaskStats();
                Integer percent = taskStats != null ? taskStats.getFullLoadProgressPercent() : Integer.valueOf(0);
                if (!lastPercent.equals(percent)) {
                    String runningMessage = String.format("fullLoadProgressPercent: %s ", percent);
                    this.log.info(runningMessage);
                }
                lastPercent = percent;
            }
            if (!exceptStatus.equals(status)) continue;
            this.log.info("success");
            return true;
        } while (!stopStatusSet.contains(status));
        this.log.info("error");
        return false;
    }

    public String replaceFileParameters(String parameter) throws IOException {
        if (parameter == null) {
            return null;
        }
        if (parameter.startsWith("file://")) {
            String filePath = parameter.substring(7);
            try {
                return IOUtils.toString((InputStream)new FileInputStream(filePath), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new IOException("Error reading file: " + filePath, e);
            }
        }
        return parameter;
    }

    public ApplicationIds getApplicationIds() {
        return new ApplicationIds(this.replicationTaskArn);
    }

    @Generated
    public Logger getLog() {
        return this.log;
    }

    @Generated
    public AWSDatabaseMigrationService getClient() {
        return this.client;
    }

    @Generated
    public String getReplicationTaskIdentifier() {
        return this.replicationTaskIdentifier;
    }

    @Generated
    public String getSourceEndpointArn() {
        return this.sourceEndpointArn;
    }

    @Generated
    public String getTargetEndpointArn() {
        return this.targetEndpointArn;
    }

    @Generated
    public String getReplicationInstanceArn() {
        return this.replicationInstanceArn;
    }

    @Generated
    public String getMigrationType() {
        return this.migrationType;
    }

    @Generated
    public String getTableMappings() {
        return this.tableMappings;
    }

    @Generated
    public String getReplicationTaskSettings() {
        return this.replicationTaskSettings;
    }

    @Generated
    public Date getCdcStartTime() {
        return this.cdcStartTime;
    }

    @Generated
    public String getCdcStartPosition() {
        return this.cdcStartPosition;
    }

    @Generated
    public String getCdcStopPosition() {
        return this.cdcStopPosition;
    }

    @Generated
    public List<Tag> getTags() {
        return this.tags;
    }

    @Generated
    public String getTaskData() {
        return this.taskData;
    }

    @Generated
    public String getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    @Generated
    public String getReplicationTaskArn() {
        return this.replicationTaskArn;
    }

    @Generated
    public String getStartReplicationTaskType() {
        return this.startReplicationTaskType;
    }

    @Generated
    public void setClient(AWSDatabaseMigrationService client) {
        this.client = client;
    }

    @Generated
    public void setReplicationTaskIdentifier(String replicationTaskIdentifier) {
        this.replicationTaskIdentifier = replicationTaskIdentifier;
    }

    @Generated
    public void setSourceEndpointArn(String sourceEndpointArn) {
        this.sourceEndpointArn = sourceEndpointArn;
    }

    @Generated
    public void setTargetEndpointArn(String targetEndpointArn) {
        this.targetEndpointArn = targetEndpointArn;
    }

    @Generated
    public void setReplicationInstanceArn(String replicationInstanceArn) {
        this.replicationInstanceArn = replicationInstanceArn;
    }

    @Generated
    public void setMigrationType(String migrationType) {
        this.migrationType = migrationType;
    }

    @Generated
    public void setTableMappings(String tableMappings) {
        this.tableMappings = tableMappings;
    }

    @Generated
    public void setReplicationTaskSettings(String replicationTaskSettings) {
        this.replicationTaskSettings = replicationTaskSettings;
    }

    @Generated
    public void setCdcStartTime(Date cdcStartTime) {
        this.cdcStartTime = cdcStartTime;
    }

    @Generated
    public void setCdcStartPosition(String cdcStartPosition) {
        this.cdcStartPosition = cdcStartPosition;
    }

    @Generated
    public void setCdcStopPosition(String cdcStopPosition) {
        this.cdcStopPosition = cdcStopPosition;
    }

    @Generated
    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    @Generated
    public void setTaskData(String taskData) {
        this.taskData = taskData;
    }

    @Generated
    public void setResourceIdentifier(String resourceIdentifier) {
        this.resourceIdentifier = resourceIdentifier;
    }

    @Generated
    public void setReplicationTaskArn(String replicationTaskArn) {
        this.replicationTaskArn = replicationTaskArn;
    }

    @Generated
    public void setStartReplicationTaskType(String startReplicationTaskType) {
        this.startReplicationTaskType = startReplicationTaskType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DmsHook)) {
            return false;
        }
        DmsHook other = (DmsHook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Logger this$log = this.getLog();
        Logger other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        AWSDatabaseMigrationService this$client = this.getClient();
        AWSDatabaseMigrationService other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        String this$replicationTaskIdentifier = this.getReplicationTaskIdentifier();
        String other$replicationTaskIdentifier = other.getReplicationTaskIdentifier();
        if (this$replicationTaskIdentifier == null ? other$replicationTaskIdentifier != null : !this$replicationTaskIdentifier.equals(other$replicationTaskIdentifier)) {
            return false;
        }
        String this$sourceEndpointArn = this.getSourceEndpointArn();
        String other$sourceEndpointArn = other.getSourceEndpointArn();
        if (this$sourceEndpointArn == null ? other$sourceEndpointArn != null : !this$sourceEndpointArn.equals(other$sourceEndpointArn)) {
            return false;
        }
        String this$targetEndpointArn = this.getTargetEndpointArn();
        String other$targetEndpointArn = other.getTargetEndpointArn();
        if (this$targetEndpointArn == null ? other$targetEndpointArn != null : !this$targetEndpointArn.equals(other$targetEndpointArn)) {
            return false;
        }
        String this$replicationInstanceArn = this.getReplicationInstanceArn();
        String other$replicationInstanceArn = other.getReplicationInstanceArn();
        if (this$replicationInstanceArn == null ? other$replicationInstanceArn != null : !this$replicationInstanceArn.equals(other$replicationInstanceArn)) {
            return false;
        }
        String this$migrationType = this.getMigrationType();
        String other$migrationType = other.getMigrationType();
        if (this$migrationType == null ? other$migrationType != null : !this$migrationType.equals(other$migrationType)) {
            return false;
        }
        String this$tableMappings = this.getTableMappings();
        String other$tableMappings = other.getTableMappings();
        if (this$tableMappings == null ? other$tableMappings != null : !this$tableMappings.equals(other$tableMappings)) {
            return false;
        }
        String this$replicationTaskSettings = this.getReplicationTaskSettings();
        String other$replicationTaskSettings = other.getReplicationTaskSettings();
        if (this$replicationTaskSettings == null ? other$replicationTaskSettings != null : !this$replicationTaskSettings.equals(other$replicationTaskSettings)) {
            return false;
        }
        Date this$cdcStartTime = this.getCdcStartTime();
        Date other$cdcStartTime = other.getCdcStartTime();
        if (this$cdcStartTime == null ? other$cdcStartTime != null : !((Object)this$cdcStartTime).equals(other$cdcStartTime)) {
            return false;
        }
        String this$cdcStartPosition = this.getCdcStartPosition();
        String other$cdcStartPosition = other.getCdcStartPosition();
        if (this$cdcStartPosition == null ? other$cdcStartPosition != null : !this$cdcStartPosition.equals(other$cdcStartPosition)) {
            return false;
        }
        String this$cdcStopPosition = this.getCdcStopPosition();
        String other$cdcStopPosition = other.getCdcStopPosition();
        if (this$cdcStopPosition == null ? other$cdcStopPosition != null : !this$cdcStopPosition.equals(other$cdcStopPosition)) {
            return false;
        }
        List<Tag> this$tags = this.getTags();
        List<Tag> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        String this$taskData = this.getTaskData();
        String other$taskData = other.getTaskData();
        if (this$taskData == null ? other$taskData != null : !this$taskData.equals(other$taskData)) {
            return false;
        }
        String this$resourceIdentifier = this.getResourceIdentifier();
        String other$resourceIdentifier = other.getResourceIdentifier();
        if (this$resourceIdentifier == null ? other$resourceIdentifier != null : !this$resourceIdentifier.equals(other$resourceIdentifier)) {
            return false;
        }
        String this$replicationTaskArn = this.getReplicationTaskArn();
        String other$replicationTaskArn = other.getReplicationTaskArn();
        if (this$replicationTaskArn == null ? other$replicationTaskArn != null : !this$replicationTaskArn.equals(other$replicationTaskArn)) {
            return false;
        }
        String this$startReplicationTaskType = this.getStartReplicationTaskType();
        String other$startReplicationTaskType = other.getStartReplicationTaskType();
        return !(this$startReplicationTaskType == null ? other$startReplicationTaskType != null : !this$startReplicationTaskType.equals(other$startReplicationTaskType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DmsHook;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Logger $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        AWSDatabaseMigrationService $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        String $replicationTaskIdentifier = this.getReplicationTaskIdentifier();
        result = result * 59 + ($replicationTaskIdentifier == null ? 43 : $replicationTaskIdentifier.hashCode());
        String $sourceEndpointArn = this.getSourceEndpointArn();
        result = result * 59 + ($sourceEndpointArn == null ? 43 : $sourceEndpointArn.hashCode());
        String $targetEndpointArn = this.getTargetEndpointArn();
        result = result * 59 + ($targetEndpointArn == null ? 43 : $targetEndpointArn.hashCode());
        String $replicationInstanceArn = this.getReplicationInstanceArn();
        result = result * 59 + ($replicationInstanceArn == null ? 43 : $replicationInstanceArn.hashCode());
        String $migrationType = this.getMigrationType();
        result = result * 59 + ($migrationType == null ? 43 : $migrationType.hashCode());
        String $tableMappings = this.getTableMappings();
        result = result * 59 + ($tableMappings == null ? 43 : $tableMappings.hashCode());
        String $replicationTaskSettings = this.getReplicationTaskSettings();
        result = result * 59 + ($replicationTaskSettings == null ? 43 : $replicationTaskSettings.hashCode());
        Date $cdcStartTime = this.getCdcStartTime();
        result = result * 59 + ($cdcStartTime == null ? 43 : ((Object)$cdcStartTime).hashCode());
        String $cdcStartPosition = this.getCdcStartPosition();
        result = result * 59 + ($cdcStartPosition == null ? 43 : $cdcStartPosition.hashCode());
        String $cdcStopPosition = this.getCdcStopPosition();
        result = result * 59 + ($cdcStopPosition == null ? 43 : $cdcStopPosition.hashCode());
        List<Tag> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        String $taskData = this.getTaskData();
        result = result * 59 + ($taskData == null ? 43 : $taskData.hashCode());
        String $resourceIdentifier = this.getResourceIdentifier();
        result = result * 59 + ($resourceIdentifier == null ? 43 : $resourceIdentifier.hashCode());
        String $replicationTaskArn = this.getReplicationTaskArn();
        result = result * 59 + ($replicationTaskArn == null ? 43 : $replicationTaskArn.hashCode());
        String $startReplicationTaskType = this.getStartReplicationTaskType();
        result = result * 59 + ($startReplicationTaskType == null ? 43 : $startReplicationTaskType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DmsHook(log=" + this.getLog() + ", client=" + this.getClient() + ", replicationTaskIdentifier=" + this.getReplicationTaskIdentifier() + ", sourceEndpointArn=" + this.getSourceEndpointArn() + ", targetEndpointArn=" + this.getTargetEndpointArn() + ", replicationInstanceArn=" + this.getReplicationInstanceArn() + ", migrationType=" + this.getMigrationType() + ", tableMappings=" + this.getTableMappings() + ", replicationTaskSettings=" + this.getReplicationTaskSettings() + ", cdcStartTime=" + this.getCdcStartTime() + ", cdcStartPosition=" + this.getCdcStartPosition() + ", cdcStopPosition=" + this.getCdcStopPosition() + ", tags=" + this.getTags() + ", taskData=" + this.getTaskData() + ", resourceIdentifier=" + this.getResourceIdentifier() + ", replicationTaskArn=" + this.getReplicationTaskArn() + ", startReplicationTaskType=" + this.getStartReplicationTaskType() + ")";
    }

    public static class CONSTANTS {
        public static final int CHECK_INTERVAL = 1000;
    }

    public static class START_TYPE {
        public static final String START_REPLICATION = "start-replication";
        public static final String RELOAD_TARGET = "reload-target";
    }

    public static class AWS_KEY {
        public static final String REPLICATION_TASK_ARN = "replication-task-arn";
        public static final String REPLICATION_INSTANCE_ARN = "replication-instance-arn";
        public static final String ENDPOINT_ARN = "endpoint-arn";
    }

    public static class STATUS {
        public static final String DELETE = "delete";
        public static final String READY = "ready";
        public static final String RUNNING = "running";
        public static final String STOPPED = "stopped";
        public static final String SUCCESSFUL = "successful";
        public static final String TESTING = "testing";
        public static final String FINISH_END_TOKEN = "FINISHED";
    }

    public static class ApplicationIds {
        private String replicationTaskArn;

        @Generated
        public String getReplicationTaskArn() {
            return this.replicationTaskArn;
        }

        @Generated
        public void setReplicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApplicationIds)) {
                return false;
            }
            ApplicationIds other = (ApplicationIds)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$replicationTaskArn = this.getReplicationTaskArn();
            String other$replicationTaskArn = other.getReplicationTaskArn();
            return !(this$replicationTaskArn == null ? other$replicationTaskArn != null : !this$replicationTaskArn.equals(other$replicationTaskArn));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ApplicationIds;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $replicationTaskArn = this.getReplicationTaskArn();
            result = result * 59 + ($replicationTaskArn == null ? 43 : $replicationTaskArn.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DmsHook.ApplicationIds(replicationTaskArn=" + this.getReplicationTaskArn() + ")";
        }

        @Generated
        public ApplicationIds(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
        }

        @Generated
        public ApplicationIds() {
        }
    }
}

