/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.utils;

import io.fabric8.kubernetes.client.dsl.LogWatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.task.api.K8sTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.TaskConstants;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.am.ApplicationManager;
import org.apache.dolphinscheduler.plugin.task.api.am.KubernetesApplicationManager;
import org.apache.dolphinscheduler.plugin.task.api.am.KubernetesApplicationManagerContext;
import org.apache.dolphinscheduler.plugin.task.api.am.YarnApplicationManagerContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.ResourceManagerType;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessUtils.class);
    private static final Map<ResourceManagerType, ApplicationManager> applicationManagerMap = new HashMap<ResourceManagerType, ApplicationManager>();
    private static final Pattern MACPATTERN;
    private static final Pattern WINDOWSPATTERN;
    private static final Pattern LINUXPATTERN;

    private ProcessUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean kill(@NonNull TaskExecutionContext request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        try {
            log.info("Begin killing task instance, processId: {}", (Object)request.getProcessId());
            int processId = request.getProcessId();
            if (processId == 0) {
                log.info("Task instance has already finished, no need to kill");
                return true;
            }
            String pids = ProcessUtils.getPidsStr(processId);
            String[] pidArray = pids.split("\\s+");
            if (pidArray.length == 0) {
                log.warn("No valid PIDs found for process: {}", (Object)processId);
                return true;
            }
            boolean gracefulKillSuccess = ProcessUtils.sendKillSignal("SIGINT", pids, request.getTenantCode());
            if (gracefulKillSuccess) {
                log.info("Successfully killed process tree using SIGINT, processId: {}", (Object)processId);
                return true;
            }
            boolean termKillSuccess = ProcessUtils.sendKillSignal("SIGTERM", pids, request.getTenantCode());
            if (termKillSuccess) {
                log.info("Successfully killed process tree using SIGTERM, processId: {}", (Object)processId);
                return true;
            }
            log.warn("SIGINT & SIGTERM failed, using SIGKILL as a last resort for processId: {}", (Object)processId);
            boolean forceKillSuccess = ProcessUtils.sendKillSignal("SIGKILL", pids, request.getTenantCode());
            if (forceKillSuccess) {
                log.info("Successfully sent SIGKILL signal to process tree, processId: {}", (Object)processId);
            } else {
                log.error("Error sending SIGKILL signal to process tree, processId: {}", (Object)processId);
            }
            return forceKillSuccess;
        }
        catch (Exception e) {
            log.error("Kill task instance error, processId: {}", (Object)request.getProcessId(), (Object)e);
            return false;
        }
    }

    private static boolean sendKillSignal(String signal, String pids, String tenantCode) {
        try {
            String killCmd = String.format("kill -s %s %s", signal, pids);
            killCmd = OSUtils.getSudoCmd((String)tenantCode, (String)killCmd);
            log.info("Sending {} to process group: {}, command: {}", new Object[]{signal, pids, killCmd});
            OSUtils.exeCmd((String)killCmd);
            return true;
        }
        catch (Exception e) {
            log.error("Error sending {} to process: {}", new Object[]{signal, pids, e});
            return false;
        }
    }

    public static String getPidsStr(int processId) throws Exception {
        String rawPidStr = SystemUtils.IS_OS_MAC ? OSUtils.exeCmd((String)String.format("%s -sp %d", "pstree", processId)) : (SystemUtils.IS_OS_LINUX ? OSUtils.exeCmd((String)String.format("%s -p %d", "pstree", processId)) : OSUtils.exeCmd((String)String.format("%s -p %d", "pstree", processId)));
        return ProcessUtils.parsePidStr(rawPidStr);
    }

    public static String parsePidStr(String rawPidStr) {
        log.info("prepare to parse pid, raw pid string: {}", (Object)rawPidStr);
        ArrayList<String> allPidList = new ArrayList<String>();
        Matcher mat = null;
        if (SystemUtils.IS_OS_MAC) {
            if (StringUtils.isNotEmpty((CharSequence)rawPidStr)) {
                mat = MACPATTERN.matcher(rawPidStr);
            }
        } else if (SystemUtils.IS_OS_LINUX) {
            if (StringUtils.isNotEmpty((CharSequence)rawPidStr)) {
                mat = LINUXPATTERN.matcher(rawPidStr);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)rawPidStr)) {
            mat = WINDOWSPATTERN.matcher(rawPidStr);
        }
        if (null != mat) {
            while (mat.find()) {
                allPidList.add(mat.group(1));
            }
        }
        return String.join((CharSequence)" ", allPidList).trim();
    }

    public static void cancelApplication(TaskExecutionContext taskExecutionContext) {
        try {
            if (Objects.nonNull(taskExecutionContext.getK8sTaskExecutionContext())) {
                if (!TaskConstants.TASK_TYPE_SET_K8S.contains(taskExecutionContext.getTaskType())) {
                    applicationManagerMap.get((Object)ResourceManagerType.KUBERNETES).killApplication(new KubernetesApplicationManagerContext(taskExecutionContext.getK8sTaskExecutionContext(), taskExecutionContext.getTaskAppId(), ""));
                }
            } else {
                List<String> appIds;
                String host = taskExecutionContext.getHost();
                String executePath = taskExecutionContext.getExecutePath();
                String tenantCode = taskExecutionContext.getTenantCode();
                if (StringUtils.isNotEmpty((CharSequence)taskExecutionContext.getAppIds())) {
                    appIds = Arrays.asList(taskExecutionContext.getAppIds().split(","));
                } else {
                    String logPath = taskExecutionContext.getLogPath();
                    String appInfoPath = taskExecutionContext.getAppInfoPath();
                    if (logPath == null || appInfoPath == null || executePath == null || tenantCode == null) {
                        log.error("Kill yarn job error, the input params is illegal, host: {}, logPath: {}, appInfoPath: {}, executePath: {}, tenantCode: {}", new Object[]{host, logPath, appInfoPath, executePath, tenantCode});
                        throw new TaskException("Cancel application failed!");
                    }
                    log.info("Get appIds from worker {}, taskLogPath: {}", (Object)host, (Object)logPath);
                    appIds = LogUtils.getAppIds(logPath, appInfoPath, PropertyUtils.getString((String)"appId.collect", (String)"log"));
                    taskExecutionContext.setAppIds(String.join((CharSequence)",", appIds));
                }
                if (CollectionUtils.isEmpty(appIds)) {
                    log.info("The appId is empty");
                    return;
                }
                ApplicationManager applicationManager = applicationManagerMap.get((Object)ResourceManagerType.YARN);
                applicationManager.killApplication(new YarnApplicationManagerContext(executePath, tenantCode, appIds));
            }
        }
        catch (Exception e) {
            log.error("Cancel application failed: {}", (Object)e.getMessage());
        }
    }

    public static TaskExecutionStatus getApplicationStatus(K8sTaskExecutionContext k8sTaskExecutionContext, String taskAppId) {
        if (Objects.isNull(k8sTaskExecutionContext)) {
            return TaskExecutionStatus.SUCCESS;
        }
        KubernetesApplicationManager applicationManager = (KubernetesApplicationManager)applicationManagerMap.get((Object)ResourceManagerType.KUBERNETES);
        return applicationManager.getApplicationStatus(new KubernetesApplicationManagerContext(k8sTaskExecutionContext, taskAppId, ""));
    }

    public static LogWatch getPodLogWatcher(K8sTaskExecutionContext k8sTaskExecutionContext, String taskAppId, String containerName) {
        KubernetesApplicationManager applicationManager = (KubernetesApplicationManager)applicationManagerMap.get((Object)ResourceManagerType.KUBERNETES);
        return applicationManager.getPodLogWatcher(new KubernetesApplicationManagerContext(k8sTaskExecutionContext, taskAppId, containerName));
    }

    public static void removeK8sClientCache(String taskAppId) {
        KubernetesApplicationManager applicationManager = (KubernetesApplicationManager)applicationManagerMap.get((Object)ResourceManagerType.KUBERNETES);
        applicationManager.removeCache(taskAppId);
    }

    static {
        ServiceLoader.load(ApplicationManager.class).forEach(applicationManager -> applicationManagerMap.put(applicationManager.getResourceManagerType(), (ApplicationManager)applicationManager));
        MACPATTERN = Pattern.compile("-[+|-][-|=]\\s(\\d+)");
        WINDOWSPATTERN = Pattern.compile("(\\d+)");
        LINUXPATTERN = Pattern.compile("\\((\\d+)\\)");
    }
}

