/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractRemoteTask;
import org.apache.dolphinscheduler.plugin.task.api.ShellCommandExecutor;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskResponse;
import org.apache.dolphinscheduler.plugin.task.api.shell.IShellInterceptorBuilder;
import org.apache.dolphinscheduler.plugin.task.api.shell.ShellInterceptorBuilderFactory;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractYarnTask
extends AbstractRemoteTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractYarnTask.class);
    private ShellCommandExecutor shellCommandExecutor;

    public AbstractYarnTask(TaskExecutionContext taskRequest) {
        super(taskRequest);
        this.shellCommandExecutor = new ShellCommandExecutor(this::logHandle, taskRequest);
    }

    @Override
    public void handle(TaskCallBack taskCallBack) throws TaskException {
        try {
            Object shellActuatorBuilder = ShellInterceptorBuilderFactory.newBuilder().properties(this.getProperties()).appendScript(this.getScript().replaceAll("\\r\\n", System.lineSeparator()));
            TaskResponse response = this.shellCommandExecutor.run((IShellInterceptorBuilder)shellActuatorBuilder, taskCallBack);
            this.setExitStatusCode(response.getExitStatusCode());
            this.setAppIds(String.join((CharSequence)",", this.getApplicationIds()));
            this.setProcessId(response.getProcessId());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            log.info("The current yarn task has been interrupted", (Throwable)ex);
            this.setExitStatusCode(-1);
            throw new TaskException("The current yarn task has been interrupted", ex);
        }
        catch (Exception e) {
            log.error("yarn process failure", (Throwable)e);
            this.exitStatusCode = -1;
            throw new TaskException("Execute task failed", e);
        }
    }

    @Override
    public void submitApplication() throws TaskException {
    }

    @Override
    public void trackApplicationStatus() throws TaskException {
    }

    @Override
    public void cancelApplication() throws TaskException {
        try {
            this.shellCommandExecutor.cancelApplication();
        }
        catch (Exception e) {
            throw new TaskException("cancel application error", e);
        }
    }

    @Override
    public List<String> getApplicationIds() throws TaskException {
        return LogUtils.getAppIds(this.taskRequest.getLogPath(), this.taskRequest.getAppInfoPath(), PropertyUtils.getString((String)"appId.collect", (String)"log"));
    }

    protected abstract String getScript();

    protected abstract Map<String, String> getProperties();
}

