/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.storage.hdfs;

import com.google.auto.service.AutoService;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperatorFactory;
import org.apache.dolphinscheduler.plugin.storage.api.StorageType;
import org.apache.dolphinscheduler.plugin.storage.hdfs.HdfsStorageProperties;
import org.apache.dolphinscheduler.plugin.storage.hdfs.LocalStorageOperator;

@AutoService(value={StorageOperatorFactory.class})
public class LocalStorageOperatorFactory
implements StorageOperatorFactory {
    public static final String LOCAL_DEFAULT_FS = "file:/";

    public StorageOperator createStorageOperate() {
        HdfsStorageProperties hdfsStorageProperties = this.getHdfsStorageProperties();
        return new LocalStorageOperator(hdfsStorageProperties);
    }

    private HdfsStorageProperties getHdfsStorageProperties() {
        return HdfsStorageProperties.builder().defaultFS(LOCAL_DEFAULT_FS).resourceUploadPath(PropertyUtils.getString((String)"resource.storage.upload.base.path", (String)"/dolphinscheduler")).build();
    }

    public StorageType getStorageOperate() {
        return StorageType.LOCAL;
    }
}

