/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.storage.cos;

import com.qcloud.cos.COS;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.CopyObjectRequest;
import com.qcloud.cos.model.CopyResult;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ListObjectsRequest;
import com.qcloud.cos.model.ObjectListing;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.UploadResult;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.transfer.Copy;
import com.qcloud.cos.transfer.Download;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.TransferManagerConfiguration;
import com.qcloud.cos.transfer.Upload;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.plugin.storage.api.AbstractStorageOperator;
import org.apache.dolphinscheduler.plugin.storage.api.ResourceMetadata;
import org.apache.dolphinscheduler.plugin.storage.api.StorageEntity;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.apache.dolphinscheduler.plugin.storage.cos.CosStorageProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosStorageOperator
extends AbstractStorageOperator
implements Closeable,
StorageOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CosStorageOperator.class);
    private static final int TRANSFER_THREAD_POOL_SIZE = 16;
    private static final long MULTIPART_UPLOAD_BYTES_THRESHOLD = 0x500000L;
    private static final long MIN_UPLOAD_PART_BYTES = 0x100000L;
    private final String bucketName;
    private final COSClient cosClient;
    private final TransferManager cosTransferManager;

    public CosStorageOperator(CosStorageProperties cosStorageProperties) {
        super(cosStorageProperties.getResourceUploadPath());
        String secretId = cosStorageProperties.getAccessKeyId();
        String secretKey = cosStorageProperties.getAccessKeySecret();
        BasicCOSCredentials cosCredentials = new BasicCOSCredentials(secretId, secretKey);
        String regionName = cosStorageProperties.getRegion();
        ClientConfig clientConfig = new ClientConfig(new Region(regionName));
        clientConfig.setHttpProtocol(HttpProtocol.https);
        this.cosClient = new COSClient((COSCredentials)cosCredentials, clientConfig);
        this.bucketName = cosStorageProperties.getBucketName();
        this.ensureBucketSuccessfullyCreated(this.bucketName);
        this.cosTransferManager = this.getCosTransferManager();
    }

    @Override
    public void close() throws IOException {
        this.cosTransferManager.shutdownNow(true);
    }

    public String getStorageBaseDirectory() {
        if (this.resourceBaseAbsolutePath.startsWith(File.separator)) {
            String warnMessage = String.format("%s -> %s should not start with %s in tencent cos", "resource.storage.upload.base.path", this.resourceBaseAbsolutePath, File.separator);
            log.warn(warnMessage);
            return this.resourceBaseAbsolutePath.substring(1);
        }
        return this.resourceBaseAbsolutePath;
    }

    public void createStorageDir(String directoryAbsolutePath) {
        String cosKey = this.transformAbsolutePathToCOSKey(directoryAbsolutePath);
        if (this.cosClient.doesObjectExist(this.bucketName, cosKey)) {
            throw new FileAlreadyExistsException("directory: " + cosKey + " already exists");
        }
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(0L);
        ByteArrayInputStream emptyContent = new ByteArrayInputStream(new byte[0]);
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucketName, cosKey, (InputStream)emptyContent, metadata);
        this.cosClient.putObject(putObjectRequest);
    }

    public void download(String srcFilePath, String dstFilePath, boolean overwrite) {
        String cosKey = this.transformAbsolutePathToCOSKey(srcFilePath);
        Path dsTempFolder = Paths.get(FileUtils.DATA_BASEDIR, new String[0]).normalize().toAbsolutePath();
        Path fileDownloadPathNormalized = dsTempFolder.resolve(dstFilePath).normalize().toAbsolutePath();
        if (!fileDownloadPathNormalized.startsWith(dsTempFolder)) {
            throw new IllegalArgumentException("failed to download to " + fileDownloadPathNormalized);
        }
        File dstFile = fileDownloadPathNormalized.toFile();
        if (dstFile.isDirectory()) {
            Files.delete(dstFile.toPath());
        } else {
            FileUtils.createDirectoryWithPermission((Path)dstFile.getParentFile().toPath(), (Set)FileUtils.PERMISSION_755);
        }
        GetObjectRequest getObjectRequest = new GetObjectRequest(this.bucketName, cosKey);
        Download download = this.cosTransferManager.download(getObjectRequest, dstFile);
        download.waitForCompletion();
    }

    public boolean exists(String fileName) {
        String cosKey = this.transformAbsolutePathToCOSKey(fileName);
        return this.cosClient.doesObjectExist(this.bucketName, cosKey);
    }

    public void delete(String filePath, boolean recursive) {
        String cosKey = this.transformAbsolutePathToCOSKey(filePath);
        this.cosClient.deleteObject(this.bucketName, cosKey);
    }

    public void copy(String srcPath, String dstPath, boolean deleteSource, boolean overwrite) {
        String srcCosKey = this.transformAbsolutePathToCOSKey(srcPath);
        String destCosKey = this.transformAbsolutePathToCOSKey(dstPath);
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(this.bucketName, srcCosKey, this.bucketName, destCosKey);
        Copy copy = this.cosTransferManager.copy(copyObjectRequest, (COS)this.cosClient, null);
        CopyResult copyResult = copy.waitForCopyResult();
        if (copyResult != null && deleteSource) {
            this.cosClient.deleteObject(this.bucketName, srcPath);
        }
    }

    public void upload(String srcFile, String dstPath, boolean deleteSource, boolean overwrite) {
        PutObjectRequest putObjectRequest;
        Upload upload;
        UploadResult uploadResult;
        dstPath = this.transformAbsolutePathToCOSKey(dstPath);
        if (this.cosClient.doesObjectExist(this.bucketName, dstPath)) {
            if (!overwrite) {
                throw new CosServiceException("file: " + dstPath + " already exists");
            }
            this.cosClient.deleteObject(this.bucketName, dstPath);
        }
        if ((uploadResult = (upload = this.cosTransferManager.upload(putObjectRequest = new PutObjectRequest(this.bucketName, dstPath, new File(srcFile)))).waitForUploadResult()) != null && deleteSource) {
            Files.delete(Paths.get(srcFile, new String[0]));
        }
    }

    /*
     * Exception decompiling
     */
    public List<String> fetchFileContent(String filePath, int skipLineNums, int limit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<StorageEntity> listStorageEntity(String path) {
        boolean objectExists;
        if (!path.endsWith(File.separator) && !(objectExists = this.cosClient.doesObjectExist(this.bucketName, path))) {
            path = path + File.separator;
        }
        String resourceAbsolutePath = path;
        ListObjectsRequest request = new ListObjectsRequest();
        request.setBucketName(this.bucketName);
        request.setPrefix(resourceAbsolutePath);
        request.setDelimiter(File.separator);
        ObjectListing result = this.cosClient.listObjects(request);
        ArrayList<StorageEntity> storageEntitys = new ArrayList<StorageEntity>();
        storageEntitys.addAll(result.getCommonPrefixes().stream().filter(x -> !resourceAbsolutePath.equals(x)).map(key -> {
            ObjectMetadata metadata = new ObjectMetadata();
            COSObject object = new COSObject();
            object.setObjectMetadata(metadata);
            object.setKey(key);
            return this.transformCOSObjectToStorageEntity(object);
        }).collect(Collectors.toList()));
        storageEntitys.addAll(result.getObjectSummaries().stream().filter(x -> !x.getKey().endsWith(File.separator)).map(summary -> {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(summary.getSize());
            metadata.setLastModified(summary.getLastModified());
            COSObject object = new COSObject();
            object.setObjectMetadata(metadata);
            object.setKey(summary.getKey());
            return this.transformCOSObjectToStorageEntity(object);
        }).collect(Collectors.toList()));
        return storageEntitys;
    }

    public List<StorageEntity> listFileStorageEntityRecursively(String resourceAbsolutePath) {
        resourceAbsolutePath = this.transformCOSKeyToAbsolutePath(resourceAbsolutePath);
        HashSet<String> visited = new HashSet<String>();
        ArrayList<StorageEntity> storageEntityList = new ArrayList<StorageEntity>();
        LinkedList<String> foldersToFetch = new LinkedList<String>();
        foldersToFetch.addLast(resourceAbsolutePath);
        while (!foldersToFetch.isEmpty()) {
            String pathToExplore = (String)foldersToFetch.pop();
            visited.add(pathToExplore);
            List<StorageEntity> storageEntities = this.listStorageEntity(pathToExplore);
            for (StorageEntity entity : storageEntities) {
                if (!entity.isDirectory() || visited.contains(entity.getFullName())) continue;
                foldersToFetch.add(entity.getFullName());
            }
            storageEntityList.addAll(storageEntities);
        }
        return storageEntityList;
    }

    public StorageEntity getStorageEntity(String resourceAbsolutePath) {
        String cosKey = this.transformCOSKeyToAbsolutePath(resourceAbsolutePath);
        COSObject object = this.cosClient.getObject(this.bucketName, cosKey);
        return this.transformCOSObjectToStorageEntity(object);
    }

    public void ensureBucketSuccessfullyCreated(String bucketName) {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            throw new IllegalArgumentException("resource.tencent.cloud.cos.bucket.name is empty");
        }
        if (!this.cosClient.doesBucketExist(bucketName)) {
            throw new IllegalArgumentException("bucketName: " + bucketName + " is not exists, you need to create them by yourself");
        }
        log.info("bucketName: {} has been found", (Object)bucketName);
    }

    protected StorageEntity transformCOSObjectToStorageEntity(COSObject object) {
        ObjectMetadata metadata = object.getObjectMetadata();
        String fileAbsolutePath = this.transformCOSKeyToAbsolutePath(object.getKey());
        ResourceMetadata resourceMetaData = this.getResourceMetaData(fileAbsolutePath);
        String fileExtension = com.google.common.io.Files.getFileExtension((String)resourceMetaData.getResourceAbsolutePath());
        return StorageEntity.builder().fileName(new File(fileAbsolutePath).getName()).fullName(fileAbsolutePath).pfullName(resourceMetaData.getResourceParentAbsolutePath()).type(resourceMetaData.getResourceType()).isDirectory(StringUtils.isEmpty((CharSequence)fileExtension)).size(metadata.getContentLength()).relativePath(resourceMetaData.getResourceRelativePath()).createTime(metadata.getLastModified()).updateTime(metadata.getLastModified()).build();
    }

    private String transformAbsolutePathToCOSKey(String absolutePath) {
        ResourceMetadata resourceMetaData = this.getResourceMetaData(absolutePath);
        if (resourceMetaData.isDirectory()) {
            return FileUtils.concatFilePath((String[])new String[]{absolutePath, File.separator});
        }
        return absolutePath;
    }

    private String transformCOSKeyToAbsolutePath(String cosKey) {
        if (cosKey.endsWith(File.separator)) {
            return cosKey.substring(0, cosKey.length() - 1);
        }
        return cosKey;
    }

    private TransferManager getCosTransferManager() {
        ExecutorService threadPool = Executors.newFixedThreadPool(16);
        TransferManager transferManager = new TransferManager((COS)this.cosClient, threadPool);
        TransferManagerConfiguration transferManagerConfiguration = new TransferManagerConfiguration();
        transferManagerConfiguration.setMultipartUploadThreshold(0x500000L);
        transferManagerConfiguration.setMinimumUploadPartSize(0x100000L);
        transferManager.setConfiguration(transferManagerConfiguration);
        return transferManager;
    }
}

