/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.subworkflow;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.RelationSubWorkflow;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.mapper.RelationSubWorkflowMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.service.subworkflow.SubWorkflowService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SubWorkflowServiceImpl
implements SubWorkflowService {
    @Autowired
    private RelationSubWorkflowMapper relationSubWorkflowMapper;
    @Autowired
    private WorkflowInstanceDao workflowInstanceDao;
    @Autowired
    private WorkflowDefinitionLogMapper workflowDefinitionLogMapper;

    @Override
    public List<WorkflowInstance> getAllDynamicSubWorkflow(long processInstanceId, long taskCode) {
        List relationSubWorkflows = this.relationSubWorkflowMapper.queryAllSubWorkflowInstance(Long.valueOf(processInstanceId), Long.valueOf(taskCode));
        List allSubProcessInstanceId = relationSubWorkflows.stream().map(RelationSubWorkflow::getSubWorkflowInstanceId).collect(Collectors.toList());
        List allSubWorkflowInstance = this.workflowInstanceDao.queryByIds(allSubProcessInstanceId);
        allSubWorkflowInstance.sort(Comparator.comparing(WorkflowInstance::getId));
        return allSubWorkflowInstance;
    }

    @Override
    public int batchInsertRelationSubWorkflow(List<RelationSubWorkflow> relationSubWorkflowList) {
        int insertN = this.relationSubWorkflowMapper.batchInsert(relationSubWorkflowList);
        return insertN;
    }

    @Override
    public List<WorkflowInstance> filterFinishProcessInstances(List<WorkflowInstance> workflowInstanceList) {
        return workflowInstanceList.stream().filter(subProcessInstance -> subProcessInstance.getState().isFinished()).collect(Collectors.toList());
    }

    @Override
    public List<WorkflowInstance> filterSuccessProcessInstances(List<WorkflowInstance> workflowInstanceList) {
        return workflowInstanceList.stream().filter(subProcessInstance -> subProcessInstance.getState().isSuccess()).collect(Collectors.toList());
    }

    @Override
    public List<WorkflowInstance> filterRunningProcessInstances(List<WorkflowInstance> workflowInstanceList) {
        return workflowInstanceList.stream().filter(subProcessInstance -> subProcessInstance.getState().isRunning()).collect(Collectors.toList());
    }

    @Override
    public List<WorkflowInstance> filterFailedProcessInstances(List<WorkflowInstance> workflowInstanceList) {
        return workflowInstanceList.stream().filter(subProcessInstance -> subProcessInstance.getState().isFailure()).collect(Collectors.toList());
    }

    @Override
    public List<Property> getWorkflowOutputParameters(WorkflowInstance workflowInstance) {
        ArrayList<Property> outputParamList = new ArrayList<Property>(JSONUtils.toList((String)workflowInstance.getVarPool(), Property.class));
        WorkflowDefinitionLog processDefinition = this.workflowDefinitionLogMapper.queryByDefinitionCodeAndVersion(workflowInstance.getWorkflowDefinitionCode().longValue(), workflowInstance.getWorkflowDefinitionVersion());
        List globalParamList = JSONUtils.toList((String)processDefinition.getGlobalParams(), Property.class);
        Set ouputParamSet = outputParamList.stream().map(Property::getProp).collect(Collectors.toSet());
        globalParamList.stream().filter(globalParam -> !ouputParamSet.contains(globalParam.getProp())).forEach(outputParamList::add);
        return outputParamList;
    }
}

