/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.process;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.enums.TaskGroupQueueStatus;
import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.model.TaskNodeRelation;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Cluster;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.DagData;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.TaskGroupQueue;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstanceRelation;
import org.apache.dolphinscheduler.dao.entity.WorkflowTaskRelation;
import org.apache.dolphinscheduler.dao.entity.WorkflowTaskRelationLog;
import org.apache.dolphinscheduler.dao.mapper.ClusterMapper;
import org.apache.dolphinscheduler.dao.mapper.CommandMapper;
import org.apache.dolphinscheduler.dao.mapper.DataSourceMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskGroupQueueMapper;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowInstanceRelationMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowTaskRelationLogMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowTaskRelationMapper;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionDao;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionLogDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceMapDao;
import org.apache.dolphinscheduler.dao.utils.EnvironmentUtils;
import org.apache.dolphinscheduler.dao.utils.WorkerGroupUtils;
import org.apache.dolphinscheduler.extract.base.client.Clients;
import org.apache.dolphinscheduler.extract.common.ILogService;
import org.apache.dolphinscheduler.plugin.task.api.enums.Direct;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.SubWorkflowParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.TaskTimeoutParameter;
import org.apache.dolphinscheduler.plugin.task.api.utils.TaskTypeUtils;
import org.apache.dolphinscheduler.service.command.CommandService;
import org.apache.dolphinscheduler.service.cron.CronUtils;
import org.apache.dolphinscheduler.service.exceptions.CronParseException;
import org.apache.dolphinscheduler.service.expand.CuringParamsService;
import org.apache.dolphinscheduler.service.model.TaskNode;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.process.WorkflowDag;
import org.apache.dolphinscheduler.service.utils.ClusterConfUtils;
import org.apache.dolphinscheduler.service.utils.DagHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessServiceImpl
implements ProcessService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private WorkflowDefinitionMapper workflowDefinitionMapper;
    @Autowired
    private WorkflowDefinitionLogMapper workflowDefinitionLogMapper;
    @Autowired
    private WorkflowInstanceMapper workflowInstanceMapper;
    @Autowired
    private WorkflowInstanceDao workflowInstanceDao;
    @Autowired
    private TaskDefinitionDao taskDefinitionDao;
    @Autowired
    private TaskInstanceDao taskInstanceDao;
    @Autowired
    private TaskDefinitionLogDao taskDefinitionLogDao;
    @Autowired
    private WorkflowInstanceMapDao workflowInstanceMapDao;
    @Autowired
    private DataSourceMapper dataSourceMapper;
    @Autowired
    private WorkflowInstanceRelationMapper workflowInstanceRelationMapper;
    @Autowired
    private CommandMapper commandMapper;
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private TaskDefinitionLogMapper taskDefinitionLogMapper;
    @Autowired
    private WorkflowTaskRelationMapper workflowTaskRelationMapper;
    @Autowired
    private WorkflowTaskRelationLogMapper workflowTaskRelationLogMapper;
    @Autowired
    private TaskGroupQueueMapper taskGroupQueueMapper;
    @Autowired
    private ClusterMapper clusterMapper;
    @Autowired
    private CuringParamsService curingGlobalParamsService;
    @Autowired
    private CommandService commandService;

    @Override
    public Optional<WorkflowInstance> findWorkflowInstanceDetailById(int workflowInstanceId) {
        return Optional.ofNullable(this.workflowInstanceMapper.queryDetailById(workflowInstanceId));
    }

    @Override
    public WorkflowInstance findWorkflowInstanceById(int workflowInstanceId) {
        return (WorkflowInstance)this.workflowInstanceMapper.selectById((Serializable)Integer.valueOf(workflowInstanceId));
    }

    @Override
    public WorkflowDefinition findWorkflowDefinition(Long workflowDefinitionCode, int workflowDefinitionVersion) {
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(workflowDefinitionCode.longValue());
        if ((workflowDefinition == null || workflowDefinition.getVersion() != workflowDefinitionVersion) && (workflowDefinition = this.workflowDefinitionLogMapper.queryByDefinitionCodeAndVersion(workflowDefinitionCode.longValue(), workflowDefinitionVersion)) != null) {
            workflowDefinition.setId(Integer.valueOf(0));
        }
        return workflowDefinition;
    }

    @Override
    public WorkflowDefinition findWorkflowDefinitionByCode(Long workflowDefinitionCode) {
        return this.workflowDefinitionMapper.queryByCode(workflowDefinitionCode.longValue());
    }

    @Override
    public int deleteWorkflowInstanceById(int workflowInstanceId) {
        return this.workflowInstanceMapper.deleteById((Serializable)Integer.valueOf(workflowInstanceId));
    }

    @Override
    public int deleteAllSubWorkflowByParentId(int workflowInstanceId) {
        List subWorkflowIdList = this.workflowInstanceRelationMapper.querySubIdListByParentId(workflowInstanceId);
        for (Integer subId : subWorkflowIdList) {
            this.deleteAllSubWorkflowByParentId(subId);
            this.deleteWorkflowMapByParentId(subId);
            this.removeTaskLogFile(subId);
            this.deleteWorkflowInstanceById(subId);
        }
        return 1;
    }

    @Override
    public void removeTaskLogFile(Integer workflowInstanceId) {
        List taskInstanceList = this.taskInstanceDao.queryByWorkflowInstanceId(workflowInstanceId);
        if (CollectionUtils.isEmpty((Collection)taskInstanceList)) {
            return;
        }
        for (TaskInstance taskInstance : taskInstanceList) {
            String taskLogPath = taskInstance.getLogPath();
            if (StringUtils.isEmpty((CharSequence)taskInstance.getHost()) || StringUtils.isEmpty((CharSequence)taskLogPath)) continue;
            ((ILogService)Clients.withService(ILogService.class).withHost(taskInstance.getHost())).removeTaskInstanceLog(taskLogPath);
        }
    }

    @Override
    public List<Long> findAllSubWorkflowDefinitionCode(long parentCode) {
        List taskNodeList = this.taskDefinitionDao.getTaskDefinitionListByDefinition(parentCode);
        if (CollectionUtils.isEmpty((Collection)taskNodeList)) {
            return Collections.emptyList();
        }
        ArrayList<Long> subWorkflowDefinitionCodes = new ArrayList<Long>();
        for (TaskDefinition taskNode : taskNodeList) {
            String parameter = taskNode.getTaskParams();
            ObjectNode parameterJson = JSONUtils.parseObject((String)parameter);
            if (parameterJson.get("processDefinitionCode") == null) continue;
            SubWorkflowParameters subProcessParam = (SubWorkflowParameters)JSONUtils.parseObject((String)parameter, SubWorkflowParameters.class);
            long subWorkflowDefinitionCode = subProcessParam.getWorkflowDefinitionCode();
            subWorkflowDefinitionCodes.add(subWorkflowDefinitionCode);
            subWorkflowDefinitionCodes.addAll(this.findAllSubWorkflowDefinitionCode(subWorkflowDefinitionCode));
        }
        return subWorkflowDefinitionCodes;
    }

    private WorkflowInstance generateNewWorkflowInstance(WorkflowDefinition workflowDefinition, Command command, Map<String, String> cmdParam) {
        WorkflowInstance workflowInstance = new WorkflowInstance(workflowDefinition);
        workflowInstance.setWorkflowDefinitionCode(Long.valueOf(workflowDefinition.getCode()));
        workflowInstance.setWorkflowDefinitionVersion(workflowDefinition.getVersion());
        workflowInstance.setProjectCode(Long.valueOf(workflowDefinition.getProjectCode()));
        workflowInstance.setStateWithDesc(WorkflowExecutionStatus.RUNNING_EXECUTION, "init running");
        workflowInstance.setRecovery(Flag.NO);
        workflowInstance.setStartTime(new Date());
        workflowInstance.setRestartTime(null);
        workflowInstance.setRunTimes(1);
        workflowInstance.setMaxTryTimes(0);
        workflowInstance.setCommandParam(command.getCommandParam());
        workflowInstance.setCommandType(command.getCommandType());
        workflowInstance.setIsSubWorkflow(Flag.NO);
        workflowInstance.setTaskDependType(command.getTaskDependType());
        workflowInstance.setFailureStrategy(command.getFailureStrategy());
        workflowInstance.setExecutorId(command.getExecutorId());
        workflowInstance.setExecutorName((String)Optional.ofNullable(this.userMapper.selectById(command.getExecutorId())).map(User::getUserName).orElse(null));
        WarningType warningType = command.getWarningType() == null ? WarningType.NONE : command.getWarningType();
        workflowInstance.setWarningType(warningType);
        Integer warningGroupId = command.getWarningGroupId() == null ? 0 : command.getWarningGroupId();
        workflowInstance.setWarningGroupId(warningGroupId);
        workflowInstance.setDryRun(command.getDryRun());
        workflowInstance.setTestFlag(command.getTestFlag());
        if (command.getScheduleTime() != null) {
            workflowInstance.setScheduleTime(command.getScheduleTime());
        }
        workflowInstance.setCommandStartTime(command.getStartTime());
        workflowInstance.setLocations(workflowDefinition.getLocations());
        this.setGlobalParamIfCommanded(workflowDefinition, cmdParam);
        Map commandParamMap = JSONUtils.toMap((String)command.getCommandParam());
        String timezoneId = null;
        if (commandParamMap != null) {
            timezoneId = (String)commandParamMap.get("schedule_timezone");
        }
        String globalParams = this.curingGlobalParamsService.curingGlobalParams(workflowInstance.getId(), workflowDefinition.getGlobalParamMap(), workflowDefinition.getGlobalParamList(), this.getCommandTypeIfComplement(workflowInstance, command), workflowInstance.getScheduleTime(), timezoneId);
        workflowInstance.setGlobalParams(globalParams);
        workflowInstance.setWorkflowInstancePriority(command.getWorkflowInstancePriority());
        workflowInstance.setWorkerGroup(WorkerGroupUtils.getWorkerGroupOrDefault((String)command.getWorkerGroup()));
        workflowInstance.setEnvironmentCode(EnvironmentUtils.getEnvironmentCodeOrDefault((Long)command.getEnvironmentCode()));
        workflowInstance.setTimeout(workflowDefinition.getTimeout());
        workflowInstance.setTenantCode(command.getTenantCode());
        return workflowInstance;
    }

    @Override
    public void setGlobalParamIfCommanded(WorkflowDefinition workflowDefinition, Map<String, String> cmdParam) {
        Map<String, Property> fatherParam = this.curingGlobalParamsService.parseWorkflowFatherParam(cmdParam);
        HashMap<String, Property> startParamMap = new HashMap<String, Property>(fatherParam);
        Map<String, Property> currentStartParamMap = this.curingGlobalParamsService.parseWorkflowStartParam(cmdParam);
        startParamMap.putAll(currentStartParamMap);
        Map globalMap = workflowDefinition.getGlobalParamMap();
        List globalParamList = workflowDefinition.getGlobalParamList();
        if (MapUtils.isNotEmpty(startParamMap) && globalMap != null) {
            for (Map.Entry entry : globalMap.entrySet()) {
                String val;
                String globalKey = (String)entry.getKey();
                if (!startParamMap.containsKey(globalKey) || (val = ((Property)startParamMap.get(globalKey)).getValue()) == null) continue;
                entry.setValue(val);
            }
            for (Map.Entry entry : startParamMap.entrySet()) {
                if (globalMap.containsKey(entry.getKey())) continue;
                globalMap.put(entry.getKey(), ((Property)entry.getValue()).getValue());
                globalParamList.add(entry.getValue());
            }
        }
    }

    @Override
    public String getTenantForWorkflow(String tenantCode, int userId) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tenantCode}) && !"default".equals(tenantCode)) {
            return tenantCode;
        }
        if (userId == 0) {
            return null;
        }
        User user = this.userMapper.selectById(userId);
        Tenant tenant = this.tenantMapper.queryById(user.getTenantId());
        return tenant.getTenantCode();
    }

    private Boolean checkCmdParam(Command command, Map<String, String> cmdParam) {
        if (!(command.getTaskDependType() != TaskDependType.TASK_ONLY && command.getTaskDependType() != TaskDependType.TASK_PRE || cmdParam != null && cmdParam.containsKey("StartNodeList") && !cmdParam.get("StartNodeList").isEmpty())) {
            log.error("command node depend type is {}, but start nodes is null ", (Object)command.getTaskDependType());
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public WorkflowInstance constructWorkflowInstance(Command command, String host) throws CronParseException, CodeGenerateUtils.CodeGenerateException {
        WorkflowInstance workflowInstance;
        int workflowInstanceId;
        CommandType commandType = command.getCommandType();
        WorkflowDefinition workflowDefinition = this.findWorkflowDefinition(command.getWorkflowDefinitionCode(), command.getWorkflowDefinitionVersion());
        if (workflowDefinition == null) {
            log.error("cannot find the work workflow define! define code : {}", (Object)command.getWorkflowDefinitionCode());
            throw new IllegalArgumentException("Cannot find the workflow definition for this workflowInstance");
        }
        HashMap<String, String> cmdParam = JSONUtils.toMap((String)command.getCommandParam());
        if (cmdParam == null) {
            cmdParam = new HashMap<String, String>();
        }
        if ((workflowInstanceId = command.getWorkflowInstanceId()) == 0) {
            workflowInstance = this.generateNewWorkflowInstance(workflowDefinition, command, cmdParam);
        } else {
            workflowInstance = this.findWorkflowInstanceDetailById(workflowInstanceId).orElse(null);
            this.setGlobalParamIfCommanded(workflowDefinition, cmdParam);
            if (workflowInstance == null) {
                return null;
            }
        }
        CommandType commandTypeIfComplement = this.getCommandTypeIfComplement(workflowInstance, command);
        if (commandTypeIfComplement == CommandType.REPEAT_RUNNING || commandTypeIfComplement == CommandType.RECOVER_TOLERANCE_FAULT_PROCESS || commandTypeIfComplement == CommandType.RECOVER_SERIAL_WAIT) {
            this.setGlobalParamIfCommanded(workflowDefinition, cmdParam);
        }
        String timezoneId = (String)cmdParam.get("schedule_timezone");
        String globalParams = this.curingGlobalParamsService.curingGlobalParams(workflowInstance.getId(), workflowDefinition.getGlobalParamMap(), workflowDefinition.getGlobalParamList(), commandTypeIfComplement, workflowInstance.getScheduleTime(), timezoneId);
        workflowInstance.setGlobalParams(globalParams);
        workflowInstance.setWorkflowDefinition(workflowDefinition);
        if (workflowInstance.getCommandParam() != null) {
            Map workflowCmdParam = JSONUtils.toMap((String)workflowInstance.getCommandParam());
            HashMap<String, String> finalCmdParam = cmdParam;
            workflowCmdParam.forEach((key, value) -> {
                if (!finalCmdParam.containsKey(key)) {
                    finalCmdParam.put((String)key, (String)value);
                }
            });
        }
        if (cmdParam.containsKey("processInstanceId")) {
            workflowInstance.setCommandParam(command.getCommandParam());
        }
        if (Boolean.FALSE.equals(this.checkCmdParam(command, cmdParam))) {
            log.error("command parameter check failed!");
            return null;
        }
        if (command.getScheduleTime() != null) {
            workflowInstance.setScheduleTime(command.getScheduleTime());
        }
        workflowInstance.setHost(host);
        workflowInstance.setRestartTime(new Date());
        WorkflowExecutionStatus runStatus = WorkflowExecutionStatus.RUNNING_EXECUTION;
        int runTime = workflowInstance.getRunTimes();
        switch (commandType) {
            case START_PROCESS: 
            case DYNAMIC_GENERATION: {
                break;
            }
            case START_FAILURE_TASK_PROCESS: 
            case RECOVER_SUSPENDED_PROCESS: {
                List needToStartTaskInstances = this.taskInstanceDao.queryValidTaskListByWorkflowInstanceId(workflowInstance.getId(), workflowInstance.getTestFlag()).stream().filter(taskInstance -> {
                    TaskExecutionStatus state = taskInstance.getState();
                    return state == TaskExecutionStatus.FAILURE || state == TaskExecutionStatus.PAUSE || state == TaskExecutionStatus.NEED_FAULT_TOLERANCE || state == TaskExecutionStatus.KILL;
                }).collect(Collectors.toList());
                for (TaskInstance taskInstance2 : needToStartTaskInstances) {
                    this.initTaskInstance(taskInstance2);
                }
                String startTaskInstanceIds = needToStartTaskInstances.stream().map(TaskInstance::getId).map(String::valueOf).collect(Collectors.joining(","));
                cmdParam.put("StartNodeIdList", startTaskInstanceIds);
                workflowInstance.setCommandParam(JSONUtils.toJsonString(cmdParam));
                workflowInstance.setRunTimes(runTime + 1);
                break;
            }
            case START_CURRENT_TASK_PROCESS: {
                break;
            }
            case RECOVER_TOLERANCE_FAULT_PROCESS: {
                if (workflowInstance.getState() == WorkflowExecutionStatus.READY_PAUSE || workflowInstance.getState() == WorkflowExecutionStatus.READY_STOP) {
                    workflowInstance.setState(WorkflowExecutionStatus.RUNNING_EXECUTION);
                }
                workflowInstance.setRecovery(Flag.YES);
                workflowInstance.setRunTimes(runTime + 1);
                runStatus = workflowInstance.getState();
                break;
            }
            case COMPLEMENT_DATA: {
                if (workflowInstance.getId() == null) break;
                List taskInstanceList = this.taskInstanceDao.queryValidTaskListByWorkflowInstanceId(workflowInstance.getId(), workflowInstance.getTestFlag());
                for (TaskInstance taskInstance3 : taskInstanceList) {
                    taskInstance3.setFlag(Flag.NO);
                    this.taskInstanceDao.updateById((Object)taskInstance3);
                }
                break;
            }
            case REPEAT_RUNNING: {
                if (cmdParam.containsKey("StartNodeIdList")) {
                    cmdParam.remove("StartNodeIdList");
                    workflowInstance.setCommandParam(JSONUtils.toJsonString(cmdParam));
                }
                if (workflowInstance.getCommandType().equals((Object)CommandType.EXECUTE_TASK)) {
                    cmdParam.remove("StartNodeList");
                    workflowInstance.setCommandParam(JSONUtils.toJsonString(cmdParam));
                    workflowInstance.setTaskDependType(command.getTaskDependType());
                }
                List validTaskList = this.taskInstanceDao.queryValidTaskListByWorkflowInstanceId(workflowInstance.getId(), workflowInstance.getTestFlag());
                for (TaskInstance taskInstance4 : validTaskList) {
                    taskInstance4.setFlag(Flag.NO);
                    this.taskInstanceDao.updateById((Object)taskInstance4);
                }
                workflowInstance.setStartTime(new Date());
                workflowInstance.setRestartTime(workflowInstance.getStartTime());
                workflowInstance.setEndTime(null);
                workflowInstance.setRunTimes(runTime + 1);
                this.initComplementDataParam(workflowDefinition, workflowInstance, cmdParam);
                break;
            }
            case SCHEDULER: {
                break;
            }
            case EXECUTE_TASK: {
                workflowInstance.setRunTimes(runTime + 1);
                workflowInstance.setTaskDependType(command.getTaskDependType());
                workflowInstance.setCommandParam(JSONUtils.toJsonString(cmdParam));
                break;
            }
        }
        workflowInstance.setStateWithDesc(runStatus, commandType.getDescp());
        return workflowInstance;
    }

    private CommandType getCommandTypeIfComplement(WorkflowInstance workflowInstance, Command command) {
        if (CommandType.COMPLEMENT_DATA == workflowInstance.getCmdTypeIfComplement()) {
            return CommandType.COMPLEMENT_DATA;
        }
        return command.getCommandType();
    }

    private void initComplementDataParam(WorkflowDefinition workflowDefinition, WorkflowInstance workflowInstance, Map<String, String> cmdParam) throws CronParseException {
        if (!workflowInstance.isComplementData()) {
            return;
        }
        Date start = DateUtils.stringToDate((String)cmdParam.get("complementStartDate"));
        Date end = DateUtils.stringToDate((String)cmdParam.get("complementEndDate"));
        List<Object> complementDate = Lists.newLinkedList();
        if (start != null && end != null) {
            List<Schedule> listSchedules = this.queryReleaseSchedulerListByWorkflowDefinitionCode(workflowInstance.getWorkflowDefinitionCode());
            complementDate = CronUtils.getSelfFireDateList(start, end, listSchedules);
        }
        if (cmdParam.containsKey("complementScheduleDateList")) {
            complementDate = CronUtils.getSelfScheduleDateList(cmdParam);
        }
        if (CollectionUtils.isNotEmpty((Collection)complementDate) && Flag.NO == workflowInstance.getIsSubWorkflow()) {
            workflowInstance.setScheduleTime((Date)complementDate.get(0));
        }
        String timezoneId = cmdParam.get("schedule_timezone");
        String globalParams = this.curingGlobalParamsService.curingGlobalParams(workflowInstance.getId(), workflowDefinition.getGlobalParamMap(), workflowDefinition.getGlobalParamList(), CommandType.COMPLEMENT_DATA, workflowInstance.getScheduleTime(), timezoneId);
        workflowInstance.setGlobalParams(globalParams);
    }

    private void initTaskInstance(TaskInstance taskInstance) {
        if (!TaskTypeUtils.isSubWorkflowTask((String)taskInstance.getTaskType()) && (taskInstance.getState().isKill() || taskInstance.getState().isFailure())) {
            taskInstance.setFlag(Flag.NO);
            this.taskInstanceDao.updateById((Object)taskInstance);
            return;
        }
        taskInstance.setState(TaskExecutionStatus.SUBMITTED_SUCCESS);
        this.taskInstanceDao.updateById((Object)taskInstance);
    }

    protected ResourceInfo updateResourceInfo(int task_id, ResourceInfo res) {
        ResourceInfo resourceInfo = null;
        if (res != null) {
            String resourceFullName = res.getResourceName();
            if (StringUtils.isBlank((CharSequence)resourceFullName)) {
                log.error("invalid resource full name, {}", (Object)resourceFullName);
                return new ResourceInfo();
            }
            resourceInfo = new ResourceInfo();
            resourceInfo.setResourceName(resourceFullName);
            log.info("updated resource info {}", (Object)JSONUtils.toJsonString((Object)resourceInfo));
        }
        return resourceInfo;
    }

    @Override
    public int deleteWorkflowMapByParentId(int parentWorkflowId) {
        return this.workflowInstanceRelationMapper.deleteByParentWorkflowInstanceId(parentWorkflowId);
    }

    @Override
    public WorkflowInstance findSubWorkflowInstance(Integer parentWorkflowInstanceId, Integer parentTaskId) {
        WorkflowInstance workflowInstance = null;
        WorkflowInstanceRelation workflowInstanceRelation = this.workflowInstanceRelationMapper.queryByParentId(parentWorkflowInstanceId.intValue(), parentTaskId.intValue());
        if (workflowInstanceRelation == null || workflowInstanceRelation.getWorkflowInstanceId() == 0) {
            return workflowInstance;
        }
        workflowInstance = this.findWorkflowInstanceById(workflowInstanceRelation.getWorkflowInstanceId());
        return workflowInstance;
    }

    @Override
    public WorkflowInstance findParentWorkflowInstance(Integer subWorkflowInstanceId) {
        WorkflowInstance workflowInstance = null;
        WorkflowInstanceRelation workflowInstanceRelation = this.workflowInstanceRelationMapper.queryBySubWorkflowId(subWorkflowInstanceId);
        if (workflowInstanceRelation == null || workflowInstanceRelation.getWorkflowInstanceId() == 0) {
            return workflowInstance;
        }
        workflowInstance = this.findWorkflowInstanceById(workflowInstanceRelation.getParentWorkflowInstanceId());
        return workflowInstance;
    }

    @Override
    public void changeOutParam(TaskInstance taskInstance) {
        if (Strings.isNullOrEmpty((String)taskInstance.getVarPool())) {
            return;
        }
        List properties = JSONUtils.toList((String)taskInstance.getVarPool(), Property.class);
        if (CollectionUtils.isEmpty((Collection)properties)) {
            return;
        }
        Map taskParams = (Map)JSONUtils.parseObject((String)taskInstance.getTaskParams(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        Object localParams = taskParams.get("localParams");
        if (localParams == null) {
            return;
        }
        List allParam = JSONUtils.toList((String)JSONUtils.toJsonString(localParams), Property.class);
        HashMap<String, String> outProperty = new HashMap<String, String>();
        for (Property info : properties) {
            if (info.getDirect() != Direct.OUT) continue;
            outProperty.put(info.getProp(), info.getValue());
        }
        for (Property info : allParam) {
            if (info.getDirect() != Direct.OUT) continue;
            String paramName = info.getProp();
            info.setValue((String)outProperty.get(paramName));
        }
        taskParams.put("localParams", allParam);
        taskInstance.setTaskParams(JSONUtils.toJsonString((Object)taskParams));
    }

    private List<String> convertIntListToString(List<Integer> intList) {
        if (intList == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>(intList.size());
        for (Integer intVar : intList) {
            result.add(String.valueOf(intVar));
        }
        return result;
    }

    @Override
    public Schedule querySchedule(int id) {
        return (Schedule)this.scheduleMapper.selectById((Serializable)Integer.valueOf(id));
    }

    @Override
    public List<Schedule> queryReleaseSchedulerListByWorkflowDefinitionCode(long workflowDefinitionCode) {
        return this.scheduleMapper.queryReleaseSchedulerListByWorkflowDefinitionCode(workflowDefinitionCode);
    }

    @Override
    public DataSource findDataSourceById(int id) {
        return (DataSource)this.dataSourceMapper.selectById((Serializable)Integer.valueOf(id));
    }

    @Override
    public User getUserById(int userId) {
        return this.userMapper.selectById(userId);
    }

    @Override
    public String formatTaskAppId(TaskInstance taskInstance) {
        WorkflowInstance workflowInstance = this.findWorkflowInstanceById(taskInstance.getWorkflowInstanceId());
        if (workflowInstance == null) {
            return "";
        }
        WorkflowDefinition definition = this.findWorkflowDefinition(workflowInstance.getWorkflowDefinitionCode(), workflowInstance.getWorkflowDefinitionVersion());
        if (definition == null) {
            return "";
        }
        return String.format("%s_%s_%s", definition.getId(), workflowInstance.getId(), taskInstance.getId());
    }

    @Override
    public <T> List<T> listUnauthorized(int userId, T[] needChecks, AuthorizationType authorizationType) {
        ArrayList<T> resultList = new ArrayList<T>();
        if (Objects.nonNull(needChecks) && needChecks.length > 0) {
            HashSet<T> originResSet = new HashSet<T>(Arrays.asList(needChecks));
            switch (authorizationType) {
                case DATASOURCE: {
                    Set authorizedDatasources = this.dataSourceMapper.listAuthorizedDataSource(userId, (Object[])needChecks).stream().map(DataSource::getId).collect(Collectors.toSet());
                    originResSet.removeAll(authorizedDatasources);
                    break;
                }
            }
            resultList.addAll(originResSet);
        }
        return resultList;
    }

    @Override
    public int switchVersion(WorkflowDefinition workflowDefinition, WorkflowDefinitionLog workflowDefinitionLog) {
        if (null == workflowDefinition || null == workflowDefinitionLog) {
            return -1;
        }
        workflowDefinitionLog.setId(workflowDefinition.getId());
        workflowDefinitionLog.setReleaseState(ReleaseState.OFFLINE);
        workflowDefinitionLog.setFlag(Flag.YES);
        int result = this.workflowDefinitionMapper.updateById((WorkflowDefinition)workflowDefinitionLog);
        if (result > 0 && (result = this.switchWorkflowTaskRelationVersion((WorkflowDefinition)workflowDefinitionLog)) <= 0) {
            return -1;
        }
        return result;
    }

    @Override
    public int switchWorkflowTaskRelationVersion(WorkflowDefinition workflowDefinition) {
        List workflowTaskRelationListFromLog;
        int batchInsert;
        List workflowTaskRelationList = this.workflowTaskRelationMapper.queryByWorkflowDefinitionCode(workflowDefinition.getCode());
        if (!workflowTaskRelationList.isEmpty()) {
            this.workflowTaskRelationMapper.deleteByWorkflowDefinitionCode(workflowDefinition.getProjectCode(), workflowDefinition.getCode());
        }
        if ((batchInsert = this.workflowTaskRelationMapper.batchInsert(workflowTaskRelationListFromLog = this.workflowTaskRelationLogMapper.queryByWorkflowCodeAndVersion(workflowDefinition.getCode(), workflowDefinition.getVersion()).stream().map(WorkflowTaskRelation::new).collect(Collectors.toList()))) == 0) {
            return -1;
        }
        int result = 0;
        for (WorkflowTaskRelation taskRelation : workflowTaskRelationListFromLog) {
            int switchResult = this.switchTaskDefinitionVersion(taskRelation.getPostTaskCode(), taskRelation.getPostTaskVersion());
            if (switchResult == -1) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int switchTaskDefinitionVersion(long taskCode, int taskVersion) {
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null) {
            return -1;
        }
        if (taskDefinition.getVersion() == taskVersion) {
            return 0;
        }
        TaskDefinitionLog taskDefinitionUpdate = this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(taskCode, taskVersion);
        if (taskDefinitionUpdate == null) {
            return -1;
        }
        taskDefinitionUpdate.setUpdateTime(new Date());
        taskDefinitionUpdate.setId(taskDefinition.getId());
        return this.taskDefinitionMapper.updateById((Object)taskDefinitionUpdate);
    }

    @Override
    @Deprecated
    public String getResourceIds(TaskDefinition taskDefinition) {
        return "";
    }

    @Override
    public int saveTaskDefine(User operator, long projectCode, List<TaskDefinitionLog> taskDefinitionLogs, Boolean syncDefine) {
        Date now = new Date();
        ArrayList<TaskDefinitionLog> newTaskDefinitionLogs = new ArrayList<TaskDefinitionLog>();
        ArrayList<TaskDefinitionLog> updateTaskDefinitionLogs = new ArrayList<TaskDefinitionLog>();
        for (TaskDefinitionLog taskDefinitionLog2 : taskDefinitionLogs) {
            TaskDefinitionLog definitionCodeAndVersion;
            taskDefinitionLog2.setProjectCode(projectCode);
            taskDefinitionLog2.setUpdateTime(now);
            taskDefinitionLog2.setOperateTime(now);
            taskDefinitionLog2.setOperator(operator.getId().intValue());
            if (taskDefinitionLog2.getCode() == 0L) {
                taskDefinitionLog2.setCode(CodeGenerateUtils.genCode());
            }
            if (taskDefinitionLog2.getVersion() == 0) {
                taskDefinitionLog2.setVersion(1);
            }
            if ((definitionCodeAndVersion = this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(taskDefinitionLog2.getCode(), taskDefinitionLog2.getVersion())) == null) {
                taskDefinitionLog2.setUserId(operator.getId().intValue());
                taskDefinitionLog2.setCreateTime(now);
                newTaskDefinitionLogs.add(taskDefinitionLog2);
                continue;
            }
            if (taskDefinitionLog2.equals((Object)definitionCodeAndVersion)) continue;
            taskDefinitionLog2.setUserId(definitionCodeAndVersion.getUserId());
            Integer version = this.taskDefinitionLogMapper.queryMaxVersionForDefinition(taskDefinitionLog2.getCode());
            taskDefinitionLog2.setVersion(version + 1);
            taskDefinitionLog2.setCreateTime(definitionCodeAndVersion.getCreateTime());
            updateTaskDefinitionLogs.add(taskDefinitionLog2);
        }
        if (CollectionUtils.isNotEmpty(updateTaskDefinitionLogs)) {
            List taskDefinitionCodes = updateTaskDefinitionLogs.stream().map(TaskDefinition::getCode).distinct().collect(Collectors.toList());
            Map taskDefinitionMap = this.taskDefinitionMapper.queryByCodeList(taskDefinitionCodes).stream().collect(Collectors.toMap(TaskDefinition::getCode, Function.identity()));
            for (TaskDefinitionLog taskDefinitionToUpdate : updateTaskDefinitionLogs) {
                TaskDefinition task = (TaskDefinition)taskDefinitionMap.get(taskDefinitionToUpdate.getCode());
                if (task == null) {
                    newTaskDefinitionLogs.add(taskDefinitionToUpdate);
                    continue;
                }
                taskDefinitionToUpdate.setId(task.getId());
            }
        }
        int updateResult = 0;
        int insertResult = 0;
        List newInsertTaskDefinitionLogs = newTaskDefinitionLogs.stream().filter(taskDefinitionLog -> !updateTaskDefinitionLogs.contains(taskDefinitionLog)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(newInsertTaskDefinitionLogs)) {
            insertResult = this.taskDefinitionLogMapper.batchInsert(newInsertTaskDefinitionLogs);
        }
        if (CollectionUtils.isNotEmpty(updateTaskDefinitionLogs)) {
            insertResult += this.taskDefinitionLogMapper.batchInsert(updateTaskDefinitionLogs);
        }
        if (CollectionUtils.isNotEmpty(newTaskDefinitionLogs) && Boolean.TRUE.equals(syncDefine)) {
            updateResult += this.taskDefinitionMapper.batchInsert(newTaskDefinitionLogs);
        }
        if (CollectionUtils.isNotEmpty(updateTaskDefinitionLogs) && Boolean.TRUE.equals(syncDefine)) {
            for (TaskDefinitionLog taskDefinitionLog3 : updateTaskDefinitionLogs) {
                updateResult += this.taskDefinitionMapper.updateById((Object)taskDefinitionLog3);
            }
        }
        return (insertResult & updateResult) > 0 ? 1 : 0;
    }

    @Override
    public int saveWorkflowDefine(User operator, WorkflowDefinition workflowDefinition, Boolean syncDefine, Boolean isFromWorkflowDefinition) {
        WorkflowDefinitionLog workflowDefinitionLog = new WorkflowDefinitionLog(workflowDefinition);
        Integer version = this.workflowDefinitionLogMapper.queryMaxVersionForDefinition(workflowDefinition.getCode());
        int insertVersion = version == null || version == 0 ? 1 : version + 1;
        workflowDefinitionLog.setVersion(insertVersion);
        workflowDefinitionLog.setReleaseState(isFromWorkflowDefinition == false || workflowDefinitionLog.getReleaseState() == ReleaseState.ONLINE ? ReleaseState.ONLINE : ReleaseState.OFFLINE);
        workflowDefinitionLog.setOperator(operator.getId().intValue());
        workflowDefinitionLog.setOperateTime(workflowDefinition.getUpdateTime());
        workflowDefinitionLog.setId(null);
        int insertLog = this.workflowDefinitionLogMapper.insert((Object)workflowDefinitionLog);
        int result = 1;
        if (Boolean.TRUE.equals(syncDefine)) {
            if (workflowDefinition.getId() == null) {
                result = this.workflowDefinitionMapper.insert((Object)workflowDefinitionLog);
                workflowDefinition.setId(workflowDefinitionLog.getId());
            } else {
                workflowDefinitionLog.setId(workflowDefinition.getId());
                result = this.workflowDefinitionMapper.updateById((WorkflowDefinition)workflowDefinitionLog);
            }
        }
        return (insertLog & result) > 0 ? insertVersion : 0;
    }

    @Override
    public int saveTaskRelation(User operator, long projectCode, long workflowDefinitionCode, int workflowDefinitionVersion, List<WorkflowTaskRelationLog> taskRelationList, List<TaskDefinitionLog> taskDefinitionLogs, Boolean syncDefine) {
        int resultLog;
        if (taskRelationList.isEmpty()) {
            return 0;
        }
        Map<Long, TaskDefinitionLog> taskDefinitionLogMap = null;
        if (CollectionUtils.isNotEmpty(taskDefinitionLogs)) {
            taskDefinitionLogMap = taskDefinitionLogs.stream().collect(Collectors.toMap(TaskDefinition::getCode, taskDefinitionLog -> taskDefinitionLog));
        }
        Date now = new Date();
        for (WorkflowTaskRelationLog workflowTaskRelationLog : taskRelationList) {
            workflowTaskRelationLog.setProjectCode(projectCode);
            workflowTaskRelationLog.setWorkflowDefinitionCode(workflowDefinitionCode);
            workflowTaskRelationLog.setWorkflowDefinitionVersion(workflowDefinitionVersion);
            if (taskDefinitionLogMap != null) {
                TaskDefinitionLog postTaskDefinitionLog;
                TaskDefinitionLog preTaskDefinitionLog = taskDefinitionLogMap.get(workflowTaskRelationLog.getPreTaskCode());
                if (preTaskDefinitionLog != null) {
                    workflowTaskRelationLog.setPreTaskVersion(preTaskDefinitionLog.getVersion());
                }
                if ((postTaskDefinitionLog = taskDefinitionLogMap.get(workflowTaskRelationLog.getPostTaskCode())) != null) {
                    workflowTaskRelationLog.setPostTaskVersion(postTaskDefinitionLog.getVersion());
                }
            }
            workflowTaskRelationLog.setCreateTime(now);
            workflowTaskRelationLog.setUpdateTime(now);
            workflowTaskRelationLog.setOperator(operator.getId().intValue());
            workflowTaskRelationLog.setOperateTime(now);
        }
        int insert = taskRelationList.size();
        if (Boolean.TRUE.equals(syncDefine)) {
            List workflowTaskRelationList = this.workflowTaskRelationMapper.queryByWorkflowDefinitionCode(workflowDefinitionCode);
            if (!workflowTaskRelationList.isEmpty()) {
                Set taskRelationSet;
                Set workflowTaskRelationSet = workflowTaskRelationList.stream().map(WorkflowTaskRelation::hashCode).collect(Collectors.toSet());
                boolean result = CollectionUtils.isEqualCollection(workflowTaskRelationSet, taskRelationSet = taskRelationList.stream().map(WorkflowTaskRelationLog::hashCode).collect(Collectors.toSet()));
                if (result) {
                    return 0;
                }
                this.workflowTaskRelationMapper.deleteByWorkflowDefinitionCode(projectCode, workflowDefinitionCode);
            }
            List workflowTaskRelations = taskRelationList.stream().map(WorkflowTaskRelation::new).collect(Collectors.toList());
            insert = this.workflowTaskRelationMapper.batchInsert(workflowTaskRelations);
        }
        return (insert & (resultLog = this.workflowTaskRelationLogMapper.batchInsert(taskRelationList))) > 0 ? 0 : -1;
    }

    @Override
    public boolean isTaskOnline(long taskCode) {
        List workflowTaskRelationList = this.workflowTaskRelationMapper.queryByTaskCode(taskCode);
        if (!workflowTaskRelationList.isEmpty()) {
            Set processDefinitionCodes = workflowTaskRelationList.stream().map(WorkflowTaskRelation::getWorkflowDefinitionCode).collect(Collectors.toSet());
            List workflowDefinitionList = this.workflowDefinitionMapper.queryByCodes(processDefinitionCodes);
            for (WorkflowDefinition workflowDefinition : workflowDefinitionList) {
                if (workflowDefinition.getReleaseState() != ReleaseState.ONLINE) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public DAG<Long, TaskNode, TaskNodeRelation> genDagGraph(WorkflowDefinition workflowDefinition) {
        List<WorkflowTaskRelation> taskRelations = this.findRelationByCode(workflowDefinition.getCode(), workflowDefinition.getVersion());
        List<TaskNode> taskNodeList = this.transformTask(taskRelations, Lists.newArrayList());
        WorkflowDag workflowDag = DagHelper.getWorkflowDag(taskNodeList, new ArrayList<WorkflowTaskRelation>(taskRelations));
        return DagHelper.buildDagGraph(workflowDag);
    }

    @Override
    public DagData genDagData(WorkflowDefinition workflowDefinition) {
        List<WorkflowTaskRelation> taskRelations = this.findRelationByCode(workflowDefinition.getCode(), workflowDefinition.getVersion());
        List taskDefinitions = this.taskDefinitionLogDao.queryTaskDefineLogList(taskRelations).stream().map(t -> t).collect(Collectors.toList());
        return new DagData(workflowDefinition, taskRelations, taskDefinitions);
    }

    @Override
    public List<WorkflowTaskRelation> findRelationByCode(long workflowDefinitionCode, int workflowDefinitionVersion) {
        List workflowTaskRelationLogList = this.workflowTaskRelationLogMapper.queryByWorkflowCodeAndVersion(workflowDefinitionCode, workflowDefinitionVersion);
        return workflowTaskRelationLogList.stream().map(r -> r).collect(Collectors.toList());
    }

    @Override
    public List<TaskNode> transformTask(List<WorkflowTaskRelation> taskRelationList, List<TaskDefinitionLog> taskDefinitionLogs) {
        HashMap<Long, List> taskCodeMap = new HashMap<Long, List>();
        for (WorkflowTaskRelation workflowTaskRelation : taskRelationList) {
            taskCodeMap.compute(workflowTaskRelation.getPostTaskCode(), (k, v) -> {
                if (v == null) {
                    v = new ArrayList<Long>();
                }
                if (workflowTaskRelation.getPreTaskCode() != 0L) {
                    v.add(workflowTaskRelation.getPreTaskCode());
                }
                return v;
            });
        }
        if (CollectionUtils.isEmpty(taskDefinitionLogs)) {
            taskDefinitionLogs = this.taskDefinitionLogDao.queryTaskDefineLogList(taskRelationList);
        }
        Map<Long, TaskDefinitionLog> taskDefinitionLogMap = taskDefinitionLogs.stream().collect(Collectors.toMap(TaskDefinition::getCode, taskDefinitionLog -> taskDefinitionLog));
        ArrayList<TaskNode> taskNodeList = new ArrayList<TaskNode>();
        for (Map.Entry code : taskCodeMap.entrySet()) {
            TaskDefinitionLog taskDefinitionLog2 = taskDefinitionLogMap.get(code.getKey());
            if (taskDefinitionLog2 == null) continue;
            TaskNode taskNode = new TaskNode();
            taskNode.setCode(taskDefinitionLog2.getCode());
            taskNode.setVersion(taskDefinitionLog2.getVersion());
            taskNode.setName(taskDefinitionLog2.getName());
            taskNode.setDesc(taskDefinitionLog2.getDescription());
            taskNode.setType(taskDefinitionLog2.getTaskType().toUpperCase());
            taskNode.setRunFlag(taskDefinitionLog2.getFlag() == Flag.YES ? "NORMAL" : "FORBIDDEN");
            taskNode.setMaxRetryTimes(taskDefinitionLog2.getFailRetryTimes());
            taskNode.setRetryInterval(taskDefinitionLog2.getFailRetryInterval());
            taskNode.setParams(taskDefinitionLog2.getTaskParams());
            taskNode.setTaskInstancePriority(taskDefinitionLog2.getTaskPriority());
            taskNode.setWorkerGroup(taskDefinitionLog2.getWorkerGroup());
            taskNode.setEnvironmentCode(taskDefinitionLog2.getEnvironmentCode());
            taskNode.setTimeout(JSONUtils.toJsonString((Object)new TaskTimeoutParameter(taskDefinitionLog2.getTimeoutFlag() == TimeoutFlag.OPEN, taskDefinitionLog2.getTimeoutNotifyStrategy(), taskDefinitionLog2.getTimeout())));
            taskNode.setDelayTime(taskDefinitionLog2.getDelayTime());
            taskNode.setPreTasks(JSONUtils.toJsonString(((List)code.getValue()).stream().map(taskDefinitionLogMap::get).map(TaskDefinition::getCode).collect(Collectors.toList())));
            taskNode.setTaskGroupId(taskDefinitionLog2.getTaskGroupId());
            taskNode.setTaskGroupPriority(taskDefinitionLog2.getTaskGroupPriority());
            taskNode.setCpuQuota(taskDefinitionLog2.getCpuQuota());
            taskNode.setMemoryMax(taskDefinitionLog2.getMemoryMax());
            taskNode.setTaskExecuteType(taskDefinitionLog2.getTaskExecuteType());
            taskNodeList.add(taskNode);
        }
        return taskNodeList;
    }

    @Override
    public TaskGroupQueue insertIntoTaskGroupQueue(Integer taskInstanceId, String taskName, Integer taskGroupId, Integer workflowInstanceId, Integer taskGroupPriority, TaskGroupQueueStatus status) {
        Date now = new Date();
        TaskGroupQueue taskGroupQueue = TaskGroupQueue.builder().taskId(taskInstanceId.intValue()).taskName(taskName).groupId(taskGroupId.intValue()).workflowInstanceId(workflowInstanceId).priority(taskGroupPriority.intValue()).status(status).forceStart(Flag.NO.getCode()).inQueue(Flag.NO.getCode()).createTime(now).updateTime(now).build();
        this.taskGroupQueueMapper.insert((Object)taskGroupQueue);
        return taskGroupQueue;
    }

    @Override
    public String findConfigYamlByName(String clusterName) {
        if (Strings.isNullOrEmpty((String)clusterName)) {
            return null;
        }
        QueryWrapper nodeWrapper = new QueryWrapper();
        nodeWrapper.eq((Object)"name", (Object)clusterName);
        Cluster cluster = (Cluster)this.clusterMapper.selectOne((Wrapper)nodeWrapper);
        return cluster == null ? null : ClusterConfUtils.getK8sConfig(cluster.getConfig());
    }

    @Override
    public void forceWorkflowInstanceSuccessByTaskInstanceId(TaskInstance task) {
        List failTaskList;
        List<WorkflowTaskRelation> taskRelations;
        List taskDefinitionLogs;
        List definiteTaskCodeList;
        List validTaskList;
        List instanceTaskCodeList;
        WorkflowInstance workflowInstance = this.findWorkflowInstanceDetailById(task.getWorkflowInstanceId()).orElse(null);
        if (workflowInstance != null && (workflowInstance.getState().isFailure() || workflowInstance.getState().isStop()) && CollectionUtils.isEqualCollection(instanceTaskCodeList = (validTaskList = this.taskInstanceDao.queryValidTaskListByWorkflowInstanceId(workflowInstance.getId(), workflowInstance.getTestFlag())).stream().map(TaskInstance::getTaskCode).collect(Collectors.toList()), definiteTaskCodeList = (taskDefinitionLogs = this.taskDefinitionLogDao.queryTaskDefineLogList(taskRelations = this.findRelationByCode(workflowInstance.getWorkflowDefinitionCode(), workflowInstance.getWorkflowDefinitionVersion()))).stream().filter(definitionLog -> definitionLog.getFlag() == Flag.YES).map(TaskDefinition::getCode).collect(Collectors.toList())) && (failTaskList = validTaskList.stream().filter(instance -> instance.getState().isFailure() || instance.getState().isKill()).map(TaskInstance::getId).collect(Collectors.toList())).size() == 1 && failTaskList.contains(task.getId())) {
            workflowInstance.setStateWithDesc(WorkflowExecutionStatus.SUCCESS, "success by task force success");
            this.workflowInstanceDao.updateById((Object)workflowInstance);
        }
    }
}

