/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.TaskRecallCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskResponseEvent;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskResponseService;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRecallProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(TaskRecallProcessor.class);
    private final TaskResponseService taskResponseService = (TaskResponseService)SpringApplicationContext.getBean(TaskResponseService.class);

    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.TASK_RECALL == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type : %s", command.getType()));
        TaskRecallCommand recallCommand = (TaskRecallCommand)JSONUtils.parseObject((byte[])command.getBody(), TaskRecallCommand.class);
        this.logger.info("taskRecallCommand: {}, opaque: {}", (Object)recallCommand, (Object)command.getOpaque());
        TaskResponseEvent taskResponseEvent = TaskResponseEvent.newRecall(ExecutionStatus.of((int)recallCommand.getStatus()), recallCommand.getEvent(), recallCommand.getTaskInstanceId(), recallCommand.getProcessInstanceId(), channel, command.getOpaque());
        this.taskResponseService.addResponse(taskResponseEvent);
    }
}

