/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import org.apache.dolphinscheduler.common.enums.CacheType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.CacheExpireCommand;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class CacheProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(CacheProcessor.class);
    private CacheManager cacheManager;

    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.CACHE_EXPIRE == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type: %s", command.getType()));
        CacheExpireCommand cacheExpireCommand = (CacheExpireCommand)JSONUtils.parseObject((byte[])command.getBody(), CacheExpireCommand.class);
        this.logger.info("received command : {}", (Object)cacheExpireCommand);
        this.cacheExpire(cacheExpireCommand);
    }

    private void cacheExpire(CacheExpireCommand cacheExpireCommand) {
        if (this.cacheManager == null) {
            this.cacheManager = (CacheManager)SpringApplicationContext.getBean(CacheManager.class);
        }
        if (cacheExpireCommand.getCacheKey().isEmpty()) {
            return;
        }
        CacheType cacheType = cacheExpireCommand.getCacheType();
        Cache cache = this.cacheManager.getCache(cacheType.getCacheName());
        if (cache != null) {
            cache.evict((Object)cacheExpireCommand.getCacheKey());
            this.logger.info("cache evict, type:{}, key:{}", (Object)cacheType.getCacheName(), (Object)cacheExpireCommand.getCacheKey());
        }
    }
}

