/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.runner;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import org.apache.dolphinscheduler.common.enums.Event;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.TaskExecuteResponseCommand;
import org.apache.dolphinscheduler.server.worker.cache.ResponceCache;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.processor.TaskCallbackService;
import org.apache.dolphinscheduler.server.worker.runner.TaskExecuteThread;
import org.apache.dolphinscheduler.server.worker.runner.WorkerExecService;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.service.queue.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.spi.task.TaskExecutionContextCacheManager;
import org.apache.dolphinscheduler.spi.task.request.TaskRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkerManagerThread
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(WorkerManagerThread.class);
    private final DelayQueue<TaskExecuteThread> workerExecuteQueue = new DelayQueue();
    private final ConcurrentHashMap<Integer, TaskExecuteThread> taskExecuteThreadMap = new ConcurrentHashMap();
    private final WorkerConfig workerConfig = (WorkerConfig)SpringApplicationContext.getBean(WorkerConfig.class);
    private final WorkerExecService workerExecService = new WorkerExecService(ThreadUtils.newDaemonFixedThreadExecutor((String)"Worker-Execute-Thread", (int)this.workerConfig.getWorkerExecThreads()), this.taskExecuteThreadMap);
    private final TaskCallbackService taskCallbackService = (TaskCallbackService)SpringApplicationContext.getBean(TaskCallbackService.class);

    public TaskExecuteThread getTaskExecuteThread(Integer taskInstanceId) {
        return this.taskExecuteThreadMap.get(taskInstanceId);
    }

    public int getDelayQueueSize() {
        return this.workerExecuteQueue.size();
    }

    public int getThreadPoolQueueSize() {
        return this.workerExecService.getThreadPoolQueueSize();
    }

    public void killTaskBeforeExecuteByInstanceId(Integer taskInstanceId) {
        this.workerExecuteQueue.stream().filter(taskExecuteThread -> taskExecuteThread.getTaskExecutionContext().getTaskInstanceId() == taskInstanceId.intValue()).forEach(this.workerExecuteQueue::remove);
        this.sendTaskKillResponse(taskInstanceId);
    }

    private void sendTaskKillResponse(Integer taskInstanceId) {
        TaskRequest taskRequest = TaskExecutionContextCacheManager.getByTaskInstanceId((Integer)taskInstanceId);
        if (taskRequest == null) {
            return;
        }
        TaskExecutionContext taskExecutionContext = (TaskExecutionContext)JSONUtils.parseObject((String)JSONUtils.toJsonString((Object)taskRequest), TaskExecutionContext.class);
        TaskExecuteResponseCommand responseCommand = new TaskExecuteResponseCommand(taskExecutionContext.getTaskInstanceId(), taskExecutionContext.getProcessInstanceId());
        responseCommand.setStatus(ExecutionStatus.KILL.getCode());
        ResponceCache.get().cache(taskExecutionContext.getTaskInstanceId(), responseCommand.convert2Command(), Event.RESULT);
        this.taskCallbackService.sendResult(taskExecutionContext.getTaskInstanceId(), responseCommand.convert2Command());
    }

    public boolean offer(TaskExecuteThread taskExecuteThread) {
        return this.workerExecuteQueue.offer(taskExecuteThread);
    }

    public void start() {
        Thread thread = new Thread((Runnable)this, this.getClass().getName());
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Worker-Execute-Manager-Thread");
        while (Stopper.isRunning()) {
            try {
                TaskExecuteThread taskExecuteThread = (TaskExecuteThread)this.workerExecuteQueue.take();
                this.workerExecService.submit(taskExecuteThread);
            }
            catch (Exception e) {
                this.logger.error("An unexpected interrupt is happened, the exception will be ignored and this thread will continue to run", (Throwable)e);
            }
        }
    }
}

