/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.common.enums.Event;
import org.apache.dolphinscheduler.remote.command.Command;

public class ResponceCache {
    private static final ResponceCache instance = new ResponceCache();
    private Map<Integer, Command> ackCache = new ConcurrentHashMap<Integer, Command>();
    private Map<Integer, Command> responseCache = new ConcurrentHashMap<Integer, Command>();
    private final Map<Integer, Command> killResponseCache = new ConcurrentHashMap<Integer, Command>();

    private ResponceCache() {
    }

    public static ResponceCache get() {
        return instance;
    }

    public void cache(Integer taskInstanceId, Command command, Event event) {
        switch (event) {
            case ACK: {
                this.ackCache.put(taskInstanceId, command);
                break;
            }
            case RESULT: {
                this.responseCache.put(taskInstanceId, command);
                break;
            }
            case ACTION_STOP: {
                this.killResponseCache.put(taskInstanceId, command);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid event type : " + event);
            }
        }
    }

    public void removeAckCache(Integer taskInstanceId) {
        this.ackCache.remove(taskInstanceId);
    }

    public void removeKillResponseCache(Integer taskInstanceId) {
        this.killResponseCache.remove(taskInstanceId);
    }

    public Map<Integer, Command> getKillResponseCache() {
        return this.killResponseCache;
    }

    public void removeResponseCache(Integer taskInstanceId) {
        this.responseCache.remove(taskInstanceId);
    }

    public Map<Integer, Command> getAckCache() {
        return this.ackCache;
    }

    public Map<Integer, Command> getResponseCache() {
        return this.responseCache;
    }
}

