/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.TaskKillResponseCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskResponseEvent;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskResponseService;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThread;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskKillResponseProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(TaskKillResponseProcessor.class);
    private final TaskResponseService taskResponseService = (TaskResponseService)SpringApplicationContext.getBean(TaskResponseService.class);

    public void init(ConcurrentHashMap<Integer, WorkflowExecuteThread> processInstanceExecMaps) {
        this.taskResponseService.init(processInstanceExecMaps);
    }

    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.TASK_KILL_RESPONSE == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type : %s", command.getType()));
        TaskKillResponseCommand responseCommand = (TaskKillResponseCommand)JSONUtils.parseObject((byte[])command.getBody(), TaskKillResponseCommand.class);
        this.logger.info("received task kill response command : {}", (Object)responseCommand);
        TaskResponseEvent taskResponseEvent = TaskResponseEvent.newActionStop(ExecutionStatus.of((int)responseCommand.getStatus()), responseCommand.getTaskInstanceId(), responseCommand.getProcessInstanceId());
        this.taskResponseService.addResponse(taskResponseEvent);
    }
}

