/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.rpc.remote;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleStateEvent;
import java.lang.reflect.Method;
import lombok.Generated;
import org.apache.dolphinscheduler.rpc.common.RpcRequest;
import org.apache.dolphinscheduler.rpc.common.RpcResponse;
import org.apache.dolphinscheduler.rpc.common.ThreadPoolManager;
import org.apache.dolphinscheduler.rpc.config.ServiceBean;
import org.apache.dolphinscheduler.rpc.protocol.EventType;
import org.apache.dolphinscheduler.rpc.protocol.RpcProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServerHandler
extends ChannelInboundHandlerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NettyServerHandler.class);
    private static final ThreadPoolManager threadPoolManager = ThreadPoolManager.INSTANCE;

    public void channelInactive(ChannelHandlerContext ctx) {
        log.info("channel close");
        ctx.channel().close();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        log.info("client connect success !" + ctx.channel().remoteAddress());
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        RpcProtocol rpcProtocol = (RpcProtocol)msg;
        if (rpcProtocol.getMsgHeader().getEventType() == EventType.HEARTBEAT.getType().byteValue()) {
            log.info("heart beat");
            return;
        }
        threadPoolManager.addExecuteTask(() -> this.readHandler(ctx, rpcProtocol));
    }

    private void readHandler(ChannelHandlerContext ctx, RpcProtocol protocol) {
        RpcRequest req = (RpcRequest)protocol.getBody();
        RpcResponse response = new RpcResponse();
        response.setStatus((byte)0);
        String classname = req.getClassName();
        String methodName = req.getMethodName();
        Class<?>[] parameterTypes = req.getParameterTypes();
        Object[] arguments = req.getParameters();
        Object result = null;
        try {
            Class serviceClass = ServiceBean.getServiceClass(classname);
            Object object = serviceClass.newInstance();
            Method method = serviceClass.getMethod(methodName, parameterTypes);
            result = method.invoke(object, arguments);
        }
        catch (Exception e) {
            log.error("netty server execute error,service name :{} method name :{} ", (Object)(classname + methodName), (Object)e);
            response.setStatus((byte)-1);
        }
        response.setResult(result);
        protocol.setBody(response);
        protocol.getMsgHeader().setEventType(EventType.RESPONSE.getType());
        ctx.writeAndFlush((Object)protocol);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            log.debug("IdleStateEvent triggered, send heartbeat to channel " + ctx.channel());
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.error("exceptionCaught : {}", (Object)cause.getMessage(), (Object)cause);
        ctx.channel().close();
    }
}

