/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.remote.processor;

import io.netty.channel.Channel;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.LogUtils;
import org.apache.dolphinscheduler.remote.command.Message;
import org.apache.dolphinscheduler.remote.command.MessageType;
import org.apache.dolphinscheduler.remote.command.log.GetLogBytesRequest;
import org.apache.dolphinscheduler.remote.command.log.GetLogBytesResponse;
import org.apache.dolphinscheduler.remote.processor.BaseLogProcessor;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GetLogBytesProcessor
extends BaseLogProcessor
implements NettyRequestProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GetLogBytesProcessor.class);

    @Override
    public void process(Channel channel, Message message) {
        GetLogBytesRequest getLogRequest = (GetLogBytesRequest)JSONUtils.parseObject((byte[])message.getBody(), GetLogBytesRequest.class);
        String path = getLogRequest.getPath();
        byte[] bytes = LogUtils.getFileContentBytes((String)path);
        GetLogBytesResponse getLogResponse = new GetLogBytesResponse(bytes);
        channel.writeAndFlush((Object)getLogResponse.convert2Command(message.getOpaque()));
    }

    @Override
    public MessageType getCommandType() {
        return MessageType.GET_LOG_BYTES_REQUEST;
    }
}

