/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.remote.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.util.List;
import lombok.Generated;
import org.apache.dolphinscheduler.remote.command.Message;
import org.apache.dolphinscheduler.remote.command.MessageContext;
import org.apache.dolphinscheduler.remote.command.MessageHeader;
import org.apache.dolphinscheduler.remote.command.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyDecoder
extends ReplayingDecoder<State> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NettyDecoder.class);
    private final MessageHeader messageHeader = new MessageHeader();

    public NettyDecoder() {
        super((Object)State.MAGIC);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        switch ((State)((Object)this.state())) {
            case MAGIC: {
                this.checkMagic(in.readByte());
                this.checkpoint((Object)State.VERSION);
            }
            case VERSION: {
                this.checkVersion(in.readByte());
                this.checkpoint((Object)State.COMMAND);
            }
            case COMMAND: {
                this.messageHeader.setType(in.readByte());
                this.checkpoint((Object)State.OPAQUE);
            }
            case OPAQUE: {
                this.messageHeader.setOpaque(in.readLong());
                this.checkpoint((Object)State.CONTEXT_LENGTH);
            }
            case CONTEXT_LENGTH: {
                this.messageHeader.setContextLength(in.readInt());
                this.checkpoint((Object)State.CONTEXT);
            }
            case CONTEXT: {
                byte[] context = new byte[this.messageHeader.getContextLength()];
                in.readBytes(context);
                this.messageHeader.setContext(context);
                this.checkpoint((Object)State.BODY_LENGTH);
            }
            case BODY_LENGTH: {
                this.messageHeader.setBodyLength(in.readInt());
                this.checkpoint((Object)State.BODY);
            }
            case BODY: {
                byte[] body = new byte[this.messageHeader.getBodyLength()];
                in.readBytes(body);
                Message packet = new Message();
                packet.setType(this.commandType(this.messageHeader.getType()));
                packet.setOpaque(this.messageHeader.getOpaque());
                packet.setContext(MessageContext.valueOf(this.messageHeader.getContext()));
                packet.setBody(body);
                out.add(packet);
                this.checkpoint((Object)State.MAGIC);
                break;
            }
            default: {
                log.warn("unknown decoder state {}", this.state());
            }
        }
    }

    private MessageType commandType(byte type) {
        for (MessageType ct : MessageType.values()) {
            if (ct.ordinal() != type) continue;
            return ct;
        }
        return null;
    }

    private void checkMagic(byte magic) {
        if (magic != -66) {
            throw new IllegalArgumentException("illegal packet [magic]" + magic);
        }
    }

    private void checkVersion(byte version) {
        if (version != 0) {
            throw new IllegalArgumentException("illegal protocol [version]" + version);
        }
    }

    static enum State {
        MAGIC,
        VERSION,
        COMMAND,
        OPAQUE,
        CONTEXT_LENGTH,
        CONTEXT,
        BODY_LENGTH,
        BODY;

    }
}

