/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.microbench.common;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.dolphinscheduler.microbench.base.AbstractBaseBenchmark;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@Warmup(iterations=2, time=1)
@Measurement(iterations=4, time=1)
@State(value=Scope.Benchmark)
public class EnumBenchMark
extends AbstractBaseBenchmark {
    @Param(value={"101", "108", "103", "104", "105", "103"})
    private int testNum;

    @Benchmark
    public boolean simpleTest() {
        return Boolean.TRUE;
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void enumValuesTest() {
        TestTypeEnum.oldGetNameByType(this.testNum);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void enumStaticMapTest() {
        TestTypeEnum.newGetNameByType(this.testNum);
    }

    public static enum TestTypeEnum {
        TYPE_101(101, "TYPE101"),
        TYPE_102(102, "TYPE102"),
        TYPE_103(103, "TYPE103"),
        TYPE_104(104, "TYPE104"),
        TYPE_105(105, "TYPE105"),
        TYPE_106(106, "TYPE106"),
        TYPE_107(107, "TYPE107"),
        TYPE_108(108, "TYPE108");

        private int code;
        private String name;
        private static final Map<Integer, TestTypeEnum> TEST_TYPE_MAP;

        public int getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        private TestTypeEnum(int code, String name) {
            this.code = code;
            this.name = name;
        }

        public static void newGetNameByType(int code) {
            if (TEST_TYPE_MAP.containsKey(code)) {
                TEST_TYPE_MAP.get(code);
                return;
            }
            throw new IllegalArgumentException("invalid code : " + code);
        }

        public static void oldGetNameByType(int code) {
            for (TestTypeEnum testTypeEnum : TestTypeEnum.values()) {
                if (testTypeEnum.getCode() != code) continue;
                return;
            }
            throw new IllegalArgumentException("invalid code : " + code);
        }

        static {
            TEST_TYPE_MAP = new HashMap<Integer, TestTypeEnum>();
            for (TestTypeEnum testTypeEnum : TestTypeEnum.values()) {
                TEST_TYPE_MAP.put(testTypeEnum.code, testTypeEnum);
            }
        }
    }
}

