/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.cluster;

import lombok.Generated;
import org.apache.dolphinscheduler.registry.api.Event;
import org.apache.dolphinscheduler.registry.api.SubscribeListener;
import org.apache.dolphinscheduler.server.master.cluster.BaseServerMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClusterSubscribeListener<T extends BaseServerMetadata>
implements SubscribeListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractClusterSubscribeListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(Event event) {
        try {
            AbstractClusterSubscribeListener abstractClusterSubscribeListener = this;
            synchronized (abstractClusterSubscribeListener) {
                Event.Type type = event.getType();
                T server = this.parseServerFromHeartbeat(event.getEventData());
                if (server == null) {
                    log.error("Unknown cluster change event: {}", (Object)event);
                    return;
                }
                switch (type) {
                    case ADD: {
                        log.info("Server {} added", server);
                        this.onServerAdded(server);
                        break;
                    }
                    case REMOVE: {
                        log.warn("Server {} removed", server);
                        this.onServerRemove(server);
                        break;
                    }
                    case UPDATE: {
                        log.debug("Server {} updated", server);
                        this.onServerUpdate(server);
                        break;
                    }
                }
            }
        }
        catch (Exception ex) {
            log.error("Notify cluster change event: {} failed", (Object)event, (Object)ex);
        }
    }

    public SubscribeListener.SubscribeScope getSubscribeScope() {
        return SubscribeListener.SubscribeScope.CHILDREN_ONLY;
    }

    abstract T parseServerFromHeartbeat(String var1);

    public abstract void onServerAdded(T var1);

    public abstract void onServerRemove(T var1);

    public abstract void onServerUpdate(T var1);
}

