/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.utils;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.TaskExecuteType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionDao;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionLogDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependResult;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependentRelation;
import org.apache.dolphinscheduler.plugin.task.api.enums.Direct;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.model.DateInterval;
import org.apache.dolphinscheduler.plugin.task.api.model.DependentItem;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.parameters.DependentParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.DependentUtils;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependentExecute {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DependentExecute.class);
    private final WorkflowInstanceDao workflowInstanceDao = (WorkflowInstanceDao)SpringApplicationContext.getBean(WorkflowInstanceDao.class);
    private final TaskInstanceDao taskInstanceDao = (TaskInstanceDao)SpringApplicationContext.getBean(TaskInstanceDao.class);
    private List<DependentItem> dependItemList;
    private DependentRelation relation;
    private WorkflowInstance workflowInstance;
    private TaskInstance taskInstance;
    private Map<String, DependResult> dependResultMap = new HashMap<String, DependResult>();
    private final ProcessService processService = (ProcessService)SpringApplicationContext.getBean(ProcessService.class);
    private final TaskDefinitionLogDao taskDefinitionLogDao = (TaskDefinitionLogDao)SpringApplicationContext.getBean(TaskDefinitionLogDao.class);
    private final TaskDefinitionDao taskDefinitionDao = (TaskDefinitionDao)SpringApplicationContext.getBean(TaskDefinitionDao.class);
    private Map<String, Property> dependTaskVarPoolPropertyMap = new HashMap<String, Property>();
    private Map<String, Long> dependTaskVarPoolEndTimeMap = new HashMap<String, Long>();
    private Map<String, Property> dependItemVarPoolPropertyMap = new HashMap<String, Property>();
    private Map<String, Long> dependItemVarPoolEndTimeMap = new HashMap<String, Long>();

    public DependentExecute(List<DependentItem> itemList, DependentRelation relation, WorkflowInstance workflowInstance, TaskInstance taskInstance) {
        this.dependItemList = itemList;
        this.relation = relation;
        this.workflowInstance = workflowInstance;
        this.taskInstance = taskInstance;
    }

    private DependResult getDependentResultForItem(DependentItem dependentItem, Date currentTime) {
        List dateIntervals = DependentUtils.getDateIntervalList((Date)currentTime, (String)dependentItem.getDateValue());
        return this.calculateResultForTasks(dependentItem, dateIntervals);
    }

    private DependResult calculateResultForTasks(DependentItem dependentItem, List<DateInterval> dateIntervals) {
        DependResult result = DependResult.FAILED;
        for (DateInterval dateInterval : dateIntervals) {
            WorkflowInstance workflowInstance = this.findDependentWorkflowCandidate(dependentItem.getDefinitionCode(), dependentItem.getDepTaskCode(), dateInterval);
            if (workflowInstance == null) {
                return DependResult.WAITING;
            }
            result = dependentItem.getDepTaskCode() == 0L ? this.dependResultByWorkflowInstance(workflowInstance) : (dependentItem.getDepTaskCode() == -1L ? this.dependResultByAllTaskOfWorkflowInstance(workflowInstance) : this.dependResultBySingleTaskInstance(workflowInstance, dependentItem.getDepTaskCode()));
            if (result == DependResult.SUCCESS) continue;
            break;
        }
        return result;
    }

    private DependResult dependResultByWorkflowInstance(WorkflowInstance workflowInstance) {
        if (!workflowInstance.getState().isFinished()) {
            return DependResult.WAITING;
        }
        if (workflowInstance.getState().isSuccess()) {
            this.addItemVarPool(workflowInstance.getVarPool(), workflowInstance.getEndTime().getTime());
            return DependResult.SUCCESS;
        }
        log.warn("The dependent workflow did not execute successfully, so return depend failed. workflowDefinitionCode: {}, workflowInstanceName: {}", (Object)workflowInstance.getWorkflowDefinitionCode(), (Object)workflowInstance.getName());
        return DependResult.FAILED;
    }

    private DependResult dependResultByAllTaskOfWorkflowInstance(WorkflowInstance workflowInstance) {
        if (!workflowInstance.getState().isFinished()) {
            log.info("Wait for the dependent workflow to complete, workflowDefinitionCode: {}, pworkflowInstanceId: {}.", (Object)workflowInstance.getWorkflowDefinitionCode(), (Object)workflowInstance.getId());
            return DependResult.WAITING;
        }
        if (workflowInstance.getState().isSuccess()) {
            List workflowTaskRelations = this.processService.findRelationByCode(workflowInstance.getWorkflowDefinitionCode().longValue(), workflowInstance.getWorkflowDefinitionVersion());
            List taskDefinitionLogs = this.taskDefinitionLogDao.queryTaskDefineLogList(workflowTaskRelations);
            Map<Long, String> taskDefinitionCodeMap = taskDefinitionLogs.stream().filter(taskDefinitionLog -> taskDefinitionLog.getFlag() == Flag.YES).collect(Collectors.toMap(TaskDefinition::getCode, TaskDefinition::getName));
            List taskInstanceList = this.taskInstanceDao.queryLastTaskInstanceListIntervalInWorkflowInstance(workflowInstance.getId(), taskDefinitionCodeMap.keySet());
            Map<Long, TaskExecutionStatus> taskExecutionStatusMap = taskInstanceList.stream().filter(taskInstance -> taskInstance.getTaskExecuteType() != TaskExecuteType.STREAM).collect(Collectors.toMap(TaskInstance::getTaskCode, TaskInstance::getState));
            for (Long taskCode : taskDefinitionCodeMap.keySet()) {
                if (!taskExecutionStatusMap.containsKey(taskCode)) {
                    log.warn("The task of the workflow is not being executed, taskCode: {}, workflowInstanceId: {}, workflowInstanceName: {}.", new Object[]{taskCode, workflowInstance.getWorkflowDefinitionCode(), workflowInstance.getName()});
                    return DependResult.FAILED;
                }
                if (taskExecutionStatusMap.get(taskCode).isSuccess()) continue;
                log.warn("The task of the workflow is not being executed successfully, taskCode: {}, workflowInstanceId: {}, workflowInstanceName: {}.", new Object[]{taskCode, workflowInstance.getWorkflowDefinitionCode(), workflowInstance.getName()});
                return DependResult.FAILED;
            }
            this.addItemVarPool(workflowInstance.getVarPool(), workflowInstance.getEndTime().getTime());
            return DependResult.SUCCESS;
        }
        return DependResult.FAILED;
    }

    private DependResult dependResultBySingleTaskInstance(WorkflowInstance workflowInstance, long depTaskCode) {
        TaskInstance taskInstance = this.taskInstanceDao.queryLastTaskInstanceIntervalInWorkflowInstance(workflowInstance.getId(), depTaskCode);
        if (taskInstance == null) {
            TaskDefinition taskDefinition = this.taskDefinitionDao.queryByCode(depTaskCode);
            if (taskDefinition == null) {
                log.error("The dependent task definition can not be find, so return depend failed, taskCode: {}", (Object)depTaskCode);
                return DependResult.FAILED;
            }
            if (taskDefinition.getFlag() == Flag.NO) {
                log.info("The dependent task is a forbidden task, so return depend success. Task code: {}, task name: {}", (Object)taskDefinition.getCode(), (Object)taskDefinition.getName());
                return DependResult.SUCCESS;
            }
            if (!workflowInstance.getState().isFinished()) {
                log.info("Wait for the dependent workflow to complete, workflowDefinitionCode: {}, workflowInstanceId: {}.", (Object)workflowInstance.getWorkflowDefinitionCode(), (Object)workflowInstance.getId());
                return DependResult.WAITING;
            }
            return DependResult.FAILED;
        }
        if (TaskExecuteType.STREAM == taskInstance.getTaskExecuteType()) {
            log.info("The dependent task is a streaming task, so return depend success. Task code: {}, task name: {}.", (Object)taskInstance.getTaskCode(), (Object)taskInstance.getName());
            this.addItemVarPool(taskInstance.getVarPool(), taskInstance.getEndTime().getTime());
            return DependResult.SUCCESS;
        }
        return this.getDependResultOfTask(workflowInstance, taskInstance);
    }

    private void addItemVarPool(String varPoolStr, Long endTime) {
        ArrayList varPool = new ArrayList(JSONUtils.toList((String)varPoolStr, Property.class));
        if (!varPool.isEmpty()) {
            Map varPoolPropertyMap = varPool.stream().filter(p -> p.getDirect().equals((Object)Direct.OUT)).collect(Collectors.toMap(Property::getProp, Function.identity()));
            Map<String, Long> varPoolEndTimeMap = varPool.stream().filter(p -> p.getDirect().equals((Object)Direct.OUT)).collect(Collectors.toMap(Property::getProp, d -> endTime));
            this.dependItemVarPoolPropertyMap.putAll(varPoolPropertyMap);
            this.dependItemVarPoolEndTimeMap.putAll(varPoolEndTimeMap);
        }
    }

    private WorkflowInstance findDependentWorkflowCandidate(Long definitionCode, Long taskCode, DateInterval dateInterval) {
        WorkflowInstance runningWorkflow = this.workflowInstanceDao.queryLastRunningWorkflowInterval(definitionCode, dateInterval);
        if (runningWorkflow != null) {
            return runningWorkflow;
        }
        WorkflowInstance lastSchedulerWorkflowInstance = this.workflowInstanceDao.queryLastSchedulerWorkflowInterval(definitionCode, taskCode, dateInterval);
        WorkflowInstance lastManualWorkflowInstance = this.workflowInstanceDao.queryLastManualWorkflowInterval(definitionCode, taskCode, dateInterval);
        if (lastManualWorkflowInstance == null) {
            return lastSchedulerWorkflowInstance;
        }
        if (lastSchedulerWorkflowInstance == null) {
            return lastManualWorkflowInstance;
        }
        return lastManualWorkflowInstance.getId() > lastSchedulerWorkflowInstance.getId() ? lastManualWorkflowInstance : lastSchedulerWorkflowInstance;
    }

    private DependResult getDependResultOfTask(WorkflowInstance workflowInstance, TaskInstance taskInstance) {
        TaskExecutionStatus state = taskInstance.getState();
        if (!state.isFinished()) {
            return DependResult.WAITING;
        }
        if (state.isSuccess()) {
            return DependResult.SUCCESS;
        }
        if (workflowInstance.getState().isRunning() && taskInstance.getRetryTimes() < taskInstance.getMaxRetryTimes()) {
            log.info("taskDefinitionCode: {}, taskDefinitionName: {}, retryTimes: {}, maxRetryTimes: {}", new Object[]{taskInstance.getTaskCode(), taskInstance.getName(), taskInstance.getRetryTimes(), taskInstance.getMaxRetryTimes()});
            return DependResult.WAITING;
        }
        log.warn("The dependent task were not executed successfully, so return depend failed. Task code: {}, task name: {}.", (Object)taskInstance.getTaskCode(), (Object)taskInstance.getName());
        return DependResult.FAILED;
    }

    public boolean finish(Date currentTime, DependentParameters.DependentFailurePolicyEnum failurePolicy, Integer failureWaitingTime) {
        DependResult modelDependResult = this.getModelDependResult(currentTime);
        if (modelDependResult == DependResult.WAITING) {
            return false;
        }
        if (modelDependResult == DependResult.FAILED && DependentParameters.DependentFailurePolicyEnum.DEPENDENT_FAILURE_WAITING == failurePolicy && failureWaitingTime != null) {
            return Duration.between(currentTime.toInstant(), Instant.now()).compareTo(Duration.ofMinutes(failureWaitingTime.intValue())) > 0;
        }
        return true;
    }

    public DependResult getModelDependResult(Date currentTime) {
        ArrayList<DependResult> dependResultList = new ArrayList<DependResult>();
        for (DependentItem dependentItem : this.dependItemList) {
            if (this.isSelfDependent(dependentItem) && this.isFirstWorkflowInstance(dependentItem)) {
                this.dependResultMap.put(dependentItem.getKey(), DependResult.SUCCESS);
                dependResultList.add(DependResult.SUCCESS);
                log.info("This dependent item is self-dependent and run at first time, default success, workflowDefinitionCode:{}, depTaskCode:{}", (Object)dependentItem.getDefinitionCode(), (Object)dependentItem.getDepTaskCode());
                continue;
            }
            DependResult dependResult = this.getDependResultForItem(dependentItem, currentTime);
            if (dependResult != DependResult.WAITING) {
                this.dependResultMap.put(dependentItem.getKey(), dependResult);
                if (dependentItem.getParameterPassing().booleanValue() && !this.dependItemVarPoolPropertyMap.isEmpty()) {
                    DependentUtils.addTaskVarPool(this.dependItemVarPoolPropertyMap, this.dependItemVarPoolEndTimeMap, this.dependTaskVarPoolPropertyMap, this.dependTaskVarPoolEndTimeMap);
                }
            }
            this.dependItemVarPoolPropertyMap.clear();
            this.dependItemVarPoolEndTimeMap.clear();
            dependResultList.add(dependResult);
        }
        return DependentUtils.getDependResultForRelation((DependentRelation)this.relation, dependResultList);
    }

    private DependResult getDependResultForItem(DependentItem item, Date currentTime) {
        String key = item.getKey();
        if (this.dependResultMap.containsKey(key)) {
            return this.dependResultMap.get(key);
        }
        return this.getDependentResultForItem(item, currentTime);
    }

    public boolean isSelfDependent(DependentItem dependentItem) {
        if (this.workflowInstance.getWorkflowDefinitionCode().equals(dependentItem.getDefinitionCode())) {
            if (dependentItem.getDepTaskCode() == -1L) {
                return true;
            }
            if (dependentItem.getDepTaskCode() == this.taskInstance.getTaskCode()) {
                return true;
            }
        }
        return false;
    }

    public boolean isFirstWorkflowInstance(DependentItem dependentItem) {
        WorkflowInstance firstWorkflowInstance = this.workflowInstanceDao.queryFirstScheduleWorkflowInstance(Long.valueOf(dependentItem.getDefinitionCode()));
        if (firstWorkflowInstance == null && (firstWorkflowInstance = this.workflowInstanceDao.queryFirstStartWorkflowInstance(Long.valueOf(dependentItem.getDefinitionCode()))) == null) {
            log.warn("First workflow instance is null, workflowDefinitionCode: {}", (Object)dependentItem.getDefinitionCode());
            return false;
        }
        return Objects.equals(firstWorkflowInstance.getId(), this.workflowInstance.getId());
    }

    @Generated
    public Map<String, DependResult> getDependResultMap() {
        return this.dependResultMap;
    }

    @Generated
    public Map<String, Property> getDependTaskVarPoolPropertyMap() {
        return this.dependTaskVarPoolPropertyMap;
    }

    @Generated
    public Map<String, Long> getDependTaskVarPoolEndTimeMap() {
        return this.dependTaskVarPoolEndTimeMap;
    }
}

