/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.workflow.statemachine;

import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.server.master.engine.WorkflowEventBus;
import org.apache.dolphinscheduler.server.master.engine.graph.IWorkflowExecutionGraph;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowFailedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowFinalizeLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowPauseLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowPausedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowStartLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowStopLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowStoppedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowSucceedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowTopologyLogicalTransitionWithTaskFinishLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.workflow.statemachine.AbstractWorkflowStateAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkflowReadyPauseStateAction
extends AbstractWorkflowStateAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowReadyPauseStateAction.class);

    @Override
    public void startEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowStartLifecycleEvent workflowStartEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        IWorkflowExecutionGraph workflowExecutionGraph = workflowExecutionRunnable.getWorkflowExecuteContext().getWorkflowExecutionGraph();
        this.triggerTasks(workflowExecutionRunnable, workflowExecutionGraph.getStartNodes());
    }

    @Override
    public void topologyLogicalTransitionEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowTopologyLogicalTransitionWithTaskFinishLifecycleEvent workflowTopologyLogicalTransitionWithTaskFinishEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        super.tryToTriggerSuccessorsAfterTaskFinish(workflowExecutionRunnable, workflowTopologyLogicalTransitionWithTaskFinishEvent.getTaskExecutionRunnable());
    }

    @Override
    public void pauseEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowPauseLifecycleEvent workflowPauseEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        this.logWarningIfCannotDoAction(workflowExecutionRunnable, workflowPauseEvent);
    }

    @Override
    public void pausedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowPausedLifecycleEvent workflowPausedEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        this.workflowFinish(workflowExecutionRunnable, WorkflowExecutionStatus.PAUSE);
    }

    @Override
    public void stopEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowStopLifecycleEvent workflowStopEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        this.logWarningIfCannotDoAction(workflowExecutionRunnable, workflowStopEvent);
    }

    @Override
    public void stoppedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowStoppedLifecycleEvent workflowStoppedEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        this.logWarningIfCannotDoAction(workflowExecutionRunnable, workflowStoppedEvent);
    }

    @Override
    public void succeedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowSucceedLifecycleEvent workflowSucceedEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        super.workflowFinish(workflowExecutionRunnable, WorkflowExecutionStatus.SUCCESS);
    }

    @Override
    public void failedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowFailedLifecycleEvent workflowFailedEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        super.workflowFinish(workflowExecutionRunnable, WorkflowExecutionStatus.FAILURE);
    }

    @Override
    public void finalizeEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowFinalizeLifecycleEvent workflowFinalizeEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        this.logWarningIfCannotDoAction(workflowExecutionRunnable, workflowFinalizeEvent);
    }

    @Override
    public WorkflowExecutionStatus matchState() {
        return WorkflowExecutionStatus.READY_PAUSE;
    }

    @Override
    protected void emitWorkflowFinishedEventIfApplicable(IWorkflowExecutionRunnable workflowExecutionRunnable) {
        IWorkflowExecutionGraph workflowExecutionGraph = workflowExecutionRunnable.getWorkflowExecutionGraph();
        if (!workflowExecutionGraph.isAllTaskExecutionRunnableChainFinish()) {
            log.debug("There exist task which is not finish, don't need to emit workflow finished event");
            return;
        }
        WorkflowEventBus workflowEventBus = workflowExecutionRunnable.getWorkflowEventBus();
        if (workflowExecutionGraph.isExistFailureTaskExecutionRunnableChain()) {
            workflowEventBus.publish(WorkflowFailedLifecycleEvent.of(workflowExecutionRunnable));
            return;
        }
        if (workflowExecutionGraph.isExistPauseTaskExecutionRunnableChain()) {
            workflowEventBus.publish(WorkflowPausedLifecycleEvent.of(workflowExecutionRunnable));
            return;
        }
        if (workflowExecutionGraph.isAllTaskExecutionRunnableChainSuccess()) {
            workflowEventBus.publish(WorkflowSucceedLifecycleEvent.of(workflowExecutionRunnable));
            return;
        }
        throw new IllegalStateException("The workflow: " + workflowExecutionRunnable.getName() + " state is " + workflowExecutionRunnable.getState() + " can only finish with success/failed/paused but exist task chain which state is not success/failure/pause");
    }
}

