/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.task.runnable;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.plugin.task.api.K8sTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.ResourceParametersHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutionContextBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskExecutionContextBuilder.class);
    private final TaskExecutionContext taskExecutionContext = new TaskExecutionContext();

    public static TaskExecutionContextBuilder get() {
        return new TaskExecutionContextBuilder();
    }

    public TaskExecutionContextBuilder buildTaskInstanceRelatedInfo(TaskInstance taskInstance) {
        this.taskExecutionContext.setTaskInstanceId(taskInstance.getId().intValue());
        this.taskExecutionContext.setTaskName(taskInstance.getName());
        this.taskExecutionContext.setFirstSubmitTime(DateUtils.dateToTimeStamp((Date)taskInstance.getFirstSubmitTime()));
        this.taskExecutionContext.setStartTime(DateUtils.dateToTimeStamp((Date)taskInstance.getStartTime()));
        this.taskExecutionContext.setTaskType(taskInstance.getTaskType());
        this.taskExecutionContext.setLogPath(taskInstance.getLogPath());
        this.taskExecutionContext.setWorkerGroup(taskInstance.getWorkerGroup());
        this.taskExecutionContext.setHost(taskInstance.getHost());
        this.taskExecutionContext.setVarPool(taskInstance.getVarPool());
        this.taskExecutionContext.setDryRun(taskInstance.getDryRun());
        this.taskExecutionContext.setTestFlag(taskInstance.getTestFlag());
        this.taskExecutionContext.setCpuQuota(taskInstance.getCpuQuota());
        this.taskExecutionContext.setMemoryMax(taskInstance.getMemoryMax());
        this.taskExecutionContext.setAppIds(taskInstance.getAppLink());
        return this;
    }

    public TaskExecutionContextBuilder buildTaskDefinitionRelatedInfo(TaskDefinition taskDefinition) {
        this.taskExecutionContext.setTaskTimeout(Integer.MAX_VALUE);
        if (taskDefinition.getTimeoutFlag() == TimeoutFlag.OPEN) {
            this.taskExecutionContext.setTaskTimeoutStrategy(taskDefinition.getTimeoutNotifyStrategy());
            if (taskDefinition.getTimeoutNotifyStrategy() == TaskTimeoutStrategy.FAILED || taskDefinition.getTimeoutNotifyStrategy() == TaskTimeoutStrategy.WARNFAILED) {
                this.taskExecutionContext.setTaskTimeout((int)Math.min(TimeUnit.MINUTES.toSeconds(taskDefinition.getTimeout()), Integer.MAX_VALUE));
            }
        }
        this.taskExecutionContext.setTaskParams(taskDefinition.getTaskParams());
        return this;
    }

    public TaskExecutionContextBuilder buildProcessInstanceRelatedInfo(WorkflowInstance workflowInstance) {
        this.taskExecutionContext.setWorkflowInstanceId(workflowInstance.getId().intValue());
        this.taskExecutionContext.setScheduleTime(DateUtils.dateToTimeStamp((Date)workflowInstance.getScheduleTime()));
        this.taskExecutionContext.setGlobalParams(workflowInstance.getGlobalParams());
        this.taskExecutionContext.setExecutorId(workflowInstance.getExecutorId());
        this.taskExecutionContext.setCmdTypeIfComplement(workflowInstance.getCmdTypeIfComplement().getCode());
        this.taskExecutionContext.setTenantCode(workflowInstance.getTenantCode());
        this.taskExecutionContext.setWorkflowDefinitionCode(workflowInstance.getWorkflowDefinitionCode());
        this.taskExecutionContext.setWorkflowDefinitionVersion(workflowInstance.getWorkflowDefinitionVersion());
        this.taskExecutionContext.setProjectCode(workflowInstance.getProjectCode().longValue());
        return this;
    }

    public TaskExecutionContextBuilder buildResourceParameters(ResourceParametersHelper parametersHelper) {
        this.taskExecutionContext.setResourceParametersHelper(parametersHelper);
        return this;
    }

    public TaskExecutionContextBuilder buildK8sTaskRelatedInfo(K8sTaskExecutionContext k8sTaskExecutionContext) {
        this.taskExecutionContext.setK8sTaskExecutionContext(k8sTaskExecutionContext);
        return this;
    }

    public TaskExecutionContextBuilder buildPrepareParams(Map<String, Property> propertyMap) {
        this.taskExecutionContext.setPrepareParamsMap(propertyMap);
        return this;
    }

    public TaskExecutionContextBuilder buildBusinessParams(Map<String, Property> businessParamsMap) {
        this.taskExecutionContext.setParamsMap(businessParamsMap);
        return this;
    }

    public TaskExecutionContextBuilder buildWorkflowInstanceHost(String masterHost) {
        this.taskExecutionContext.setWorkflowInstanceHost(masterHost);
        return this;
    }

    public TaskExecutionContextBuilder buildEnvironmentConfig(String environmentConfig) {
        this.taskExecutionContext.setEnvironmentConfig(environmentConfig);
        return this;
    }

    public TaskExecutionContext create() {
        Preconditions.checkNotNull((Object)this.taskExecutionContext.getWorkflowInstanceHost(), (Object)"The workflow instance host cannot be empty");
        return this.taskExecutionContext;
    }
}

