/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.extract.master;

import lombok.Generated;
import org.apache.dolphinscheduler.extract.base.client.Clients;
import org.apache.dolphinscheduler.extract.master.ITaskExecutorEventListener;
import org.apache.dolphinscheduler.task.executor.eventbus.ITaskExecutorEventRemoteReporterClient;
import org.apache.dolphinscheduler.task.executor.events.IReportableTaskExecutorLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorDispatchedLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorFailedLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorKilledLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorPausedLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorRuntimeContextChangedLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorStartedLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorSuccessLifecycleEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutorEventRemoteReporterClient
implements ITaskExecutorEventRemoteReporterClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskExecutorEventRemoteReporterClient.class);

    public void reportTaskExecutionEventToMaster(IReportableTaskExecutorLifecycleEvent taskExecutorLifecycleEvent) {
        try {
            taskExecutorLifecycleEvent.setLatestReportTime(Long.valueOf(System.currentTimeMillis()));
            switch (taskExecutorLifecycleEvent.getType()) {
                case DISPATCHED: {
                    TaskExecutorEventRemoteReporterClient.reportTaskDispatchedEventToMaster((TaskExecutorDispatchedLifecycleEvent)taskExecutorLifecycleEvent);
                    break;
                }
                case RUNNING: {
                    TaskExecutorEventRemoteReporterClient.reportTaskRunningEventToMaster((TaskExecutorStartedLifecycleEvent)taskExecutorLifecycleEvent);
                    break;
                }
                case RUNTIME_CONTEXT_CHANGE: {
                    TaskExecutorEventRemoteReporterClient.reportTaskRuntimeContextChangeEventToMaster((TaskExecutorRuntimeContextChangedLifecycleEvent)taskExecutorLifecycleEvent);
                    break;
                }
                case PAUSED: {
                    TaskExecutorEventRemoteReporterClient.reportTaskPausedEventToMaster((TaskExecutorPausedLifecycleEvent)taskExecutorLifecycleEvent);
                    break;
                }
                case KILLED: {
                    TaskExecutorEventRemoteReporterClient.reportTaskKilledEventToMaster((TaskExecutorKilledLifecycleEvent)taskExecutorLifecycleEvent);
                    break;
                }
                case FAILED: {
                    TaskExecutorEventRemoteReporterClient.reportTaskFailedEventToMaster((TaskExecutorFailedLifecycleEvent)taskExecutorLifecycleEvent);
                    break;
                }
                case SUCCESS: {
                    TaskExecutorEventRemoteReporterClient.reportTaskSuccessEventToMaster((TaskExecutorSuccessLifecycleEvent)taskExecutorLifecycleEvent);
                    break;
                }
                default: {
                    log.warn("Unsupported TaskExecutionEvent: {}", (Object)taskExecutorLifecycleEvent);
                }
            }
            log.info("Report: {} to master success", (Object)taskExecutorLifecycleEvent);
        }
        catch (Throwable throwable) {
            log.error("Report ITaskExecutorLifecycleEvent: {} to master failed", (Object)taskExecutorLifecycleEvent, (Object)throwable);
        }
    }

    private static void reportTaskDispatchedEventToMaster(TaskExecutorDispatchedLifecycleEvent taskExecutionDispatchedEvent) {
        ((ITaskExecutorEventListener)Clients.withService(ITaskExecutorEventListener.class).withHost(taskExecutionDispatchedEvent.getWorkflowInstanceHost())).onTaskExecutorDispatched(taskExecutionDispatchedEvent);
    }

    private static void reportTaskRunningEventToMaster(TaskExecutorStartedLifecycleEvent taskExecutionRunningEvent) {
        ((ITaskExecutorEventListener)Clients.withService(ITaskExecutorEventListener.class).withHost(taskExecutionRunningEvent.getWorkflowInstanceHost())).onTaskExecutorRunning(taskExecutionRunningEvent);
    }

    private static void reportTaskRuntimeContextChangeEventToMaster(TaskExecutorRuntimeContextChangedLifecycleEvent taskExecutorLifecycleEvent) {
        ((ITaskExecutorEventListener)Clients.withService(ITaskExecutorEventListener.class).withHost(taskExecutorLifecycleEvent.getWorkflowInstanceHost())).onTaskExecutorRuntimeContextChanged(taskExecutorLifecycleEvent);
    }

    private static void reportTaskPausedEventToMaster(TaskExecutorPausedLifecycleEvent taskExecutionPausedEvent) {
        ((ITaskExecutorEventListener)Clients.withService(ITaskExecutorEventListener.class).withHost(taskExecutionPausedEvent.getWorkflowInstanceHost())).onTaskExecutorPaused(taskExecutionPausedEvent);
    }

    private static void reportTaskKilledEventToMaster(TaskExecutorKilledLifecycleEvent taskExecutionKilledEvent) {
        ((ITaskExecutorEventListener)Clients.withService(ITaskExecutorEventListener.class).withHost(taskExecutionKilledEvent.getWorkflowInstanceHost())).onTaskExecutorKilled(taskExecutionKilledEvent);
    }

    private static void reportTaskFailedEventToMaster(TaskExecutorFailedLifecycleEvent taskExecutionFailedEvent) {
        ((ITaskExecutorEventListener)Clients.withService(ITaskExecutorEventListener.class).withHost(taskExecutionFailedEvent.getWorkflowInstanceHost())).onTaskExecutorFailed(taskExecutionFailedEvent);
    }

    private static void reportTaskSuccessEventToMaster(TaskExecutorSuccessLifecycleEvent taskExecutionSuccessEvent) {
        ((ITaskExecutorEventListener)Clients.withService(ITaskExecutorEventListener.class).withHost(taskExecutionSuccessEvent.getWorkflowInstanceHost())).onTaskExecutorSuccess(taskExecutionSuccessEvent);
    }
}

