/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.postgresql.param;

import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.postgresql.param.PostgreSQLConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.postgresql.param.PostgreSQLDataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;

@AutoService(value={DataSourceProcessor.class})
public class PostgreSQLDataSourceProcessor
extends AbstractDataSourceProcessor {
    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, PostgreSQLDataSourceParamDTO.class);
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        PostgreSQLConnectionParam connectionParams = (PostgreSQLConnectionParam)this.createConnectionParams(connectionJson);
        PostgreSQLDataSourceParamDTO postgreSqlDatasourceParamDTO = new PostgreSQLDataSourceParamDTO();
        postgreSqlDatasourceParamDTO.setDatabase(connectionParams.getDatabase());
        postgreSqlDatasourceParamDTO.setUserName(connectionParams.getUser());
        postgreSqlDatasourceParamDTO.setOther(connectionParams.getOther());
        String address = connectionParams.getAddress();
        String[] hostSeperator = address.split("//");
        String[] hostPortArray = hostSeperator[hostSeperator.length - 1].split(",");
        postgreSqlDatasourceParamDTO.setHost(hostPortArray[0].split(":")[0]);
        postgreSqlDatasourceParamDTO.setPort(Integer.parseInt(hostPortArray[0].split(":")[1]));
        return postgreSqlDatasourceParamDTO;
    }

    public BaseConnectionParam createConnectionParams(BaseDataSourceParamDTO datasourceParam) {
        PostgreSQLDataSourceParamDTO postgreSqlParam = (PostgreSQLDataSourceParamDTO)datasourceParam;
        String address = String.format("%s%s:%s", "jdbc:postgresql://", postgreSqlParam.getHost(), postgreSqlParam.getPort());
        String jdbcUrl = String.format("%s/%s", address, postgreSqlParam.getDatabase());
        PostgreSQLConnectionParam postgreSqlConnectionParam = new PostgreSQLConnectionParam();
        postgreSqlConnectionParam.setJdbcUrl(jdbcUrl);
        postgreSqlConnectionParam.setAddress(address);
        postgreSqlConnectionParam.setDatabase(postgreSqlParam.getDatabase());
        postgreSqlConnectionParam.setUser(postgreSqlParam.getUserName());
        postgreSqlConnectionParam.setPassword(PasswordUtils.encodePassword((String)postgreSqlParam.getPassword()));
        postgreSqlConnectionParam.setDriverClassName(this.getDatasourceDriver());
        postgreSqlConnectionParam.setValidationQuery(this.getValidationQuery());
        postgreSqlConnectionParam.setOther(postgreSqlParam.getOther());
        return postgreSqlConnectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, PostgreSQLConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "org.postgresql.Driver";
    }

    public String getValidationQuery() {
        return "select version()";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        PostgreSQLConnectionParam postgreSqlConnectionParam = (PostgreSQLConnectionParam)connectionParam;
        if (MapUtils.isNotEmpty((Map)postgreSqlConnectionParam.getOther())) {
            return String.format("%s?%s", postgreSqlConnectionParam.getJdbcUrl(), this.transformOther(postgreSqlConnectionParam.getOther()));
        }
        return postgreSqlConnectionParam.getJdbcUrl();
    }

    public Connection getConnection(ConnectionParam connectionParam) throws ClassNotFoundException, SQLException {
        PostgreSQLConnectionParam postgreSqlConnectionParam = (PostgreSQLConnectionParam)connectionParam;
        Class.forName(this.getDatasourceDriver());
        return DriverManager.getConnection(this.getJdbcUrl((ConnectionParam)postgreSqlConnectionParam), postgreSqlConnectionParam.getUser(), PasswordUtils.decodePassword((String)postgreSqlConnectionParam.getPassword()));
    }

    public DbType getDbType() {
        return DbType.POSTGRESQL;
    }

    public DataSourceProcessor create() {
        return new PostgreSQLDataSourceProcessor();
    }

    public List<String> splitAndRemoveComment(String sql) {
        String cleanSQL = SQLParserUtils.removeComment((String)sql, (com.alibaba.druid.DbType)com.alibaba.druid.DbType.postgresql);
        return this.splitSqlRespectingDollarQuotes(cleanSQL);
    }

    private int findNextDollar(String sql, int from) {
        for (int i = from; i < sql.length(); ++i) {
            if (sql.charAt(i) == '$') {
                return i;
            }
            if (!Character.isLetterOrDigit(sql.charAt(i))) break;
        }
        return -1;
    }

    private int findClosingTag(String sql, int startIndex, String tag) {
        boolean inString = false;
        for (int i = startIndex; i <= sql.length() - tag.length(); ++i) {
            char ch = sql.charAt(i);
            if (ch == '\'') {
                if (i + 1 < sql.length() && sql.charAt(i + 1) == '\'') {
                    ++i;
                } else {
                    boolean bl = inString = !inString;
                }
            }
            if (inString || !sql.startsWith(tag, i)) continue;
            return i;
        }
        return -1;
    }

    private List<String> splitSqlRespectingDollarQuotes(String sql) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean insideDollarBlock = false;
        String dollarTag = null;
        int i = 0;
        while (i < sql.length()) {
            String potentialTag;
            int closingIndex;
            int tagEnd;
            char ch = sql.charAt(i);
            if (!insideDollarBlock && ch == '$' && (tagEnd = this.findNextDollar(sql, i + 1)) > i && (closingIndex = this.findClosingTag(sql, tagEnd + 1, potentialTag = sql.substring(i, tagEnd + 1))) != -1) {
                insideDollarBlock = true;
                dollarTag = potentialTag;
                current.append(dollarTag);
                i = tagEnd + 1;
                continue;
            }
            if (insideDollarBlock && dollarTag != null && sql.startsWith(dollarTag, i)) {
                insideDollarBlock = false;
                current.append(dollarTag);
                i += dollarTag.length();
                continue;
            }
            if (!insideDollarBlock && ch == ';') {
                result.add(current.toString().trim());
                current.setLength(0);
                ++i;
                continue;
            }
            current.append(ch);
            ++i;
        }
        if (!current.toString().trim().isEmpty()) {
            result.add(current.toString().trim());
        }
        return result;
    }

    private String transformOther(Map<String, String> otherMap) {
        if (MapUtils.isEmpty(otherMap)) {
            return null;
        }
        ArrayList otherList = new ArrayList();
        otherMap.forEach((key, value) -> otherList.add(String.format("%s=%s", key, value)));
        return String.join((CharSequence)"&", otherList);
    }
}

