/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.hive.security;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.StorageType;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserGroupInformationFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserGroupInformationFactory.class);
    private static final Map<String, Integer> currentLoginTimesMap = new HashMap<String, Integer>();
    private static final Map<String, UserGroupInformation> userGroupInformationMap = new HashMap<String, UserGroupInformation>();
    private static final ScheduledExecutorService kerberosRenewalService = ThreadUtils.newSingleDaemonScheduledExecutorService((String)"Hive-Kerberos-Renewal-Thread-");

    public static synchronized UserGroupInformation login(String userName) {
        UserGroupInformation userGroupInformation = userGroupInformationMap.get(userName);
        if (userGroupInformation == null) {
            userGroupInformation = !UserGroupInformationFactory.openKerberos() ? UserGroupInformationFactory.createRemoteUser(userName) : UserGroupInformationFactory.createKerberosUser();
            userGroupInformationMap.put(userName, userGroupInformation);
        }
        currentLoginTimesMap.compute(userName, (k, v) -> v == null ? 1 : v + 1);
        return userGroupInformation;
    }

    public static synchronized void logout(String userName) {
        Integer currentLoginTimes = currentLoginTimesMap.get(userName);
        if (currentLoginTimes == null) {
            return;
        }
        if (currentLoginTimes <= 1) {
            currentLoginTimesMap.remove(userName);
            userGroupInformationMap.remove(userName);
        } else {
            currentLoginTimesMap.put(userName, currentLoginTimes - 1);
        }
    }

    private static UserGroupInformation createRemoteUser(String userName) {
        return UserGroupInformation.createRemoteUser((String)userName);
    }

    private static UserGroupInformation createKerberosUser() {
        String krb5File = PropertyUtils.getString((String)"java.security.krb5.conf.path");
        String keytab = PropertyUtils.getString((String)"login.user.keytab.path");
        String principal = PropertyUtils.getString((String)"login.user.keytab.username");
        if (StringUtils.isNotBlank((CharSequence)krb5File)) {
            System.setProperty("java.security.krb5.conf", krb5File);
        }
        Configuration hadoopConf = new Configuration();
        hadoopConf.setBoolean("ipc.client.fallback-to-simple-auth-allowed", true);
        hadoopConf.set("hadoop.security.authentication", "kerberos");
        try {
            UserGroupInformation.setConfiguration((Configuration)hadoopConf);
            UserGroupInformation userGroupInformation = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal.trim(), (String)keytab.trim());
            UserGroupInformation.setLoginUser((UserGroupInformation)userGroupInformation);
            return userGroupInformation;
        }
        catch (IOException e) {
            throw new RuntimeException("createUserGroupInformation fail. ", e);
        }
    }

    public static boolean openKerberos() {
        String resUploadStartupType = PropertyUtils.getUpperCaseString((String)"resource.storage.type");
        StorageType storageType = StorageType.valueOf((String)resUploadStartupType);
        Boolean kerberosStartupState = PropertyUtils.getBoolean((String)"hadoop.security.authentication.startup.state", (Boolean)false);
        return storageType == StorageType.HDFS && kerberosStartupState != false;
    }

    static {
        kerberosRenewalService.scheduleWithFixedDelay(() -> {
            if (userGroupInformationMap.isEmpty()) {
                return;
            }
            userGroupInformationMap.forEach((key, ugi) -> {
                try {
                    if (ugi.isFromKeytab()) {
                        ugi.checkTGTAndReloginFromKeytab();
                    }
                    log.info("Relogin from keytab success, user: {}", key);
                }
                catch (Exception e) {
                    log.error("Relogin from keytab failed, user: {}", key, (Object)e);
                }
            });
        }, 0L, 5L, TimeUnit.MINUTES);
    }
}

