/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.aliyunserverlessspark.param;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.text.MessageFormat;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.aliyunserverlessspark.AliyunServerlessSparkClientWrapper;
import org.apache.dolphinscheduler.plugin.datasource.aliyunserverlessspark.param.AliyunServerlessSparkConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.aliyunserverlessspark.param.AliyunServerlessSparkDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={DataSourceProcessor.class})
public class AliyunServerlessSparkDataSourceProcessor
extends AbstractDataSourceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AliyunServerlessSparkDataSourceProcessor.class);

    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, AliyunServerlessSparkDataSourceParamDTO.class);
    }

    public void checkDatasourceParam(BaseDataSourceParamDTO datasourceParamDTO) {
        AliyunServerlessSparkDataSourceParamDTO aliyunServerlessSparkDataSourceParamDTO = (AliyunServerlessSparkDataSourceParamDTO)datasourceParamDTO;
        if (StringUtils.isEmpty((CharSequence)aliyunServerlessSparkDataSourceParamDTO.getRegionId()) || StringUtils.isEmpty((CharSequence)aliyunServerlessSparkDataSourceParamDTO.getAccessKeyId())) {
            throw new IllegalArgumentException("spark datasource param is not valid");
        }
    }

    public String getDatasourceUniqueId(ConnectionParam connectionParam, DbType dbType) {
        AliyunServerlessSparkConnectionParam baseConnectionParam = (AliyunServerlessSparkConnectionParam)connectionParam;
        return MessageFormat.format("{0}@{1}@{2}@{3}", dbType.getName(), baseConnectionParam.getRegionId(), PasswordUtils.encodePassword((String)baseConnectionParam.getAccessKeyId()), PasswordUtils.encodePassword((String)baseConnectionParam.getAccessKeySecret()));
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        AliyunServerlessSparkConnectionParam connectionParams = (AliyunServerlessSparkConnectionParam)this.createConnectionParams(connectionJson);
        AliyunServerlessSparkDataSourceParamDTO aliyunServerlessSparkDataSourceParamDTO = new AliyunServerlessSparkDataSourceParamDTO();
        aliyunServerlessSparkDataSourceParamDTO.setAccessKeyId(connectionParams.getAccessKeyId());
        aliyunServerlessSparkDataSourceParamDTO.setAccessKeySecret(connectionParams.getAccessKeySecret());
        aliyunServerlessSparkDataSourceParamDTO.setRegionId(connectionParams.getRegionId());
        aliyunServerlessSparkDataSourceParamDTO.setEndpoint(connectionParams.getEndpoint());
        return aliyunServerlessSparkDataSourceParamDTO;
    }

    public AliyunServerlessSparkConnectionParam createConnectionParams(BaseDataSourceParamDTO datasourceParam) {
        AliyunServerlessSparkDataSourceParamDTO aliyunServerlessSparkDataSourceParamDTO = (AliyunServerlessSparkDataSourceParamDTO)datasourceParam;
        AliyunServerlessSparkConnectionParam aliyunServerlessSparkConnectionParam = new AliyunServerlessSparkConnectionParam();
        aliyunServerlessSparkConnectionParam.setAccessKeyId(aliyunServerlessSparkDataSourceParamDTO.getAccessKeyId());
        aliyunServerlessSparkConnectionParam.setAccessKeySecret(aliyunServerlessSparkDataSourceParamDTO.getAccessKeySecret());
        aliyunServerlessSparkConnectionParam.setRegionId(aliyunServerlessSparkDataSourceParamDTO.getRegionId());
        aliyunServerlessSparkConnectionParam.setEndpoint(aliyunServerlessSparkDataSourceParamDTO.getEndpoint());
        return aliyunServerlessSparkConnectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, AliyunServerlessSparkConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "";
    }

    public String getValidationQuery() {
        return "";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        return "";
    }

    public Connection getConnection(ConnectionParam connectionParam) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkDataSourceConnectivity(ConnectionParam connectionParam) {
        AliyunServerlessSparkConnectionParam baseConnectionParam = (AliyunServerlessSparkConnectionParam)connectionParam;
        try (AliyunServerlessSparkClientWrapper aliyunServerlessSparkClientWrapper = new AliyunServerlessSparkClientWrapper(baseConnectionParam.getAccessKeyId(), baseConnectionParam.getAccessKeySecret(), baseConnectionParam.getRegionId(), baseConnectionParam.getEndpoint());){
            boolean bl = aliyunServerlessSparkClientWrapper.checkConnect(baseConnectionParam.getAccessKeyId(), baseConnectionParam.getAccessKeySecret(), baseConnectionParam.getRegionId());
            return bl;
        }
        catch (Exception e) {
            log.error("spark client failed to connect to the server", (Throwable)e);
            return false;
        }
    }

    public DbType getDbType() {
        return DbType.ALIYUN_SERVERLESS_SPARK;
    }

    public DataSourceProcessor create() {
        return new AliyunServerlessSparkDataSourceProcessor();
    }
}

