/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.repository.impl;

import java.util.Date;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowInstanceMapper;
import org.apache.dolphinscheduler.dao.repository.BaseDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class TaskInstanceDaoImpl
extends BaseDao<TaskInstance, TaskInstanceMapper>
implements TaskInstanceDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskInstanceDaoImpl.class);
    @Autowired
    private WorkflowInstanceMapper workflowInstanceMapper;

    public TaskInstanceDaoImpl(@NonNull TaskInstanceMapper taskInstanceMapper) {
        super(taskInstanceMapper);
        if (taskInstanceMapper == null) {
            throw new NullPointerException("taskInstanceMapper is marked non-null but is null");
        }
    }

    @Override
    public boolean upsertTaskInstance(TaskInstance taskInstance) {
        if (taskInstance.getId() != null) {
            return this.updateById(taskInstance);
        }
        return this.insert(taskInstance) > 0;
    }

    @Override
    public boolean submitTaskInstanceToDB(TaskInstance taskInstance, WorkflowInstance workflowInstance) {
        WorkflowExecutionStatus processInstanceState = workflowInstance.getState();
        if (processInstanceState.isFinished() || processInstanceState == WorkflowExecutionStatus.READY_STOP) {
            log.warn("processInstance: {} state was: {}, skip submit this task, taskCode: {}", new Object[]{workflowInstance.getId(), processInstanceState, taskInstance.getTaskCode()});
            return false;
        }
        if (processInstanceState == WorkflowExecutionStatus.READY_PAUSE) {
            taskInstance.setState(TaskExecutionStatus.PAUSE);
        }
        taskInstance.setExecutorId(workflowInstance.getExecutorId());
        taskInstance.setExecutorName(workflowInstance.getExecutorName());
        taskInstance.setState(this.getSubmitTaskState(taskInstance, workflowInstance));
        if (taskInstance.getSubmitTime() == null) {
            taskInstance.setSubmitTime(new Date());
        }
        if (taskInstance.getFirstSubmitTime() == null) {
            taskInstance.setFirstSubmitTime(taskInstance.getSubmitTime());
        }
        return this.upsertTaskInstance(taskInstance);
    }

    @Override
    public void markTaskInstanceInvalid(List<TaskInstance> taskInstances) {
        if (CollectionUtils.isEmpty(taskInstances)) {
            return;
        }
        for (TaskInstance taskInstance : taskInstances) {
            taskInstance.setFlag(Flag.NO);
            ((TaskInstanceMapper)this.mybatisMapper).updateById(taskInstance);
        }
    }

    private TaskExecutionStatus getSubmitTaskState(TaskInstance taskInstance, WorkflowInstance workflowInstance) {
        TaskExecutionStatus state = taskInstance.getState();
        if (state == TaskExecutionStatus.RUNNING_EXECUTION || state == TaskExecutionStatus.DELAY_EXECUTION || state == TaskExecutionStatus.KILL || state == TaskExecutionStatus.DISPATCH) {
            return state;
        }
        state = workflowInstance.getState() == WorkflowExecutionStatus.READY_PAUSE ? TaskExecutionStatus.PAUSE : (workflowInstance.getState() == WorkflowExecutionStatus.READY_STOP || !this.checkProcessStrategy(taskInstance, workflowInstance) ? TaskExecutionStatus.KILL : TaskExecutionStatus.SUBMITTED_SUCCESS);
        return state;
    }

    private boolean checkProcessStrategy(TaskInstance taskInstance, WorkflowInstance workflowInstance) {
        FailureStrategy failureStrategy = workflowInstance.getFailureStrategy();
        if (failureStrategy == FailureStrategy.CONTINUE) {
            return true;
        }
        List<TaskInstance> taskInstances = this.queryValidTaskListByWorkflowInstanceId(taskInstance.getWorkflowInstanceId(), taskInstance.getTestFlag());
        for (TaskInstance task : taskInstances) {
            if (task.getState() != TaskExecutionStatus.FAILURE || task.getRetryTimes() < task.getMaxRetryTimes()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<TaskInstance> queryValidTaskListByWorkflowInstanceId(Integer processInstanceId, int testFlag) {
        return ((TaskInstanceMapper)this.mybatisMapper).findValidTaskListByWorkflowInstanceId(processInstanceId, Flag.YES, testFlag);
    }

    @Override
    public TaskInstance queryByWorkflowInstanceIdAndTaskCode(Integer workflowInstanceId, Long taskCode) {
        return ((TaskInstanceMapper)this.mybatisMapper).queryByInstanceIdAndCode(workflowInstanceId, taskCode);
    }

    @Override
    public List<TaskInstance> queryPreviousTaskListByWorkflowInstanceId(Integer workflowInstanceId) {
        WorkflowInstance workflowInstance = (WorkflowInstance)this.workflowInstanceMapper.selectById(workflowInstanceId);
        return ((TaskInstanceMapper)this.mybatisMapper).findValidTaskListByWorkflowInstanceId(workflowInstanceId, Flag.NO, workflowInstance.getTestFlag());
    }

    @Override
    public void deleteByWorkflowInstanceId(int workflowInstanceId) {
        ((TaskInstanceMapper)this.mybatisMapper).deleteByWorkflowInstanceId(workflowInstanceId);
    }

    @Override
    public List<TaskInstance> queryByWorkflowInstanceId(Integer workflowInstanceId) {
        return ((TaskInstanceMapper)this.mybatisMapper).findByWorkflowInstanceId(workflowInstanceId);
    }

    @Override
    public List<TaskInstance> queryLastTaskInstanceListIntervalInWorkflowInstance(Integer workflowInstanceId, Set<Long> taskCodes, int testFlag) {
        return ((TaskInstanceMapper)this.mybatisMapper).findLastTaskInstances(workflowInstanceId, taskCodes, testFlag);
    }

    @Override
    public TaskInstance queryLastTaskInstanceIntervalInWorkflowInstance(Integer workflowInstanceId, long depTaskCode, int testFlag) {
        return ((TaskInstanceMapper)this.mybatisMapper).findLastTaskInstance(workflowInstanceId, depTaskCode, testFlag);
    }

    @Override
    public void updateTaskInstanceState(Integer taskInstanceId, TaskExecutionStatus originState, TaskExecutionStatus targetState) {
        ((TaskInstanceMapper)this.mybatisMapper).updateTaskInstanceState(taskInstanceId, originState.getCode(), targetState.getCode());
    }
}

