/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.dto.task.TaskFilterRequest;
import org.apache.dolphinscheduler.api.dto.taskRelation.TaskRelationUpdateUpstreamRequest;
import org.apache.dolphinscheduler.api.dto.workflow.WorkflowUpdateRequest;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.permission.PermissionCheck;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.TaskDefinitionService;
import org.apache.dolphinscheduler.api.service.WorkflowDefinitionService;
import org.apache.dolphinscheduler.api.service.WorkflowTaskRelationService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.api.vo.TaskDefinitionVO;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.ConditionType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.TaskExecuteType;
import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.TaskMainInfo;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.WorkflowTaskRelation;
import org.apache.dolphinscheduler.dao.entity.WorkflowTaskRelationLog;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowTaskRelationMapper;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowTaskRelationLogDao;
import org.apache.dolphinscheduler.plugin.task.api.TaskPluginManager;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskDefinitionServiceImpl
extends BaseServiceImpl
implements TaskDefinitionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskDefinitionServiceImpl.class);
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private TaskDefinitionDao taskDefinitionDao;
    @Autowired
    private TaskDefinitionLogMapper taskDefinitionLogMapper;
    @Autowired
    private WorkflowTaskRelationMapper workflowTaskRelationMapper;
    @Autowired
    private WorkflowTaskRelationLogDao workflowTaskRelationLogDao;
    @Autowired
    private WorkflowTaskRelationService workflowTaskRelationService;
    @Autowired
    private WorkflowDefinitionMapper workflowDefinitionMapper;
    @Autowired
    private ProcessService processService;
    @Autowired
    private WorkflowDefinitionService workflowDefinitionService;
    @Autowired
    private WorkflowDefinitionLogMapper workflowDefinitionLogMapper;

    private TaskDefinitionLog persist2TaskDefinitionLog(User user, TaskDefinition taskDefinition) {
        TaskDefinitionLog taskDefinitionLog = new TaskDefinitionLog(taskDefinition);
        taskDefinitionLog.setOperator(user.getId().intValue());
        taskDefinitionLog.setOperateTime(new Date());
        int result = this.taskDefinitionLogMapper.insert((Object)taskDefinitionLog);
        if (result <= 0) {
            throw new ServiceException(Status.CREATE_TASK_DEFINITION_LOG_ERROR, taskDefinitionLog.getName());
        }
        return taskDefinitionLog;
    }

    private void checkTaskDefinitionValid(User user, TaskDefinition taskDefinition, String permissions) {
        Project project = this.projectMapper.queryByCode(taskDefinition.getProjectCode());
        this.projectService.checkProjectAndAuthThrowException(user, project, permissions);
        if (!TaskPluginManager.checkTaskParameters((String)taskDefinition.getTaskType(), (String)taskDefinition.getTaskParams())) {
            throw new ServiceException(Status.WORKFLOW_NODE_S_PARAMETER_INVALID, taskDefinition.getName());
        }
    }

    private List<WorkflowTaskRelation> updateTaskUpstreams(User user, long workflowCode, long taskCode, String upstreamCodes) {
        TaskRelationUpdateUpstreamRequest taskRelationUpdateUpstreamRequest = new TaskRelationUpdateUpstreamRequest();
        taskRelationUpdateUpstreamRequest.setWorkflowCode(workflowCode);
        if (upstreamCodes != null) {
            taskRelationUpdateUpstreamRequest.setUpstreams(upstreamCodes);
        }
        return this.workflowTaskRelationService.updateUpstreamTaskDefinitionWithSyncDag(user, taskCode, Boolean.FALSE, taskRelationUpdateUpstreamRequest);
    }

    private WorkflowDefinition updateWorkflowLocation(User user, WorkflowDefinition workflowDefinition) {
        WorkflowUpdateRequest workflowUpdateRequest = new WorkflowUpdateRequest();
        workflowUpdateRequest.setLocation(null);
        return this.workflowDefinitionService.updateSingleWorkflowDefinition(user, workflowDefinition.getCode(), workflowUpdateRequest);
    }

    @Override
    public Map<String, Object> queryTaskDefinitionByName(User loginUser, long projectCode, long workflowDefinitionCode, String taskName) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:task-definition:view");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByName(project.getCode(), workflowDefinitionCode, taskName);
        if (taskDefinition == null) {
            log.error("Task definition does not exist, taskName:{}.", (Object)taskName);
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, taskName);
        } else {
            result.put("data", taskDefinition);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    private void taskCanDeleteValid(User user, TaskDefinition taskDefinition, User loginUser) {
        Project project = this.projectMapper.queryByCode(taskDefinition.getProjectCode());
        this.projectService.checkProjectAndAuthThrowException(user, project, "project:task-definition:delete");
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean hasProjectAndWritePerm = this.projectService.hasProjectAndWritePerm(loginUser, project, result);
        if (!hasProjectAndWritePerm) {
            throw new ServiceException(Status.TASK_DEFINITION_STATE_ONLINE, taskDefinition.getCode());
        }
        if (this.processService.isTaskOnline(taskDefinition.getCode()) && taskDefinition.getFlag() == Flag.YES) {
            throw new ServiceException(Status.TASK_DEFINITION_STATE_ONLINE, taskDefinition.getCode());
        }
        List workflowTaskRelationList = this.workflowTaskRelationMapper.queryDownstreamByTaskCode(taskDefinition.getCode());
        if (CollectionUtils.isNotEmpty((Collection)workflowTaskRelationList)) {
            Set postTaskCodes = workflowTaskRelationList.stream().map(WorkflowTaskRelation::getPostTaskCode).collect(Collectors.toSet());
            String postTaskCodesStr = StringUtils.join(postTaskCodes, (String)",");
            throw new ServiceException(Status.TASK_HAS_DOWNSTREAM, postTaskCodesStr);
        }
    }

    public void updateDag(User loginUser, long workflowDefinitionCode, List<WorkflowTaskRelation> workflowTaskRelationList, List<TaskDefinitionLog> taskDefinitionLogs) {
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(workflowDefinitionCode);
        if (workflowDefinition == null) {
            log.error("workflow definition does not exist, workflowDefinitionCode:{}.", (Object)workflowDefinitionCode);
            throw new ServiceException(Status.WORKFLOW_DEFINITION_NOT_EXIST);
        }
        int insertVersion = this.processService.saveWorkflowDefine(loginUser, workflowDefinition, Boolean.TRUE, Boolean.TRUE);
        if (insertVersion <= 0) {
            log.error("Update workflow definition error, projectCode:{}, workflowDefinitionCode:{}.", (Object)workflowDefinition.getProjectCode(), (Object)workflowDefinitionCode);
            throw new ServiceException(Status.UPDATE_WORKFLOW_DEFINITION_ERROR);
        }
        log.info("Save new version workflow definition complete, projectCode:{}, workflowDefinitionCode:{}, newVersion:{}.", new Object[]{workflowDefinition.getProjectCode(), workflowDefinitionCode, insertVersion});
        List relationLogs = workflowTaskRelationList.stream().map(WorkflowTaskRelationLog::new).collect(Collectors.toList());
        int insertResult = this.processService.saveTaskRelation(loginUser, workflowDefinition.getProjectCode(), workflowDefinition.getCode(), insertVersion, relationLogs, taskDefinitionLogs, Boolean.TRUE);
        if (insertResult != 0) {
            log.error("Update task relations error, projectCode:{}, workflowDefinitionCode:{}.", (Object)workflowDefinition.getProjectCode(), (Object)workflowDefinitionCode);
            throw new ServiceException(Status.UPDATE_WORKFLOW_DEFINITION_ERROR);
        }
        log.info("Save new version task relations complete, projectCode:{}, workflowDefinitionCode:{}, newVersion:{}.", new Object[]{workflowDefinition.getProjectCode(), workflowDefinitionCode, insertVersion});
    }

    private void TaskDefinitionUpdateValid(TaskDefinition taskDefinitionOriginal, TaskDefinition taskDefinitionUpdate) {
        if (this.processService.isTaskOnline(taskDefinitionOriginal.getCode()) && taskDefinitionOriginal.getFlag() == Flag.YES && taskDefinitionOriginal.getTaskExecuteType() != TaskExecuteType.STREAM) {
            throw new ServiceException(Status.NOT_SUPPORT_UPDATE_TASK_DEFINITION);
        }
        if (taskDefinitionOriginal.equals((Object)taskDefinitionUpdate)) {
            throw new ServiceException(Status.TASK_DEFINITION_NOT_CHANGE, taskDefinitionOriginal.getCode());
        }
        Integer version = this.taskDefinitionLogMapper.queryMaxVersionForDefinition(taskDefinitionOriginal.getCode());
        if (version == null || version == 0) {
            throw new ServiceException(Status.DATA_IS_NOT_VALID, taskDefinitionOriginal.getCode());
        }
    }

    @Override
    public TaskDefinition getTaskDefinition(User loginUser, long taskCode) {
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null) {
            throw new ServiceException(Status.TASK_DEFINE_NOT_EXIST, taskCode);
        }
        Project project = this.projectMapper.queryByCode(taskDefinition.getProjectCode());
        this.projectService.checkProjectAndAuthThrowException(loginUser, project, "project:task-definition:view");
        return taskDefinition;
    }

    @Override
    public PageInfo<TaskDefinition> filterTaskDefinition(User loginUser, TaskFilterRequest taskFilterRequest) {
        TaskDefinition taskDefinition = taskFilterRequest.convert2TaskDefinition();
        if (taskDefinition.getProjectName() != null) {
            Project project = this.projectMapper.queryByName(taskDefinition.getProjectName());
            this.projectService.checkProjectAndAuthThrowException(loginUser, project, "project:definition:list");
            taskDefinition.setProjectCode(project.getCode());
        }
        Page page = new Page((long)taskFilterRequest.getPageNo().intValue(), (long)taskFilterRequest.getPageSize().intValue());
        IPage taskDefinitionIPage = this.taskDefinitionMapper.filterTaskDefinition((IPage)page, taskDefinition);
        PageInfo<TaskDefinition> pageInfo = new PageInfo<TaskDefinition>(taskFilterRequest.getPageNo(), taskFilterRequest.getPageSize());
        pageInfo.setTotal((int)taskDefinitionIPage.getTotal());
        pageInfo.setTotalList(taskDefinitionIPage.getRecords());
        return pageInfo;
    }

    private TaskDefinitionLog updateTask(User loginUser, long projectCode, long taskCode, String taskDefinitionJsonObj, Map<String, Object> result) {
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndWritePerm = this.projectService.hasProjectAndWritePerm(loginUser, project, result);
        if (!hasProjectAndWritePerm) {
            return null;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null) {
            log.error("Task definition does not exist, taskDefinitionCode:{}.", (Object)taskCode);
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, String.valueOf(taskCode));
            return null;
        }
        if (this.processService.isTaskOnline(taskCode) && taskDefinition.getFlag() == Flag.YES && taskDefinition.getTaskExecuteType() != TaskExecuteType.STREAM) {
            log.warn("Only {} type task can be updated without online check, taskDefinitionCode:{}.", (Object)TaskExecuteType.STREAM, (Object)taskCode);
            this.putMsg(result, Status.NOT_SUPPORT_UPDATE_TASK_DEFINITION, new Object[0]);
            return null;
        }
        TaskDefinitionLog taskDefinitionToUpdate = (TaskDefinitionLog)JSONUtils.parseObject((String)taskDefinitionJsonObj, TaskDefinitionLog.class);
        if (TimeoutFlag.CLOSE == taskDefinition.getTimeoutFlag()) {
            taskDefinition.setTimeoutNotifyStrategy(null);
        }
        if (taskDefinition.equals((Object)taskDefinitionToUpdate)) {
            log.warn("Task definition does not need update because no change, taskDefinitionCode:{}.", (Object)taskCode);
            this.putMsg(result, Status.TASK_DEFINITION_NOT_MODIFY_ERROR, String.valueOf(taskCode));
            return null;
        }
        if (taskDefinitionToUpdate == null) {
            log.warn("Parameter taskDefinitionJson is invalid.");
            this.putMsg(result, Status.DATA_IS_NOT_VALID, taskDefinitionJsonObj);
            return null;
        }
        if (!TaskPluginManager.checkTaskParameters((String)taskDefinitionToUpdate.getTaskType(), (String)taskDefinitionToUpdate.getTaskParams())) {
            this.putMsg(result, Status.WORKFLOW_NODE_S_PARAMETER_INVALID, taskDefinitionToUpdate.getName());
            return null;
        }
        Integer version = this.taskDefinitionLogMapper.queryMaxVersionForDefinition(taskCode);
        if (version == null || version == 0) {
            log.error("Max version task definitionLog can not be found in database, taskDefinitionCode:{}.", (Object)taskCode);
            this.putMsg(result, Status.DATA_IS_NOT_VALID, taskCode);
            return null;
        }
        Date now = new Date();
        taskDefinitionToUpdate.setCode(taskCode);
        taskDefinitionToUpdate.setId(taskDefinition.getId());
        taskDefinitionToUpdate.setProjectCode(projectCode);
        taskDefinitionToUpdate.setUserId(taskDefinition.getUserId());
        version = version + 1;
        taskDefinitionToUpdate.setVersion(version.intValue());
        taskDefinitionToUpdate.setTaskType(taskDefinitionToUpdate.getTaskType().toUpperCase());
        taskDefinitionToUpdate.setResourceIds(this.processService.getResourceIds((TaskDefinition)taskDefinitionToUpdate));
        taskDefinitionToUpdate.setUpdateTime(now);
        int update = this.taskDefinitionMapper.updateById((Object)taskDefinitionToUpdate);
        taskDefinitionToUpdate.setOperator(loginUser.getId().intValue());
        taskDefinitionToUpdate.setOperateTime(now);
        taskDefinitionToUpdate.setCreateTime(now);
        taskDefinitionToUpdate.setId(null);
        int insert = this.taskDefinitionLogMapper.insert((Object)taskDefinitionToUpdate);
        if ((update & insert) != 1) {
            log.error("Update task definition or definitionLog error, projectCode:{}, taskDefinitionCode:{}.", (Object)projectCode, (Object)taskCode);
            this.putMsg(result, Status.UPDATE_TASK_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_TASK_DEFINITION_ERROR);
        }
        log.info("Update task definition and definitionLog complete, projectCode:{}, taskDefinitionCode:{}, newTaskVersion:{}.", new Object[]{projectCode, taskCode, taskDefinitionToUpdate.getVersion()});
        List workflowTaskRelations = this.workflowTaskRelationMapper.queryWorkflowTaskRelationByTaskCodeAndTaskVersion(taskDefinitionToUpdate.getCode(), (long)taskDefinition.getVersion());
        if (CollectionUtils.isNotEmpty((Collection)workflowTaskRelations)) {
            Map<Long, List<WorkflowTaskRelation>> workflowTaskRelationGroupList = workflowTaskRelations.stream().collect(Collectors.groupingBy(WorkflowTaskRelation::getWorkflowDefinitionCode));
            for (Map.Entry<Long, List<WorkflowTaskRelation>> workflowTaskRelationMap : workflowTaskRelationGroupList.entrySet()) {
                Long workflowDefinitionCode = workflowTaskRelationMap.getKey();
                int workflowDefinitionVersion = this.workflowDefinitionLogMapper.queryMaxVersionForDefinition(workflowDefinitionCode.longValue()) + 1;
                List<WorkflowTaskRelation> workflowTaskRelationList = workflowTaskRelationMap.getValue();
                for (WorkflowTaskRelation workflowTaskRelation : workflowTaskRelationList) {
                    if (taskCode == workflowTaskRelation.getPreTaskCode()) {
                        workflowTaskRelation.setPreTaskVersion(version.intValue());
                    } else if (taskCode == workflowTaskRelation.getPostTaskCode()) {
                        workflowTaskRelation.setPostTaskVersion(version.intValue());
                    }
                    workflowTaskRelation.setWorkflowDefinitionVersion(workflowDefinitionVersion);
                    int updateWorkflowDefinitionVersionCount = this.workflowTaskRelationMapper.updateWorkflowTaskRelationTaskVersion(workflowTaskRelation);
                    if (updateWorkflowDefinitionVersionCount != 1) {
                        log.error("batch update workflow task relation error, projectCode:{}, taskDefinitionCode:{}.", (Object)projectCode, (Object)taskCode);
                        this.putMsg(result, Status.WORKFLOW_TASK_RELATION_BATCH_UPDATE_ERROR, new Object[0]);
                        throw new ServiceException(Status.WORKFLOW_TASK_RELATION_BATCH_UPDATE_ERROR);
                    }
                    WorkflowTaskRelationLog workflowTaskRelationLog = new WorkflowTaskRelationLog(workflowTaskRelation);
                    workflowTaskRelationLog.setOperator(loginUser.getId().intValue());
                    workflowTaskRelationLog.setId(null);
                    workflowTaskRelationLog.setOperateTime(now);
                    int insertWorkflowTaskRelationLogCount = this.workflowTaskRelationLogDao.insert((Object)workflowTaskRelationLog);
                    if (insertWorkflowTaskRelationLogCount == 1) continue;
                    log.error("batch update workflow task relation error, projectCode:{}, taskDefinitionCode:{}.", (Object)projectCode, (Object)taskCode);
                    this.putMsg(result, Status.CREATE_WORKFLOW_TASK_RELATION_LOG_ERROR, new Object[0]);
                    throw new ServiceException(Status.CREATE_WORKFLOW_TASK_RELATION_LOG_ERROR);
                }
                WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(workflowDefinitionCode.longValue());
                workflowDefinition.setVersion(workflowDefinitionVersion);
                workflowDefinition.setUpdateTime(now);
                workflowDefinition.setUserId(loginUser.getId().intValue());
                int updateWorkflowDefinitionCount = this.workflowDefinitionMapper.updateById(workflowDefinition);
                WorkflowDefinitionLog workflowDefinitionLog = new WorkflowDefinitionLog(workflowDefinition);
                workflowDefinitionLog.setOperateTime(now);
                workflowDefinitionLog.setId(null);
                workflowDefinitionLog.setOperator(loginUser.getId().intValue());
                int insertWorkflowDefinitionLogCount = this.workflowDefinitionLogMapper.insert((Object)workflowDefinitionLog);
                if ((updateWorkflowDefinitionCount & insertWorkflowDefinitionLogCount) == 1) continue;
                this.putMsg(result, Status.UPDATE_WORKFLOW_DEFINITION_ERROR, new Object[0]);
                throw new ServiceException(Status.UPDATE_WORKFLOW_DEFINITION_ERROR);
            }
        }
        return taskDefinitionToUpdate;
    }

    @Override
    public Map<String, Object> updateTaskWithUpstream(User loginUser, long projectCode, long taskCode, String taskDefinitionJsonObj, String upstreamCodes) {
        Map<Object, Object> queryUpStreamTaskCodeMap;
        HashMap<String, Object> result = new HashMap<String, Object>();
        TaskDefinitionLog taskDefinitionToUpdate = this.updateTask(loginUser, projectCode, taskCode, taskDefinitionJsonObj, result);
        List upstreamTaskRelations = this.workflowTaskRelationMapper.queryUpstreamByCode(projectCode, taskCode);
        Set upstreamCodeSet = upstreamTaskRelations.stream().map(WorkflowTaskRelation::getPreTaskCode).collect(Collectors.toSet());
        Set upstreamTaskCodes = Collections.emptySet();
        if (StringUtils.isNotEmpty((CharSequence)upstreamCodes)) {
            upstreamTaskCodes = Arrays.stream(upstreamCodes.split(",")).map(Long::parseLong).collect(Collectors.toSet());
        }
        if (CollectionUtils.isEqualCollection(upstreamCodeSet, upstreamTaskCodes) && taskDefinitionToUpdate == null) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        if (CollectionUtils.isNotEmpty(upstreamTaskCodes)) {
            List upstreamTaskDefinitionList = this.taskDefinitionMapper.queryByCodeList(upstreamTaskCodes);
            queryUpStreamTaskCodeMap = upstreamTaskDefinitionList.stream().collect(Collectors.toMap(TaskDefinition::getCode, taskDefinition -> taskDefinition));
            upstreamTaskCodes.removeAll(queryUpStreamTaskCodeMap.keySet());
            if (CollectionUtils.isNotEmpty(upstreamTaskCodes)) {
                String notExistTaskCodes = StringUtils.join(upstreamTaskCodes, (String)",");
                log.error("Some task definitions in parameter upstreamTaskCodes do not exist, notExistTaskCodes:{}.", (Object)notExistTaskCodes);
                this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, notExistTaskCodes);
                return result;
            }
        } else {
            queryUpStreamTaskCodeMap = new HashMap();
        }
        if (MapUtils.isNotEmpty(queryUpStreamTaskCodeMap)) {
            WorkflowTaskRelation taskRelation = (WorkflowTaskRelation)upstreamTaskRelations.get(0);
            List workflowTaskRelations = this.workflowTaskRelationMapper.queryByWorkflowDefinitionCode(taskRelation.getWorkflowDefinitionCode());
            this.updateUpstreamTask(new HashSet<Object>(queryUpStreamTaskCodeMap.keySet()), taskCode, projectCode, taskRelation.getWorkflowDefinitionCode(), loginUser);
            ArrayList workflowTaskRelationList = Lists.newArrayList((Iterable)workflowTaskRelations);
            ArrayList relationList = Lists.newArrayList();
            for (WorkflowTaskRelation workflowTaskRelation : workflowTaskRelationList) {
                if (workflowTaskRelation.getPostTaskCode() != taskCode) continue;
                if (queryUpStreamTaskCodeMap.containsKey(workflowTaskRelation.getPreTaskCode()) && workflowTaskRelation.getPreTaskCode() != 0L) {
                    queryUpStreamTaskCodeMap.remove(workflowTaskRelation.getPreTaskCode());
                    continue;
                }
                workflowTaskRelation.setPreTaskCode(0L);
                workflowTaskRelation.setPreTaskVersion(0);
                relationList.add(workflowTaskRelation);
            }
            workflowTaskRelationList.removeAll(relationList);
            for (Map.Entry entry : queryUpStreamTaskCodeMap.entrySet()) {
                taskRelation.setPreTaskCode(((Long)entry.getKey()).longValue());
                taskRelation.setPreTaskVersion(((TaskDefinition)entry.getValue()).getVersion());
                workflowTaskRelationList.add(taskRelation);
            }
            if (MapUtils.isEmpty(queryUpStreamTaskCodeMap) && CollectionUtils.isNotEmpty((Collection)workflowTaskRelationList)) {
                workflowTaskRelationList.add(workflowTaskRelationList.get(0));
            }
        }
        log.info("Update task with upstream tasks complete, projectCode:{}, taskDefinitionCode:{}, upstreamTaskCodes:{}.", new Object[]{projectCode, taskCode, upstreamTaskCodes});
        result.put("data", taskCode);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private void updateUpstreamTask(Set<Long> allPreTaskCodeSet, long taskCode, long projectCode, long workflowDefinitionCode, User loginUser) {
        List hadWorkflowTaskRelationList = this.workflowTaskRelationMapper.queryUpstreamByCode(projectCode, taskCode);
        HashSet<Long> removePreTaskSet = new HashSet<Long>();
        ArrayList<WorkflowTaskRelation> removePreTaskList = new ArrayList<WorkflowTaskRelation>();
        HashSet<Long> addPreTaskSet = new HashSet<Long>();
        ArrayList<WorkflowTaskRelation> addPreTaskList = new ArrayList<WorkflowTaskRelation>();
        ArrayList<WorkflowTaskRelationLog> workflowTaskRelationLogList = new ArrayList<WorkflowTaskRelationLog>();
        if (CollectionUtils.isNotEmpty((Collection)hadWorkflowTaskRelationList)) {
            for (WorkflowTaskRelation workflowTaskRelation : hadWorkflowTaskRelationList) {
                if (workflowTaskRelation.getPreTaskCode() == 0L) continue;
                if (allPreTaskCodeSet.contains(workflowTaskRelation.getPreTaskCode())) {
                    allPreTaskCodeSet.remove(workflowTaskRelation.getPreTaskCode());
                    continue;
                }
                removePreTaskSet.add(workflowTaskRelation.getPreTaskCode());
                workflowTaskRelation.setPreTaskCode(0L);
                workflowTaskRelation.setPreTaskVersion(0);
                removePreTaskList.add(workflowTaskRelation);
                workflowTaskRelationLogList.add(this.createWorkflowTaskRelationLog(loginUser, workflowTaskRelation));
            }
        }
        if (allPreTaskCodeSet.size() != 0) {
            addPreTaskSet.addAll(allPreTaskCodeSet);
        }
        allPreTaskCodeSet.add(taskCode);
        List taskDefinitionList = this.taskDefinitionMapper.queryByCodeList(allPreTaskCodeSet);
        Map taskCodeMap = taskDefinitionList.stream().collect(Collectors.toMap(TaskDefinition::getCode, Function.identity(), (a, b) -> a));
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(workflowDefinitionCode);
        TaskDefinition taskDefinition = (TaskDefinition)taskCodeMap.get(taskCode);
        for (Long preTaskCode : addPreTaskSet) {
            TaskDefinition preTaskRelation = (TaskDefinition)taskCodeMap.get(preTaskCode);
            WorkflowTaskRelation workflowTaskRelation = new WorkflowTaskRelation(null, workflowDefinition.getVersion(), projectCode, workflowDefinition.getCode(), preTaskRelation.getCode(), preTaskRelation.getVersion(), taskDefinition.getCode(), taskDefinition.getVersion(), ConditionType.NONE, "{}");
            addPreTaskList.add(workflowTaskRelation);
            workflowTaskRelationLogList.add(this.createWorkflowTaskRelationLog(loginUser, workflowTaskRelation));
        }
        int insert = 0;
        int remove = 0;
        int log = 0;
        if (CollectionUtils.isNotEmpty(addPreTaskList)) {
            insert = this.workflowTaskRelationMapper.batchInsert(addPreTaskList);
        }
        if (CollectionUtils.isNotEmpty(removePreTaskList)) {
            for (WorkflowTaskRelation workflowTaskRelation : removePreTaskList) {
                remove += this.workflowTaskRelationMapper.updateById(workflowTaskRelation);
            }
        }
        if (CollectionUtils.isNotEmpty(workflowTaskRelationLogList)) {
            log = this.workflowTaskRelationLogDao.batchInsert(workflowTaskRelationLogList);
        }
        if (insert + remove != log) {
            throw new RuntimeException("updateUpstreamTask error");
        }
    }

    private WorkflowTaskRelationLog createWorkflowTaskRelationLog(User loginUser, WorkflowTaskRelation workflowTaskRelation) {
        Date now = new Date();
        WorkflowTaskRelationLog workflowTaskRelationLog = new WorkflowTaskRelationLog(workflowTaskRelation);
        workflowTaskRelationLog.setOperator(loginUser.getId().intValue());
        workflowTaskRelationLog.setOperateTime(now);
        workflowTaskRelationLog.setCreateTime(now);
        workflowTaskRelationLog.setUpdateTime(now);
        return workflowTaskRelationLog;
    }

    @Override
    @Transactional
    public Map<String, Object> switchVersion(User loginUser, long projectCode, long taskCode, int version) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:definition:version:switch");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (this.processService.isTaskOnline(taskCode)) {
            log.warn("Task definition version can not be switched due to workflow definition is {}, taskDefinitionCode:{}.", (Object)ReleaseState.ONLINE.getDescp(), (Object)taskCode);
            this.putMsg(result, Status.WORKFLOW_DEFINE_STATE_ONLINE, new Object[0]);
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null || projectCode != taskDefinition.getProjectCode()) {
            log.error("Task definition does not exist, taskDefinitionCode:{}.", (Object)taskCode);
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, String.valueOf(taskCode));
            return result;
        }
        TaskDefinitionLog taskDefinitionUpdate = this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(taskCode, version);
        taskDefinitionUpdate.setUserId(loginUser.getId().intValue());
        taskDefinitionUpdate.setUpdateTime(new Date());
        taskDefinitionUpdate.setId(taskDefinition.getId());
        int switchVersion = this.taskDefinitionMapper.updateById((Object)taskDefinitionUpdate);
        if (switchVersion > 0) {
            List taskRelationList = this.workflowTaskRelationMapper.queryUpstreamByCode(projectCode, taskCode);
            if (CollectionUtils.isNotEmpty((Collection)taskRelationList)) {
                log.info("Task definition has upstream tasks, start handle them after switch task, taskDefinitionCode:{}.", (Object)taskCode);
                long workflowDefinitionCode = ((WorkflowTaskRelation)taskRelationList.get(0)).getWorkflowDefinitionCode();
                List workflowTaskRelations = this.workflowTaskRelationMapper.queryByWorkflowDefinitionCode(workflowDefinitionCode);
                this.updateDag(loginUser, workflowDefinitionCode, workflowTaskRelations, Lists.newArrayList((Object[])new TaskDefinitionLog[]{taskDefinitionUpdate}));
            } else {
                log.info("Task definition version switch complete, switch task version to {}, taskDefinitionCode:{}.", (Object)version, (Object)taskCode);
                this.putMsg(result, Status.SUCCESS, new Object[0]);
            }
        } else {
            log.error("Task definition version switch error, taskDefinitionCode:{}.", (Object)taskCode);
            this.putMsg(result, Status.SWITCH_TASK_DEFINITION_VERSION_ERROR, new Object[0]);
        }
        return result;
    }

    @Override
    public Result queryTaskDefinitionVersions(User loginUser, long projectCode, long taskCode, int pageNo, int pageSize) {
        Result result = new Result();
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:task-definition:version");
        Status resultStatus = (Status)((Object)checkResult.get("status"));
        if (resultStatus != Status.SUCCESS) {
            this.putMsg(result, resultStatus, new Object[0]);
            return result;
        }
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        Page page = new Page((long)pageNo, (long)pageSize);
        IPage taskDefinitionVersionsPaging = this.taskDefinitionLogMapper.queryTaskDefinitionVersionsPaging(page, taskCode, projectCode);
        List taskDefinitionLogs = taskDefinitionVersionsPaging.getRecords();
        pageInfo.setTotalList(taskDefinitionLogs);
        pageInfo.setTotal((int)taskDefinitionVersionsPaging.getTotal());
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> deleteByCodeAndVersion(User loginUser, long projectCode, long taskCode, int version) {
        HashMap<String, Object> result;
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndWritePerm = this.projectService.hasProjectAndWritePerm(loginUser, project, result = new HashMap<String, Object>());
        if (!hasProjectAndWritePerm) {
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null) {
            log.error("Task definition does not exist, taskDefinitionCode:{}.", (Object)taskCode);
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, String.valueOf(taskCode));
        } else {
            if (taskDefinition.getVersion() == version) {
                log.warn("Task definition can not be deleted due to version is being used, projectCode:{}, taskDefinitionCode:{}, version:{}.", new Object[]{projectCode, taskCode, version});
                this.putMsg(result, Status.MAIN_TABLE_USING_VERSION, new Object[0]);
                return result;
            }
            int delete = this.taskDefinitionLogMapper.deleteByCodeAndVersion(taskCode, version);
            if (delete > 0) {
                log.info("Task definition version delete complete, projectCode:{}, taskDefinitionCode:{}, version:{}.", new Object[]{projectCode, taskCode, version});
                this.putMsg(result, Status.SUCCESS, new Object[0]);
            } else {
                log.error("Task definition version delete error, projectCode:{}, taskDefinitionCode:{}, version:{}.", new Object[]{projectCode, taskCode, version});
                this.putMsg(result, Status.DELETE_TASK_DEFINITION_VERSION_ERROR, new Object[0]);
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> queryTaskDefinitionDetail(User loginUser, long projectCode, long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:task-definition:view");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null || projectCode != taskDefinition.getProjectCode()) {
            log.error("Task definition does not exist, taskDefinitionCode:{}.", (Object)taskCode);
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, String.valueOf(taskCode));
        } else {
            List taskRelationList = this.workflowTaskRelationMapper.queryByCode(projectCode, 0L, 0L, taskCode);
            if (CollectionUtils.isNotEmpty((Collection)taskRelationList)) {
                taskRelationList = taskRelationList.stream().filter(v -> v.getPreTaskCode() != 0L).collect(Collectors.toList());
            }
            TaskDefinitionVO taskDefinitionVo = TaskDefinitionVO.fromTaskDefinition(taskDefinition);
            taskDefinitionVo.setWorkflowTaskRelationList(taskRelationList);
            result.put("data", (Object)taskDefinitionVo);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    private void fillRecords(long projectCode, IPage<TaskMainInfo> taskMainInfoIPage) {
        List records = Collections.emptyList();
        if (CollectionUtils.isNotEmpty((Collection)taskMainInfoIPage.getRecords())) {
            records = this.taskDefinitionMapper.queryDefineListByCodeList(projectCode, taskMainInfoIPage.getRecords().stream().map(TaskMainInfo::getTaskCode).collect(Collectors.toList()));
        }
        taskMainInfoIPage.setRecords(Collections.emptyList());
        if (CollectionUtils.isNotEmpty(records)) {
            HashMap<Long, TaskMainInfo> taskMainInfoMap = new HashMap<Long, TaskMainInfo>();
            for (TaskMainInfo info : records) {
                taskMainInfoMap.compute(info.getTaskCode(), (k, v) -> {
                    if (v == null) {
                        HashMap<Long, String> upstreamTaskMap = new HashMap<Long, String>();
                        if (info.getUpstreamTaskCode() != 0L) {
                            upstreamTaskMap.put(info.getUpstreamTaskCode(), info.getUpstreamTaskName());
                            info.setUpstreamTaskCode(0L);
                            info.setUpstreamTaskName("");
                        }
                        info.setUpstreamTaskMap(upstreamTaskMap);
                        v = info;
                    }
                    if (info.getUpstreamTaskCode() != 0L) {
                        v.getUpstreamTaskMap().put(info.getUpstreamTaskCode(), info.getUpstreamTaskName());
                    }
                    return v;
                });
            }
            ArrayList resultRecords = Lists.newArrayList(taskMainInfoMap.values());
            resultRecords.sort((o1, o2) -> o2.getTaskUpdateTime().compareTo(o1.getTaskUpdateTime()));
            taskMainInfoIPage.setRecords((List)resultRecords);
        }
    }

    private void fillWorkflowInfo(long projectCode, IPage<TaskMainInfo> taskMainInfoIPage) {
    }

    @Override
    public Map<String, Object> genTaskCodeList(Integer genNum) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (genNum == null || genNum < 1 || genNum > 100) {
            log.warn("Parameter genNum must be great than 1 and less than 100.");
            this.putMsg(result, Status.DATA_IS_NOT_VALID, genNum);
            return result;
        }
        ArrayList<Long> taskCodes = new ArrayList<Long>();
        try {
            for (int i = 0; i < genNum; ++i) {
                taskCodes.add(CodeGenerateUtils.genCode());
            }
        }
        catch (CodeGenerateUtils.CodeGenerateException e) {
            log.error("Generate task definition code error.", (Throwable)e);
            this.putMsg(result, Status.INTERNAL_SERVER_ERROR_ARGS, "Error generating task definition code");
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", taskCodes);
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> releaseTaskDefinition(User loginUser, long projectCode, long code, ReleaseState releaseState) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, null);
        Status resultStatus = (Status)((Object)result.get("status"));
        if (resultStatus != Status.SUCCESS) {
            return result;
        }
        if (null == releaseState) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "releaseState");
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(code);
        if (taskDefinition == null || projectCode != taskDefinition.getProjectCode()) {
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, String.valueOf(code));
            return result;
        }
        TaskDefinitionLog taskDefinitionLog = this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(code, taskDefinition.getVersion());
        if (taskDefinitionLog == null) {
            log.error("Task definition does not exist, taskDefinitionCode:{}.", (Object)code);
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, String.valueOf(code));
            return result;
        }
        switch (releaseState) {
            case OFFLINE: {
                taskDefinition.setFlag(Flag.NO);
                taskDefinitionLog.setFlag(Flag.NO);
                break;
            }
            case ONLINE: {
                String resourceIds = taskDefinition.getResourceIds();
                if (StringUtils.isNotBlank((CharSequence)resourceIds)) {
                    Integer[] resourceIdArray = (Integer[])Arrays.stream(resourceIds.split(",")).map(Integer::parseInt).toArray(Integer[]::new);
                    PermissionCheck<Integer> permissionCheck = new PermissionCheck<Integer>(AuthorizationType.RESOURCE_FILE_ID, this.processService, resourceIdArray, (int)loginUser.getId(), log);
                    try {
                        permissionCheck.checkPermission();
                    }
                    catch (Exception e) {
                        log.error("Resources permission check error, resourceIds:{}.", (Object)resourceIds, (Object)e);
                        this.putMsg(result, Status.RESOURCE_NOT_EXIST_OR_NO_PERMISSION, new Object[0]);
                        return result;
                    }
                }
                taskDefinition.setFlag(Flag.YES);
                taskDefinitionLog.setFlag(Flag.YES);
                break;
            }
            default: {
                log.warn("Parameter releaseState is invalid.");
                this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "releaseState");
                return result;
            }
        }
        int update = this.taskDefinitionMapper.updateById((Object)taskDefinition);
        int updateLog = this.taskDefinitionLogMapper.updateById(taskDefinitionLog);
        if (update == 0 && updateLog == 1 || update == 1 && updateLog == 0) {
            log.error("Update taskDefinition state or taskDefinitionLog state error, taskDefinitionCode:{}.", (Object)code);
            this.putMsg(result, Status.UPDATE_TASK_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_TASK_DEFINITION_ERROR);
        }
        log.error("Update taskDefinition state or taskDefinitionLog state to complete, taskDefinitionCode:{}.", (Object)code);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public void deleteTaskByWorkflowDefinitionCode(long workflowDefinitionCode, int workflowDefinitionVersion) {
        List<WorkflowTaskRelation> workflowTaskRelations = this.workflowTaskRelationService.queryByWorkflowDefinitionCode(workflowDefinitionCode, workflowDefinitionVersion);
        if (CollectionUtils.isEmpty(workflowTaskRelations)) {
            return;
        }
        HashSet<Long> needToDeleteTaskDefinitionCodes = new HashSet<Long>();
        for (WorkflowTaskRelation workflowTaskRelation : workflowTaskRelations) {
            needToDeleteTaskDefinitionCodes.add(workflowTaskRelation.getPreTaskCode());
            needToDeleteTaskDefinitionCodes.add(workflowTaskRelation.getPostTaskCode());
        }
        this.taskDefinitionDao.deleteByTaskDefinitionCodes(needToDeleteTaskDefinitionCodes);
        this.workflowTaskRelationService.deleteByWorkflowDefinitionCode(workflowDefinitionCode, workflowDefinitionVersion);
    }
}

