/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.executor.workflow;

import lombok.Generated;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.executor.workflow.IExecutorDelegate;
import org.apache.dolphinscheduler.api.validator.workflow.TriggerWorkflowDTO;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.extract.base.client.Clients;
import org.apache.dolphinscheduler.extract.master.IWorkflowControlClient;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowManualTriggerRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowManualTriggerResponse;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TriggerWorkflowExecutorDelegate
implements IExecutorDelegate<TriggerWorkflowDTO, Integer> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TriggerWorkflowExecutorDelegate.class);
    @Autowired
    private RegistryClient registryClient;

    @Override
    public Integer execute(TriggerWorkflowDTO triggerWorkflowDTO) {
        Server masterServer = this.registryClient.getRandomServer(RegistryNodeType.MASTER).orElse(null);
        if (masterServer == null) {
            throw new ServiceException("no master server available");
        }
        WorkflowManualTriggerResponse workflowManualTriggerResponse = ((IWorkflowControlClient)Clients.withService(IWorkflowControlClient.class).withHost(masterServer.getHost() + ":" + masterServer.getPort())).manualTriggerWorkflow(this.transform2WorkflowTriggerRequest(triggerWorkflowDTO));
        if (!workflowManualTriggerResponse.isSuccess()) {
            throw new ServiceException("Trigger workflow failed: " + workflowManualTriggerResponse.getMessage());
        }
        return workflowManualTriggerResponse.getWorkflowInstanceId();
    }

    private WorkflowManualTriggerRequest transform2WorkflowTriggerRequest(TriggerWorkflowDTO triggerWorkflowDTO) {
        return WorkflowManualTriggerRequest.builder().userId(triggerWorkflowDTO.getLoginUser().getId()).workflowDefinitionCode(Long.valueOf(triggerWorkflowDTO.getWorkflowDefinition().getCode())).workflowDefinitionVersion(Integer.valueOf(triggerWorkflowDTO.getWorkflowDefinition().getVersion())).startNodes(triggerWorkflowDTO.getStartNodes()).failureStrategy(triggerWorkflowDTO.getFailureStrategy()).taskDependType(triggerWorkflowDTO.getTaskDependType()).warningType(triggerWorkflowDTO.getWarningType()).warningGroupId(triggerWorkflowDTO.getWarningGroupId()).workflowInstancePriority(triggerWorkflowDTO.getWorkflowInstancePriority()).workerGroup(triggerWorkflowDTO.getWorkerGroup()).tenantCode(triggerWorkflowDTO.getTenantCode()).environmentCode(triggerWorkflowDTO.getEnvironmentCode()).startParamList(triggerWorkflowDTO.getStartParamList()).dryRun(triggerWorkflowDTO.getDryRun()).testFlag(triggerWorkflowDTO.getTestFlag()).build();
    }
}

