/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.wechat;

import com.google.auto.service.AutoService;
import java.util.Arrays;
import java.util.List;
import org.apache.dolphinscheduler.alert.api.AlertChannel;
import org.apache.dolphinscheduler.alert.api.AlertChannelFactory;
import org.apache.dolphinscheduler.alert.api.AlertInputTips;
import org.apache.dolphinscheduler.alert.api.ShowType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.alert.wechat.WeChatAlertChannel;
import org.apache.dolphinscheduler.plugin.alert.wechat.WeChatType;
import org.apache.dolphinscheduler.spi.params.base.ParamsOptions;
import org.apache.dolphinscheduler.spi.params.base.PluginParams;
import org.apache.dolphinscheduler.spi.params.base.Validate;
import org.apache.dolphinscheduler.spi.params.input.InputParam;
import org.apache.dolphinscheduler.spi.params.radio.RadioParam;

@AutoService(value={AlertChannelFactory.class})
public final class WeChatAlertChannelFactory
implements AlertChannelFactory {
    public String name() {
        return "WeChat";
    }

    public List<PluginParams> params() {
        InputParam corpIdParam = InputParam.newBuilder((String)"corpId", (String)"$t('corpId')").setPlaceholder(JSONUtils.toJsonString((Object)AlertInputTips.getAllMsg((AlertInputTips)AlertInputTips.CORP_ID))).addValidate(Validate.newBuilder().setRequired(true).build()).build();
        InputParam secretParam = InputParam.newBuilder((String)"secret", (String)"$t('secret')").setPlaceholder(JSONUtils.toJsonString((Object)AlertInputTips.getAllMsg((AlertInputTips)AlertInputTips.SECRET))).addValidate(Validate.newBuilder().setRequired(true).build()).build();
        InputParam usersParam = InputParam.newBuilder((String)"users", (String)"$t('users')").setPlaceholder(JSONUtils.toJsonString((Object)AlertInputTips.getAllMsg((AlertInputTips)AlertInputTips.WECHAT_MENTION_USERS))).addValidate(Validate.newBuilder().setRequired(false).build()).build();
        InputParam agentIdParam = InputParam.newBuilder((String)"agentId/chatId", (String)"$t('agentId/chatId')").setPlaceholder(JSONUtils.toJsonString((Object)AlertInputTips.getAllMsg((AlertInputTips)AlertInputTips.WECHAT_AGENT_ID))).addValidate(Validate.newBuilder().setRequired(true).build()).build();
        RadioParam sendType = RadioParam.newBuilder((String)"sendType", (String)"send.type").addParamsOptions(new ParamsOptions(WeChatType.APP.getDescp(), (Object)WeChatType.APP.getDescp(), false)).addParamsOptions(new ParamsOptions(WeChatType.APPCHAT.getDescp(), (Object)WeChatType.APPCHAT.getDescp(), false)).setValue((Object)WeChatType.APP.getDescp()).addValidate(Validate.newBuilder().setRequired(true).build()).build();
        RadioParam showType = RadioParam.newBuilder((String)"showType", (String)"$t('showType')").addParamsOptions(new ParamsOptions(ShowType.MARKDOWN.getDescp(), (Object)ShowType.MARKDOWN.getDescp(), false)).addParamsOptions(new ParamsOptions(ShowType.TEXT.getDescp(), (Object)ShowType.TEXT.getDescp(), false)).setValue((Object)ShowType.MARKDOWN.getDescp()).addValidate(Validate.newBuilder().setRequired(true).build()).build();
        return Arrays.asList(corpIdParam, secretParam, usersParam, agentIdParam, sendType, showType);
    }

    public AlertChannel create() {
        return new WeChatAlertChannel();
    }
}

