/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.wechat;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.dolphinscheduler.alert.api.AlertResult;
import org.apache.dolphinscheduler.alert.api.ShowType;
import org.apache.dolphinscheduler.spi.utils.JSONUtils;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WeChatSender {
    private static final Logger log = LoggerFactory.getLogger(WeChatSender.class);
    private static final String MUST_NOT_NULL = " must not null";
    private static final String ALERT_STATUS = "false";
    private static final String AGENT_ID_REG_EXP = "{agentId}";
    private static final String MSG_REG_EXP = "{msg}";
    private static final String USER_REG_EXP = "{toUser}";
    private static final String CORP_ID_REGEX = "{corpId}";
    private static final String SECRET_REGEX = "{secret}";
    private static final String TOKEN_REGEX = "{token}";
    private final String weChatAgentId;
    private final String weChatUsers;
    private final String weChatUserSendMsg;
    private final String weChatTokenUrlReplace;
    private final String weChatToken;
    private final String showType;

    WeChatSender(Map<String, String> config) {
        this.weChatAgentId = config.get("agentId");
        this.weChatUsers = config.get("users");
        String weChatCorpId = config.get("corpId");
        String weChatSecret = config.get("secret");
        String weChatTokenUrl = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid={corpId}&corpsecret={secret}";
        this.weChatUserSendMsg = config.get("userSendMsg");
        this.showType = config.get("showType");
        Objects.requireNonNull(this.showType, "showType must not null");
        this.weChatTokenUrlReplace = weChatTokenUrl.replace(CORP_ID_REGEX, weChatCorpId).replace(SECRET_REGEX, weChatSecret);
        this.weChatToken = this.getToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String post(String url, String data) throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String resp;
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)new StringEntity(data, "UTF-8"));
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                HttpEntity entity = response.getEntity();
                resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                EntityUtils.consume((HttpEntity)entity);
            }
            log.info("Enterprise WeChat send [{}], param:{}, resp:{}", new Object[]{url, data, resp});
            String string = resp;
            return string;
        }
    }

    private static String markdownTable(String title, String content) {
        List mapItemsList = JSONUtils.toList((String)content, LinkedHashMap.class);
        if (null == mapItemsList || mapItemsList.isEmpty()) {
            log.error("itemsList is null");
            throw new RuntimeException("itemsList is null");
        }
        StringBuilder contents = new StringBuilder(200);
        for (LinkedHashMap mapItems : mapItemsList) {
            Set entries = mapItems.entrySet();
            Iterator iterator = entries.iterator();
            StringBuilder t = new StringBuilder(String.format("`%s`%s", title, "\n"));
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                t.append(">");
                t.append((String)entry.getKey()).append(":").append(entry.getValue());
                t.append("\n");
            }
            contents.append((CharSequence)t);
        }
        return contents.toString();
    }

    private static String markdownText(String title, String content) {
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            List mapItemsList = JSONUtils.toList((String)content, LinkedHashMap.class);
            if (null == mapItemsList || mapItemsList.isEmpty()) {
                log.error("itemsList is null");
                throw new RuntimeException("itemsList is null");
            }
            StringBuilder contents = new StringBuilder(100);
            contents.append(String.format("`%s`%n", title));
            for (LinkedHashMap mapItems : mapItemsList) {
                Set entries = mapItems.entrySet();
                for (Map.Entry entry : entries) {
                    contents.append(">");
                    contents.append((String)entry.getKey()).append(":").append(entry.getValue());
                    contents.append("\n");
                }
            }
            return contents.toString();
        }
        return null;
    }

    private static String get(String url) throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String resp;
            HttpGet httpGet = new HttpGet(url);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            Object object = null;
            try {
                HttpEntity entity = response.getEntity();
                resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                EntityUtils.consume((HttpEntity)entity);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (response != null) {
                    if (object != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        response.close();
                    }
                }
            }
            HashMap map = (HashMap)JSONUtils.parseObject((String)resp, HashMap.class);
            if (map != null && null != map.get("access_token")) {
                object = map.get("access_token").toString();
                return object;
            }
            object = null;
            return object;
        }
    }

    private static String mkString(Iterable<String> list) {
        if (null == list || StringUtils.isEmpty((CharSequence)"|")) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String item : list) {
            if (first) {
                first = false;
            } else {
                sb.append("|");
            }
            sb.append(item);
        }
        return sb.toString();
    }

    private static AlertResult checkWeChatSendMsgResult(String result) {
        AlertResult alertResult = new AlertResult();
        alertResult.setStatus(ALERT_STATUS);
        if (null == result) {
            alertResult.setMessage("we chat send fail");
            log.info("send we chat msg error,resp is null");
            return alertResult;
        }
        WeChatSendMsgResponse sendMsgResponse = (WeChatSendMsgResponse)JSONUtils.parseObject((String)result, WeChatSendMsgResponse.class);
        if (null == sendMsgResponse) {
            alertResult.setMessage("we chat send fail");
            log.info("send we chat msg error,resp error");
            return alertResult;
        }
        if (sendMsgResponse.errcode == 0) {
            alertResult.setStatus("true");
            alertResult.setMessage("we chat alert send success");
            return alertResult;
        }
        alertResult.setStatus(ALERT_STATUS);
        alertResult.setMessage(sendMsgResponse.getErrmsg());
        return alertResult;
    }

    private String makeUserSendMsg(Collection<String> toUser, String agentId, String msg) {
        String listUser = WeChatSender.mkString(toUser);
        return this.weChatUserSendMsg.replace(USER_REG_EXP, listUser).replace(AGENT_ID_REG_EXP, agentId).replace(MSG_REG_EXP, msg);
    }

    public AlertResult sendEnterpriseWeChat(String title, String content) {
        List<String> userList = Arrays.asList(this.weChatUsers.split(","));
        String data = this.markdownByAlert(title, content);
        String msg = this.makeUserSendMsg(userList, this.weChatAgentId, data);
        if (null == this.weChatToken) {
            AlertResult alertResult = new AlertResult();
            alertResult.setMessage("send we chat alert fail,get weChat token error");
            alertResult.setStatus(ALERT_STATUS);
            return alertResult;
        }
        String enterpriseWeChatPushUrlReplace = "https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token={token}".replace(TOKEN_REGEX, this.weChatToken);
        try {
            return WeChatSender.checkWeChatSendMsgResult(WeChatSender.post(enterpriseWeChatPushUrlReplace, msg));
        }
        catch (Exception e) {
            log.info("send we chat alert msg  exception : {}", (Object)e.getMessage());
            AlertResult alertResult = new AlertResult();
            alertResult.setMessage("send we chat alert fail");
            alertResult.setStatus(ALERT_STATUS);
            return alertResult;
        }
    }

    private String markdownByAlert(String title, String content) {
        String result = "";
        if (this.showType.equals(ShowType.TABLE.getDescp())) {
            result = WeChatSender.markdownTable(title, content);
        } else if (this.showType.equals(ShowType.TEXT.getDescp())) {
            result = WeChatSender.markdownText(title, content);
        }
        return result;
    }

    private String getToken() {
        try {
            return WeChatSender.get(this.weChatTokenUrlReplace);
        }
        catch (IOException e) {
            log.info("we chat alert get token error{}", (Object)e.getMessage());
            return null;
        }
    }

    static final class WeChatSendMsgResponse {
        private Integer errcode;
        private String errmsg;

        public Integer getErrcode() {
            return this.errcode;
        }

        public void setErrcode(Integer errcode) {
            this.errcode = errcode;
        }

        public String getErrmsg() {
            return this.errmsg;
        }

        public void setErrmsg(String errmsg) {
            this.errmsg = errmsg;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WeChatSendMsgResponse)) {
                return false;
            }
            WeChatSendMsgResponse other = (WeChatSendMsgResponse)o;
            Integer this$errcode = this.getErrcode();
            Integer other$errcode = other.getErrcode();
            if (this$errcode == null ? other$errcode != null : !((Object)this$errcode).equals(other$errcode)) {
                return false;
            }
            String this$errmsg = this.getErrmsg();
            String other$errmsg = other.getErrmsg();
            return !(this$errmsg == null ? other$errmsg != null : !this$errmsg.equals(other$errmsg));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $errcode = this.getErrcode();
            result = result * 59 + ($errcode == null ? 43 : ((Object)$errcode).hashCode());
            String $errmsg = this.getErrmsg();
            result = result * 59 + ($errmsg == null ? 43 : $errmsg.hashCode());
            return result;
        }

        public String toString() {
            return "WeChatSender.WeChatSendMsgResponse(errcode=" + this.getErrcode() + ", errmsg=" + this.getErrmsg() + ")";
        }
    }
}

