/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.webexteams;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.dolphinscheduler.alert.api.AlertData;
import org.apache.dolphinscheduler.alert.api.AlertResult;
import org.apache.dolphinscheduler.alert.api.HttpServiceRetryStrategy;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.alert.webexteams.WebexMessage;
import org.apache.dolphinscheduler.plugin.alert.webexteams.WebexTeamsDestination;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebexTeamsSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebexTeamsSender.class);
    private final String botAccessToken;
    private final String roomId;
    private final String toPersonId;
    private final String toPersonEmail;
    private final String atSomeoneInRoom;
    private final WebexTeamsDestination destination;

    public WebexTeamsSender(Map<String, String> config) {
        this.botAccessToken = config.get("BotAccessToken");
        this.roomId = config.get("RoomId");
        this.toPersonId = config.get("ToPersonId");
        this.toPersonEmail = config.get("ToPersonEmail");
        this.atSomeoneInRoom = config.get("AtSomeoneInRoom");
        this.destination = WebexTeamsDestination.of(config.get("Destination"));
        Preconditions.checkArgument((!Objects.isNull(this.botAccessToken) ? 1 : 0) != 0, (Object)"WebexTeams bot access token can not be null");
        Preconditions.checkArgument((!Objects.isNull((Object)this.destination) ? 1 : 0) != 0, (Object)"WebexTeams message destination can not be null");
        Preconditions.checkArgument((!Objects.isNull(this.roomId) || !Objects.isNull(this.toPersonId) || !Objects.isNull(this.toPersonEmail) ? 1 : 0) != 0, (Object)"WebexTeams message destination could not be determined. Provide only one destination in the roomId, toPersonEmail, or toPersonId field");
    }

    public AlertResult sendWebexTeamsAlter(AlertData alertData) {
        AlertResult alertResult = new AlertResult();
        alertResult.setSuccess(false);
        alertResult.setMessage("send webex teams alert fail.");
        try {
            this.send(alertResult, alertData);
        }
        catch (Exception e) {
            log.info("send webex teams alert exception : {}", (Object)e.getMessage());
        }
        return alertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(AlertResult alertResult, AlertData alertData) throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.custom().setRetryHandler((HttpRequestRetryHandler)HttpServiceRetryStrategy.retryStrategy).build();){
            WebexMessage message = this.getMessage(alertData);
            HttpPost httpPost = WebexTeamsSender.constructHttpPost(message, this.botAccessToken);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            String responseContent = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
            try {
                if (statusCode == 200) {
                    alertResult.setSuccess(true);
                    alertResult.setMessage("send webex teams alert success");
                } else {
                    alertResult.setMessage(String.format("send webex teams alert error, message: %s, statusCode: %s, responseContent: %s", message, statusCode, responseContent));
                    log.info("send webex teams alert fail, statusCode : {}", (Object)statusCode);
                }
            }
            finally {
                response.close();
            }
        }
    }

    private WebexMessage getMessage(AlertData alertData) {
        WebexMessage message = new WebexMessage();
        String formatContent = WebexTeamsSender.formatContent(alertData);
        switch (this.destination) {
            case ROOM_ID: {
                message.setRoomId(this.roomId);
                if (Objects.isNull(this.atSomeoneInRoom)) break;
                formatContent = WebexTeamsSender.addAtPersonEmailInRoom(formatContent, this.atSomeoneInRoom);
                break;
            }
            case PERSON_EMAIL: {
                message.setToPersonEmail(this.toPersonEmail);
                break;
            }
            case PERSON_ID: {
                message.setToPersonId(this.toPersonId);
            }
        }
        message.setMarkdown(formatContent);
        return message;
    }

    private static HttpPost constructHttpPost(WebexMessage message, String botAccessToken) {
        HttpPost post = new HttpPost("https://webexapis.com/v1/messages");
        StringEntity entity = new StringEntity(JSONUtils.toJsonString((Object)message), StandardCharsets.UTF_8);
        post.setEntity((HttpEntity)entity);
        post.addHeader("Content-Type", "application/json; charset=utf-8");
        post.addHeader("Authorization", "Bearer " + botAccessToken);
        return post;
    }

    public static String addAtPersonEmailInRoom(String formatContent, String atPersonEmailInRoom) {
        String[] emailArr = atPersonEmailInRoom.split(",");
        StringBuilder formatContentBuilder = new StringBuilder(formatContent);
        for (String email : emailArr) {
            formatContentBuilder.append(" <@personEmail:").append(email).append(">");
        }
        return formatContentBuilder.toString();
    }

    public static String formatContent(AlertData alertData) {
        if (alertData.getContent() != null) {
            List list = JSONUtils.toList((String)alertData.getContent(), Map.class);
            if (list.isEmpty()) {
                return alertData.getTitle() + alertData.getContent();
            }
            StringBuilder contents = new StringBuilder(100);
            contents.append(String.format("`%s`%n", alertData.getTitle()));
            for (Map map : list) {
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = entry.getValue() == null ? "" : entry.getValue().toString();
                    contents.append(key).append(":").append(value);
                    contents.append("\n");
                }
            }
            return contents.toString();
        }
        return null;
    }
}

