/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.telegram;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.alert.api.AlertData;
import org.apache.dolphinscheduler.alert.api.AlertResult;
import org.apache.dolphinscheduler.alert.api.HttpServiceRetryStrategy;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TelegramSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelegramSender.class);
    private static final String BOT_TOKEN_REGEX = "{botToken}";
    private final String chatId;
    private final String parseMode;
    private final Boolean enableProxy;
    private String botToken;
    private String url;
    private String proxy;
    private Integer port;
    private String user;
    private String password;

    TelegramSender(Map<String, String> config) {
        this.url = config.get("webHook");
        this.botToken = config.get("botToken");
        this.chatId = config.get("chatId");
        this.parseMode = config.get("parseMode");
        this.url = this.url == null || this.url.isEmpty() ? "https://api.telegram.org/bot{botToken}/sendMessage".replace(BOT_TOKEN_REGEX, this.botToken) : this.url.replace(BOT_TOKEN_REGEX, this.botToken);
        this.enableProxy = Boolean.valueOf(config.get("IsEnableProxy"));
        if (Boolean.TRUE.equals(this.enableProxy)) {
            this.port = Integer.parseInt(config.get("Port"));
            this.proxy = config.get("Proxy");
            this.user = config.get("User");
            this.password = config.get("Password");
        }
    }

    public AlertResult sendMessage(AlertData alertData) {
        AlertResult result;
        try {
            String resp = this.sendInvoke(alertData.getTitle(), alertData.getContent());
            result = this.parseRespToResult(resp);
        }
        catch (Exception e) {
            log.warn("send telegram alert msg exception : {}", (Object)e.getMessage());
            result = new AlertResult();
            result.setSuccess(false);
            result.setMessage(String.format("send telegram alert fail. %s", e.getMessage()));
        }
        return result;
    }

    private AlertResult parseRespToResult(String resp) {
        AlertResult result = new AlertResult();
        result.setSuccess(false);
        if (null == resp || resp.isEmpty()) {
            result.setMessage("send telegram msg error. telegram server resp is empty");
            return result;
        }
        TelegramSendMsgResponse response = (TelegramSendMsgResponse)JSONUtils.parseObject((String)resp, TelegramSendMsgResponse.class);
        if (null == response) {
            result.setMessage("send telegram msg fail.");
            return result;
        }
        if (!response.isOk()) {
            result.setMessage(String.format("send telegram alert fail. telegram server error_code: %d, description: %s", response.errorCode, response.description));
        } else {
            result.setSuccess(true);
            result.setMessage("send telegram msg success.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendInvoke(String title, String content) throws IOException {
        CloseableHttpClient httpClient;
        HttpPost httpPost = TelegramSender.buildHttpPost(this.url, this.buildMsgJsonStr(content));
        if (Boolean.TRUE.equals(this.enableProxy)) {
            httpClient = StringUtils.isNotEmpty((CharSequence)this.user) && StringUtils.isNotEmpty((CharSequence)this.password) ? TelegramSender.getProxyClient(this.proxy, this.port, this.user, this.password) : TelegramSender.getDefaultClient();
            RequestConfig rcf = TelegramSender.getProxyConfig(this.proxy, this.port);
            httpPost.setConfig(rcf);
        } else {
            httpClient = TelegramSender.getDefaultClient();
        }
        try {
            String resp;
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                HttpEntity entity = response.getEntity();
                resp = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                EntityUtils.consume((HttpEntity)entity);
            }
            log.info("Telegram send title :{},content : {}, resp: {}", new Object[]{title, content, resp});
            String string = resp;
            return string;
        }
        finally {
            httpClient.close();
        }
    }

    private String buildMsgJsonStr(String content) {
        HashMap<String, String> items = new HashMap<String, String>();
        items.put("chat_id", this.chatId);
        if (!this.isTextParseMode()) {
            items.put("parse_mode", this.parseMode);
        }
        items.put("text", content);
        return JSONUtils.toJsonString(items);
    }

    private boolean isTextParseMode() {
        return null == this.parseMode || "Txt".equals(this.parseMode);
    }

    private static HttpPost buildHttpPost(String url, String msg) {
        HttpPost post = new HttpPost(url);
        StringEntity entity = new StringEntity(msg, StandardCharsets.UTF_8);
        post.setEntity((HttpEntity)entity);
        post.addHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
        return post;
    }

    private static CloseableHttpClient getDefaultClient() {
        return HttpClients.custom().setRetryHandler((HttpRequestRetryHandler)HttpServiceRetryStrategy.retryStrategy).build();
    }

    private static CloseableHttpClient getProxyClient(String proxy, int port, String user, String password) {
        HttpHost httpProxy = new HttpHost(proxy, port);
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(new AuthScope(httpProxy), (Credentials)new UsernamePasswordCredentials(user, password));
        return HttpClients.custom().setRetryHandler((HttpRequestRetryHandler)HttpServiceRetryStrategy.retryStrategy).setDefaultCredentialsProvider((CredentialsProvider)provider).build();
    }

    private static RequestConfig getProxyConfig(String proxy, int port) {
        HttpHost httpProxy = new HttpHost(proxy, port);
        return RequestConfig.custom().setProxy(httpProxy).build();
    }

    static class TelegramSendMsgResponse {
        @JsonProperty(value="ok")
        private Boolean ok;
        @JsonProperty(value="error_code")
        private Integer errorCode;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="result")
        private Object result;

        TelegramSendMsgResponse() {
        }

        public boolean isOk() {
            return null != this.ok && this.ok != false;
        }

        public Boolean getOk() {
            return this.ok;
        }

        @JsonProperty(value="ok")
        public void setOk(Boolean ok) {
            this.ok = ok;
        }

        @JsonProperty(value="error_code")
        public void setErrorCode(Integer errorCode) {
            this.errorCode = errorCode;
        }

        public Integer getErrorCode() {
            return this.errorCode;
        }

        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        public Object getResult() {
            return this.result;
        }

        @JsonProperty(value="result")
        public void setResult(Object result) {
            this.result = result;
        }
    }
}

