/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.http;

import com.google.auto.service.AutoService;
import java.util.Arrays;
import java.util.List;
import org.apache.dolphinscheduler.alert.api.AlertChannel;
import org.apache.dolphinscheduler.alert.api.AlertChannelFactory;
import org.apache.dolphinscheduler.alert.api.AlertInputTips;
import org.apache.dolphinscheduler.common.model.OkHttpRequestHeaderContentType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.alert.http.HttpAlertChannel;
import org.apache.dolphinscheduler.plugin.alert.http.HttpRequestMethod;
import org.apache.dolphinscheduler.spi.params.base.DataType;
import org.apache.dolphinscheduler.spi.params.base.ParamsOptions;
import org.apache.dolphinscheduler.spi.params.base.PluginParams;
import org.apache.dolphinscheduler.spi.params.base.Validate;
import org.apache.dolphinscheduler.spi.params.input.InputParam;
import org.apache.dolphinscheduler.spi.params.input.number.InputNumberParam;
import org.apache.dolphinscheduler.spi.params.radio.RadioParam;

@AutoService(value={AlertChannelFactory.class})
public final class HttpAlertChannelFactory
implements AlertChannelFactory {
    public String name() {
        return "Http";
    }

    public List<PluginParams> params() {
        InputParam url = InputParam.newBuilder((String)"url", (String)"$t('url')").setPlaceholder(JSONUtils.toJsonString((Object)AlertInputTips.getAllMsg((AlertInputTips)AlertInputTips.URL))).addValidate(Validate.newBuilder().setRequired(true).build()).build();
        InputParam headerParams = InputParam.newBuilder((String)"headerParams", (String)"$t('headerParams')").setPlaceholder(JSONUtils.toJsonString((Object)AlertInputTips.getAllMsg((AlertInputTips)AlertInputTips.HEADER))).addValidate(Validate.newBuilder().setRequired(false).build()).build();
        RadioParam contentType = RadioParam.newBuilder((String)"contentType", (String)"$t('contentType')").addParamsOptions(new ParamsOptions(OkHttpRequestHeaderContentType.APPLICATION_JSON.getValue(), (Object)OkHttpRequestHeaderContentType.APPLICATION_JSON.getValue(), false)).addParamsOptions(new ParamsOptions(OkHttpRequestHeaderContentType.APPLICATION_FORM_URLENCODED.getValue(), (Object)OkHttpRequestHeaderContentType.APPLICATION_FORM_URLENCODED.getValue(), false)).setValue((Object)OkHttpRequestHeaderContentType.APPLICATION_JSON.getValue()).addValidate(Validate.newBuilder().setRequired(true).build()).build();
        InputParam bodyParams = InputParam.newBuilder((String)"bodyParams", (String)"$t('bodyParams')").setPlaceholder(JSONUtils.toJsonString((Object)AlertInputTips.getAllMsg((AlertInputTips)AlertInputTips.JSON_BODY))).addValidate(Validate.newBuilder().setRequired(false).build()).build();
        RadioParam requestType = RadioParam.newBuilder((String)"requestType", (String)"$t('requestType')").addParamsOptions(new ParamsOptions(HttpRequestMethod.GET.name(), (Object)HttpRequestMethod.GET.name(), false)).addParamsOptions(new ParamsOptions(HttpRequestMethod.POST.name(), (Object)HttpRequestMethod.POST.name(), false)).addParamsOptions(new ParamsOptions(HttpRequestMethod.PUT.name(), (Object)HttpRequestMethod.PUT.name(), false)).setValue((Object)HttpRequestMethod.GET.name()).addValidate(Validate.newBuilder().setRequired(true).build()).build();
        InputNumberParam timeout = InputNumberParam.newBuilder((String)"timeout", (String)"$t('timeout')").setValue((Object)120).addValidate(Validate.newBuilder().setType(DataType.NUMBER.getDataType()).setRequired(false).build()).build();
        return Arrays.asList(url, requestType, headerParams, bodyParams, contentType, timeout);
    }

    public AlertChannel create() {
        return new HttpAlertChannel();
    }
}

