/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.api;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;

public class HttpServiceRetryStrategy
implements HttpRequestRetryHandler {
    public static final HttpServiceRetryStrategy retryStrategy = new HttpServiceRetryStrategy();
    private static final int RETRY_COUNT = 3;
    private static final long RETRY_INTERVAL_TIME = 2000L;

    public boolean retryRequest(IOException exception, int executionCount, HttpContext httpContext) {
        if (executionCount > 3) {
            return false;
        }
        if (exception instanceof SSLException) {
            return false;
        }
        if (exception instanceof UnknownHostException || exception instanceof InterruptedIOException || exception instanceof NoHttpResponseException || exception instanceof SocketException) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return true;
        }
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)httpContext);
        HttpRequest request = clientContext.getRequest();
        return !(request instanceof HttpEntityEnclosingRequest);
    }
}

