/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnNode<N>
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(DnNode.class);
    private N nodeElement;
    private Rdn nodeRdn;
    private Dn nodeDn;
    private int depth;
    private DnNode<N> parent;
    private Map<Rdn, DnNode<N>> children;

    private void checkDn(Dn dn) throws LdapException {
        if (dn == null || dn.isEmpty()) {
            String message = "Cannot process an empty Dn";
            LOG.error(message);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, message);
        }
    }

    private DnNode<N> createNode(Dn dn, N element, int nbRdns) throws LdapException {
        this.checkDn(dn);
        DnNode<N> rootNode = null;
        for (Rdn rdn : dn.getRdns()) {
            DnNode<N> node;
            if (nbRdns == 0) break;
            if (rootNode == null) {
                node = new DnNode<N>(element);
                node.nodeRdn = rdn;
                node.nodeDn = dn;
                node.depth = dn.size() + this.depth;
                rootNode = node;
            } else {
                node = new DnNode<N>();
                node.nodeRdn = rdn;
                node.nodeDn = rootNode.nodeDn.getParent();
                node.depth = node.nodeDn.size() + this.depth;
                rootNode.parent = node;
                node.children.put(rootNode.nodeRdn, rootNode);
                rootNode = node;
            }
            --nbRdns;
        }
        return rootNode;
    }

    private void setElement(N element) {
        this.nodeElement = element;
    }

    public DnNode() {
        this.children = new ConcurrentHashMap<Rdn, DnNode<N>>();
        this.nodeDn = Dn.EMPTY_DN;
        this.nodeRdn = Rdn.EMPTY_RDN;
    }

    public DnNode(N element) {
        this.nodeElement = element;
        this.children = new ConcurrentHashMap<Rdn, DnNode<N>>();
    }

    public DnNode(Dn dn, N element) {
        if (dn == null || dn.isEmpty()) {
            this.children = new ConcurrentHashMap<Rdn, DnNode<N>>();
            this.nodeDn = Dn.EMPTY_DN;
            return;
        }
        try {
            DnNode<N> rootNode = this.createNode(dn, element, dn.size());
            this.children = rootNode.children;
            this.depth = rootNode.depth;
            this.nodeDn = rootNode.nodeDn;
            this.nodeElement = rootNode.nodeElement;
            this.nodeRdn = rootNode.nodeRdn;
            this.parent = null;
        }
        catch (LdapException le) {
            throw new IllegalArgumentException(le.getMessage());
        }
    }

    public boolean isLeaf() {
        return !this.hasChildren();
    }

    public boolean isLeaf(Dn dn) {
        DnNode<N> node = this.getNode(dn);
        if (node == null) {
            return false;
        }
        return node.children.size() == 0;
    }

    public int size() {
        int size = 1;
        if (this.children.size() != 0) {
            for (DnNode<N> node : this.children.values()) {
                size += node.size();
            }
        }
        return size;
    }

    public N getElement() {
        return this.nodeElement;
    }

    public N getElement(Dn dn) {
        DnNode<N> node = this.getNode(dn);
        if (node == null) {
            return null;
        }
        return node.nodeElement;
    }

    public boolean hasElement() {
        return this.nodeElement != null;
    }

    public boolean hasElement(Dn dn) {
        DnNode<N> node = this.getNode(dn);
        if (node == null) {
            return false;
        }
        return node.nodeElement != null;
    }

    private boolean hasDescendantElement(DnNode<N> node) {
        if (node == null) {
            return false;
        }
        if (node.hasElement()) {
            return true;
        }
        for (DnNode<N> child : node.getChildren().values()) {
            if (!this.hasDescendantElement(child)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDescendantElement(Dn dn) {
        DnNode<N> node = this.getNode(dn);
        if (node == null) {
            return false;
        }
        if (node.getDn().size() != dn.size()) {
            return false;
        }
        if (node.hasChildren()) {
            for (DnNode<N> child : node.getChildren().values()) {
                if (!this.hasDescendantElement(child)) continue;
                return true;
            }
        }
        return false;
    }

    private void getDescendantElements(DnNode<N> node, List<N> descendants) {
        if (node == null) {
            return;
        }
        if (node.hasElement()) {
            descendants.add(node.getElement());
            return;
        }
        for (DnNode<N> child : node.getChildren().values()) {
            this.getDescendantElements(child, descendants);
        }
    }

    public List<N> getDescendantElements(Dn dn) {
        ArrayList descendants = new ArrayList();
        DnNode<N> node = this.getNode(dn);
        if (node == null) {
            return descendants;
        }
        if (node.getDn().size() != dn.size()) {
            return descendants;
        }
        if (node.hasChildren()) {
            for (DnNode<N> child : node.getChildren().values()) {
                this.getDescendantElements(child, descendants);
            }
        }
        return descendants;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() != 0;
    }

    public boolean hasChildren(Dn dn) throws LdapException {
        this.checkDn(dn);
        DnNode<N> node = this.getNode(dn);
        return node != null && node.hasChildren();
    }

    public Map<Rdn, DnNode<N>> getChildren() {
        return this.children;
    }

    public DnNode<N> getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean hasParent(Dn dn) {
        List rdns = dn.getRdns();
        DnNode<N> currentNode = this;
        DnNode<N> parentNode = null;
        for (int i = rdns.size() - 1; i >= 0; --i) {
            Rdn rdn = (Rdn)rdns.get(i);
            if (rdn.equals((Object)currentNode.nodeRdn)) {
                parentNode = currentNode;
                continue;
            }
            if (!currentNode.hasChildren() || (currentNode = currentNode.children.get(rdn)) == null) break;
            parentNode = currentNode;
        }
        return parentNode != null;
    }

    public void add(Dn dn) throws LdapException {
        this.add(dn, null);
    }

    public void add(Dn dn, N element) throws LdapException {
        this.checkDn(dn);
        DnNode<N> parentNode = this.getNode(dn);
        if (parentNode == null) {
            DnNode<N> childNode = this.createNode(dn, element, dn.size());
            childNode.parent = this;
            this.children.put(childNode.nodeRdn, childNode);
        } else {
            int nbRdns = dn.size() - parentNode.depth;
            if (nbRdns == 0) {
                if (parentNode.hasElement()) {
                    String message = "Cannot add a node to a node already having an element";
                    LOG.error(message);
                    throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, message);
                }
                if (element == null) {
                    String message = "Cannot add a node with no element if it already exists";
                    LOG.error(message);
                    throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, message);
                }
                super.setElement(element);
            } else {
                DnNode<N> rootNode = this.createNode(dn, element, nbRdns);
                rootNode.parent = parentNode;
                parentNode.children.put(rootNode.nodeRdn, rootNode);
            }
        }
    }

    public void remove(Dn dn) throws LdapException {
        this.checkDn(dn);
        DnNode<N> parentNode = this.getNode(dn);
        if (parentNode == null) {
            return;
        }
        if (dn.size() != parentNode.depth || parentNode.hasChildren()) {
            return;
        }
        parentNode = parentNode.getParent();
        for (Rdn rdn : dn.getRdns()) {
            parentNode.children.remove(rdn);
            if (parentNode.children.size() > 0) break;
            parentNode = parentNode.getParent();
        }
    }

    public boolean contains(Rdn rdn) {
        return this.children.containsKey(rdn);
    }

    public DnNode<N> getChild(Rdn rdn) {
        if (this.children.containsKey(rdn)) {
            return this.children.get(rdn);
        }
        return null;
    }

    public Rdn getRdn() {
        return this.nodeRdn;
    }

    public DnNode<N> getNode(Dn dn) {
        List rdns = dn.getRdns();
        DnNode<N> currentNode = this;
        DnNode<N> parentNode = null;
        for (int i = rdns.size() - 1; i >= 0; --i) {
            Rdn rdn = (Rdn)rdns.get(i);
            if (!currentNode.hasChildren() || (currentNode = currentNode.children.get(rdn)) == null) break;
            parentNode = currentNode;
        }
        return parentNode;
    }

    public boolean hasParentElement(Dn dn) {
        List rdns = dn.getRdns();
        DnNode<N> currentNode = this;
        boolean hasElement = false;
        for (int i = rdns.size() - 1; i >= 0; --i) {
            Rdn rdn = (Rdn)rdns.get(i);
            if (!currentNode.hasChildren() || (currentNode = currentNode.children.get(rdn)) == null) break;
            if (currentNode.hasElement()) {
                hasElement = true;
            }
            this.parent = currentNode;
        }
        return hasElement;
    }

    public DnNode<N> clone() {
        DnNode<N> clonedDnNode = new DnNode<N>();
        clonedDnNode.nodeElement = this.nodeElement;
        clonedDnNode.depth = this.depth;
        clonedDnNode.parent = this.parent;
        clonedDnNode.nodeRdn = this.nodeRdn;
        clonedDnNode.nodeDn = this.nodeDn;
        for (DnNode<N> node : this.children.values()) {
            clonedDnNode.children.put(node.getRdn(), (DnNode<N>)node.clone());
        }
        return clonedDnNode;
    }

    private String toString(String tabs) {
        if (this.nodeRdn == null) {
            return tabs;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(tabs);
        boolean hasChildren = this.hasChildren();
        if (this.isLeaf()) {
            sb.append("Leaf[").append(this.nodeDn).append("]: ").append("'").append(this.nodeElement).append("'");
            return sb.toString();
        }
        sb.append("Branch[").append(this.nodeDn).append("]: ");
        if (this.nodeElement != null) {
            sb.append("'").append(this.nodeElement).append("'");
        }
        tabs = tabs + "    ";
        sb.append('\n');
        boolean isFirst = true;
        if (hasChildren) {
            for (Rdn rdn : this.children.keySet()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append("\n");
                }
                DnNode<N> child = this.children.get(rdn);
                sb.append(super.toString(tabs));
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }

    public Dn getDn() {
        return this.nodeDn;
    }
}

