/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci.protectedItem;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.directory.shared.ldap.aci.ProtectedItem;
import org.apache.directory.shared.ldap.model.entry.EntryAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeValueItem
extends ProtectedItem {
    private final Set<EntryAttribute> attributes;

    public AttributeValueItem(Set<EntryAttribute> attributes) {
        this.attributes = Collections.unmodifiableSet(attributes);
    }

    public Iterator<EntryAttribute> iterator() {
        return this.attributes.iterator();
    }

    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + ((Object)this.attributes).hashCode();
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof AttributeValueItem) {
            AttributeValueItem that = (AttributeValueItem)o;
            return ((Object)this.attributes).equals(that.attributes);
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("attributeValue {");
        boolean isFirst = true;
        for (EntryAttribute attribute : this.attributes) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(", ");
            }
            buf.append(attribute.getId());
            buf.append('=');
            buf.append(attribute.get(0));
        }
        buf.append(" }");
        return buf.toString();
    }
}

