/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.util.ByteBuffer;
import org.apache.directory.shared.ldap.util.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTools {
    static String defaultCharset = null;
    private static final byte[] HEX_CHAR = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final int UTF8_MULTI_BYTES_MASK = 128;
    private static final int UTF8_TWO_BYTES_MASK = 224;
    private static final int UTF8_TWO_BYTES = 192;
    private static final int UTF8_THREE_BYTES_MASK = 240;
    private static final int UTF8_THREE_BYTES = 224;
    private static final int UTF8_FOUR_BYTES_MASK = 248;
    private static final int UTF8_FOUR_BYTES = 240;
    private static final int UTF8_FIVE_BYTES_MASK = 252;
    private static final int UTF8_FIVE_BYTES = 248;
    private static final int UTF8_SIX_BYTES_MASK = 254;
    private static final int UTF8_SIX_BYTES = 252;
    private static final boolean[] ALPHA = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    private static final boolean[] ALPHA_LOWER_CASE = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    private static final boolean[] ALPHA_UPPER_CASE = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static final boolean[] ALPHA_DIGIT = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    private static final boolean[] CHAR = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    private static final boolean[] UNICODE_SUBSET = new boolean[]{false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private static final boolean[] DIGIT = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static final boolean[] HEX = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static final boolean[] IS_PRINTABLE_CHAR = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, true, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    private static final byte[] HEX_VALUE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final char[] LOWER_CASE = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '-', '\u0000', '\u0000', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    private static final char[] TO_LOWER_CASE = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};
    private static final char[] UPPER_CASE = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '-', '\u0000', '\u0000', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    private static final int CHAR_ONE_BYTE_MASK = -128;
    private static final int CHAR_TWO_BYTES_MASK = -2048;
    private static final int CHAR_THREE_BYTES_MASK = -65536;
    private static final int CHAR_FOUR_BYTES_MASK = -2097152;
    private static final int CHAR_FIVE_BYTES_MASK = -67108864;
    private static final int CHAR_SIX_BYTES_MASK = Integer.MIN_VALUE;
    public static final int NOT_EQUAL = -1;
    public static final String EMPTY = "";
    public static final byte[] EMPTY_BYTES = new byte[0];

    public static final String trimConsecutiveToOne(String str, char ch) {
        if (null == str || str.length() == 0) {
            return EMPTY;
        }
        char[] buffer = str.toCharArray();
        char[] newbuf = new char[buffer.length];
        int pos = 0;
        boolean same = false;
        for (int i = 0; i < buffer.length; ++i) {
            char car = buffer[i];
            if (car == ch) {
                if (same) continue;
                same = true;
                newbuf[pos++] = car;
                continue;
            }
            same = false;
            newbuf[pos++] = car;
        }
        return new String(newbuf, 0, pos);
    }

    public static final String deepTrim(String string) {
        return StringTools.deepTrim(string, false);
    }

    public static final String deepTrimToLower(String string) {
        return StringTools.deepTrim(string, true);
    }

    public static final String deepTrim(String str, boolean toLowerCase) {
        if (null == str || str.length() == 0) {
            return EMPTY;
        }
        char[] buf = str.toCharArray();
        char[] newbuf = new char[buf.length];
        boolean wsSeen = false;
        boolean isStart = true;
        int pos = 0;
        for (int i = 0; i < str.length(); ++i) {
            char ch = buf[i];
            if (toLowerCase && Character.isUpperCase(ch)) {
                ch = Character.toLowerCase(ch);
            }
            if (Character.isWhitespace(ch)) {
                if (wsSeen) continue;
                wsSeen = true;
                if (isStart) {
                    isStart = false;
                    continue;
                }
                newbuf[pos++] = ch;
                continue;
            }
            wsSeen = false;
            isStart = false;
            newbuf[pos++] = ch;
        }
        return pos == 0 ? EMPTY : new String(newbuf, 0, wsSeen ? pos - 1 : pos);
    }

    public static final String centerTrunc(String str, int head, int tail) {
        StringBuffer buf = null;
        if (str.length() <= head + tail + 7 + str.length() / 10) {
            return str;
        }
        buf = new StringBuffer();
        buf.append('[').append(str.length()).append("][");
        buf.append(str.substring(0, head)).append("...");
        buf.append(str.substring(str.length() - tail));
        buf.append(']');
        return buf.toString();
    }

    public static final String toHexString(byte[] res) {
        StringBuffer buf = new StringBuffer(res.length << 1);
        for (int ii = 0; ii < res.length; ++ii) {
            String digit = Integer.toHexString(0xFF & res[ii]);
            if (digit.length() == 1) {
                digit = '0' + digit;
            }
            buf.append(digit);
        }
        return buf.toString().toUpperCase();
    }

    public static final String toLowerCase(String value) {
        if (null == value || value.length() == 0) {
            return EMPTY;
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = LOWER_CASE[chars[i]];
        }
        return new String(chars);
    }

    public static final String toUpperCase(String value) {
        if (null == value || value.length() == 0) {
            return EMPTY;
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = UPPER_CASE[chars[i]];
        }
        return new String(chars);
    }

    public static final byte[] toByteArray(String hexString) {
        int arrLength = hexString.length() >> 1;
        byte[] buf = new byte[arrLength];
        for (int ii = 0; ii < arrLength; ++ii) {
            int index = ii << 1;
            String l_digit = hexString.substring(index, index + 2);
            buf[ii] = (byte)Integer.parseInt(l_digit, 16);
        }
        return buf;
    }

    public static final String formatHtml(String source, boolean replaceNl, boolean replaceTag, boolean replaceQuote) {
        StringBuffer buf = new StringBuffer();
        int len = source.length();
        block8: for (int ii = 0; ii < len; ++ii) {
            char ch = source.charAt(ii);
            switch (ch) {
                case '\"': {
                    if (replaceQuote) {
                        buf.append("&quot;");
                        continue block8;
                    }
                    buf.append(ch);
                    continue block8;
                }
                case '<': {
                    if (replaceTag) {
                        buf.append("&lt;");
                        continue block8;
                    }
                    buf.append(ch);
                    continue block8;
                }
                case '>': {
                    if (replaceTag) {
                        buf.append("&gt;");
                        continue block8;
                    }
                    buf.append(ch);
                    continue block8;
                }
                case '\n': {
                    if (replaceNl) {
                        if (replaceTag) {
                            buf.append("&lt;br&gt;");
                            continue block8;
                        }
                        buf.append("<br>");
                        continue block8;
                    }
                    buf.append(ch);
                    continue block8;
                }
                case '\r': {
                    continue block8;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block8;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    public static final Pattern getRegex(String initialPattern, String[] anyPattern, String finalPattern) throws PatternSyntaxException {
        StringBuffer buf = new StringBuffer();
        if (initialPattern != null) {
            buf.append('^').append(initialPattern);
        }
        if (anyPattern != null) {
            for (int i = 0; i < anyPattern.length; ++i) {
                buf.append(".*").append(anyPattern[i]);
            }
        }
        if (finalPattern != null) {
            buf.append(".*").append(finalPattern);
        } else {
            buf.append(".*");
        }
        return Pattern.compile(buf.toString());
    }

    public static final Pattern getRegex(String ldapRegex) throws PatternSyntaxException {
        if (ldapRegex == null) {
            throw new PatternSyntaxException("Regex was null", "null", -1);
        }
        ArrayList<String> any = new ArrayList<String>();
        String remaining = ldapRegex;
        int index = remaining.indexOf(42);
        if (index == -1) {
            throw new PatternSyntaxException("Ldap regex must have wild cards!", remaining, -1);
        }
        String initialPattern = null;
        if (remaining.charAt(0) != '*') {
            initialPattern = remaining.substring(0, index);
        }
        remaining = remaining.substring(index + 1, remaining.length());
        while ((index = remaining.indexOf(42)) != -1) {
            any.add(remaining.substring(0, index));
            remaining = remaining.substring(index + 1, remaining.length());
        }
        String finalPattern = null;
        if (!remaining.endsWith("*") && remaining.length() > 0) {
            finalPattern = remaining;
        }
        if (any.size() > 0) {
            String[] anyStrs = new String[any.size()];
            for (int i = 0; i < anyStrs.length; ++i) {
                anyStrs[i] = (String)any.get(i);
            }
            return StringTools.getRegex(initialPattern, anyStrs, finalPattern);
        }
        return StringTools.getRegex(initialPattern, null, finalPattern);
    }

    public static final List<String> getPaths(String paths, FileFilter filter) {
        int start = 0;
        int stop = -1;
        String path = null;
        ArrayList<String> list = new ArrayList<String>();
        if (paths == null || paths.trim().equals(EMPTY)) {
            return list;
        }
        int max = paths.length() - 1;
        while (start < max) {
            stop = paths.indexOf(File.pathSeparatorChar, start);
            if (stop == -1) {
                if (start >= max || (path = paths.substring(start)).trim().equals(EMPTY) || filter != null && !filter.accept(new File(path))) break;
                list.add(path);
                break;
            }
            path = paths.substring(start, stop);
            if (!path.trim().equals(EMPTY) && (filter == null || filter.accept(new File(path)))) {
                list.add(path);
            }
            start = stop + 1;
        }
        return list;
    }

    public static final String dumpByte(byte octet) {
        return new String(new byte[]{48, 120, HEX_CHAR[(octet & 0xF0) >> 4], HEX_CHAR[octet & 0xF]});
    }

    public static final char dumpHex(byte hex) {
        return (char)HEX_CHAR[hex & 0xF];
    }

    public static final String dumpBytes(byte[] buffer) {
        if (buffer == null) {
            return EMPTY;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buffer.length; ++i) {
            sb.append("0x").append((char)HEX_CHAR[(buffer[i] & 0xF0) >> 4]).append((char)HEX_CHAR[buffer[i] & 0xF]).append(" ");
        }
        return sb.toString();
    }

    public static String dumpObject(Object object) {
        if (object != null) {
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof byte[]) {
                return StringTools.dumpBytes((byte[])object);
            }
            return "<unknown type>";
        }
        return EMPTY;
    }

    public static final String dumpHexPairs(byte[] buffer) {
        if (buffer == null) {
            return EMPTY;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buffer.length; ++i) {
            sb.append((char)HEX_CHAR[(buffer[i] & 0xF0) >> 4]).append((char)HEX_CHAR[buffer[i] & 0xF]);
        }
        return sb.toString();
    }

    public static final char bytesToChar(byte[] bytes) {
        return StringTools.bytesToChar(bytes, 0);
    }

    public static final int countBytesPerChar(byte[] bytes, int pos) {
        if (bytes == null) {
            return -1;
        }
        if ((bytes[pos] & 0x80) == 0) {
            return 1;
        }
        if ((bytes[pos] & 0xE0) == 192) {
            return 2;
        }
        if ((bytes[pos] & 0xF0) == 224) {
            return 3;
        }
        if ((bytes[pos] & 0xF8) == 240) {
            return 4;
        }
        if ((bytes[pos] & 0xFC) == 248) {
            return 5;
        }
        if ((bytes[pos] & 0xFE) == 252) {
            return 6;
        }
        return -1;
    }

    public static final int countNbBytesPerChar(char car) {
        if ((car & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((car & 0xFFFFF800) == 0) {
            return 2;
        }
        if ((car & 0xFFFF0000) == 0) {
            return 3;
        }
        if ((car & 0xFFE00000) == 0) {
            return 4;
        }
        if ((car & 0xFC000000) == 0) {
            return 5;
        }
        if ((car & Integer.MIN_VALUE) == 0) {
            return 6;
        }
        return -1;
    }

    public static final int countBytes(char[] chars) {
        if (chars == null) {
            return 0;
        }
        int nbBytes = 0;
        int currentPos = 0;
        while (currentPos < chars.length) {
            int nbb;
            currentPos += (nbb = StringTools.countNbBytesPerChar(chars[currentPos])) < 4 ? 1 : 2;
            nbBytes += nbb;
        }
        return nbBytes;
    }

    public static final char bytesToChar(byte[] bytes, int pos) {
        if (bytes == null) {
            return '\uffff';
        }
        if ((bytes[pos] & 0x80) == 0) {
            return (char)bytes[pos];
        }
        if ((bytes[pos] & 0xE0) == 192) {
            return (char)(((bytes[pos] & 0x1C) << 6) + ((bytes[pos] & 3) << 6) + (bytes[pos + 1] & 0x3F));
        }
        if ((bytes[pos] & 0xF0) == 224) {
            return (char)(((bytes[pos] & 0xF) << 12) + ((bytes[pos + 1] & 0x3C) << 6) + ((bytes[pos + 1] & 3) << 6) + (bytes[pos + 2] & 0x3F));
        }
        if ((bytes[pos] & 0xF8) == 240) {
            return (char)(((bytes[pos] & 7) << 18) + ((bytes[pos + 1] & 0x30) << 16) + ((bytes[pos + 1] & 0xF) << 12) + ((bytes[pos + 2] & 0x3C) << 6) + ((bytes[pos + 2] & 3) << 6) + (bytes[pos + 3] & 0x3F));
        }
        if ((bytes[pos] & 0xFC) == 248) {
            return (char)(((bytes[pos] & 3) << 24) + ((bytes[pos + 1] & 0x3F) << 18) + ((bytes[pos + 2] & 0x30) << 12) + ((bytes[pos + 2] & 0xF) << 12) + ((bytes[pos + 3] & 0x3C) << 6) + ((bytes[pos + 3] & 3) << 6) + (bytes[pos + 4] & 0x3F));
        }
        if ((bytes[pos] & 0xFC) == 248) {
            return (char)(((bytes[pos] & 1) << 30) + ((bytes[pos + 1] & 0x3F) << 24) + ((bytes[pos + 2] & 0x3F) << 18) + ((bytes[pos + 3] & 0x30) << 12) + ((bytes[pos + 3] & 0xF) << 12) + ((bytes[pos + 4] & 0x3C) << 6) + ((bytes[pos + 4] & 3) << 6) + (bytes[pos + 5] & 0x3F));
        }
        return '\uffff';
    }

    public static final byte[] charToBytes(char car) {
        byte[] bytes = new byte[StringTools.countNbBytesPerChar(car)];
        if (car <= '\u007f') {
            bytes[0] = (byte)car;
            return bytes;
        }
        if (car <= '\u07ff') {
            bytes[0] = (byte)(192 + ((car & 0x7C0) >> 6));
            bytes[1] = (byte)(128 + (car & 0x3F));
        } else {
            bytes[0] = (byte)(224 + ((car & 0xF000) >> 12));
            bytes[1] = (byte)(128 + ((car & 0xFC0) >> 6));
            bytes[2] = (byte)(128 + (car & 0x3F));
        }
        return bytes;
    }

    public static final int countChars(byte[] bytes) {
        if (bytes == null) {
            return 0;
        }
        int nbChars = 0;
        int currentPos = 0;
        while (currentPos < bytes.length) {
            currentPos += StringTools.countBytesPerChar(bytes, currentPos);
            ++nbChars;
        }
        return nbChars;
    }

    public static final int areEquals(byte[] bytes, int index, String text) {
        if (bytes == null || bytes.length == 0 || bytes.length <= index || index < 0 || text == null) {
            return -1;
        }
        try {
            byte[] data = text.getBytes("UTF-8");
            return StringTools.areEquals(bytes, index, data);
        }
        catch (UnsupportedEncodingException uee) {
            return -1;
        }
    }

    public static final int areEquals(char[] chars, int index, String text) {
        if (chars == null || chars.length == 0 || chars.length <= index || index < 0 || text == null) {
            return -1;
        }
        char[] data = text.toCharArray();
        return StringTools.areEquals(chars, index, data);
    }

    public static final int areEquals(char[] chars, int index, char[] chars2) {
        if (chars == null || chars.length == 0 || chars.length <= index || index < 0 || chars2 == null || chars2.length == 0 || chars2.length > chars.length + index) {
            return -1;
        }
        for (int i = 0; i < chars2.length; ++i) {
            if (chars[index++] == chars2[i]) continue;
            return -1;
        }
        return index;
    }

    public static final boolean areEquals(String string, int index, String text) {
        if (string == null || text == null) {
            return false;
        }
        int length1 = string.length();
        int length2 = text.length();
        if (length1 == 0 || length1 <= index || index < 0 || length2 == 0 || length2 > length1 + index) {
            return false;
        }
        return string.substring(index).startsWith(text);
    }

    public static final int areEquals(byte[] bytes, int index, byte[] bytes2) {
        if (bytes == null || bytes.length == 0 || bytes.length <= index || index < 0 || bytes2 == null || bytes2.length == 0 || bytes2.length > bytes.length + index) {
            return -1;
        }
        for (int i = 0; i < bytes2.length; ++i) {
            if (bytes[index++] == bytes2[i]) continue;
            return -1;
        }
        return index;
    }

    public static final boolean isCharASCII(byte[] byteArray, int index, char car) {
        if (byteArray == null || byteArray.length == 0 || index < 0 || index >= byteArray.length) {
            return false;
        }
        return byteArray[index] == car;
    }

    public static final boolean isCharASCII(char[] chars, int index, char car) {
        if (chars == null || chars.length == 0 || index < 0 || index >= chars.length) {
            return false;
        }
        return chars[index] == car;
    }

    public static final boolean isCharASCII(String string, int index, char car) {
        if (string == null) {
            return false;
        }
        int length = string.length();
        if (length == 0 || index < 0 || index >= length) {
            return false;
        }
        return string.charAt(index) == car;
    }

    public static final boolean isICharASCII(String string, int index, char car) {
        if (string == null) {
            return false;
        }
        int length = string.length();
        if (length == 0 || index < 0 || index >= length) {
            return false;
        }
        return ((string.charAt(index) | 0x20) & car) == car;
    }

    public static final boolean isICharASCII(byte[] bytes, int index, char car) {
        if (bytes == null) {
            return false;
        }
        int length = bytes.length;
        if (length == 0 || index < 0 || index >= length) {
            return false;
        }
        return ((bytes[index] | 0x20) & car) == car;
    }

    public static final boolean isBit(String string, int index) {
        if (string == null) {
            return false;
        }
        int length = string.length();
        if (length == 0 || index < 0 || index >= length) {
            return false;
        }
        char c = string.charAt(index);
        return c == '0' || c == '1';
    }

    public static final char charAt(String string, int index) {
        if (string == null) {
            return '\u0000';
        }
        int length = string.length();
        if (length == 0 || index < 0 || index >= length) {
            return '\u0000';
        }
        return string.charAt(index);
    }

    public static byte getHexValue(char high, char low) {
        if (high > '\u007f' || low > '\u007f' || high < '\u0000' | low < '\u0000') {
            return -1;
        }
        return (byte)(HEX_VALUE[high] << 4 | HEX_VALUE[low]);
    }

    public static byte getHexValue(byte high, byte low) {
        if (high > 127 || low > 127 || high < 0 | low < 0) {
            return -1;
        }
        return (byte)(HEX_VALUE[high] << 4 | HEX_VALUE[low]);
    }

    public static byte getHexValue(char c) {
        if (c > '\u007f' || c < '\u0000') {
            return -1;
        }
        return HEX_VALUE[c];
    }

    public static final boolean isHex(byte[] bytes, int index) {
        if (bytes == null || bytes.length == 0 || index < 0 || index >= bytes.length) {
            return false;
        }
        byte c = bytes[index];
        return (c | 0x7F) == 127 && HEX[c];
    }

    public static final boolean isHex(char[] chars, int index) {
        if (chars == null || chars.length == 0 || index < 0 || index >= chars.length) {
            return false;
        }
        char c = chars[index];
        return c <= '\u007f' && HEX[c];
    }

    public static final boolean isHex(String string, int index) {
        if (string == null) {
            return false;
        }
        int length = string.length();
        if (length == 0 || index < 0 || index >= length) {
            return false;
        }
        char c = string.charAt(index);
        return c <= '\u007f' && HEX[c];
    }

    public static final boolean isDigit(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return false;
        }
        return (bytes[0] | 0x7F) == 127 && DIGIT[bytes[0]];
    }

    public static final boolean isDigit(char car) {
        return car >= '0' && car <= '9';
    }

    public static final boolean isAlpha(byte c) {
        return c > 0 && c <= 127 && ALPHA[c];
    }

    public static final boolean isAlpha(char c) {
        return c > '\u0000' && c <= '\u007f' && ALPHA[c];
    }

    public static final boolean isAlphaASCII(byte[] bytes, int index) {
        if (bytes == null || bytes.length == 0 || index < 0 || index >= bytes.length) {
            return false;
        }
        byte c = bytes[index];
        return (c | 0x7F) == 127 && ALPHA[c];
    }

    public static final boolean isAlphaASCII(char[] chars, int index) {
        if (chars == null || chars.length == 0 || index < 0 || index >= chars.length) {
            return false;
        }
        char c = chars[index];
        return c <= '\u007f' && ALPHA[c];
    }

    public static final boolean isAlphaASCII(String string, int index) {
        if (string == null) {
            return false;
        }
        int length = string.length();
        if (length == 0 || index < 0 || index >= length) {
            return false;
        }
        char c = string.charAt(index);
        return c <= '\u007f' && ALPHA[c];
    }

    public static final boolean isAlphaLowercaseASCII(String string, int index) {
        if (string == null) {
            return false;
        }
        int length = string.length();
        if (length == 0 || index < 0 || index >= length) {
            return false;
        }
        char c = string.charAt(index);
        return c <= '\u007f' && ALPHA_LOWER_CASE[c];
    }

    public static final boolean isAlphaUppercaseASCII(String string, int index) {
        if (string == null) {
            return false;
        }
        int length = string.length();
        if (length == 0 || index < 0 || index >= length) {
            return false;
        }
        char c = string.charAt(index);
        return c <= '\u007f' && ALPHA_UPPER_CASE[c];
    }

    public static final boolean isDigit(byte[] bytes, int index) {
        if (bytes == null || bytes.length == 0 || index < 0 || index >= bytes.length) {
            return false;
        }
        return (bytes[index] | 0x7F) == 127 && DIGIT[bytes[index]];
    }

    public static final boolean isDigit(char[] chars, int index) {
        if (chars == null || chars.length == 0 || index < 0 || index >= chars.length) {
            return false;
        }
        return chars[index] <= '\u007f' && DIGIT[chars[index]];
    }

    public static final boolean isDigit(String string, int index) {
        if (string == null) {
            return false;
        }
        int length = string.length();
        if (length == 0 || index < 0 || index >= length) {
            return false;
        }
        char c = string.charAt(index);
        return c <= '\u007f' && DIGIT[c];
    }

    public static final boolean isDigit(char[] chars) {
        if (chars == null || chars.length == 0) {
            return false;
        }
        return chars[0] <= '\u007f' && DIGIT[chars[0]];
    }

    public static final boolean isAlphaDigit(String string, int index) {
        if (string == null) {
            return false;
        }
        int length = string.length();
        if (length == 0 || index < 0 || index >= length) {
            return false;
        }
        char c = string.charAt(index);
        return c <= '\u007f' && ALPHA_DIGIT[c];
    }

    public static final boolean isAlphaDigitMinus(byte[] bytes, int index) {
        if (bytes == null || bytes.length == 0 || index < 0 || index >= bytes.length) {
            return false;
        }
        byte c = bytes[index];
        return (c | 0x7F) == 127 && CHAR[c];
    }

    public static final boolean isAlphaDigitMinus(char[] chars, int index) {
        if (chars == null || chars.length == 0 || index < 0 || index >= chars.length) {
            return false;
        }
        char c = chars[index];
        return c <= '\u007f' && CHAR[c];
    }

    public static final boolean isAlphaDigitMinus(String string, int index) {
        if (string == null) {
            return false;
        }
        int length = string.length();
        if (length == 0 || index < 0 || index >= length) {
            return false;
        }
        char c = string.charAt(index);
        return c <= '\u007f' && CHAR[c];
    }

    public static final boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static final boolean isEmpty(byte[] bytes) {
        return bytes == null || bytes.length == 0;
    }

    public static final boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static final String trim(String str) {
        return StringTools.isEmpty(str) ? EMPTY : str.trim();
    }

    public static final byte[] trim(byte[] bytes) {
        if (StringTools.isEmpty(bytes)) {
            return EMPTY_BYTES;
        }
        int start = StringTools.trimLeft(bytes, 0);
        int end = StringTools.trimRight(bytes, bytes.length - 1);
        int length = end - start + 1;
        if (length != 0) {
            byte[] newBytes = new byte[end - start + 1];
            System.arraycopy(bytes, start, newBytes, 0, length);
            return newBytes;
        }
        return EMPTY_BYTES;
    }

    public static final String trimLeft(String str) {
        int start;
        if (StringTools.isEmpty(str)) {
            return EMPTY;
        }
        int end = str.length();
        for (start = 0; start < end && str.charAt(start) == ' '; ++start) {
        }
        return start == 0 ? str : str.substring(start);
    }

    public static final int trimLeft(char[] chars, int pos) {
        if (chars == null) {
            return pos;
        }
        while (pos < chars.length && chars[pos] == ' ') {
            ++pos;
        }
        return pos;
    }

    public static final void trimLeft(String string, Position pos) {
        if (string == null) {
            return;
        }
        int length = string.length();
        while (pos.start < length && string.charAt(pos.start) == ' ') {
            ++pos.start;
        }
        pos.end = pos.start;
    }

    public static final void trimLeft(byte[] bytes, Position pos) {
        if (bytes == null) {
            return;
        }
        int length = bytes.length;
        while (pos.start < length && bytes[pos.start] == 32) {
            ++pos.start;
        }
        pos.end = pos.start;
    }

    public static final int trimLeft(byte[] bytes, int pos) {
        if (bytes == null) {
            return pos;
        }
        while (pos < bytes.length && bytes[pos] == 32) {
            ++pos;
        }
        return pos;
    }

    public static final String trimRight(String str) {
        int length;
        int end;
        if (StringTools.isEmpty(str)) {
            return EMPTY;
        }
        for (end = length = str.length(); end > 0 && str.charAt(end - 1) == ' ' && (end <= 1 || str.charAt(end - 2) != '\\'); --end) {
        }
        return end == length ? str : str.substring(0, end);
    }

    public static final String trimRight(String str, int escapedSpace) {
        int length;
        int end;
        if (StringTools.isEmpty(str)) {
            return EMPTY;
        }
        for (end = length = str.length(); end > 0 && str.charAt(end - 1) == ' ' && end > escapedSpace && (end <= 1 || str.charAt(end - 2) != '\\'); --end) {
        }
        return end == length ? str : str.substring(0, end);
    }

    public static final int trimRight(char[] chars, int pos) {
        if (chars == null) {
            return pos;
        }
        while (pos >= 0 && chars[pos - 1] == ' ') {
            --pos;
        }
        return pos;
    }

    public static final String trimRight(String string, Position pos) {
        if (string == null) {
            return EMPTY;
        }
        while (pos.end >= 0 && string.charAt(pos.end - 1) == ' ' && (pos.end <= 1 || string.charAt(pos.end - 2) != '\\')) {
            --pos.end;
        }
        return pos.end == string.length() ? string : string.substring(0, pos.end);
    }

    public static final String trimRight(byte[] bytes, Position pos) {
        if (bytes == null) {
            return EMPTY;
        }
        while (pos.end >= 0 && bytes[pos.end - 1] == 32 && (pos.end <= 1 || bytes[pos.end - 2] != 92)) {
            --pos.end;
        }
        if (pos.end == bytes.length) {
            return StringTools.utf8ToString(bytes);
        }
        return StringTools.utf8ToString(bytes, pos.end);
    }

    public static final int trimRight(byte[] bytes, int pos) {
        if (bytes == null) {
            return pos;
        }
        while (pos >= 0 && bytes[pos] == 32) {
            --pos;
        }
        return pos;
    }

    public static final String upperCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase();
    }

    public static final String lowerCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    public static final String lowerCaseAscii(String str) {
        if (str == null) {
            return null;
        }
        char[] chars = str.toCharArray();
        int pos = 0;
        for (char c : chars) {
            chars[pos++] = TO_LOWER_CASE[c];
        }
        return new String(chars);
    }

    public static final boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static final String utf8ToString(byte[] bytes) {
        if (bytes == null) {
            return EMPTY;
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return EMPTY;
        }
    }

    public static final String utf8ToString(byte[] bytes, int length) {
        if (bytes == null) {
            return EMPTY;
        }
        try {
            return new String(bytes, 0, length, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return EMPTY;
        }
    }

    public static final String utf8ToString(byte[] bytes, int start, int length) {
        if (bytes == null) {
            return EMPTY;
        }
        try {
            return new String(bytes, start, length, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return EMPTY;
        }
    }

    public static final byte[] getBytesUtf8(String string) {
        if (string == null) {
            return new byte[0];
        }
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return new byte[0];
        }
    }

    public static final String listToString(List<?> list) {
        if (list == null || list.size() == 0) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        Iterator<?> iter = list.iterator();
        while (iter.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(iter.next());
        }
        return sb.toString();
    }

    public static final String listToString(List<?> list, String tabs) {
        if (list == null || list.size() == 0) {
            return EMPTY;
        }
        StringBuffer sb = new StringBuffer();
        Iterator<?> iter = list.iterator();
        while (iter.hasNext()) {
            sb.append(tabs);
            sb.append(iter.next());
            sb.append('\n');
        }
        return sb.toString();
    }

    public static final String mapToString(Map<?, ?> map) {
        if (map == null || map.size() == 0) {
            return EMPTY;
        }
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(entry.getKey());
            sb.append(" = '").append(entry.getValue()).append("'");
        }
        return sb.toString();
    }

    public static final String mapToString(Map<?, ?> map, String tabs) {
        if (map == null || map.size() == 0) {
            return EMPTY;
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            sb.append(tabs);
            sb.append(entry.getKey());
            sb.append(" = '").append(entry.getValue().toString()).append("'\n");
        }
        return sb.toString();
    }

    public static final String getDefaultCharsetName() {
        if (null == defaultCharset) {
            try {
                Method method = Charset.class.getMethod("defaultCharset", new Class[0]);
                defaultCharset = ((Charset)method.invoke(null, new Object[0])).name();
            }
            catch (Exception e) {
                defaultCharset = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
            }
        }
        return defaultCharset;
    }

    public static final String decodeHexString(String str) throws InvalidNameException {
        if (str == null || str.length() == 0) {
            throw new InvalidNameException("Expected string to start with a '#' character.  Invalid hex encoded string for empty or null string.");
        }
        char[] chars = str.toCharArray();
        if (chars[0] != '#') {
            throw new InvalidNameException("Expected string to start with a '#' character.  Invalid hex encoded string: " + str);
        }
        byte[] decoded = new byte[chars.length - 1 >> 1];
        int ii = 1;
        int jj = 0;
        while (ii < chars.length) {
            int ch = (HEX_VALUE[chars[ii]] << 4) + HEX_VALUE[chars[ii + 1]];
            decoded[jj] = (byte)ch;
            ii += 2;
            ++jj;
        }
        return StringTools.utf8ToString(decoded);
    }

    public static final String decodeEscapedHex(String str) throws InvalidNameException {
        if (str == null) {
            throw new InvalidNameException("Expected string to be non-null with valid index.");
        }
        int length = str.length();
        if (length == 0) {
            throw new InvalidNameException("Expected string to be non-empty with valid index.");
        }
        StringBuffer buf = new StringBuffer();
        ByteBuffer bb = new ByteBuffer();
        for (int ii = 0; ii < length; ++ii) {
            if (str.charAt(ii) == '\\') {
                if (StringTools.isHex(str, ii + 1) && StringTools.isHex(str, ii + 2)) {
                    bb.clear();
                    int advancedBy = StringTools.collectEscapedHexBytes(bb, str, ii);
                    ii += advancedBy - 1;
                    buf.append(StringTools.utf8ToString(bb.buffer(), bb.position()));
                    continue;
                }
                buf.append(str.charAt(ii));
                continue;
            }
            buf.append(str.charAt(ii));
        }
        return buf.toString();
    }

    private static int collectEscapedHexBytes(ByteBuffer bb, String str, int index) {
        int advanceBy = 0;
        int ii = index;
        while (ii < str.length() && StringTools.isHex(str, ii + 1) && StringTools.isHex(str, ii + 2)) {
            int bite = (HEX_VALUE[str.charAt(ii + 1)] << 4) + HEX_VALUE[str.charAt(ii + 2)];
            bb.append(bite);
            ii += 3;
            advanceBy += 3;
        }
        return advanceBy;
    }

    public static String asciiBytesToString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return EMPTY;
        }
        char[] result = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = (char)bytes[i];
        }
        return new String(result);
    }

    public static String getType(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        char[] chars = new char[bytes.length];
        int pos = 0;
        for (byte b : bytes) {
            chars[pos++] = TO_LOWER_CASE[b];
        }
        return new String(chars);
    }

    public static boolean isIA5String(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        for (char c : str.toCharArray()) {
            if (c >= '\u0000' && c <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public static boolean isPrintableString(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        for (char c : str.toCharArray()) {
            if (c <= '\u007f' && IS_PRINTABLE_CHAR[c]) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnicodeSubset(String str, int pos) {
        if (str == null || str.length() <= pos || pos < 0) {
            return false;
        }
        char c = str.charAt(pos);
        return c > '\u007f' || UNICODE_SUBSET[c];
    }

    public static boolean isUnicodeSubset(char c) {
        return c > '\u007f' || UNICODE_SUBSET[c];
    }
}

