/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.ldif;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.Control;
import org.apache.directory.shared.ldap.ldif.ChangeType;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.AttributesImpl;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdifEntry
implements Cloneable,
Serializable {
    public static final ModificationItemImpl[] EMPTY_MODS = new ModificationItemImpl[0];
    private ChangeType changeType = ChangeType.Add;
    private List<ModificationItemImpl> modificationList = new LinkedList<ModificationItemImpl>();
    private Map<String, ModificationItemImpl> modificationItems = new HashMap<String, ModificationItemImpl>();
    private String dn = null;
    private String newSuperior;
    private String newRdn;
    private boolean deleteOldRdn;
    private Attributes attributes = new AttributesImpl(true);
    private Control control = null;

    public void setDn(String dn) {
        this.dn = dn;
    }

    public void setChangeType(ChangeType changeType) {
        this.changeType = changeType;
    }

    public void setChangeType(String changeType) {
        if ("add".equals(changeType)) {
            this.changeType = ChangeType.Add;
        } else if ("modify".equals(changeType)) {
            this.changeType = ChangeType.Modify;
        } else if ("moddn".equals(changeType)) {
            this.changeType = ChangeType.ModDn;
        } else if ("modrdn".equals(changeType)) {
            this.changeType = ChangeType.ModRdn;
        } else if ("delete".equals(changeType)) {
            this.changeType = ChangeType.Delete;
        }
    }

    public void addModificationItem(ModificationItemImpl modification) {
        if (this.changeType == ChangeType.Modify) {
            this.modificationList.add(modification);
            this.modificationItems.put(modification.getAttribute().getID(), modification);
        }
    }

    public void addModificationItem(int modOp, Attribute attr) throws NamingException {
        if (this.changeType == ChangeType.Modify) {
            ModificationItemImpl item = new ModificationItemImpl(modOp, attr);
            this.modificationList.add(item);
            this.modificationItems.put(attr.getID(), item);
        }
    }

    public void addModificationItem(int modOp, String id, Object value) throws NamingException {
        if (this.changeType == ChangeType.Modify) {
            AttributeImpl attr = new AttributeImpl(id, value);
            ModificationItemImpl item = new ModificationItemImpl(modOp, attr);
            this.modificationList.add(item);
            this.modificationItems.put(id, item);
        }
    }

    public void addAttribute(Attribute attr) {
        this.attributes.put(attr);
    }

    public void addAttribute(String id, Object value) {
        Attribute attr = this.get(id);
        if (attr != null) {
            attr.add(value);
        } else {
            this.attributes.put(id, value);
        }
    }

    public void putAttribute(String id, Object value) {
        Attribute attribute = this.attributes.get(id);
        if (attribute != null) {
            attribute.add(value);
        } else {
            this.attributes.put(id, value);
        }
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public List<ModificationItemImpl> getModificationItems() {
        return this.modificationList;
    }

    public ModificationItemImpl[] getModificationItemsArray() {
        return this.modificationList.toArray(EMPTY_MODS);
    }

    public String getDn() {
        return this.dn;
    }

    public int size() {
        return this.modificationList.size();
    }

    public Attribute get(String attributeId) {
        if ("dn".equalsIgnoreCase(attributeId)) {
            return new AttributeImpl("dn", this.dn);
        }
        return this.attributes.get(attributeId);
    }

    public Attributes getAttributes() {
        if (this.isEntry()) {
            return this.attributes;
        }
        return null;
    }

    public boolean isDeleteOldRdn() {
        return this.deleteOldRdn;
    }

    public void setDeleteOldRdn(boolean deleteOldRdn) {
        this.deleteOldRdn = deleteOldRdn;
    }

    public String getNewRdn() {
        return this.newRdn;
    }

    public void setNewRdn(String newRdn) {
        this.newRdn = newRdn;
    }

    public String getNewSuperior() {
        return this.newSuperior;
    }

    public void setNewSuperior(String newSuperior) {
        this.newSuperior = newSuperior;
    }

    public boolean isChangeAdd() {
        return this.changeType == ChangeType.Add;
    }

    public boolean isChangeDelete() {
        return this.changeType == ChangeType.Delete;
    }

    public boolean isChangeModDn() {
        return this.changeType == ChangeType.ModDn;
    }

    public boolean isChangeModRdn() {
        return this.changeType == ChangeType.ModRdn;
    }

    public boolean isChangeModify() {
        return this.changeType == ChangeType.Modify;
    }

    public boolean isEntry() {
        return this.changeType == ChangeType.Add;
    }

    public Control getControl() {
        return this.control;
    }

    public void setControl(Control control) {
        this.control = control;
    }

    public LdifEntry clone() throws CloneNotSupportedException {
        LdifEntry clone = (LdifEntry)super.clone();
        if (this.modificationList != null) {
            for (ModificationItemImpl modif : this.modificationList) {
                ModificationItemImpl modifClone = new ModificationItemImpl(modif.getModificationOp(), (Attribute)modif.getAttribute().clone());
                clone.modificationList.add(modifClone);
            }
        }
        if (this.modificationItems != null) {
            for (String key : this.modificationItems.keySet()) {
                ModificationItemImpl modif = this.modificationItems.get(key);
                ModificationItemImpl modifClone = new ModificationItemImpl(modif.getModificationOp(), (Attribute)modif.getAttribute().clone());
                clone.modificationItems.put(key, modifClone);
            }
        }
        if (this.attributes != null) {
            clone.attributes = (Attributes)this.attributes.clone();
        }
        return clone;
    }

    private String dumpAttributes() {
        StringBuffer sb = new StringBuffer();
        try {
            NamingEnumeration<? extends Attribute> attrs = this.attributes.getAll();
            while (attrs.hasMoreElements()) {
                Attribute attribute = (Attribute)attrs.nextElement();
                sb.append("        ").append(attribute.getID()).append(":\n");
                NamingEnumeration<?> values = attribute.getAll();
                while (values.hasMoreElements()) {
                    Object value = values.nextElement();
                    if (value instanceof String) {
                        sb.append("            ").append((String)value).append('\n');
                        continue;
                    }
                    sb.append("            ").append(StringTools.dumpBytes((byte[])value)).append('\n');
                }
            }
        }
        catch (NamingException ne) {
            return "";
        }
        return sb.toString();
    }

    private String dumpModificationItems() {
        StringBuffer sb = new StringBuffer();
        for (ModificationItemImpl modif : this.modificationList) {
            sb.append("            Operation: ");
            switch (modif.getModificationOp()) {
                case 1: {
                    sb.append("ADD\n");
                    break;
                }
                case 3: {
                    sb.append("REMOVE\n");
                    break;
                }
                case 2: {
                    sb.append("REPLACE \n");
                }
            }
            Attribute attribute = modif.getAttribute();
            sb.append("                Attribute: ").append(attribute.getID()).append('\n');
            if (attribute.size() == 0) continue;
            try {
                NamingEnumeration<?> values = attribute.getAll();
                while (values.hasMoreElements()) {
                    Object value = values.nextElement();
                    if (value instanceof String) {
                        sb.append("                ").append((String)value).append('\n');
                        continue;
                    }
                    sb.append("                ").append(StringTools.dumpBytes((byte[])value)).append('\n');
                }
            }
            catch (NamingException ne) {
                return "";
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Entry : ").append(this.dn).append('\n');
        if (this.control != null) {
            sb.append("    Control : ").append(this.control).append('\n');
        }
        switch (this.changeType) {
            case Add: {
                sb.append("    Change type is ADD\n");
                sb.append("        Attributes : \n");
                sb.append(this.dumpAttributes());
                break;
            }
            case Modify: {
                sb.append("    Change type is MODIFY\n");
                sb.append("        Modifications : \n");
                sb.append(this.dumpModificationItems());
                break;
            }
            case Delete: {
                sb.append("    Change type is DELETE\n");
                break;
            }
            case ModDn: 
            case ModRdn: {
                sb.append("    Change type is ").append(this.changeType == ChangeType.ModDn ? "MODDN\n" : "MODRDN\n");
                sb.append("    Delete old RDN : ").append(this.deleteOldRdn ? "true\n" : "false\n");
                sb.append("    New RDN : ").append(this.newRdn).append('\n');
                if (StringTools.isEmpty(this.newSuperior)) break;
                sb.append("    New superior : ").append(this.newSuperior).append('\n');
            }
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof LdifEntry)) {
            return false;
        }
        LdifEntry entry = (LdifEntry)o;
        try {
            LdapDN thisDn = new LdapDN(this.dn);
            LdapDN dnEntry = new LdapDN(entry.dn);
            if (!thisDn.equals(dnEntry)) {
                return false;
            }
        }
        catch (InvalidNameException ine) {
            return false;
        }
        if (this.changeType != entry.changeType) {
            return false;
        }
        switch (this.changeType) {
            case Add: {
                if (this.attributes == null) {
                    if (entry.attributes == null) break;
                    return false;
                }
                if (entry.attributes == null) {
                    return false;
                }
                if (this.attributes.size() != entry.attributes.size()) {
                    return false;
                }
                if (this.attributes.equals(entry.attributes)) break;
                return false;
            }
            case Delete: {
                break;
            }
            case Modify: {
                if (this.modificationList == null) {
                    if (entry.modificationList == null) break;
                    return false;
                }
                if (entry.modificationList == null) {
                    return false;
                }
                if (this.modificationList.size() != entry.modificationList.size()) {
                    return false;
                }
                int i = 0;
                for (ModificationItemImpl modification : this.modificationList) {
                    if (!modification.equals(entry.modificationList.get(i))) {
                        return false;
                    }
                    ++i;
                }
                break;
            }
            case ModDn: 
            case ModRdn: {
                if (this.deleteOldRdn != entry.deleteOldRdn) {
                    return false;
                }
                try {
                    Rdn thisNewRdn = new Rdn(this.newRdn);
                    Rdn entryNewRdn = new Rdn(entry.newRdn);
                    if (!thisNewRdn.equals(entryNewRdn)) {
                        return false;
                    }
                }
                catch (InvalidNameException ine) {
                    return false;
                }
                try {
                    LdapDN thisNewSuperior = new LdapDN(this.newSuperior);
                    LdapDN entryNewSuperior = new LdapDN(entry.newSuperior);
                    if (!thisNewSuperior.equals(entryNewSuperior)) {
                        return false;
                    }
                    break;
                }
                catch (InvalidNameException ine) {
                    return false;
                }
            }
        }
        if (this.control != null) {
            return this.control.equals(entry.control);
        }
        return entry.control == null;
    }
}

