/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.common.ServerAttribute;
import org.apache.directory.shared.ldap.common.ServerAttributeImpl;
import org.apache.directory.shared.ldap.common.ServerEntry;
import org.apache.directory.shared.ldap.common.Value;
import org.apache.directory.shared.ldap.name.LdapDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerEntryImpl
implements ServerEntry {
    private LdapDN dn;
    private transient Map<OID, ServerAttribute> hashAttrs;
    private List<ServerAttribute> attributes = new ArrayList<ServerAttribute>();
    static final long serialVersionUID = 2L;

    public ServerEntryImpl() {
        this.hashAttrs = new HashMap<OID, ServerAttribute>();
    }

    public ServerEntryImpl(LdapDN dn) {
        this.hashAttrs = new HashMap<OID, ServerAttribute>();
        this.dn = dn;
    }

    @Override
    public void clear() {
        if (this.attributes != null) {
            this.attributes.clear();
            this.hashAttrs.clear();
        }
    }

    @Override
    public ServerEntry clone() {
        try {
            ServerEntryImpl clone = (ServerEntryImpl)super.clone();
            clone.dn = (LdapDN)this.dn.clone();
            if (this.attributes != null) {
                clone.attributes = new ArrayList<ServerAttribute>(this.attributes.size());
                clone.hashAttrs = new HashMap<OID, ServerAttribute>(this.attributes.size());
                for (ServerAttribute attr : this.attributes) {
                    ServerAttribute clonedAttr = attr.clone();
                    clone.attributes.add(attr);
                    clone.hashAttrs.put(attr.getOid(), clonedAttr);
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    @Override
    public ServerAttribute copy(ServerAttribute attr) {
        if (attr == null) {
            return null;
        }
        return this.put(attr.clone());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ServerEntryImpl)) {
            return false;
        }
        ServerEntry entry = (ServerEntry)obj;
        if (this.dn == null ? entry.getDn() != null : !this.dn.equals(entry.getDn())) {
            return false;
        }
        Iterator<ServerAttribute> all = entry.getAll();
        if (!all.hasNext()) {
            return this.attributes.size() == 0;
        }
        int size = this.attributes.size();
        while (all.hasNext()) {
            if (!this.attributes.contains(all.next())) {
                return false;
            }
            --size;
        }
        return size == 0;
    }

    @Override
    public ServerAttribute get(OID oid) {
        assert (oid != null);
        return this.hashAttrs.get(oid);
    }

    @Override
    public Iterator<ServerAttribute> getAll() {
        return new ServerAttributeIterator();
    }

    @Override
    public LdapDN getDn() {
        return this.dn;
    }

    @Override
    public void setDn(LdapDN dn) {
        this.dn = dn;
    }

    @Override
    public Iterator<OID> getOids() {
        return new OidIterator();
    }

    @Override
    public ServerAttribute put(ServerAttribute attr) {
        if (attr == null) {
            return null;
        }
        if (attr.getOid() == null) {
            return null;
        }
        ServerAttribute replacedAttribute = this.hashAttrs.put(attr.getOid(), attr);
        if (replacedAttribute != null) {
            this.attributes.remove(replacedAttribute);
        }
        this.attributes.add(attr);
        return replacedAttribute;
    }

    @Override
    public ServerAttribute put(OID oid, Value<?> val) throws NamingException {
        return this.put(new ServerAttributeImpl(oid, val));
    }

    @Override
    public ServerAttribute put(OID oid, String val) throws NamingException {
        return this.put(new ServerAttributeImpl(oid, val));
    }

    @Override
    public ServerAttribute put(OID oid, byte[] val) throws NamingException {
        if (oid == null) {
            throw new NamingException("Attributes with an empty ID or OID are not allowed");
        }
        ServerAttribute oldAttr = this.hashAttrs.get(oid);
        if (oldAttr != null) {
            this.attributes.remove(oid);
            this.hashAttrs.remove(oid);
        }
        ServerAttributeImpl attribute = new ServerAttributeImpl(oid, val);
        this.attributes.add(attribute);
        this.hashAttrs.put(oid, attribute);
        return oldAttr;
    }

    @Override
    public ServerAttribute remove(OID oid) {
        if (oid == null) {
            return null;
        }
        ServerAttribute attribute = this.hashAttrs.get(oid);
        if (attribute != null) {
            this.hashAttrs.remove(oid);
            this.attributes.remove(attribute);
        }
        return attribute;
    }

    @Override
    public ServerAttribute remove(ServerAttribute attribute) {
        if (attribute == null) {
            return null;
        }
        OID oid = attribute.getOid();
        if (oid == null) {
            return null;
        }
        ServerAttribute existingAttr = this.hashAttrs.get(oid);
        if (existingAttr != null) {
            this.hashAttrs.remove(oid);
            this.attributes.remove(existingAttr);
        }
        return existingAttr;
    }

    @Override
    public int size() {
        if (this.attributes == null) {
            return 0;
        }
        return this.attributes.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ServerAttributeIterator
    implements Iterator<ServerAttribute> {
        private Iterator<ServerAttribute> iterator;
        int index;
        int max;

        private ServerAttributeIterator() {
            this.iterator = ServerEntryImpl.this.attributes.iterator();
            this.index = 0;
            this.max = ServerEntryImpl.this.attributes != null && ServerEntryImpl.this.attributes.size() != 0 ? ServerEntryImpl.this.attributes.size() : 0;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported");
        }

        @Override
        public boolean hasNext() {
            return this.index < this.max;
        }

        @Override
        public ServerAttribute next() {
            if (this.index >= this.max) {
                return null;
            }
            ++this.index;
            ServerAttribute current = this.iterator.next();
            return current;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OidIterator
    implements Iterator<OID> {
        private Iterator<ServerAttribute> iterator;
        int index;
        int max;

        private OidIterator() {
            this.iterator = ServerEntryImpl.this.attributes.iterator();
            this.index = 0;
            this.max = ServerEntryImpl.this.attributes != null && ServerEntryImpl.this.attributes.size() != 0 ? 0 : ServerEntryImpl.this.attributes.size();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported");
        }

        @Override
        public boolean hasNext() {
            return this.index < this.max;
        }

        @Override
        public OID next() {
            if (this.index >= this.max) {
                return null;
            }
            ++this.index;
            ServerAttribute current = this.iterator.next();
            return current.getOid();
        }
    }
}

