/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.common.BinaryValue;
import org.apache.directory.shared.ldap.common.ServerAttribute;
import org.apache.directory.shared.ldap.common.StringValue;
import org.apache.directory.shared.ldap.common.Value;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerAttributeImpl
implements ServerAttribute,
Serializable,
Cloneable {
    private static final long serialVersionUID = 2L;
    private final String upId;
    private OID oid;
    private Value<?> value;
    private List<Value<?>> values;
    private int size;

    public ServerAttributeImpl(String id) {
        assert (!StringTools.isEmpty(id));
        this.upId = id;
        this.value = null;
        this.values = null;
        this.oid = null;
        this.size = 0;
    }

    public ServerAttributeImpl(OID oid) {
        assert (oid != null);
        this.upId = oid.toString();
        this.value = null;
        this.values = null;
        this.oid = oid;
        this.size = 0;
    }

    public ServerAttributeImpl(String id, Value<?> val) {
        assert (!StringTools.isEmpty(id));
        this.upId = id;
        this.value = val;
        this.values = null;
        this.oid = null;
        this.size = 1;
    }

    public ServerAttributeImpl(OID oid, Value<?> val) {
        assert (oid != null);
        this.upId = oid.toString();
        this.value = val;
        this.values = null;
        this.oid = oid;
        this.size = 1;
    }

    public ServerAttributeImpl(String id, byte[] val) {
        assert (!StringTools.isEmpty(id));
        this.upId = id;
        this.values = null;
        this.value = new BinaryValue(val);
        this.oid = null;
        this.size = 1;
    }

    public ServerAttributeImpl(OID oid, byte[] val) {
        assert (oid != null);
        this.upId = oid.toString();
        this.values = null;
        this.value = new BinaryValue(val);
        this.oid = oid;
        this.size = 1;
    }

    public ServerAttributeImpl(String id, String val) {
        assert (!StringTools.isEmpty(id));
        this.upId = id;
        this.values = null;
        this.value = new StringValue(val);
        this.oid = null;
        this.size = 1;
    }

    public ServerAttributeImpl(OID oid, String val) {
        assert (oid != null);
        this.upId = oid.toString();
        this.values = null;
        this.value = new StringValue(val);
        this.oid = oid;
        this.size = 1;
    }

    public ServerAttributeImpl(ServerAttribute attribute) {
        assert (attribute != null);
        ServerAttribute copy = attribute.clone();
        this.upId = ((ServerAttributeImpl)copy).getID();
        this.oid = ((ServerAttributeImpl)copy).getOid();
        switch (copy.size()) {
            case 0: {
                this.values = null;
                this.value = null;
                this.size = 0;
                break;
            }
            case 1: {
                try {
                    this.value = this.getClonedValue(copy.get());
                }
                catch (NamingException ne) {
                    this.value = new StringValue((String)null);
                }
                this.values = null;
                this.size = 1;
                break;
            }
            default: {
                this.value = null;
                this.values = new ArrayList(copy.size());
                try {
                    Iterator<Value<?>> vals = copy.getAll();
                    while (vals.hasNext()) {
                        Value<?> val = vals.next();
                        this.values.add(val);
                    }
                }
                catch (NamingException ne) {
                    this.values.add(new StringValue((String)null));
                }
                this.size = copy.size();
            }
        }
        this.oid = null;
    }

    private Value<?> getClonedValue(Value<?> value) {
        if (value == null) {
            return new StringValue(null);
        }
        try {
            return value.clone();
        }
        catch (CloneNotSupportedException csne) {
            return new StringValue(null);
        }
    }

    @Override
    public Iterator<Value<?>> getAll() {
        if (this.size < 2) {
            return new Iterator<Value<?>>(){
                private boolean more;
                {
                    this.more = ServerAttributeImpl.this.value != null;
                }

                @Override
                public boolean hasNext() {
                    return this.more;
                }

                @Override
                public Value<?> next() {
                    this.more = false;
                    return ServerAttributeImpl.this.value;
                }

                @Override
                public void remove() {
                    ServerAttributeImpl.this.value = null;
                    this.more = true;
                }
            };
        }
        return this.values.iterator();
    }

    @Override
    public Value<?> get() {
        switch (this.size) {
            case 0: {
                return null;
            }
            case 1: {
                return this.value;
            }
        }
        return this.values.get(0);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String getID() {
        return this.upId;
    }

    @Override
    public OID getOid() {
        return this.oid;
    }

    @Override
    public boolean contains(Value<?> val) {
        switch (this.size) {
            case 0: {
                return false;
            }
            case 1: {
                return AttributeUtils.equals(this.value, val);
            }
        }
        for (Value<?> value : this.values) {
            if (!AttributeUtils.equals(value, val)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(String val) {
        return this.contains(new StringValue(val));
    }

    @Override
    public boolean contains(byte[] val) {
        return this.contains(new BinaryValue(val));
    }

    @Override
    public boolean add(Value<?> val) {
        if (this.contains(val)) {
            return true;
        }
        val = this.getClonedValue(val);
        switch (this.size()) {
            case 0: {
                this.value = val;
                ++this.size;
                return true;
            }
            case 1: {
                if (this.value.getValue() != null && val.getValue() != null && this.value.getClass() != val.getClass()) {
                    return false;
                }
                if (this.value.equals(val)) {
                    return true;
                }
                this.values = new ArrayList();
                this.values.add(this.value);
                this.values.add(val);
                this.value = null;
                ++this.size;
                return true;
            }
        }
        Value<?> firstValue = this.values.get(0);
        if (firstValue.getValue() == null) {
            firstValue = this.values.get(1);
        }
        if (val.getValue() != null && firstValue.getValue().getClass() != val.getClass()) {
            return false;
        }
        if (this.values.contains(val)) {
            return true;
        }
        this.values.add(val);
        ++this.size;
        return false;
    }

    @Override
    public boolean add(String val) {
        return this.add(new StringValue(val));
    }

    @Override
    public boolean add(byte[] val) {
        return this.add(new BinaryValue(val));
    }

    @Override
    public boolean remove(Value<?> val) {
        if (this.contains(val)) {
            switch (this.size) {
                case 0: {
                    return false;
                }
                case 1: {
                    this.value = null;
                    this.size = 0;
                    return true;
                }
                case 2: {
                    this.values.remove(val);
                    this.value = this.values.get(0);
                    this.values = null;
                    --this.size;
                    return true;
                }
            }
            this.values.remove(val);
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(String val) {
        return this.remove(new StringValue(val));
    }

    @Override
    public boolean remove(byte[] val) {
        return this.remove(new BinaryValue(val));
    }

    @Override
    public void clear() {
        switch (this.size) {
            case 0: {
                return;
            }
            case 1: {
                this.value = null;
                this.size = 0;
                return;
            }
        }
        this.values = null;
        this.size = 0;
    }

    @Override
    public ServerAttribute clone() {
        try {
            ServerAttributeImpl clone = (ServerAttributeImpl)super.clone();
            clone.oid = this.oid;
            if (this.size < 2) {
                clone.value = this.value.clone();
            } else {
                clone.values = new ArrayList(this.values.size());
                for (Value<?> value : this.values) {
                    Value<?> newValue = value.clone();
                    clone.values.add(newValue);
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ServerAttributeImpl)) {
            return false;
        }
        ServerAttributeImpl attr = (ServerAttributeImpl)obj;
        if (attr.oid != this.oid) {
            return false;
        }
        if (!this.upId.equalsIgnoreCase(attr.getID())) {
            return false;
        }
        if (attr.size != this.size) {
            return false;
        }
        switch (this.size) {
            case 0: {
                return true;
            }
            case 1: {
                return this.value.equals(attr.get());
            }
        }
        Iterator<Value<?>> vals = this.getAll();
        while (vals.hasNext()) {
            Value<?> val = vals.next();
            if (attr.contains(val)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void normalize(OID oid, Normalizer normalizer) throws NamingException {
        this.oid = oid;
        switch (this.size) {
            case 0: {
                return;
            }
            case 1: {
                this.value.normalize(normalizer);
                return;
            }
        }
        for (Value<?> value : this.values) {
            value.normalize(normalizer);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ServerAttribute id : '").append(this.upId).append("', ");
        if (this.oid != null) {
            sb.append(" OID : ").append(this.oid).append('\n');
        }
        sb.append(" Values : [");
        switch (this.size) {
            case 0: {
                sb.append("]\n");
                break;
            }
            case 1: {
                sb.append('\'').append(this.value).append('\'');
                sb.append("]\n");
                break;
            }
            default: {
                boolean isFirst = true;
                for (Value<?> value : this.values) {
                    if (!isFirst) {
                        sb.append(", ");
                    } else {
                        isFirst = false;
                    }
                    sb.append('\'').append(value).append('\'');
                }
                sb.append("]\n");
            }
        }
        return sb.toString();
    }
}

